/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.Product;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductBasicText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductBasicTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductBasicTextCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductBasicTextDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductBasicTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductBasicTextUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductDescription;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductDescriptionByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductDescriptionCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductDescriptionDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductDescriptionFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductDescriptionUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductInspectionText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductInspectionTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductInspectionTextCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductInspectionTextDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductInspectionTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductInspectionTextUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductMLAccount;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductMLAccountByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductMLAccountCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductMLAccountFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductMLAccountUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductMLPrices;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductMLPricesByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductMLPricesCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductMLPricesFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductMLPricesUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlant;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantCosting;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantCostingByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantCostingCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantCostingFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantCostingUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantForecasting;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantForecastingByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantForecastingCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantForecastingFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantForecastingUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantIntlTrd;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantIntlTrdByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantIntlTrdCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantIntlTrdFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantIntlTrdUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantMRPArea;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantMRPAreaByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantMRPAreaCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantMRPAreaFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantMRPAreaUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantProcurement;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantProcurementByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantProcurementCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantProcurementFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantProcurementUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantQualityMgmt;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantQualityMgmtByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantQualityMgmtCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantQualityMgmtFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantQualityMgmtUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantSales;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantSalesByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantSalesCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantSalesFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantSalesUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantStorage;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantStorageByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantStorageCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantStorageFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantStorageUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantTextCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantTextDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantTextUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductProcurement;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductProcurementByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductProcurementCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductProcurementFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductProcurementUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPurchaseText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPurchaseTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPurchaseTextCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPurchaseTextDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPurchaseTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPurchaseTextUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductQualityMgmt;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductQualityMgmtByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductQualityMgmtCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductQualityMgmtFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductQualityMgmtUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSales;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesDelivery;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesDeliveryByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesDeliveryCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesDeliveryFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesDeliveryUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesTax;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesTaxByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesTaxCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesTaxDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesTaxFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesTaxUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesTextCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesTextDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesTextUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductStorage;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductStorageByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductStorageCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductStorageFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductStorageLocation;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductStorageLocationByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductStorageLocationCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductStorageLocationFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductStorageLocationUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductStorageUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSupplyPlanning;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSupplyPlanningByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSupplyPlanningCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSupplyPlanningFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSupplyPlanningUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductUnitsOfMeasure;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductUnitsOfMeasureByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductUnitsOfMeasureCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductUnitsOfMeasureDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductUnitsOfMeasureEAN;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductUnitsOfMeasureEANByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductUnitsOfMeasureEANCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductUnitsOfMeasureEANDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductUnitsOfMeasureEANFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductUnitsOfMeasureEANUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductUnitsOfMeasureFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductUnitsOfMeasureUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuation;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuationAccount;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuationAccountByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuationAccountCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuationAccountFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuationAccountUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuationByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuationCosting;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuationCostingByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuationCostingCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuationCostingFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuationCostingUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuationCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuationFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuationUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductWorkScheduling;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductWorkSchedulingByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductWorkSchedulingCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductWorkSchedulingFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductWorkSchedulingUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.batch.ProductMasterServiceBatch;

/**
 * <p>
 *
 * The service supports following operations: GET, POST, PUT, PATCH, DELETE. You can create, read, update, and delete
 * product master data at the entity level..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/74/aa2b58a333a107e10000000a441470/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference:
 * <a href='https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_PRODUCT_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_PRODUCT_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.2.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Product Integration(SAP_COM_0009), Distributed Manufacturing Integration(SAP_COM_0077), SAP Analytics Cloud for
 * Planning Integration(SAP_COM_0087), Excise Tax Integration(SAP_COM_0568), Procurement - Supplier Quotation Management
 * Integration(SAP_COM_0760), S/4HANA QM/NCM - Supplier Problem-Solving Integration(SAP_COM_0808), S/4HANA QM/NCM -
 * Quality Issue Resolution Integration(SAP_COM_0837)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/1RO'>Master Data Integration(1RO)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/1VP'>Opportunity-to-Order with SAP Cloud for Customer(1VP)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/1NX'>Collaborative Manufacturing with SAP Digital Manufacturing
 * Cloud(1NX)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/1YB'>Import Connection setup with SAP Analytics
 * Cloud(1YB)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/4LO'>Enablement of SAP Excise Tax Management(4LO)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/4RD'>Direct Material Sourcing(4RD)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/2F9'>Quality Management for Complaints Against Suppliers(2F9)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/2FA'>Quality Management for Complaints from Customers(2FA)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Product</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Deprecated
public interface ProductMasterService extends BatchService<ProductMasterServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_PRODUCT_SRV";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    ProductMasterService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.Product Product}
     * entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.Product Product} entities. This
     *         fluent helper allows methods which modify the underlying query to be called before executing the query
     *         itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductFluentHelper getAllProduct();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.Product Product} entity
     * using key fields.
     *
     * @param product
     *            Product Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.Product Product} entity using
     *         key fields. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductByKeyFluentHelper getProductByKey( final String product );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.Product Product} entity and
     * save it to the S/4HANA system.
     *
     * @param product
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.Product Product} entity
     *            object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.Product Product} entity. To
     *         perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductCreateFluentHelper createProduct( @Nonnull final Product product );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.Product Product}
     * entity and save it to the S/4HANA system.
     *
     * @param product
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.Product Product} entity
     *            object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.Product Product} entity. To
     *         perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductUpdateFluentHelper updateProduct( @Nonnull final Product product );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductBasicText
     * ProductBasicText} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductBasicText
     *         ProductBasicText} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductBasicTextFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductBasicTextFluentHelper getAllProductBasicText();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductBasicText
     * ProductBasicText} entity using key fields.
     *
     * @param product
     *            Material Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductBasicText
     *         ProductBasicText} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductBasicTextByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductBasicTextByKeyFluentHelper getProductBasicTextByKey( final String product, final String language );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductBasicText
     * ProductBasicText} entity and save it to the S/4HANA system.
     *
     * @param productBasicText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductBasicText
     *            ProductBasicText} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductBasicText
     *         ProductBasicText} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductBasicTextCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductBasicTextCreateFluentHelper createProductBasicText( @Nonnull final ProductBasicText productBasicText );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductBasicText
     * ProductBasicText} entity and save it to the S/4HANA system.
     *
     * @param productBasicText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductBasicText
     *            ProductBasicText} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductBasicText
     *         ProductBasicText} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductBasicTextUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductBasicTextUpdateFluentHelper updateProductBasicText( @Nonnull final ProductBasicText productBasicText );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductBasicText
     * ProductBasicText} entity in the S/4HANA system.
     *
     * @param productBasicText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductBasicText
     *            ProductBasicText} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductBasicText
     *         ProductBasicText} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductBasicTextDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductBasicTextDeleteFluentHelper deleteProductBasicText( @Nonnull final ProductBasicText productBasicText );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductDescription
     * ProductDescription} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductDescription
     *         ProductDescription} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductDescriptionFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductDescriptionFluentHelper getAllProductDescription();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductDescription
     * ProductDescription} entity using key fields.
     *
     * @param product
     *            Product Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductDescription
     *         ProductDescription} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductDescriptionByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductDescriptionByKeyFluentHelper getProductDescriptionByKey( final String product, final String language );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductDescription
     * ProductDescription} entity and save it to the S/4HANA system.
     *
     * @param productDescription
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductDescription
     *            ProductDescription} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductDescription
     *         ProductDescription} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductDescriptionCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductDescriptionCreateFluentHelper
        createProductDescription( @Nonnull final ProductDescription productDescription );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductDescription
     * ProductDescription} entity and save it to the S/4HANA system.
     *
     * @param productDescription
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductDescription
     *            ProductDescription} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductDescription
     *         ProductDescription} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductDescriptionUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductDescriptionUpdateFluentHelper
        updateProductDescription( @Nonnull final ProductDescription productDescription );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductDescription
     * ProductDescription} entity in the S/4HANA system.
     *
     * @param productDescription
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductDescription
     *            ProductDescription} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductDescription
     *         ProductDescription} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductDescriptionDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductDescriptionDeleteFluentHelper
        deleteProductDescription( @Nonnull final ProductDescription productDescription );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductInspectionText
     * ProductInspectionText} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductInspectionText
     *         ProductInspectionText} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductInspectionTextFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductInspectionTextFluentHelper getAllProductInspectionText();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductInspectionText
     * ProductInspectionText} entity using key fields.
     *
     * @param product
     *            Material Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductInspectionText
     *         ProductInspectionText} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductInspectionTextByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductInspectionTextByKeyFluentHelper getProductInspectionTextByKey( final String product, final String language );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductInspectionText
     * ProductInspectionText} entity and save it to the S/4HANA system.
     *
     * @param productInspectionText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductInspectionText
     *            ProductInspectionText} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductInspectionText
     *         ProductInspectionText} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductInspectionTextCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductInspectionTextCreateFluentHelper
        createProductInspectionText( @Nonnull final ProductInspectionText productInspectionText );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductInspectionText
     * ProductInspectionText} entity and save it to the S/4HANA system.
     *
     * @param productInspectionText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductInspectionText
     *            ProductInspectionText} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductInspectionText
     *         ProductInspectionText} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductInspectionTextUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductInspectionTextUpdateFluentHelper
        updateProductInspectionText( @Nonnull final ProductInspectionText productInspectionText );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductInspectionText
     * ProductInspectionText} entity in the S/4HANA system.
     *
     * @param productInspectionText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductInspectionText
     *            ProductInspectionText} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductInspectionText
     *         ProductInspectionText} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductInspectionTextDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductInspectionTextDeleteFluentHelper
        deleteProductInspectionText( @Nonnull final ProductInspectionText productInspectionText );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductMLAccount
     * ProductMLAccount} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductMLAccount
     *         ProductMLAccount} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductMLAccountFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductMLAccountFluentHelper getAllProductMLAccount();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductMLAccount
     * ProductMLAccount} entity using key fields.
     *
     * @param product
     *            Material Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @param valuationArea
     *            Valuation Area
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param currencyRole
     *            External Currency Type and Valuation View
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param valuationType
     *            Valuation Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductMLAccount
     *         ProductMLAccount} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductMLAccountByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductMLAccountByKeyFluentHelper getProductMLAccountByKey(
        final String product,
        final String valuationArea,
        final String valuationType,
        final String currencyRole );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductMLAccount
     * ProductMLAccount} entity and save it to the S/4HANA system.
     *
     * @param productMLAccount
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductMLAccount
     *            ProductMLAccount} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductMLAccount
     *         ProductMLAccount} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductMLAccountCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductMLAccountCreateFluentHelper createProductMLAccount( @Nonnull final ProductMLAccount productMLAccount );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductMLAccount
     * ProductMLAccount} entity and save it to the S/4HANA system.
     *
     * @param productMLAccount
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductMLAccount
     *            ProductMLAccount} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductMLAccount
     *         ProductMLAccount} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductMLAccountUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductMLAccountUpdateFluentHelper updateProductMLAccount( @Nonnull final ProductMLAccount productMLAccount );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductMLPrices
     * ProductMLPrices} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductMLPrices ProductMLPrices}
     *         entities. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductMLPricesFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductMLPricesFluentHelper getAllProductMLPrices();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductMLPrices
     * ProductMLPrices} entity using key fields.
     *
     * @param product
     *            Material Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @param valuationArea
     *            Valuation Area
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param currencyRole
     *            External Currency Type and Valuation View
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param valuationType
     *            Valuation Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductMLPrices ProductMLPrices}
     *         entity using key fields. This fluent helper allows methods which modify the underlying query to be called
     *         before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductMLPricesByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductMLPricesByKeyFluentHelper getProductMLPricesByKey(
        final String product,
        final String valuationArea,
        final String valuationType,
        final String currencyRole );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductMLPrices
     * ProductMLPrices} entity and save it to the S/4HANA system.
     *
     * @param productMLPrices
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductMLPrices
     *            ProductMLPrices} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductMLPrices ProductMLPrices}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductMLPricesCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductMLPricesCreateFluentHelper createProductMLPrices( @Nonnull final ProductMLPrices productMLPrices );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductMLPrices
     * ProductMLPrices} entity and save it to the S/4HANA system.
     *
     * @param productMLPrices
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductMLPrices
     *            ProductMLPrices} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductMLPrices ProductMLPrices}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductMLPricesUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductMLPricesUpdateFluentHelper updateProductMLPrices( @Nonnull final ProductMLPrices productMLPrices );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlant
     * ProductPlant} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlant ProductPlant}
     *         entities. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductPlantFluentHelper getAllProductPlant();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlant
     * ProductPlant} entity using key fields.
     *
     * @param product
     *            Material Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @param plant
     *            Plant
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlant ProductPlant}
     *         entity using key fields. This fluent helper allows methods which modify the underlying query to be called
     *         before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductPlantByKeyFluentHelper getProductPlantByKey( final String product, final String plant );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlant ProductPlant}
     * entity and save it to the S/4HANA system.
     *
     * @param productPlant
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlant ProductPlant}
     *            entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlant ProductPlant}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductPlantCreateFluentHelper createProductPlant( @Nonnull final ProductPlant productPlant );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlant
     * ProductPlant} entity and save it to the S/4HANA system.
     *
     * @param productPlant
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlant ProductPlant}
     *            entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlant ProductPlant}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductPlantUpdateFluentHelper updateProductPlant( @Nonnull final ProductPlant productPlant );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantCosting
     * ProductPlantCosting} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantCosting
     *         ProductPlantCosting} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantCostingFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductPlantCostingFluentHelper getAllProductPlantCosting();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantCosting
     * ProductPlantCosting} entity using key fields.
     *
     * @param product
     *            Product Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @param plant
     *            Plant
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantCosting
     *         ProductPlantCosting} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantCostingByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductPlantCostingByKeyFluentHelper getProductPlantCostingByKey( final String product, final String plant );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantCosting
     * ProductPlantCosting} entity and save it to the S/4HANA system.
     *
     * @param productPlantCosting
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantCosting
     *            ProductPlantCosting} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantCosting
     *         ProductPlantCosting} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantCostingCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductPlantCostingCreateFluentHelper
        createProductPlantCosting( @Nonnull final ProductPlantCosting productPlantCosting );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantCosting
     * ProductPlantCosting} entity and save it to the S/4HANA system.
     *
     * @param productPlantCosting
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantCosting
     *            ProductPlantCosting} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantCosting
     *         ProductPlantCosting} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantCostingUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductPlantCostingUpdateFluentHelper
        updateProductPlantCosting( @Nonnull final ProductPlantCosting productPlantCosting );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantForecasting
     * ProductPlantForecasting} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantForecasting
     *         ProductPlantForecasting} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantForecastingFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductPlantForecastingFluentHelper getAllProductPlantForecasting();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantForecasting
     * ProductPlantForecasting} entity using key fields.
     *
     * @param product
     *            Product Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @param plant
     *            Plant
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantForecasting
     *         ProductPlantForecasting} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantForecastingByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductPlantForecastingByKeyFluentHelper
        getProductPlantForecastingByKey( final String product, final String plant );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantForecasting
     * ProductPlantForecasting} entity and save it to the S/4HANA system.
     *
     * @param productPlantForecasting
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantForecasting
     *            ProductPlantForecasting} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantForecasting
     *         ProductPlantForecasting} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantForecastingCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductPlantForecastingCreateFluentHelper
        createProductPlantForecasting( @Nonnull final ProductPlantForecasting productPlantForecasting );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantForecasting
     * ProductPlantForecasting} entity and save it to the S/4HANA system.
     *
     * @param productPlantForecasting
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantForecasting
     *            ProductPlantForecasting} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantForecasting
     *         ProductPlantForecasting} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantForecastingUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductPlantForecastingUpdateFluentHelper
        updateProductPlantForecasting( @Nonnull final ProductPlantForecasting productPlantForecasting );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantIntlTrd
     * ProductPlantIntlTrd} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantIntlTrd
     *         ProductPlantIntlTrd} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantIntlTrdFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductPlantIntlTrdFluentHelper getAllProductPlantIntlTrd();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantIntlTrd
     * ProductPlantIntlTrd} entity using key fields.
     *
     * @param product
     *            Product Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @param plant
     *            Plant
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantIntlTrd
     *         ProductPlantIntlTrd} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantIntlTrdByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductPlantIntlTrdByKeyFluentHelper getProductPlantIntlTrdByKey( final String product, final String plant );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantIntlTrd
     * ProductPlantIntlTrd} entity and save it to the S/4HANA system.
     *
     * @param productPlantIntlTrd
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantIntlTrd
     *            ProductPlantIntlTrd} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantIntlTrd
     *         ProductPlantIntlTrd} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantIntlTrdCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductPlantIntlTrdCreateFluentHelper
        createProductPlantIntlTrd( @Nonnull final ProductPlantIntlTrd productPlantIntlTrd );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantIntlTrd
     * ProductPlantIntlTrd} entity and save it to the S/4HANA system.
     *
     * @param productPlantIntlTrd
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantIntlTrd
     *            ProductPlantIntlTrd} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantIntlTrd
     *         ProductPlantIntlTrd} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantIntlTrdUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductPlantIntlTrdUpdateFluentHelper
        updateProductPlantIntlTrd( @Nonnull final ProductPlantIntlTrd productPlantIntlTrd );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantMRPArea
     * ProductPlantMRPArea} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantMRPArea
     *         ProductPlantMRPArea} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantMRPAreaFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductPlantMRPAreaFluentHelper getAllProductPlantMRPArea();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantMRPArea
     * ProductPlantMRPArea} entity using key fields.
     *
     * @param product
     *            Material Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @param mRPArea
     *            MRP Area
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param plant
     *            MRP Area: Plant
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantMRPArea
     *         ProductPlantMRPArea} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantMRPAreaByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductPlantMRPAreaByKeyFluentHelper
        getProductPlantMRPAreaByKey( final String product, final String plant, final String mRPArea );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantMRPArea
     * ProductPlantMRPArea} entity and save it to the S/4HANA system.
     *
     * @param productPlantMRPArea
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantMRPArea
     *            ProductPlantMRPArea} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantMRPArea
     *         ProductPlantMRPArea} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantMRPAreaCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductPlantMRPAreaCreateFluentHelper
        createProductPlantMRPArea( @Nonnull final ProductPlantMRPArea productPlantMRPArea );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantMRPArea
     * ProductPlantMRPArea} entity and save it to the S/4HANA system.
     *
     * @param productPlantMRPArea
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantMRPArea
     *            ProductPlantMRPArea} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantMRPArea
     *         ProductPlantMRPArea} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantMRPAreaUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductPlantMRPAreaUpdateFluentHelper
        updateProductPlantMRPArea( @Nonnull final ProductPlantMRPArea productPlantMRPArea );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantProcurement
     * ProductPlantProcurement} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantProcurement
     *         ProductPlantProcurement} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantProcurementFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductPlantProcurementFluentHelper getAllProductPlantProcurement();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantProcurement
     * ProductPlantProcurement} entity using key fields.
     *
     * @param product
     *            Product Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @param plant
     *            Plant
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantProcurement
     *         ProductPlantProcurement} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantProcurementByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductPlantProcurementByKeyFluentHelper
        getProductPlantProcurementByKey( final String product, final String plant );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantProcurement
     * ProductPlantProcurement} entity and save it to the S/4HANA system.
     *
     * @param productPlantProcurement
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantProcurement
     *            ProductPlantProcurement} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantProcurement
     *         ProductPlantProcurement} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantProcurementCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductPlantProcurementCreateFluentHelper
        createProductPlantProcurement( @Nonnull final ProductPlantProcurement productPlantProcurement );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantProcurement
     * ProductPlantProcurement} entity and save it to the S/4HANA system.
     *
     * @param productPlantProcurement
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantProcurement
     *            ProductPlantProcurement} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantProcurement
     *         ProductPlantProcurement} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantProcurementUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductPlantProcurementUpdateFluentHelper
        updateProductPlantProcurement( @Nonnull final ProductPlantProcurement productPlantProcurement );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantQualityMgmt
     * ProductPlantQualityMgmt} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantQualityMgmt
     *         ProductPlantQualityMgmt} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantQualityMgmtFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductPlantQualityMgmtFluentHelper getAllProductPlantQualityMgmt();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantQualityMgmt
     * ProductPlantQualityMgmt} entity using key fields.
     *
     * @param product
     *            Product Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @param plant
     *            Plant
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantQualityMgmt
     *         ProductPlantQualityMgmt} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantQualityMgmtByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductPlantQualityMgmtByKeyFluentHelper
        getProductPlantQualityMgmtByKey( final String product, final String plant );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantQualityMgmt
     * ProductPlantQualityMgmt} entity and save it to the S/4HANA system.
     *
     * @param productPlantQualityMgmt
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantQualityMgmt
     *            ProductPlantQualityMgmt} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantQualityMgmt
     *         ProductPlantQualityMgmt} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantQualityMgmtCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductPlantQualityMgmtCreateFluentHelper
        createProductPlantQualityMgmt( @Nonnull final ProductPlantQualityMgmt productPlantQualityMgmt );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantQualityMgmt
     * ProductPlantQualityMgmt} entity and save it to the S/4HANA system.
     *
     * @param productPlantQualityMgmt
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantQualityMgmt
     *            ProductPlantQualityMgmt} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantQualityMgmt
     *         ProductPlantQualityMgmt} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantQualityMgmtUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductPlantQualityMgmtUpdateFluentHelper
        updateProductPlantQualityMgmt( @Nonnull final ProductPlantQualityMgmt productPlantQualityMgmt );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantSales
     * ProductPlantSales} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantSales
     *         ProductPlantSales} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantSalesFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductPlantSalesFluentHelper getAllProductPlantSales();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantSales
     * ProductPlantSales} entity using key fields.
     *
     * @param product
     *            Product Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @param plant
     *            Plant
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantSales
     *         ProductPlantSales} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantSalesByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductPlantSalesByKeyFluentHelper getProductPlantSalesByKey( final String product, final String plant );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantSales
     * ProductPlantSales} entity and save it to the S/4HANA system.
     *
     * @param productPlantSales
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantSales
     *            ProductPlantSales} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantSales
     *         ProductPlantSales} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantSalesCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductPlantSalesCreateFluentHelper createProductPlantSales( @Nonnull final ProductPlantSales productPlantSales );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantSales
     * ProductPlantSales} entity and save it to the S/4HANA system.
     *
     * @param productPlantSales
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantSales
     *            ProductPlantSales} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantSales
     *         ProductPlantSales} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantSalesUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductPlantSalesUpdateFluentHelper updateProductPlantSales( @Nonnull final ProductPlantSales productPlantSales );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantStorage
     * ProductPlantStorage} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantStorage
     *         ProductPlantStorage} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantStorageFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductPlantStorageFluentHelper getAllProductPlantStorage();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantStorage
     * ProductPlantStorage} entity using key fields.
     *
     * @param product
     *            Product Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @param plant
     *            Plant
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantStorage
     *         ProductPlantStorage} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantStorageByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductPlantStorageByKeyFluentHelper getProductPlantStorageByKey( final String product, final String plant );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantStorage
     * ProductPlantStorage} entity and save it to the S/4HANA system.
     *
     * @param productPlantStorage
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantStorage
     *            ProductPlantStorage} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantStorage
     *         ProductPlantStorage} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantStorageCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductPlantStorageCreateFluentHelper
        createProductPlantStorage( @Nonnull final ProductPlantStorage productPlantStorage );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantStorage
     * ProductPlantStorage} entity and save it to the S/4HANA system.
     *
     * @param productPlantStorage
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantStorage
     *            ProductPlantStorage} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantStorage
     *         ProductPlantStorage} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantStorageUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductPlantStorageUpdateFluentHelper
        updateProductPlantStorage( @Nonnull final ProductPlantStorage productPlantStorage );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantText
     * ProductPlantText} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantText
     *         ProductPlantText} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantTextFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductPlantTextFluentHelper getAllProductPlantText();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantText
     * ProductPlantText} entity using key fields.
     *
     * @param product
     *            Material Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @param plant
     *            Plant
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantText
     *         ProductPlantText} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantTextByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductPlantTextByKeyFluentHelper getProductPlantTextByKey( final String product, final String plant );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantText
     * ProductPlantText} entity and save it to the S/4HANA system.
     *
     * @param productPlantText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantText
     *            ProductPlantText} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantText
     *         ProductPlantText} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantTextCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductPlantTextCreateFluentHelper createProductPlantText( @Nonnull final ProductPlantText productPlantText );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantText
     * ProductPlantText} entity and save it to the S/4HANA system.
     *
     * @param productPlantText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantText
     *            ProductPlantText} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantText
     *         ProductPlantText} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantTextUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductPlantTextUpdateFluentHelper updateProductPlantText( @Nonnull final ProductPlantText productPlantText );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantText
     * ProductPlantText} entity in the S/4HANA system.
     *
     * @param productPlantText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantText
     *            ProductPlantText} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantText
     *         ProductPlantText} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPlantTextDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductPlantTextDeleteFluentHelper deleteProductPlantText( @Nonnull final ProductPlantText productPlantText );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductProcurement
     * ProductProcurement} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductProcurement
     *         ProductProcurement} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductProcurementFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductProcurementFluentHelper getAllProductProcurement();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductProcurement
     * ProductProcurement} entity using key fields.
     *
     * @param product
     *            Material Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductProcurement
     *         ProductProcurement} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductProcurementByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductProcurementByKeyFluentHelper getProductProcurementByKey( final String product );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductProcurement
     * ProductProcurement} entity and save it to the S/4HANA system.
     *
     * @param productProcurement
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductProcurement
     *            ProductProcurement} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductProcurement
     *         ProductProcurement} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductProcurementCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductProcurementCreateFluentHelper
        createProductProcurement( @Nonnull final ProductProcurement productProcurement );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductProcurement
     * ProductProcurement} entity and save it to the S/4HANA system.
     *
     * @param productProcurement
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductProcurement
     *            ProductProcurement} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductProcurement
     *         ProductProcurement} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductProcurementUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductProcurementUpdateFluentHelper
        updateProductProcurement( @Nonnull final ProductProcurement productProcurement );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPurchaseText
     * ProductPurchaseText} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPurchaseText
     *         ProductPurchaseText} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPurchaseTextFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductPurchaseTextFluentHelper getAllProductPurchaseText();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPurchaseText
     * ProductPurchaseText} entity using key fields.
     *
     * @param product
     *            Material Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPurchaseText
     *         ProductPurchaseText} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPurchaseTextByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductPurchaseTextByKeyFluentHelper getProductPurchaseTextByKey( final String product, final String language );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPurchaseText
     * ProductPurchaseText} entity and save it to the S/4HANA system.
     *
     * @param productPurchaseText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPurchaseText
     *            ProductPurchaseText} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPurchaseText
     *         ProductPurchaseText} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPurchaseTextCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductPurchaseTextCreateFluentHelper
        createProductPurchaseText( @Nonnull final ProductPurchaseText productPurchaseText );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPurchaseText
     * ProductPurchaseText} entity and save it to the S/4HANA system.
     *
     * @param productPurchaseText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPurchaseText
     *            ProductPurchaseText} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPurchaseText
     *         ProductPurchaseText} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPurchaseTextUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductPurchaseTextUpdateFluentHelper
        updateProductPurchaseText( @Nonnull final ProductPurchaseText productPurchaseText );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPurchaseText
     * ProductPurchaseText} entity in the S/4HANA system.
     *
     * @param productPurchaseText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPurchaseText
     *            ProductPurchaseText} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPurchaseText
     *         ProductPurchaseText} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductPurchaseTextDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductPurchaseTextDeleteFluentHelper
        deleteProductPurchaseText( @Nonnull final ProductPurchaseText productPurchaseText );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductQualityMgmt
     * ProductQualityMgmt} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductQualityMgmt
     *         ProductQualityMgmt} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductQualityMgmtFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductQualityMgmtFluentHelper getAllProductQualityMgmt();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductQualityMgmt
     * ProductQualityMgmt} entity using key fields.
     *
     * @param product
     *            Product Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductQualityMgmt
     *         ProductQualityMgmt} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductQualityMgmtByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductQualityMgmtByKeyFluentHelper getProductQualityMgmtByKey( final String product );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductQualityMgmt
     * ProductQualityMgmt} entity and save it to the S/4HANA system.
     *
     * @param productQualityMgmt
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductQualityMgmt
     *            ProductQualityMgmt} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductQualityMgmt
     *         ProductQualityMgmt} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductQualityMgmtCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductQualityMgmtCreateFluentHelper
        createProductQualityMgmt( @Nonnull final ProductQualityMgmt productQualityMgmt );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductQualityMgmt
     * ProductQualityMgmt} entity and save it to the S/4HANA system.
     *
     * @param productQualityMgmt
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductQualityMgmt
     *            ProductQualityMgmt} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductQualityMgmt
     *         ProductQualityMgmt} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductQualityMgmtUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductQualityMgmtUpdateFluentHelper
        updateProductQualityMgmt( @Nonnull final ProductQualityMgmt productQualityMgmt );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSales
     * ProductSales} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSales ProductSales}
     *         entities. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductSalesFluentHelper getAllProductSales();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSales
     * ProductSales} entity using key fields.
     *
     * @param product
     *            Material Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSales ProductSales}
     *         entity using key fields. This fluent helper allows methods which modify the underlying query to be called
     *         before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductSalesByKeyFluentHelper getProductSalesByKey( final String product );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSales ProductSales}
     * entity and save it to the S/4HANA system.
     *
     * @param productSales
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSales ProductSales}
     *            entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSales ProductSales}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductSalesCreateFluentHelper createProductSales( @Nonnull final ProductSales productSales );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSales
     * ProductSales} entity and save it to the S/4HANA system.
     *
     * @param productSales
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSales ProductSales}
     *            entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSales ProductSales}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductSalesUpdateFluentHelper updateProductSales( @Nonnull final ProductSales productSales );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesDelivery
     * ProductSalesDelivery} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesDelivery
     *         ProductSalesDelivery} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesDeliveryFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductSalesDeliveryFluentHelper getAllProductSalesDelivery();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesDelivery
     * ProductSalesDelivery} entity using key fields.
     *
     * @param product
     *            Product Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @param productDistributionChnl
     *            Distribution Channel
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param productSalesOrg
     *            Sales Organization
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesDelivery
     *         ProductSalesDelivery} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesDeliveryByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductSalesDeliveryByKeyFluentHelper getProductSalesDeliveryByKey(
        final String product,
        final String productSalesOrg,
        final String productDistributionChnl );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesDelivery
     * ProductSalesDelivery} entity and save it to the S/4HANA system.
     *
     * @param productSalesDelivery
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesDelivery
     *            ProductSalesDelivery} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesDelivery
     *         ProductSalesDelivery} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesDeliveryCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductSalesDeliveryCreateFluentHelper
        createProductSalesDelivery( @Nonnull final ProductSalesDelivery productSalesDelivery );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesDelivery
     * ProductSalesDelivery} entity and save it to the S/4HANA system.
     *
     * @param productSalesDelivery
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesDelivery
     *            ProductSalesDelivery} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesDelivery
     *         ProductSalesDelivery} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesDeliveryUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductSalesDeliveryUpdateFluentHelper
        updateProductSalesDelivery( @Nonnull final ProductSalesDelivery productSalesDelivery );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesTax
     * ProductSalesTax} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesTax ProductSalesTax}
     *         entities. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesTaxFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductSalesTaxFluentHelper getAllProductSalesTax();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesTax
     * ProductSalesTax} entity using key fields.
     *
     * @param country
     *            Departure Country/Region (from which the goods are sent)
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @param product
     *            Product Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @param taxClassification
     *
     * @param taxCategory
     *            Tax Condition Type (Sales Tax, Value-Added Tax,...)
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesTax ProductSalesTax}
     *         entity using key fields. This fluent helper allows methods which modify the underlying query to be called
     *         before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesTaxByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductSalesTaxByKeyFluentHelper getProductSalesTaxByKey(
        final String product,
        final String country,
        final String taxCategory,
        final String taxClassification );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesTax
     * ProductSalesTax} entity and save it to the S/4HANA system.
     *
     * @param productSalesTax
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesTax
     *            ProductSalesTax} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesTax ProductSalesTax}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesTaxCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductSalesTaxCreateFluentHelper createProductSalesTax( @Nonnull final ProductSalesTax productSalesTax );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesTax
     * ProductSalesTax} entity and save it to the S/4HANA system.
     *
     * @param productSalesTax
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesTax
     *            ProductSalesTax} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesTax ProductSalesTax}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesTaxUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductSalesTaxUpdateFluentHelper updateProductSalesTax( @Nonnull final ProductSalesTax productSalesTax );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesTax
     * ProductSalesTax} entity in the S/4HANA system.
     *
     * @param productSalesTax
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesTax
     *            ProductSalesTax} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesTax ProductSalesTax}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesTaxDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductSalesTaxDeleteFluentHelper deleteProductSalesTax( @Nonnull final ProductSalesTax productSalesTax );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesText
     * ProductSalesText} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesText
     *         ProductSalesText} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesTextFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductSalesTextFluentHelper getAllProductSalesText();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesText
     * ProductSalesText} entity using key fields.
     *
     * @param product
     *            Product Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @param productDistributionChnl
     *            Distribution Channel
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param productSalesOrg
     *            Sales Organization
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesText
     *         ProductSalesText} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesTextByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductSalesTextByKeyFluentHelper getProductSalesTextByKey(
        final String product,
        final String productSalesOrg,
        final String productDistributionChnl,
        final String language );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesText
     * ProductSalesText} entity and save it to the S/4HANA system.
     *
     * @param productSalesText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesText
     *            ProductSalesText} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesText
     *         ProductSalesText} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesTextCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductSalesTextCreateFluentHelper createProductSalesText( @Nonnull final ProductSalesText productSalesText );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesText
     * ProductSalesText} entity and save it to the S/4HANA system.
     *
     * @param productSalesText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesText
     *            ProductSalesText} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesText
     *         ProductSalesText} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesTextUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductSalesTextUpdateFluentHelper updateProductSalesText( @Nonnull final ProductSalesText productSalesText );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesText
     * ProductSalesText} entity in the S/4HANA system.
     *
     * @param productSalesText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesText
     *            ProductSalesText} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesText
     *         ProductSalesText} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSalesTextDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductSalesTextDeleteFluentHelper deleteProductSalesText( @Nonnull final ProductSalesText productSalesText );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductStorage
     * ProductStorage} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductStorage ProductStorage}
     *         entities. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductStorageFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductStorageFluentHelper getAllProductStorage();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductStorage
     * ProductStorage} entity using key fields.
     *
     * @param product
     *            Material Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductStorage ProductStorage}
     *         entity using key fields. This fluent helper allows methods which modify the underlying query to be called
     *         before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductStorageByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductStorageByKeyFluentHelper getProductStorageByKey( final String product );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductStorage
     * ProductStorage} entity and save it to the S/4HANA system.
     *
     * @param productStorage
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductStorage
     *            ProductStorage} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductStorage ProductStorage}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductStorageCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductStorageCreateFluentHelper createProductStorage( @Nonnull final ProductStorage productStorage );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductStorage
     * ProductStorage} entity and save it to the S/4HANA system.
     *
     * @param productStorage
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductStorage
     *            ProductStorage} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductStorage ProductStorage}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductStorageUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductStorageUpdateFluentHelper updateProductStorage( @Nonnull final ProductStorage productStorage );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductStorageLocation
     * ProductStorageLocation} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductStorageLocation
     *         ProductStorageLocation} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductStorageLocationFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductStorageLocationFluentHelper getAllProductStorageLocation();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductStorageLocation
     * ProductStorageLocation} entity using key fields.
     *
     * @param product
     *            Material Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @param plant
     *            Plant
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param storageLocation
     *            Storage Location
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductStorageLocation
     *         ProductStorageLocation} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductStorageLocationByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductStorageLocationByKeyFluentHelper
        getProductStorageLocationByKey( final String product, final String plant, final String storageLocation );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductStorageLocation
     * ProductStorageLocation} entity and save it to the S/4HANA system.
     *
     * @param productStorageLocation
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductStorageLocation
     *            ProductStorageLocation} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductStorageLocation
     *         ProductStorageLocation} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductStorageLocationCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductStorageLocationCreateFluentHelper
        createProductStorageLocation( @Nonnull final ProductStorageLocation productStorageLocation );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductStorageLocation
     * ProductStorageLocation} entity and save it to the S/4HANA system.
     *
     * @param productStorageLocation
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductStorageLocation
     *            ProductStorageLocation} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductStorageLocation
     *         ProductStorageLocation} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductStorageLocationUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductStorageLocationUpdateFluentHelper
        updateProductStorageLocation( @Nonnull final ProductStorageLocation productStorageLocation );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSupplyPlanning
     * ProductSupplyPlanning} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSupplyPlanning
     *         ProductSupplyPlanning} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSupplyPlanningFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductSupplyPlanningFluentHelper getAllProductSupplyPlanning();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSupplyPlanning
     * ProductSupplyPlanning} entity using key fields.
     *
     * @param product
     *            Product Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @param plant
     *            Plant
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSupplyPlanning
     *         ProductSupplyPlanning} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSupplyPlanningByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductSupplyPlanningByKeyFluentHelper getProductSupplyPlanningByKey( final String product, final String plant );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSupplyPlanning
     * ProductSupplyPlanning} entity and save it to the S/4HANA system.
     *
     * @param productSupplyPlanning
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSupplyPlanning
     *            ProductSupplyPlanning} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSupplyPlanning
     *         ProductSupplyPlanning} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSupplyPlanningCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductSupplyPlanningCreateFluentHelper
        createProductSupplyPlanning( @Nonnull final ProductSupplyPlanning productSupplyPlanning );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSupplyPlanning
     * ProductSupplyPlanning} entity and save it to the S/4HANA system.
     *
     * @param productSupplyPlanning
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSupplyPlanning
     *            ProductSupplyPlanning} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSupplyPlanning
     *         ProductSupplyPlanning} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductSupplyPlanningUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductSupplyPlanningUpdateFluentHelper
        updateProductSupplyPlanning( @Nonnull final ProductSupplyPlanning productSupplyPlanning );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductUnitsOfMeasure
     * ProductUnitsOfMeasure} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductUnitsOfMeasure
     *         ProductUnitsOfMeasure} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductUnitsOfMeasureFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductUnitsOfMeasureFluentHelper getAllProductUnitsOfMeasure();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductUnitsOfMeasure
     * ProductUnitsOfMeasure} entity using key fields.
     *
     * @param product
     *            Product Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @param alternativeUnit
     *            Alternative Unit of Measure for Stockkeeping Unit
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductUnitsOfMeasure
     *         ProductUnitsOfMeasure} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductUnitsOfMeasureByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductUnitsOfMeasureByKeyFluentHelper
        getProductUnitsOfMeasureByKey( final String product, final String alternativeUnit );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductUnitsOfMeasure
     * ProductUnitsOfMeasure} entity and save it to the S/4HANA system.
     *
     * @param productUnitsOfMeasure
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductUnitsOfMeasure
     *            ProductUnitsOfMeasure} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductUnitsOfMeasure
     *         ProductUnitsOfMeasure} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductUnitsOfMeasureCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductUnitsOfMeasureCreateFluentHelper
        createProductUnitsOfMeasure( @Nonnull final ProductUnitsOfMeasure productUnitsOfMeasure );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductUnitsOfMeasure
     * ProductUnitsOfMeasure} entity and save it to the S/4HANA system.
     *
     * @param productUnitsOfMeasure
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductUnitsOfMeasure
     *            ProductUnitsOfMeasure} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductUnitsOfMeasure
     *         ProductUnitsOfMeasure} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductUnitsOfMeasureUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductUnitsOfMeasureUpdateFluentHelper
        updateProductUnitsOfMeasure( @Nonnull final ProductUnitsOfMeasure productUnitsOfMeasure );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductUnitsOfMeasure
     * ProductUnitsOfMeasure} entity in the S/4HANA system.
     *
     * @param productUnitsOfMeasure
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductUnitsOfMeasure
     *            ProductUnitsOfMeasure} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductUnitsOfMeasure
     *         ProductUnitsOfMeasure} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductUnitsOfMeasureDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductUnitsOfMeasureDeleteFluentHelper
        deleteProductUnitsOfMeasure( @Nonnull final ProductUnitsOfMeasure productUnitsOfMeasure );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductUnitsOfMeasureEAN
     * ProductUnitsOfMeasureEAN} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductUnitsOfMeasureEAN
     *         ProductUnitsOfMeasureEAN} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductUnitsOfMeasureEANFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductUnitsOfMeasureEANFluentHelper getAllProductUnitsOfMeasureEAN();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductUnitsOfMeasureEAN
     * ProductUnitsOfMeasureEAN} entity using key fields.
     *
     * @param product
     *            Material Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @param alternativeUnit
     *            Unit of Measure for Display
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @param consecutiveNumber
     *            Consecutive Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 5
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductUnitsOfMeasureEAN
     *         ProductUnitsOfMeasureEAN} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductUnitsOfMeasureEANByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductUnitsOfMeasureEANByKeyFluentHelper getProductUnitsOfMeasureEANByKey(
        final String product,
        final String alternativeUnit,
        final String consecutiveNumber );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductUnitsOfMeasureEAN
     * ProductUnitsOfMeasureEAN} entity and save it to the S/4HANA system.
     *
     * @param productUnitsOfMeasureEAN
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductUnitsOfMeasureEAN
     *            ProductUnitsOfMeasureEAN} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductUnitsOfMeasureEAN
     *         ProductUnitsOfMeasureEAN} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductUnitsOfMeasureEANCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductUnitsOfMeasureEANCreateFluentHelper
        createProductUnitsOfMeasureEAN( @Nonnull final ProductUnitsOfMeasureEAN productUnitsOfMeasureEAN );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductUnitsOfMeasureEAN
     * ProductUnitsOfMeasureEAN} entity and save it to the S/4HANA system.
     *
     * @param productUnitsOfMeasureEAN
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductUnitsOfMeasureEAN
     *            ProductUnitsOfMeasureEAN} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductUnitsOfMeasureEAN
     *         ProductUnitsOfMeasureEAN} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductUnitsOfMeasureEANUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductUnitsOfMeasureEANUpdateFluentHelper
        updateProductUnitsOfMeasureEAN( @Nonnull final ProductUnitsOfMeasureEAN productUnitsOfMeasureEAN );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductUnitsOfMeasureEAN
     * ProductUnitsOfMeasureEAN} entity in the S/4HANA system.
     *
     * @param productUnitsOfMeasureEAN
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductUnitsOfMeasureEAN
     *            ProductUnitsOfMeasureEAN} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductUnitsOfMeasureEAN
     *         ProductUnitsOfMeasureEAN} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductUnitsOfMeasureEANDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductUnitsOfMeasureEANDeleteFluentHelper
        deleteProductUnitsOfMeasureEAN( @Nonnull final ProductUnitsOfMeasureEAN productUnitsOfMeasureEAN );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuation
     * ProductValuation} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuation
     *         ProductValuation} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuationFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductValuationFluentHelper getAllProductValuation();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuation
     * ProductValuation} entity using key fields.
     *
     * @param product
     *            Material Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @param valuationArea
     *            Valuation Area
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param valuationType
     *            Valuation Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuation
     *         ProductValuation} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuationByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductValuationByKeyFluentHelper
        getProductValuationByKey( final String product, final String valuationArea, final String valuationType );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuation
     * ProductValuation} entity and save it to the S/4HANA system.
     *
     * @param productValuation
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuation
     *            ProductValuation} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuation
     *         ProductValuation} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuationCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductValuationCreateFluentHelper createProductValuation( @Nonnull final ProductValuation productValuation );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuation
     * ProductValuation} entity and save it to the S/4HANA system.
     *
     * @param productValuation
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuation
     *            ProductValuation} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuation
     *         ProductValuation} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuationUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductValuationUpdateFluentHelper updateProductValuation( @Nonnull final ProductValuation productValuation );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuationAccount
     * ProductValuationAccount} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuationAccount
     *         ProductValuationAccount} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuationAccountFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductValuationAccountFluentHelper getAllProductValuationAccount();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuationAccount
     * ProductValuationAccount} entity using key fields.
     *
     * @param product
     *            Product Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @param valuationArea
     *            Valuation Area
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param valuationType
     *            Valuation Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuationAccount
     *         ProductValuationAccount} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuationAccountByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductValuationAccountByKeyFluentHelper
        getProductValuationAccountByKey( final String product, final String valuationArea, final String valuationType );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuationAccount
     * ProductValuationAccount} entity and save it to the S/4HANA system.
     *
     * @param productValuationAccount
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuationAccount
     *            ProductValuationAccount} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuationAccount
     *         ProductValuationAccount} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuationAccountCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductValuationAccountCreateFluentHelper
        createProductValuationAccount( @Nonnull final ProductValuationAccount productValuationAccount );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuationAccount
     * ProductValuationAccount} entity and save it to the S/4HANA system.
     *
     * @param productValuationAccount
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuationAccount
     *            ProductValuationAccount} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuationAccount
     *         ProductValuationAccount} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuationAccountUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductValuationAccountUpdateFluentHelper
        updateProductValuationAccount( @Nonnull final ProductValuationAccount productValuationAccount );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuationCosting
     * ProductValuationCosting} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuationCosting
     *         ProductValuationCosting} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuationCostingFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductValuationCostingFluentHelper getAllProductValuationCosting();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuationCosting
     * ProductValuationCosting} entity using key fields.
     *
     * @param product
     *            Product Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @param valuationArea
     *            Valuation Area
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param valuationType
     *            Valuation Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuationCosting
     *         ProductValuationCosting} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuationCostingByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductValuationCostingByKeyFluentHelper
        getProductValuationCostingByKey( final String product, final String valuationArea, final String valuationType );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuationCosting
     * ProductValuationCosting} entity and save it to the S/4HANA system.
     *
     * @param productValuationCosting
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuationCosting
     *            ProductValuationCosting} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuationCosting
     *         ProductValuationCosting} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuationCostingCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductValuationCostingCreateFluentHelper
        createProductValuationCosting( @Nonnull final ProductValuationCosting productValuationCosting );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuationCosting
     * ProductValuationCosting} entity and save it to the S/4HANA system.
     *
     * @param productValuationCosting
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuationCosting
     *            ProductValuationCosting} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuationCosting
     *         ProductValuationCosting} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductValuationCostingUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductValuationCostingUpdateFluentHelper
        updateProductValuationCosting( @Nonnull final ProductValuationCosting productValuationCosting );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductWorkScheduling
     * ProductWorkScheduling} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductWorkScheduling
     *         ProductWorkScheduling} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductWorkSchedulingFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductWorkSchedulingFluentHelper getAllProductWorkScheduling();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductWorkScheduling
     * ProductWorkScheduling} entity using key fields.
     *
     * @param product
     *            Product Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @param plant
     *            Plant
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductWorkScheduling
     *         ProductWorkScheduling} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductWorkSchedulingByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductWorkSchedulingByKeyFluentHelper getProductWorkSchedulingByKey( final String product, final String plant );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductWorkScheduling
     * ProductWorkScheduling} entity and save it to the S/4HANA system.
     *
     * @param productWorkScheduling
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductWorkScheduling
     *            ProductWorkScheduling} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductWorkScheduling
     *         ProductWorkScheduling} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductWorkSchedulingCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductWorkSchedulingCreateFluentHelper
        createProductWorkScheduling( @Nonnull final ProductWorkScheduling productWorkScheduling );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductWorkScheduling
     * ProductWorkScheduling} entity and save it to the S/4HANA system.
     *
     * @param productWorkScheduling
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductWorkScheduling
     *            ProductWorkScheduling} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductWorkScheduling
     *         ProductWorkScheduling} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productmaster.ProductWorkSchedulingUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductWorkSchedulingUpdateFluentHelper
        updateProductWorkScheduling( @Nonnull final ProductWorkScheduling productWorkScheduling );

}
