/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.util.UUID;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productstructure.ProductStructureNodeByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productstructure.ProductStructureNodeFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productstructure.ProductStructureVariantByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productstructure.ProductStructureVariantFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productstructure.batch.ProductStructureServiceBatch;

/**
 * <p>
 *
 * The service enables you to read the product structure information including the product structure nodes and product
 * structure variants. The service contains two filters, one for node and one for variant..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2208.latest/EN/10/398dac8fd1480185cdf55ab2a85fc1/frameset.htm?profile=20020833'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_PRODUCT_STRUCTURE_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_PRODUCT_STRUCTURE_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2208</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>(Deprecated) Product Lifecycle Management - Product Structure Integration(SAP_COM_0346)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/3ND'>Product Structure Management(3ND)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Product Structure</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated as of release 2008 (Aug 2020). Please use the
 *             odata generator to generate the VDM.
 */
@Deprecated
public interface ProductStructureService extends BatchService<ProductStructureServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_PRODUCT_STRUCTURE_SRV";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    ProductStructureService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productstructure.ProductStructureNode
     * ProductStructureNode} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productstructure.ProductStructureNode
     *         ProductStructureNode} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productstructure.ProductStructureNodeFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductStructureNodeFluentHelper getAllProductStructureNode();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productstructure.ProductStructureNode
     * ProductStructureNode} entity using key fields.
     *
     * @param productStructureNodeUUID
     *            Internal Number of iPPE Node
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productstructure.ProductStructureNode
     *         ProductStructureNode} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productstructure.ProductStructureNodeByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductStructureNodeByKeyFluentHelper getProductStructureNodeByKey( final UUID productStructureNodeUUID );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productstructure.ProductStructureVariant
     * ProductStructureVariant} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productstructure.ProductStructureVariant
     *         ProductStructureVariant} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productstructure.ProductStructureVariantFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductStructureVariantFluentHelper getAllProductStructureVariant();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productstructure.ProductStructureVariant
     * ProductStructureVariant} entity using key fields.
     *
     * @param productStructureVariantUUID
     *            Internal Number of the PVS Variant
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @param prodStrucVariantChgStateIntID
     *            Internal Counter for iPPE Objects
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productstructure.ProductStructureVariant
     *         ProductStructureVariant} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productstructure.ProductStructureVariantByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductStructureVariantByKeyFluentHelper getProductStructureVariantByKey(
        final UUID productStructureVariantUUID,
        final String prodStrucVariantChgStateIntID );

}
