/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.time.LocalDateTime;
import java.time.LocalTime;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.CloseProdnOrdFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.CompleteTechnicallyProdnOrdFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ConvertPlannedOrderFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.DiscardOrderFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrder;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrderByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrderComponentByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrderComponentFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrderCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrderFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrderItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrderItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrderOperationByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrderOperationFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrderStatusByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrderStatusFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrderUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionRsceToolsByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionRsceToolsFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ReleaseProductionOrderFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ReleaseProductionOrderOprFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ScheduleProductionOrderOperationFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.SetDeltnFlagProdnOrdFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.SetDeltnIndProdnOrdFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.batch.ProductionOrderServiceBatch;

/**
 * <p>
 * In addition to create, read, and update, you can also release production orders and operations. This service also
 * enables you to schedule production order operations, technically complete and close production orders as well as set
 * the deletion flag and deletion indicator.
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2208.latest/EN/32/b13458b222a107e10000000a441470/frameset.htm?profile=20020833'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_PRODUCTION_ORDERS?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_PRODUCTION_ORDERS</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2208</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Production Planning Integration(SAP_COM_0104), Manufacturing Execution - Order and Confirmation
 * Integration(SAP_COM_0522)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/BJ5'> Make-to-Stock Production - Discrete Manufacturing(BJ5)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BJ8'>Make-to-Stock - Process Manufacturing Based on Process
 * Order(BJ8)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/J44'>Material Requirements Planning(J44)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/O44'>Material Requirements Planning(O44)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/3W3'>Third-Party Shop Floor Execution - Process Industry(3W3)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/3W4'>Third-Party Shop Floor Execution - Discrete
 * Industry(3W4)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Production Order</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated as of release 2002 (Feb 2020). Please use the
 *             odata generator to generate the VDM.
 */
@Deprecated
public interface ProductionOrderService extends BatchService<ProductionOrderServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_PRODUCTION_ORDERS";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    ProductionOrderService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrder
     * ProductionOrder} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrder
     *         ProductionOrder} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrderFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductionOrderFluentHelper getAllProductionOrder();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrder
     * ProductionOrder} entity using key fields.
     *
     * @param productionOrder
     *            Manufacturing Order ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrder
     *         ProductionOrder} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrderByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductionOrderByKeyFluentHelper getProductionOrderByKey( final String productionOrder );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrder
     * ProductionOrder} entity and save it to the S/4HANA system.
     *
     * @param productionOrder
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrder
     *            ProductionOrder} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrder
     *         ProductionOrder} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrderCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductionOrderCreateFluentHelper createProductionOrder( @Nonnull final ProductionOrder productionOrder );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrder
     * ProductionOrder} entity and save it to the S/4HANA system.
     *
     * @param productionOrder
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrder
     *            ProductionOrder} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrder
     *         ProductionOrder} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrderUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductionOrderUpdateFluentHelper updateProductionOrder( @Nonnull final ProductionOrder productionOrder );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrderComponent
     * ProductionOrderComponent} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrderComponent
     *         ProductionOrderComponent} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrderComponentFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductionOrderComponentFluentHelper getAllProductionOrderComponent();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrderComponent
     * ProductionOrderComponent} entity using key fields.
     *
     * @param reservationItem
     *            Reservation Item
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param reservation
     *            Number of reservation/dependent requirements
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrderComponent
     *         ProductionOrderComponent} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrderComponentByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductionOrderComponentByKeyFluentHelper
        getProductionOrderComponentByKey( final String reservation, final String reservationItem );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrderItem
     * ProductionOrderItem} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrderItem
     *         ProductionOrderItem} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrderItemFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductionOrderItemFluentHelper getAllProductionOrderItem();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrderItem
     * ProductionOrderItem} entity using key fields.
     *
     * @param manufacturingOrderItem
     *            Manufacturing Order Item ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param manufacturingOrder
     *            Manufacturing Order ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrderItem
     *         ProductionOrderItem} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrderItemByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductionOrderItemByKeyFluentHelper
        getProductionOrderItemByKey( final String manufacturingOrder, final String manufacturingOrderItem );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrderOperation
     * ProductionOrderOperation} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrderOperation
     *         ProductionOrderOperation} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrderOperationFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductionOrderOperationFluentHelper getAllProductionOrderOperation();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrderOperation
     * ProductionOrderOperation} entity using key fields.
     *
     * @param orderIntBillOfOperationsItem
     *            Internal Identifier of an Operation or Activity
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param orderInternalBillOfOperations
     *            Order Internal ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrderOperation
     *         ProductionOrderOperation} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrderOperationByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductionOrderOperationByKeyFluentHelper getProductionOrderOperationByKey(
        final String orderInternalBillOfOperations,
        final String orderIntBillOfOperationsItem );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrderStatus
     * ProductionOrderStatus} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrderStatus
     *         ProductionOrderStatus} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrderStatusFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductionOrderStatusFluentHelper getAllProductionOrderStatus();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrderStatus
     * ProductionOrderStatus} entity using key fields.
     *
     * @param manufacturingOrder
     *            Order Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     * @param statusCode
     *            Object status
     *            <p>
     *            Constraints: Not nullable, Maximum length: 5
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrderStatus
     *         ProductionOrderStatus} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionOrderStatusByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductionOrderStatusByKeyFluentHelper
        getProductionOrderStatusByKey( final String manufacturingOrder, final String statusCode );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionRsceTools
     * ProductionRsceTools} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionRsceTools
     *         ProductionRsceTools} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionRsceToolsFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductionRsceToolsFluentHelper getAllProductionRsceTools();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionRsceTools
     * ProductionRsceTools} entity using key fields.
     *
     * @param mfgOrderOpProdnRsceToolIntID
     *            Item Counter for Production Resources/Tools
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param orderInternalBillOfOperations
     *            Order Internal ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionRsceTools
     *         ProductionRsceTools} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ProductionRsceToolsByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductionRsceToolsByKeyFluentHelper getProductionRsceToolsByKey(
        final String orderInternalBillOfOperations,
        final String mfgOrderOpProdnRsceToolIntID );

    /**
     * <p>
     * Creates a fluent helper for the <b>ReleaseProductionOrder</b> OData function import.
     * </p>
     *
     * @param manufacturingOrder
     *            Constraints: none
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ManufacturingOrder</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>ReleaseProductionOrder</b> OData function import with the
     *         provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ReleaseProductionOrderFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ReleaseProductionOrderFluentHelper releaseProductionOrder( @Nonnull final String manufacturingOrder );

    /**
     * <p>
     * Creates a fluent helper for the <b>ReleaseProductionOrderOpr</b> OData function import.
     * </p>
     *
     * @param manufacturingOrderOperation
     *            Constraints: none
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ManufacturingOrderOperation</b>
     *            </p>
     * @param manufacturingOrder
     *            Constraints: none
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ManufacturingOrder</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>ReleaseProductionOrderOpr</b> OData function import with
     *         the provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ReleaseProductionOrderOprFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ReleaseProductionOrderOprFluentHelper releaseProductionOrderOpr(
        @Nonnull final String manufacturingOrder,
        @Nonnull final String manufacturingOrderOperation );

    /**
     * <p>
     * Creates a fluent helper for the <b>CompleteTechnicallyProdnOrd</b> OData function import.
     * </p>
     *
     * @param manufacturingOrder
     *            Constraints: Not nullable, Maximum length: 12
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ManufacturingOrder</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>CompleteTechnicallyProdnOrd</b> OData function import
     *         with the provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.CompleteTechnicallyProdnOrdFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CompleteTechnicallyProdnOrdFluentHelper completeTechnicallyProdnOrd( @Nonnull final String manufacturingOrder );

    /**
     * <p>
     * Creates a fluent helper for the <b>CloseProdnOrd</b> OData function import.
     * </p>
     *
     * @param manufacturingOrder
     *            Constraints: Not nullable, Maximum length: 12
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ManufacturingOrder</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>CloseProdnOrd</b> OData function import with the provided
     *         parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.CloseProdnOrdFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CloseProdnOrdFluentHelper closeProdnOrd( @Nonnull final String manufacturingOrder );

    /**
     * <p>
     * Creates a fluent helper for the <b>SetDeltnFlagProdnOrd</b> OData function import.
     * </p>
     *
     * @param manufacturingOrder
     *            Constraints: Not nullable, Maximum length: 12
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ManufacturingOrder</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>SetDeltnFlagProdnOrd</b> OData function import with the
     *         provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.SetDeltnFlagProdnOrdFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SetDeltnFlagProdnOrdFluentHelper setDeltnFlagProdnOrd( @Nonnull final String manufacturingOrder );

    /**
     * <p>
     * Creates a fluent helper for the <b>SetDeltnIndProdnOrd</b> OData function import.
     * </p>
     *
     * @param manufacturingOrder
     *            Constraints: Not nullable, Maximum length: 12
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ManufacturingOrder</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>SetDeltnIndProdnOrd</b> OData function import with the
     *         provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.SetDeltnIndProdnOrdFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SetDeltnIndProdnOrdFluentHelper setDeltnIndProdnOrd( @Nonnull final String manufacturingOrder );

    /**
     * <p>
     * Creates a fluent helper for the <b>DiscardOrder</b> OData function import.
     * </p>
     *
     * @param manufacturingOrder
     *            Constraints: Not nullable, Maximum length: 12
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ManufacturingOrder</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>DiscardOrder</b> OData function import with the provided
     *         parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.DiscardOrderFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    DiscardOrderFluentHelper discardOrder( @Nonnull final String manufacturingOrder );

    /**
     * <p>
     * Creates a fluent helper for the <b>ConvertPlannedOrder</b> OData function import.
     * </p>
     *
     * @param plannedOrder
     *            Constraints: Not nullable, Maximum length: 10
     *            <p>
     *            Original parameter name from the Odata EDM: <b>PlannedOrder</b>
     *            </p>
     * @param manufacturingOrderType
     *            Constraints: Nullable, Maximum length: 4
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ManufacturingOrderType</b>
     *            </p>
     * @param manufacturingOrder
     *            Constraints: Nullable, Maximum length: 12
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ManufacturingOrder</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>ConvertPlannedOrder</b> OData function import with the
     *         provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ConvertPlannedOrderFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ConvertPlannedOrderFluentHelper convertPlannedOrder(
        @Nonnull final String plannedOrder,
        @Nullable final String manufacturingOrderType,
        @Nullable final String manufacturingOrder );

    /**
     * <p>
     * Creates a fluent helper for the <b>ScheduleProductionOrderOperation</b> OData function import.
     * </p>
     *
     * @param orderIntBillOfOperationsItem
     *            Operation Internal ID
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>OrderIntBillOfOperationsItem</b>
     *            </p>
     * @param opSchedldStartDate
     *            Execution Start Date
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 0
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>OpSchedldStartDate</b>
     *            </p>
     * @param opSchedulingStrategy
     *            Component of the Version Number
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>OpSchedulingStrategy</b>
     *            </p>
     * @param orderInternalBillOfOperations
     *            Order Internal ID
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>OrderInternalBillOfOperations</b>
     *            </p>
     * @param opSchedulingStatus
     *            Status
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 4
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>OpSchedulingStatus</b>
     *            </p>
     * @param opSchedulingMode
     *            Scheduling type
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>OpSchedulingMode</b>
     *            </p>
     * @param opSchedldStartTime
     *            Execution Start Time
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 0
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>OpSchedldStartTime</b>
     *            </p>
     * @param opSchedldEndDate
     *            Execution End Date
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 0
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>OpSchedldEndDate</b>
     *            </p>
     * @param productionOrder
     *            Order
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ProductionOrder</b>
     *            </p>
     * @param opSchedldEndTime
     *            Execution End Time
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 0
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>OpSchedldEndTime</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>ScheduleProductionOrderOperation</b> OData function
     *         import with the provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorder.ScheduleProductionOrderOperationFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ScheduleProductionOrderOperationFluentHelper scheduleProductionOrderOperation(
        @Nonnull final String productionOrder,
        @Nonnull final String orderInternalBillOfOperations,
        @Nonnull final String orderIntBillOfOperationsItem,
        @Nullable final LocalDateTime opSchedldStartDate,
        @Nullable final LocalTime opSchedldStartTime,
        @Nullable final LocalDateTime opSchedldEndDate,
        @Nullable final LocalTime opSchedldEndTime,
        @Nonnull final String opSchedulingMode,
        @Nullable final String opSchedulingStatus,
        @Nonnull final String opSchedulingStrategy );

}
