/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.time.LocalDateTime;
import java.time.LocalTime;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.CloseOrderFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ConvertPlndOrderFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.DeletionFlagOrderFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.DeletionIndOrderFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.DeliveryCompletedOrderFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.DiscardOrderFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.OrderReleasedByMESFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionOrderComponent_2ByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionOrderComponent_2FluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionOrderComponent_3;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionOrderComponent_3ByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionOrderComponent_3FluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionOrderComponent_3UpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionOrderComponent_4;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionOrderComponent_4ByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionOrderComponent_4FluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionOrderComponent_4UpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionOrderItem_2ByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionOrderItem_2FluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionOrderOperation_2ByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionOrderOperation_2FluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionOrderStatus_2ByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionOrderStatus_2FluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionOrder_2;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionOrder_2ByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionOrder_2CreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionOrder_2FluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionOrder_2UpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionRsceTools_2ByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionRsceTools_2FluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ReleaseOperationFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ReleaseOrderFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ScheduleProductionOrderOperationFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.TechlyCmpltOrderFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.batch.ProductionOrderV2ServiceBatch;

/**
 * <p>
 * In addition to create, read, and update production orders, you can also release orders and operations. Besides
 * updating header data of the order including the scheduling type, you can also update some properties of the order
 * components. This service enables you to convert planned orders to production orders, schedule production order
 * operations, and set further statuses for the order such as technically completed, closed, discarded by MES, or
 * released by MES. In addition, you can set the deletion flag, deletion indicator, and delivery completed indicator.
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/0a/4262096d2e43258df27c594bdd1468/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_PRODUCTION_ORDER_2_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_PRODUCTION_ORDER_2_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.2.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Production Planning Integration(SAP_COM_0104), Manufacturing Execution - Order and Confirmation
 * Integration(SAP_COM_0522)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/BJ5'> Make-to-Stock Production - Discrete Manufacturing(BJ5)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BJ8'>Make-to-Stock - Process Manufacturing Based on Process
 * Order(BJ8)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/J44'>Material Requirements Planning(J44)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/O44'>Material Requirements Planning(O44)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/3W3'>Third-Party Shop Floor Execution - Process Industry(3W3)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/3W4'>Third-Party Shop Floor Execution - Discrete
 * Industry(3W4)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Production Order</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Deprecated
public interface ProductionOrderV2Service extends BatchService<ProductionOrderV2ServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_PRODUCTION_ORDER_2_SRV";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    ProductionOrderV2Service withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionOrderComponent_2
     * ProductionOrderComponent_2} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionOrderComponent_2
     *         ProductionOrderComponent_2} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionOrderComponent_2FluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductionOrderComponent_2FluentHelper getAllProductionOrderComponent_2();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionOrderComponent_2
     * ProductionOrderComponent_2} entity using key fields.
     *
     * @param reservationItem
     *            Reservation Item
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param reservation
     *            Number of reservation/dependent requirements
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionOrderComponent_2
     *         ProductionOrderComponent_2} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionOrderComponent_2ByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductionOrderComponent_2ByKeyFluentHelper
        getProductionOrderComponent_2ByKey( final String reservation, final String reservationItem );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionOrderComponent_3
     * ProductionOrderComponent_3} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionOrderComponent_3
     *         ProductionOrderComponent_3} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionOrderComponent_3FluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductionOrderComponent_3FluentHelper getAllProductionOrderComponent_3();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionOrderComponent_3
     * ProductionOrderComponent_3} entity using key fields.
     *
     * @param reservationItem
     *            Reservation Item
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param reservation
     *            Number of reservation/dependent requirements
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param reservationRecordType
     *            Reservation Record Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionOrderComponent_3
     *         ProductionOrderComponent_3} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionOrderComponent_3ByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductionOrderComponent_3ByKeyFluentHelper getProductionOrderComponent_3ByKey(
        final String reservation,
        final String reservationItem,
        final String reservationRecordType );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionOrderComponent_3
     * ProductionOrderComponent_3} entity and save it to the S/4HANA system.
     *
     * @param productionOrderComponent_3
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionOrderComponent_3
     *            ProductionOrderComponent_3} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionOrderComponent_3
     *         ProductionOrderComponent_3} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionOrderComponent_3UpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductionOrderComponent_3UpdateFluentHelper
        updateProductionOrderComponent_3( @Nonnull final ProductionOrderComponent_3 productionOrderComponent_3 );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionOrderComponent_4
     * ProductionOrderComponent_4} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionOrderComponent_4
     *         ProductionOrderComponent_4} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionOrderComponent_4FluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductionOrderComponent_4FluentHelper getAllProductionOrderComponent_4();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionOrderComponent_4
     * ProductionOrderComponent_4} entity using key fields.
     *
     * @param reservationItem
     *            Reservation Item
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param reservation
     *            Number of reservation/dependent requirements
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param reservationRecordType
     *            Reservation Record Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionOrderComponent_4
     *         ProductionOrderComponent_4} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionOrderComponent_4ByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductionOrderComponent_4ByKeyFluentHelper getProductionOrderComponent_4ByKey(
        final String reservation,
        final String reservationItem,
        final String reservationRecordType );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionOrderComponent_4
     * ProductionOrderComponent_4} entity and save it to the S/4HANA system.
     *
     * @param productionOrderComponent_4
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionOrderComponent_4
     *            ProductionOrderComponent_4} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionOrderComponent_4
     *         ProductionOrderComponent_4} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionOrderComponent_4UpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductionOrderComponent_4UpdateFluentHelper
        updateProductionOrderComponent_4( @Nonnull final ProductionOrderComponent_4 productionOrderComponent_4 );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionOrderItem_2
     * ProductionOrderItem_2} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionOrderItem_2
     *         ProductionOrderItem_2} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionOrderItem_2FluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductionOrderItem_2FluentHelper getAllProductionOrderItem_2();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionOrderItem_2
     * ProductionOrderItem_2} entity using key fields.
     *
     * @param manufacturingOrderItem
     *            Manufacturing Order Item ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param manufacturingOrder
     *            Production Order
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionOrderItem_2
     *         ProductionOrderItem_2} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionOrderItem_2ByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductionOrderItem_2ByKeyFluentHelper
        getProductionOrderItem_2ByKey( final String manufacturingOrder, final String manufacturingOrderItem );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionOrderOperation_2
     * ProductionOrderOperation_2} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionOrderOperation_2
     *         ProductionOrderOperation_2} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionOrderOperation_2FluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductionOrderOperation_2FluentHelper getAllProductionOrderOperation_2();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionOrderOperation_2
     * ProductionOrderOperation_2} entity using key fields.
     *
     * @param orderIntBillOfOperationsItem
     *            Internal Identifier of an Operation or Activity
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param orderInternalBillOfOperations
     *            Order Internal ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionOrderOperation_2
     *         ProductionOrderOperation_2} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionOrderOperation_2ByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductionOrderOperation_2ByKeyFluentHelper getProductionOrderOperation_2ByKey(
        final String orderInternalBillOfOperations,
        final String orderIntBillOfOperationsItem );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionOrderStatus_2
     * ProductionOrderStatus_2} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionOrderStatus_2
     *         ProductionOrderStatus_2} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionOrderStatus_2FluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductionOrderStatus_2FluentHelper getAllProductionOrderStatus_2();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionOrderStatus_2
     * ProductionOrderStatus_2} entity using key fields.
     *
     * @param manufacturingOrder
     *            Production Order
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     * @param statusCode
     *            Object status
     *            <p>
     *            Constraints: Not nullable, Maximum length: 5
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionOrderStatus_2
     *         ProductionOrderStatus_2} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionOrderStatus_2ByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductionOrderStatus_2ByKeyFluentHelper
        getProductionOrderStatus_2ByKey( final String manufacturingOrder, final String statusCode );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionOrder_2
     * ProductionOrder_2} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionOrder_2
     *         ProductionOrder_2} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionOrder_2FluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductionOrder_2FluentHelper getAllProductionOrder_2();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionOrder_2
     * ProductionOrder_2} entity using key fields.
     *
     * @param manufacturingOrder
     *            Production Order
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionOrder_2
     *         ProductionOrder_2} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionOrder_2ByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductionOrder_2ByKeyFluentHelper getProductionOrder_2ByKey( final String manufacturingOrder );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionOrder_2
     * ProductionOrder_2} entity and save it to the S/4HANA system.
     *
     * @param productionOrder_2
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionOrder_2
     *            ProductionOrder_2} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionOrder_2
     *         ProductionOrder_2} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionOrder_2CreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductionOrder_2CreateFluentHelper createProductionOrder_2( @Nonnull final ProductionOrder_2 productionOrder_2 );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionOrder_2
     * ProductionOrder_2} entity and save it to the S/4HANA system.
     *
     * @param productionOrder_2
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionOrder_2
     *            ProductionOrder_2} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionOrder_2
     *         ProductionOrder_2} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionOrder_2UpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductionOrder_2UpdateFluentHelper updateProductionOrder_2( @Nonnull final ProductionOrder_2 productionOrder_2 );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionRsceTools_2
     * ProductionRsceTools_2} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionRsceTools_2
     *         ProductionRsceTools_2} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionRsceTools_2FluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductionRsceTools_2FluentHelper getAllProductionRsceTools_2();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionRsceTools_2
     * ProductionRsceTools_2} entity using key fields.
     *
     * @param mfgOrderOpProdnRsceToolIntID
     *            Item Counter for Production Resources/Tools
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param orderInternalBillOfOperations
     *            Order Internal ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionRsceTools_2
     *         ProductionRsceTools_2} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ProductionRsceTools_2ByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductionRsceTools_2ByKeyFluentHelper getProductionRsceTools_2ByKey(
        final String orderInternalBillOfOperations,
        final String mfgOrderOpProdnRsceToolIntID );

    /**
     * <p>
     * Creates a fluent helper for the <b>ReleaseOrder</b> OData function import.
     * </p>
     *
     * @param manufacturingOrder
     *            Constraints: Not nullable, Maximum length: 12
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ManufacturingOrder</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>ReleaseOrder</b> OData function import with the provided
     *         parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ReleaseOrderFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ReleaseOrderFluentHelper releaseOrder( @Nonnull final String manufacturingOrder );

    /**
     * <p>
     * Creates a fluent helper for the <b>ReleaseOperation</b> OData function import.
     * </p>
     *
     * @param manufacturingOrderOperation
     *            Constraints: Not nullable, Maximum length: 4
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ManufacturingOrderOperation</b>
     *            </p>
     * @param manufacturingOrder
     *            Constraints: Not nullable, Maximum length: 12
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ManufacturingOrder</b>
     *            </p>
     * @param manufacturingOrderSequence
     *            Constraints: none
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ManufacturingOrderSequence</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>ReleaseOperation</b> OData function import with the
     *         provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ReleaseOperationFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ReleaseOperationFluentHelper releaseOperation(
        @Nonnull final String manufacturingOrder,
        @Nonnull final String manufacturingOrderOperation,
        @Nonnull final String manufacturingOrderSequence );

    /**
     * <p>
     * Creates a fluent helper for the <b>TechlyCmpltOrder</b> OData function import.
     * </p>
     *
     * @param manufacturingOrder
     *            Constraints: Not nullable, Maximum length: 12
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ManufacturingOrder</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>TechlyCmpltOrder</b> OData function import with the
     *         provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.TechlyCmpltOrderFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    TechlyCmpltOrderFluentHelper techlyCmpltOrder( @Nonnull final String manufacturingOrder );

    /**
     * <p>
     * Creates a fluent helper for the <b>CloseOrder</b> OData function import.
     * </p>
     *
     * @param manufacturingOrder
     *            Constraints: Not nullable, Maximum length: 12
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ManufacturingOrder</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>CloseOrder</b> OData function import with the provided
     *         parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.CloseOrderFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CloseOrderFluentHelper closeOrder( @Nonnull final String manufacturingOrder );

    /**
     * <p>
     * Creates a fluent helper for the <b>DeletionFlagOrder</b> OData function import.
     * </p>
     *
     * @param manufacturingOrder
     *            Constraints: Not nullable, Maximum length: 12
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ManufacturingOrder</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>DeletionFlagOrder</b> OData function import with the
     *         provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.DeletionFlagOrderFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    DeletionFlagOrderFluentHelper deletionFlagOrder( @Nonnull final String manufacturingOrder );

    /**
     * <p>
     * Creates a fluent helper for the <b>DeletionIndOrder</b> OData function import.
     * </p>
     *
     * @param manufacturingOrder
     *            Constraints: Not nullable, Maximum length: 12
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ManufacturingOrder</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>DeletionIndOrder</b> OData function import with the
     *         provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.DeletionIndOrderFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    DeletionIndOrderFluentHelper deletionIndOrder( @Nonnull final String manufacturingOrder );

    /**
     * <p>
     * Creates a fluent helper for the <b>DiscardOrder</b> OData function import.
     * </p>
     *
     * @param manufacturingOrder
     *            Constraints: Not nullable, Maximum length: 12
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ManufacturingOrder</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>DiscardOrder</b> OData function import with the provided
     *         parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.DiscardOrderFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    DiscardOrderFluentHelper discardOrder( @Nonnull final String manufacturingOrder );

    /**
     * <p>
     * Creates a fluent helper for the <b>ConvertPlndOrder</b> OData function import.
     * </p>
     *
     * @param plannedOrder
     *            Constraints: none
     *            <p>
     *            Original parameter name from the Odata EDM: <b>PlannedOrder</b>
     *            </p>
     * @param manufacturingOrderType
     *            Constraints: Nullable
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ManufacturingOrderType</b>
     *            </p>
     * @param manufacturingOrder
     *            Constraints: Nullable, Maximum length: 12
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ManufacturingOrder</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>ConvertPlndOrder</b> OData function import with the
     *         provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ConvertPlndOrderFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ConvertPlndOrderFluentHelper convertPlndOrder(
        @Nullable final String manufacturingOrder,
        @Nonnull final String plannedOrder,
        @Nullable final String manufacturingOrderType );

    /**
     * <p>
     * Creates a fluent helper for the <b>ScheduleProductionOrderOperation</b> OData function import.
     * </p>
     *
     * @param orderIntBillOfOperationsItem
     *            Operation Internal ID
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>OrderIntBillOfOperationsItem</b>
     *            </p>
     * @param opSchedldStartDate
     *            Execution Start Date
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 0
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>OpSchedldStartDate</b>
     *            </p>
     * @param opSchedulingStrategy
     *            Component of the Version Number
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>OpSchedulingStrategy</b>
     *            </p>
     * @param orderInternalBillOfOperations
     *            Order Internal ID
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>OrderInternalBillOfOperations</b>
     *            </p>
     * @param opSchedulingStatus
     *            Status
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 4
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>OpSchedulingStatus</b>
     *            </p>
     * @param opSchedulingMode
     *            Scheduling type
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>OpSchedulingMode</b>
     *            </p>
     * @param manufacturingOrder
     *            Order
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ManufacturingOrder</b>
     *            </p>
     * @param opSchedldStartTime
     *            Execution Start Time
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 0
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>OpSchedldStartTime</b>
     *            </p>
     * @param opSchedldEndDate
     *            Execution End Date
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 0
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>OpSchedldEndDate</b>
     *            </p>
     * @param opSchedldEndTime
     *            Execution End Time
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 0
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>OpSchedldEndTime</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>ScheduleProductionOrderOperation</b> OData function
     *         import with the provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.ScheduleProductionOrderOperationFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ScheduleProductionOrderOperationFluentHelper scheduleProductionOrderOperation(
        @Nonnull final String manufacturingOrder,
        @Nonnull final String orderInternalBillOfOperations,
        @Nonnull final String orderIntBillOfOperationsItem,
        @Nullable final LocalDateTime opSchedldStartDate,
        @Nullable final LocalTime opSchedldStartTime,
        @Nullable final LocalDateTime opSchedldEndDate,
        @Nullable final LocalTime opSchedldEndTime,
        @Nonnull final String opSchedulingMode,
        @Nullable final String opSchedulingStatus,
        @Nonnull final String opSchedulingStrategy );

    /**
     * <p>
     * Creates a fluent helper for the <b>DeliveryCompletedOrder</b> OData function import.
     * </p>
     *
     * @param manufacturingOrder
     *            Constraints: Not nullable, Maximum length: 12
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ManufacturingOrder</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>DeliveryCompletedOrder</b> OData function import with the
     *         provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.DeliveryCompletedOrderFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    DeliveryCompletedOrderFluentHelper deliveryCompletedOrder( @Nonnull final String manufacturingOrder );

    /**
     * <p>
     * Creates a fluent helper for the <b>OrderReleasedByMES</b> OData function import.
     * </p>
     *
     * @param manufacturingOrder
     *            Constraints: Not nullable, Maximum length: 12
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ManufacturingOrder</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>OrderReleasedByMES</b> OData function import with the
     *         provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionorderv2.OrderReleasedByMESFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    OrderReleasedByMESFluentHelper orderReleasedByMES( @Nonnull final String manufacturingOrder );

}
