/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.OperationDocumentPRTAssignmentByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.OperationDocumentPRTAssignmentFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.OperationEquipmentPRTAssignmentByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.OperationEquipmentPRTAssignmentFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.OperationMaterialPRTAssignmentByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.OperationMaterialPRTAssignmentFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.OperationMiscellaneousPRTAssignmentByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.OperationMiscellaneousPRTAssignmentFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingHeader;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingHeaderByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingHeaderCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingHeaderFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingHeaderUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingMatlAssgmtByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingMatlAssgmtFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingOpCompAlloc;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingOpCompAllocByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingOpCompAllocCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingOpCompAllocFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingOpCompAllocUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingOperation;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingOperationByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingOperationCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingOperationFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingOperationUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingSequence;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingSequenceByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingSequenceCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingSequenceFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingSequenceUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingSubOperation;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingSubOperationByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingSubOperationCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingSubOperationFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingSubOperationUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.batch.ProductionRoutingServiceBatch;

/**
 * <p>
 *
 * A routing is a description of the operations (or steps in a process) that are performed to manufacture a product (or
 * material). It is used as a reference for production orders, to run schedules and in calculating the costs of
 * products..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/2d/d233df3bc947d6b402d246ed887b5a/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_PRODUCTION_ROUTING?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_PRODUCTION_ROUTING</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.2</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Production Planning Master Data Integration(SAP_COM_0519)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/3W3'>Third-Party Shop Floor Execution - Process Industry(3W3)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/3W4'>Third-Party Shop Floor Execution - Discrete
 * Industry(3W4)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Production Routing</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Deprecated
public interface ProductionRoutingService extends BatchService<ProductionRoutingServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_PRODUCTION_ROUTING";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    ProductionRoutingService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.OperationDocumentPRTAssignment
     * OperationDocumentPRTAssignment} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.OperationDocumentPRTAssignment
     *         OperationDocumentPRTAssignment} entities. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.OperationDocumentPRTAssignmentFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    OperationDocumentPRTAssignmentFluentHelper getAllOperationDocumentPRTAssignment();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.OperationDocumentPRTAssignment
     * OperationDocumentPRTAssignment} entity using key fields.
     *
     * @param productionRoutingGroup
     *            Key for Task List Group
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param productionRouting
     *            Group Counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param productionRoutingOpIntID
     *            Number of the Task List Node
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param bOOOperationPRTInternalID
     *            Item Counter for Production Resources/Tools
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param bOOOperationPRTIntVersCounter
     *            Internal counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param productionRoutingSequence
     *            Sequence
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.OperationDocumentPRTAssignment
     *         OperationDocumentPRTAssignment} entity using key fields. This fluent helper allows methods which modify
     *         the underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.OperationDocumentPRTAssignmentByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    OperationDocumentPRTAssignmentByKeyFluentHelper getOperationDocumentPRTAssignmentByKey(
        final String productionRoutingGroup,
        final String productionRouting,
        final String productionRoutingSequence,
        final String productionRoutingOpIntID,
        final String bOOOperationPRTInternalID,
        final String bOOOperationPRTIntVersCounter );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.OperationEquipmentPRTAssignment
     * OperationEquipmentPRTAssignment} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.OperationEquipmentPRTAssignment
     *         OperationEquipmentPRTAssignment} entities. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.OperationEquipmentPRTAssignmentFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    OperationEquipmentPRTAssignmentFluentHelper getAllOperationEquipmentPRTAssignment();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.OperationEquipmentPRTAssignment
     * OperationEquipmentPRTAssignment} entity using key fields.
     *
     * @param productionRoutingGroup
     *            Key for Task List Group
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param productionRouting
     *            Group Counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param productionRoutingOpIntID
     *            Number of the Task List Node
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param bOOOperationPRTInternalID
     *            Item Counter for Production Resources/Tools
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param bOOOperationPRTIntVersCounter
     *            Internal counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param productionRoutingSequence
     *            Sequence
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.OperationEquipmentPRTAssignment
     *         OperationEquipmentPRTAssignment} entity using key fields. This fluent helper allows methods which modify
     *         the underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.OperationEquipmentPRTAssignmentByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    OperationEquipmentPRTAssignmentByKeyFluentHelper getOperationEquipmentPRTAssignmentByKey(
        final String productionRoutingGroup,
        final String productionRouting,
        final String productionRoutingSequence,
        final String productionRoutingOpIntID,
        final String bOOOperationPRTInternalID,
        final String bOOOperationPRTIntVersCounter );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.OperationMaterialPRTAssignment
     * OperationMaterialPRTAssignment} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.OperationMaterialPRTAssignment
     *         OperationMaterialPRTAssignment} entities. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.OperationMaterialPRTAssignmentFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    OperationMaterialPRTAssignmentFluentHelper getAllOperationMaterialPRTAssignment();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.OperationMaterialPRTAssignment
     * OperationMaterialPRTAssignment} entity using key fields.
     *
     * @param productionRoutingGroup
     *            Key for Task List Group
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param productionRouting
     *            Group Counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param productionRoutingOpIntID
     *            Number of the Task List Node
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param bOOOperationPRTInternalID
     *            Item Counter for Production Resources/Tools
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param bOOOperationPRTIntVersCounter
     *            Internal counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param productionRoutingSequence
     *            Sequence
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.OperationMaterialPRTAssignment
     *         OperationMaterialPRTAssignment} entity using key fields. This fluent helper allows methods which modify
     *         the underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.OperationMaterialPRTAssignmentByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    OperationMaterialPRTAssignmentByKeyFluentHelper getOperationMaterialPRTAssignmentByKey(
        final String productionRoutingGroup,
        final String productionRouting,
        final String productionRoutingSequence,
        final String productionRoutingOpIntID,
        final String bOOOperationPRTInternalID,
        final String bOOOperationPRTIntVersCounter );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.OperationMiscellaneousPRTAssignment
     * OperationMiscellaneousPRTAssignment} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.OperationMiscellaneousPRTAssignment
     *         OperationMiscellaneousPRTAssignment} entities. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.OperationMiscellaneousPRTAssignmentFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    OperationMiscellaneousPRTAssignmentFluentHelper getAllOperationMiscellaneousPRTAssignment();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.OperationMiscellaneousPRTAssignment
     * OperationMiscellaneousPRTAssignment} entity using key fields.
     *
     * @param productionRoutingGroup
     *            Key for Task List Group
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param productionRouting
     *            Group Counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param productionRoutingOpIntID
     *            Number of the Task List Node
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param bOOOperationPRTInternalID
     *            Item Counter for Production Resources/Tools
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param bOOOperationPRTIntVersCounter
     *            Internal counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param productionRoutingSequence
     *            Sequence
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.OperationMiscellaneousPRTAssignment
     *         OperationMiscellaneousPRTAssignment} entity using key fields. This fluent helper allows methods which
     *         modify the underlying query to be called before executing the query itself. To perform execution, call
     *         the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.OperationMiscellaneousPRTAssignmentByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    OperationMiscellaneousPRTAssignmentByKeyFluentHelper getOperationMiscellaneousPRTAssignmentByKey(
        final String productionRoutingGroup,
        final String productionRouting,
        final String productionRoutingSequence,
        final String productionRoutingOpIntID,
        final String bOOOperationPRTInternalID,
        final String bOOOperationPRTIntVersCounter );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingHeader
     * ProductionRoutingHeader} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingHeader
     *         ProductionRoutingHeader} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingHeaderFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductionRoutingHeaderFluentHelper getAllProductionRoutingHeader();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingHeader
     * ProductionRoutingHeader} entity using key fields.
     *
     * @param productionRoutingGroup
     *            Key for Task List Group
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param productionRoutingInternalVers
     *            Internal counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param productionRouting
     *            Group Counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingHeader
     *         ProductionRoutingHeader} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingHeaderByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductionRoutingHeaderByKeyFluentHelper getProductionRoutingHeaderByKey(
        final String productionRoutingGroup,
        final String productionRouting,
        final String productionRoutingInternalVers );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingHeader
     * ProductionRoutingHeader} entity and save it to the S/4HANA system.
     *
     * @param productionRoutingHeader
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingHeader
     *            ProductionRoutingHeader} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingHeader
     *         ProductionRoutingHeader} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingHeaderCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductionRoutingHeaderCreateFluentHelper
        createProductionRoutingHeader( @Nonnull final ProductionRoutingHeader productionRoutingHeader );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingHeader
     * ProductionRoutingHeader} entity and save it to the S/4HANA system.
     *
     * @param productionRoutingHeader
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingHeader
     *            ProductionRoutingHeader} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingHeader
     *         ProductionRoutingHeader} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingHeaderUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductionRoutingHeaderUpdateFluentHelper
        updateProductionRoutingHeader( @Nonnull final ProductionRoutingHeader productionRoutingHeader );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingMatlAssgmt
     * ProductionRoutingMatlAssgmt} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingMatlAssgmt
     *         ProductionRoutingMatlAssgmt} entities. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingMatlAssgmtFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductionRoutingMatlAssgmtFluentHelper getAllProductionRoutingMatlAssgmt();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingMatlAssgmt
     * ProductionRoutingMatlAssgmt} entity using key fields.
     *
     * @param productionRoutingGroup
     *            Key for Task List Group
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param productionRoutingMatlAssgmt
     *            Counter for Additional Criteria
     *            <p>
     *            Constraints: Not nullable, Maximum length: 7
     *            </p>
     * @param product
     *            Material Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 18
     *            </p>
     * @param productionRouting
     *            Group Counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param plant
     *            Plant
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param productionRtgMatlAssgmtIntVers
     *            Internal counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingMatlAssgmt
     *         ProductionRoutingMatlAssgmt} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingMatlAssgmtByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductionRoutingMatlAssgmtByKeyFluentHelper getProductionRoutingMatlAssgmtByKey(
        final String product,
        final String plant,
        final String productionRoutingGroup,
        final String productionRouting,
        final String productionRoutingMatlAssgmt,
        final String productionRtgMatlAssgmtIntVers );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingOpCompAlloc
     * ProductionRoutingOpCompAlloc} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingOpCompAlloc
     *         ProductionRoutingOpCompAlloc} entities. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingOpCompAllocFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductionRoutingOpCompAllocFluentHelper getAllProductionRoutingOpCompAlloc();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingOpCompAlloc
     * ProductionRoutingOpCompAlloc} entity using key fields.
     *
     * @param productionRoutingGroup
     *            Key for Task List Group
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param productionRouting
     *            Group Counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param productionRoutingOpIntID
     *            Task list node number for operation
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param prodnRtgOpBOMItemIntVersion
     *            Internal counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param prodnRtgOpBOMItemInternalID
     *            No. for material comp. allocation to task list
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param productionRoutingSequence
     *            Sequence
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingOpCompAlloc
     *         ProductionRoutingOpCompAlloc} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingOpCompAllocByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductionRoutingOpCompAllocByKeyFluentHelper getProductionRoutingOpCompAllocByKey(
        final String productionRoutingGroup,
        final String productionRouting,
        final String productionRoutingSequence,
        final String productionRoutingOpIntID,
        final String prodnRtgOpBOMItemInternalID,
        final String prodnRtgOpBOMItemIntVersion );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingOpCompAlloc
     * ProductionRoutingOpCompAlloc} entity and save it to the S/4HANA system.
     *
     * @param productionRoutingOpCompAlloc
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingOpCompAlloc
     *            ProductionRoutingOpCompAlloc} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingOpCompAlloc
     *         ProductionRoutingOpCompAlloc} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingOpCompAllocCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductionRoutingOpCompAllocCreateFluentHelper
        createProductionRoutingOpCompAlloc( @Nonnull final ProductionRoutingOpCompAlloc productionRoutingOpCompAlloc );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingOpCompAlloc
     * ProductionRoutingOpCompAlloc} entity and save it to the S/4HANA system.
     *
     * @param productionRoutingOpCompAlloc
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingOpCompAlloc
     *            ProductionRoutingOpCompAlloc} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingOpCompAlloc
     *         ProductionRoutingOpCompAlloc} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingOpCompAllocUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductionRoutingOpCompAllocUpdateFluentHelper
        updateProductionRoutingOpCompAlloc( @Nonnull final ProductionRoutingOpCompAlloc productionRoutingOpCompAlloc );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingOperation
     * ProductionRoutingOperation} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingOperation
     *         ProductionRoutingOperation} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingOperationFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductionRoutingOperationFluentHelper getAllProductionRoutingOperation();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingOperation
     * ProductionRoutingOperation} entity using key fields.
     *
     * @param productionRoutingGroup
     *            Key for Task List Group
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param productionRouting
     *            Group Counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param productionRoutingOpIntID
     *            Number of the Task List Node
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param productionRoutingOpIntVersion
     *            Internal counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param productionRoutingSequence
     *            Sequence
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingOperation
     *         ProductionRoutingOperation} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingOperationByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductionRoutingOperationByKeyFluentHelper getProductionRoutingOperationByKey(
        final String productionRoutingGroup,
        final String productionRouting,
        final String productionRoutingSequence,
        final String productionRoutingOpIntID,
        final String productionRoutingOpIntVersion );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingOperation
     * ProductionRoutingOperation} entity and save it to the S/4HANA system.
     *
     * @param productionRoutingOperation
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingOperation
     *            ProductionRoutingOperation} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingOperation
     *         ProductionRoutingOperation} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingOperationCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductionRoutingOperationCreateFluentHelper
        createProductionRoutingOperation( @Nonnull final ProductionRoutingOperation productionRoutingOperation );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingOperation
     * ProductionRoutingOperation} entity and save it to the S/4HANA system.
     *
     * @param productionRoutingOperation
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingOperation
     *            ProductionRoutingOperation} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingOperation
     *         ProductionRoutingOperation} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingOperationUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductionRoutingOperationUpdateFluentHelper
        updateProductionRoutingOperation( @Nonnull final ProductionRoutingOperation productionRoutingOperation );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingSequence
     * ProductionRoutingSequence} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingSequence
     *         ProductionRoutingSequence} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingSequenceFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductionRoutingSequenceFluentHelper getAllProductionRoutingSequence();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingSequence
     * ProductionRoutingSequence} entity using key fields.
     *
     * @param productionRoutingGroup
     *            Key for Task List Group
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param productionRouting
     *            Group Counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param productionRoutingSqncIntVers
     *            Internal counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param productionRoutingSequence
     *            Sequence
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingSequence
     *         ProductionRoutingSequence} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingSequenceByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductionRoutingSequenceByKeyFluentHelper getProductionRoutingSequenceByKey(
        final String productionRoutingGroup,
        final String productionRouting,
        final String productionRoutingSequence,
        final String productionRoutingSqncIntVers );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingSequence
     * ProductionRoutingSequence} entity and save it to the S/4HANA system.
     *
     * @param productionRoutingSequence
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingSequence
     *            ProductionRoutingSequence} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingSequence
     *         ProductionRoutingSequence} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingSequenceCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductionRoutingSequenceCreateFluentHelper
        createProductionRoutingSequence( @Nonnull final ProductionRoutingSequence productionRoutingSequence );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingSequence
     * ProductionRoutingSequence} entity and save it to the S/4HANA system.
     *
     * @param productionRoutingSequence
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingSequence
     *            ProductionRoutingSequence} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingSequence
     *         ProductionRoutingSequence} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingSequenceUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductionRoutingSequenceUpdateFluentHelper
        updateProductionRoutingSequence( @Nonnull final ProductionRoutingSequence productionRoutingSequence );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingSubOperation
     * ProductionRoutingSubOperation} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingSubOperation
     *         ProductionRoutingSubOperation} entities. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingSubOperationFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductionRoutingSubOperationFluentHelper getAllProductionRoutingSubOperation();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingSubOperation
     * ProductionRoutingSubOperation} entity using key fields.
     *
     * @param productionRoutingGroup
     *            Key for Task List Group
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param productionRouting
     *            Group Counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param productionRoutingOpIntID
     *            Number of the Task List Node
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param productionRoutingOpIntVersion
     *            Internal counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param productionRoutingSequence
     *            Sequence
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingSubOperation
     *         ProductionRoutingSubOperation} entity using key fields. This fluent helper allows methods which modify
     *         the underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingSubOperationByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductionRoutingSubOperationByKeyFluentHelper getProductionRoutingSubOperationByKey(
        final String productionRoutingGroup,
        final String productionRouting,
        final String productionRoutingOpIntID,
        final String productionRoutingSequence,
        final String productionRoutingOpIntVersion );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingSubOperation
     * ProductionRoutingSubOperation} entity and save it to the S/4HANA system.
     *
     * @param productionRoutingSubOperation
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingSubOperation
     *            ProductionRoutingSubOperation} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingSubOperation
     *         ProductionRoutingSubOperation} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingSubOperationCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductionRoutingSubOperationCreateFluentHelper createProductionRoutingSubOperation(
        @Nonnull final ProductionRoutingSubOperation productionRoutingSubOperation );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingSubOperation
     * ProductionRoutingSubOperation} entity and save it to the S/4HANA system.
     *
     * @param productionRoutingSubOperation
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingSubOperation
     *            ProductionRoutingSubOperation} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingSubOperation
     *         ProductionRoutingSubOperation} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionrouting.ProductionRoutingSubOperationUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductionRoutingSubOperationUpdateFluentHelper updateProductionRoutingSubOperation(
        @Nonnull final ProductionRoutingSubOperation productionRoutingSubOperation );

}
