/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.time.LocalDateTime;
import java.time.ZonedDateTime;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionvolumecapture.ProductionVolume;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionvolumecapture.ProductionVolumeByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionvolumecapture.ProductionVolumeCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionvolumecapture.ProductionVolumeFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionvolumecapture.batch.ProductionVolumeCaptureServiceBatch;

/**
 * <p>
 * You can use the service to read and create production volumes for wells or combination of well and well completions.
 * The service is based on the OData protocol and can be consumed by external systems.
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/9e/39877d13dd42cca8166ac6075dbfcc/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_PRODVOLCAPTURE?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_PRODVOLCAPTURE</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Production Volume Management Integration(SAP_COM_0704)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/4AG'>Production Volume Capture(4AG)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Deprecated
public interface ProductionVolumeCaptureService extends BatchService<ProductionVolumeCaptureServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_PRODVOLCAPTURE";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    ProductionVolumeCaptureService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionvolumecapture.ProductionVolume
     * ProductionVolume} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionvolumecapture.ProductionVolume
     *         ProductionVolume} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionvolumecapture.ProductionVolumeFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductionVolumeFluentHelper getAllProductionVolume();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionvolumecapture.ProductionVolume
     * ProductionVolume} entity using key fields.
     *
     * @param productionDate
     *            Production Date
     *            <p>
     *            Constraints: Not nullable, Precision: 0
     *            </p>
     * @param well
     *            Well ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 30
     *            </p>
     * @param wellCompletion
     *            Well Completion ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 30
     *            </p>
     * @param oilAllocAtWellCompltnDateTime
     *            UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     *            <p>
     *            Constraints: Not nullable, Precision: 0
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionvolumecapture.ProductionVolume
     *         ProductionVolume} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionvolumecapture.ProductionVolumeByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductionVolumeByKeyFluentHelper getProductionVolumeByKey(
        final String well,
        final String wellCompletion,
        final LocalDateTime productionDate,
        final ZonedDateTime oilAllocAtWellCompltnDateTime );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionvolumecapture.ProductionVolume
     * ProductionVolume} entity and save it to the S/4HANA system.
     *
     * @param productionVolume
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionvolumecapture.ProductionVolume
     *            ProductionVolume} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionvolumecapture.ProductionVolume
     *         ProductionVolume} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.productionvolumecapture.ProductionVolumeCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductionVolumeCreateFluentHelper createProductionVolume( @Nonnull final ProductionVolume productionVolume );

}
