/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.time.LocalDateTime;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.profitcenter.PrftCtrCompanyCodeAssignmentByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.profitcenter.PrftCtrCompanyCodeAssignmentFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.profitcenter.ProfitCenterByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.profitcenter.ProfitCenterFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.profitcenter.ProfitCenterTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.profitcenter.ProfitCenterTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.profitcenter.batch.ProfitCenterServiceBatch;

/**
 * <p>
 *
 * This service enables you to read profit center master data in an API call. It is based on the OData protocol and can
 * be consumed in SAP Fiori apps and other user interfaces. .
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/04/bb2efc2e9444cba9547a99d77ec61c/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_PROFITCENTER_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_PROFITCENTER_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>SAP Analytics Cloud for Planning Integration(SAP_COM_0087), Public Sector API Integration(SAP_COM_0761)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/1YB'>Import Connection setup with SAP Analytics Cloud(1YB)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/6UC'>Government Budget Planning(6UC)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Profit Center</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Deprecated
public interface ProfitCenterService extends BatchService<ProfitCenterServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_PROFITCENTER_SRV";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    ProfitCenterService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.profitcenter.PrftCtrCompanyCodeAssignment
     * PrftCtrCompanyCodeAssignment} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.profitcenter.PrftCtrCompanyCodeAssignment
     *         PrftCtrCompanyCodeAssignment} entities. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.profitcenter.PrftCtrCompanyCodeAssignmentFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PrftCtrCompanyCodeAssignmentFluentHelper getAllPrftCtrCompanyCodeAssignment();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.profitcenter.PrftCtrCompanyCodeAssignment
     * PrftCtrCompanyCodeAssignment} entity using key fields.
     *
     * @param companyCode
     *
     * @param controllingArea
     *            Controlling Area
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param profitCenter
     *            Profit Center
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.profitcenter.PrftCtrCompanyCodeAssignment
     *         PrftCtrCompanyCodeAssignment} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.profitcenter.PrftCtrCompanyCodeAssignmentByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PrftCtrCompanyCodeAssignmentByKeyFluentHelper getPrftCtrCompanyCodeAssignmentByKey(
        final String controllingArea,
        final String profitCenter,
        final String companyCode );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.profitcenter.ProfitCenter ProfitCenter}
     * entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.profitcenter.ProfitCenter ProfitCenter}
     *         entities. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.profitcenter.ProfitCenterFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProfitCenterFluentHelper getAllProfitCenter();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.profitcenter.ProfitCenter ProfitCenter}
     * entity using key fields.
     *
     * @param controllingArea
     *            Controlling Area
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param profitCenter
     *            Profit Center
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param validityEndDate
     *            Valid To Date
     *            <p>
     *            Constraints: Not nullable, Precision: 0
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.profitcenter.ProfitCenter ProfitCenter} entity
     *         using key fields. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.profitcenter.ProfitCenterByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProfitCenterByKeyFluentHelper getProfitCenterByKey(
        final String controllingArea,
        final String profitCenter,
        final LocalDateTime validityEndDate );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.profitcenter.ProfitCenterText
     * ProfitCenterText} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.profitcenter.ProfitCenterText
     *         ProfitCenterText} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.profitcenter.ProfitCenterTextFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProfitCenterTextFluentHelper getAllProfitCenterText();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.profitcenter.ProfitCenterText
     * ProfitCenterText} entity using key fields.
     *
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param controllingArea
     *            Controlling Area
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param profitCenter
     *            Profit Center
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param validityEndDate
     *            Valid To Date
     *            <p>
     *            Constraints: Not nullable, Precision: 0
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.profitcenter.ProfitCenterText
     *         ProfitCenterText} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.profitcenter.ProfitCenterTextByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProfitCenterTextByKeyFluentHelper getProfitCenterTextByKey(
        final String language,
        final String controllingArea,
        final String profitCenter,
        final LocalDateTime validityEndDate );

}
