/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.util.UUID;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndExpenseDistr;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndExpenseDistrByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndExpenseDistrDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndExpenseDistrFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndExpenseDistrUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndResourceAssignment;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndResourceAssignmentByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndResourceAssignmentCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndResourceAssignmentDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndResourceAssignmentFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndResourceAssignmentUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndRsceAssgmtDistr;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndRsceAssgmtDistrByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndRsceAssgmtDistrDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndRsceAssgmtDistrFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndRsceAssgmtDistrUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndRsceReqDistribution;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndRsceReqDistributionByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndRsceReqDistributionDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndRsceReqDistributionFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndRsceReqDistributionUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemand;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandExpense;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandExpenseByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandExpenseCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandExpenseFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandExpenseUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandMaterial;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandMaterialByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandMaterialFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandMaterialSupply;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandMaterialSupplyByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandMaterialSupplyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandMaterialSupplyUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandMaterialUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandResource;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandResourceByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandResourceCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandResourceFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandResourceRequest;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandResourceRequestByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandResourceRequestCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandResourceRequestDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandResourceRequestFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandResourceRequestUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandResourceUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandServiceByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandServiceFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandServiceSupply;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandServiceSupplyByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandServiceSupplyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandServiceSupplyUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandServiceUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ResetDemandStatusToRequestedFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.SetDemandStatusToClosedFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.SetDemandStatusToRequestedFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.SetDmndStsToRequestOnReleaseFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.batch.ProjectDemandServiceBatch;

/**
 * <p>
 *
 * This service enables you to create, read, update, and delete project demands of enterprise projects and professional
 * services projects. A project demand represents a need for a material, service, resource, or expense that is related
 * to a project or a project element. With this service, you can process the following: - Service and material demands
 * of enterprise projects including the related supply information - Resource demands of enterprise projects including
 * the related resource assignments - Resource demands of professional services projects including the related resource
 * requests and resource assignments with their respective distributions - Demands for expenses of professional services
 * projects including the related demand distribution
 *
 * This service is based on the OData protocol and can be consumed by apps and other user interfaces..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/c8/b1ad2902384b46b8ab6f991f48cf68/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_PROJECTDEMAND_0001?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_PROJECTDEMAND_0001</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Project Demand Integration(SAP_COM_0783)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/4RF'>Project Control - Resourcing and Procurement(4RF)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/PRF'>Project Control - Resourcing and Procurement(PRF)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Project Demand</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Deprecated
public interface ProjectDemandService extends BatchService<ProjectDemandServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_PROJECTDEMAND";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    ProjectDemandService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndExpenseDistr
     * ProjDmndExpenseDistr} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndExpenseDistr
     *         ProjDmndExpenseDistr} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndExpenseDistrFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProjDmndExpenseDistrFluentHelper getAllProjDmndExpenseDistr();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndExpenseDistr
     * ProjDmndExpenseDistr} entity using key fields.
     *
     * @param projDmndExpnDistributionUUID
     *            Global ID for the Distribution of a Demand for Expense
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndExpenseDistr
     *         ProjDmndExpenseDistr} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndExpenseDistrByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProjDmndExpenseDistrByKeyFluentHelper getProjDmndExpenseDistrByKey( final UUID projDmndExpnDistributionUUID );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndExpenseDistr
     * ProjDmndExpenseDistr} entity and save it to the S/4HANA system.
     *
     * @param projDmndExpenseDistr
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndExpenseDistr
     *            ProjDmndExpenseDistr} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndExpenseDistr
     *         ProjDmndExpenseDistr} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndExpenseDistrUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProjDmndExpenseDistrUpdateFluentHelper
        updateProjDmndExpenseDistr( @Nonnull final ProjDmndExpenseDistr projDmndExpenseDistr );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndExpenseDistr
     * ProjDmndExpenseDistr} entity in the S/4HANA system.
     *
     * @param projDmndExpenseDistr
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndExpenseDistr
     *            ProjDmndExpenseDistr} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndExpenseDistr
     *         ProjDmndExpenseDistr} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndExpenseDistrDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProjDmndExpenseDistrDeleteFluentHelper
        deleteProjDmndExpenseDistr( @Nonnull final ProjDmndExpenseDistr projDmndExpenseDistr );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndResourceAssignment
     * ProjDmndResourceAssignment} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndResourceAssignment
     *         ProjDmndResourceAssignment} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndResourceAssignmentFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProjDmndResourceAssignmentFluentHelper getAllProjDmndResourceAssignment();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndResourceAssignment
     * ProjDmndResourceAssignment} entity using key fields.
     *
     * @param projDmndRsceAssgmtUUID
     *            Global Identification of a Resource Assignment to a Demand
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndResourceAssignment
     *         ProjDmndResourceAssignment} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndResourceAssignmentByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProjDmndResourceAssignmentByKeyFluentHelper getProjDmndResourceAssignmentByKey( final UUID projDmndRsceAssgmtUUID );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndResourceAssignment
     * ProjDmndResourceAssignment} entity and save it to the S/4HANA system.
     *
     * @param projDmndResourceAssignment
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndResourceAssignment
     *            ProjDmndResourceAssignment} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndResourceAssignment
     *         ProjDmndResourceAssignment} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndResourceAssignmentCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProjDmndResourceAssignmentCreateFluentHelper
        createProjDmndResourceAssignment( @Nonnull final ProjDmndResourceAssignment projDmndResourceAssignment );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndResourceAssignment
     * ProjDmndResourceAssignment} entity and save it to the S/4HANA system.
     *
     * @param projDmndResourceAssignment
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndResourceAssignment
     *            ProjDmndResourceAssignment} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndResourceAssignment
     *         ProjDmndResourceAssignment} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndResourceAssignmentUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProjDmndResourceAssignmentUpdateFluentHelper
        updateProjDmndResourceAssignment( @Nonnull final ProjDmndResourceAssignment projDmndResourceAssignment );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndResourceAssignment
     * ProjDmndResourceAssignment} entity in the S/4HANA system.
     *
     * @param projDmndResourceAssignment
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndResourceAssignment
     *            ProjDmndResourceAssignment} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndResourceAssignment
     *         ProjDmndResourceAssignment} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndResourceAssignmentDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProjDmndResourceAssignmentDeleteFluentHelper
        deleteProjDmndResourceAssignment( @Nonnull final ProjDmndResourceAssignment projDmndResourceAssignment );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndRsceAssgmtDistr
     * ProjDmndRsceAssgmtDistr} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndRsceAssgmtDistr
     *         ProjDmndRsceAssgmtDistr} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndRsceAssgmtDistrFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProjDmndRsceAssgmtDistrFluentHelper getAllProjDmndRsceAssgmtDistr();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndRsceAssgmtDistr
     * ProjDmndRsceAssgmtDistr} entity using key fields.
     *
     * @param projDmndRsceAssgmtDistrUUID
     *            Global Identification of a Resource Assignment Distribution
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndRsceAssgmtDistr
     *         ProjDmndRsceAssgmtDistr} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndRsceAssgmtDistrByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProjDmndRsceAssgmtDistrByKeyFluentHelper getProjDmndRsceAssgmtDistrByKey( final UUID projDmndRsceAssgmtDistrUUID );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndRsceAssgmtDistr
     * ProjDmndRsceAssgmtDistr} entity and save it to the S/4HANA system.
     *
     * @param projDmndRsceAssgmtDistr
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndRsceAssgmtDistr
     *            ProjDmndRsceAssgmtDistr} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndRsceAssgmtDistr
     *         ProjDmndRsceAssgmtDistr} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndRsceAssgmtDistrUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProjDmndRsceAssgmtDistrUpdateFluentHelper
        updateProjDmndRsceAssgmtDistr( @Nonnull final ProjDmndRsceAssgmtDistr projDmndRsceAssgmtDistr );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndRsceAssgmtDistr
     * ProjDmndRsceAssgmtDistr} entity in the S/4HANA system.
     *
     * @param projDmndRsceAssgmtDistr
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndRsceAssgmtDistr
     *            ProjDmndRsceAssgmtDistr} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndRsceAssgmtDistr
     *         ProjDmndRsceAssgmtDistr} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndRsceAssgmtDistrDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProjDmndRsceAssgmtDistrDeleteFluentHelper
        deleteProjDmndRsceAssgmtDistr( @Nonnull final ProjDmndRsceAssgmtDistr projDmndRsceAssgmtDistr );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndRsceReqDistribution
     * ProjDmndRsceReqDistribution} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndRsceReqDistribution
     *         ProjDmndRsceReqDistribution} entities. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndRsceReqDistributionFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProjDmndRsceReqDistributionFluentHelper getAllProjDmndRsceReqDistribution();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndRsceReqDistribution
     * ProjDmndRsceReqDistribution} entity using key fields.
     *
     * @param projDmndRsceReqDistrUUID
     *            Global Identification of a Resource Request Distribution
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndRsceReqDistribution
     *         ProjDmndRsceReqDistribution} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndRsceReqDistributionByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProjDmndRsceReqDistributionByKeyFluentHelper
        getProjDmndRsceReqDistributionByKey( final UUID projDmndRsceReqDistrUUID );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndRsceReqDistribution
     * ProjDmndRsceReqDistribution} entity and save it to the S/4HANA system.
     *
     * @param projDmndRsceReqDistribution
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndRsceReqDistribution
     *            ProjDmndRsceReqDistribution} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndRsceReqDistribution
     *         ProjDmndRsceReqDistribution} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndRsceReqDistributionUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProjDmndRsceReqDistributionUpdateFluentHelper
        updateProjDmndRsceReqDistribution( @Nonnull final ProjDmndRsceReqDistribution projDmndRsceReqDistribution );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndRsceReqDistribution
     * ProjDmndRsceReqDistribution} entity in the S/4HANA system.
     *
     * @param projDmndRsceReqDistribution
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndRsceReqDistribution
     *            ProjDmndRsceReqDistribution} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndRsceReqDistribution
     *         ProjDmndRsceReqDistribution} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjDmndRsceReqDistributionDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProjDmndRsceReqDistributionDeleteFluentHelper
        deleteProjDmndRsceReqDistribution( @Nonnull final ProjDmndRsceReqDistribution projDmndRsceReqDistribution );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemand
     * ProjectDemand} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemand ProjectDemand}
     *         entities. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProjectDemandFluentHelper getAllProjectDemand();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemand
     * ProjectDemand} entity using key fields.
     *
     * @param projectDemandUUID
     *            Global Identification of a Project Demand
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemand ProjectDemand}
     *         entity using key fields. This fluent helper allows methods which modify the underlying query to be called
     *         before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProjectDemandByKeyFluentHelper getProjectDemandByKey( final UUID projectDemandUUID );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemand
     * ProjectDemand} entity and save it to the S/4HANA system.
     *
     * @param projectDemand
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemand ProjectDemand}
     *            entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemand ProjectDemand}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProjectDemandCreateFluentHelper createProjectDemand( @Nonnull final ProjectDemand projectDemand );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemand
     * ProjectDemand} entity and save it to the S/4HANA system.
     *
     * @param projectDemand
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemand ProjectDemand}
     *            entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemand ProjectDemand}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProjectDemandUpdateFluentHelper updateProjectDemand( @Nonnull final ProjectDemand projectDemand );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemand
     * ProjectDemand} entity in the S/4HANA system.
     *
     * @param projectDemand
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemand ProjectDemand}
     *            entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemand ProjectDemand}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProjectDemandDeleteFluentHelper deleteProjectDemand( @Nonnull final ProjectDemand projectDemand );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandExpense
     * ProjectDemandExpense} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandExpense
     *         ProjectDemandExpense} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandExpenseFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProjectDemandExpenseFluentHelper getAllProjectDemandExpense();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandExpense
     * ProjectDemandExpense} entity using key fields.
     *
     * @param projectDemandExpenseUUID
     *            Global Identification of a Demand for Expense
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandExpense
     *         ProjectDemandExpense} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandExpenseByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProjectDemandExpenseByKeyFluentHelper getProjectDemandExpenseByKey( final UUID projectDemandExpenseUUID );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandExpense
     * ProjectDemandExpense} entity and save it to the S/4HANA system.
     *
     * @param projectDemandExpense
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandExpense
     *            ProjectDemandExpense} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandExpense
     *         ProjectDemandExpense} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandExpenseCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProjectDemandExpenseCreateFluentHelper
        createProjectDemandExpense( @Nonnull final ProjectDemandExpense projectDemandExpense );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandExpense
     * ProjectDemandExpense} entity and save it to the S/4HANA system.
     *
     * @param projectDemandExpense
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandExpense
     *            ProjectDemandExpense} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandExpense
     *         ProjectDemandExpense} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandExpenseUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProjectDemandExpenseUpdateFluentHelper
        updateProjectDemandExpense( @Nonnull final ProjectDemandExpense projectDemandExpense );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandMaterial
     * ProjectDemandMaterial} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandMaterial
     *         ProjectDemandMaterial} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandMaterialFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProjectDemandMaterialFluentHelper getAllProjectDemandMaterial();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandMaterial
     * ProjectDemandMaterial} entity using key fields.
     *
     * @param projectDemandMaterialUUID
     *            Global Identification for Material Demand
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandMaterial
     *         ProjectDemandMaterial} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandMaterialByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProjectDemandMaterialByKeyFluentHelper getProjectDemandMaterialByKey( final UUID projectDemandMaterialUUID );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandMaterial
     * ProjectDemandMaterial} entity and save it to the S/4HANA system.
     *
     * @param projectDemandMaterial
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandMaterial
     *            ProjectDemandMaterial} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandMaterial
     *         ProjectDemandMaterial} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandMaterialUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProjectDemandMaterialUpdateFluentHelper
        updateProjectDemandMaterial( @Nonnull final ProjectDemandMaterial projectDemandMaterial );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandMaterialSupply
     * ProjectDemandMaterialSupply} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandMaterialSupply
     *         ProjectDemandMaterialSupply} entities. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandMaterialSupplyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProjectDemandMaterialSupplyFluentHelper getAllProjectDemandMaterialSupply();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandMaterialSupply
     * ProjectDemandMaterialSupply} entity using key fields.
     *
     * @param projDemandMaterialSupplyUUID
     *            UUID for the Material Demand Supply
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandMaterialSupply
     *         ProjectDemandMaterialSupply} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandMaterialSupplyByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProjectDemandMaterialSupplyByKeyFluentHelper
        getProjectDemandMaterialSupplyByKey( final UUID projDemandMaterialSupplyUUID );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandMaterialSupply
     * ProjectDemandMaterialSupply} entity and save it to the S/4HANA system.
     *
     * @param projectDemandMaterialSupply
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandMaterialSupply
     *            ProjectDemandMaterialSupply} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandMaterialSupply
     *         ProjectDemandMaterialSupply} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandMaterialSupplyUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProjectDemandMaterialSupplyUpdateFluentHelper
        updateProjectDemandMaterialSupply( @Nonnull final ProjectDemandMaterialSupply projectDemandMaterialSupply );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandResource
     * ProjectDemandResource} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandResource
     *         ProjectDemandResource} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandResourceFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProjectDemandResourceFluentHelper getAllProjectDemandResource();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandResource
     * ProjectDemandResource} entity using key fields.
     *
     * @param projectDemandWorkUUID
     *            Global Identification of a Resource Demand
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandResource
     *         ProjectDemandResource} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandResourceByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProjectDemandResourceByKeyFluentHelper getProjectDemandResourceByKey( final UUID projectDemandWorkUUID );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandResource
     * ProjectDemandResource} entity and save it to the S/4HANA system.
     *
     * @param projectDemandResource
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandResource
     *            ProjectDemandResource} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandResource
     *         ProjectDemandResource} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandResourceCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProjectDemandResourceCreateFluentHelper
        createProjectDemandResource( @Nonnull final ProjectDemandResource projectDemandResource );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandResource
     * ProjectDemandResource} entity and save it to the S/4HANA system.
     *
     * @param projectDemandResource
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandResource
     *            ProjectDemandResource} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandResource
     *         ProjectDemandResource} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandResourceUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProjectDemandResourceUpdateFluentHelper
        updateProjectDemandResource( @Nonnull final ProjectDemandResource projectDemandResource );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandResourceRequest
     * ProjectDemandResourceRequest} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandResourceRequest
     *         ProjectDemandResourceRequest} entities. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandResourceRequestFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProjectDemandResourceRequestFluentHelper getAllProjectDemandResourceRequest();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandResourceRequest
     * ProjectDemandResourceRequest} entity using key fields.
     *
     * @param projDmndResourceRequestUUID
     *            Global Identification of a Resource Request
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandResourceRequest
     *         ProjectDemandResourceRequest} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandResourceRequestByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProjectDemandResourceRequestByKeyFluentHelper
        getProjectDemandResourceRequestByKey( final UUID projDmndResourceRequestUUID );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandResourceRequest
     * ProjectDemandResourceRequest} entity and save it to the S/4HANA system.
     *
     * @param projectDemandResourceRequest
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandResourceRequest
     *            ProjectDemandResourceRequest} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandResourceRequest
     *         ProjectDemandResourceRequest} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandResourceRequestCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProjectDemandResourceRequestCreateFluentHelper
        createProjectDemandResourceRequest( @Nonnull final ProjectDemandResourceRequest projectDemandResourceRequest );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandResourceRequest
     * ProjectDemandResourceRequest} entity and save it to the S/4HANA system.
     *
     * @param projectDemandResourceRequest
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandResourceRequest
     *            ProjectDemandResourceRequest} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandResourceRequest
     *         ProjectDemandResourceRequest} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandResourceRequestUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProjectDemandResourceRequestUpdateFluentHelper
        updateProjectDemandResourceRequest( @Nonnull final ProjectDemandResourceRequest projectDemandResourceRequest );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandResourceRequest
     * ProjectDemandResourceRequest} entity in the S/4HANA system.
     *
     * @param projectDemandResourceRequest
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandResourceRequest
     *            ProjectDemandResourceRequest} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandResourceRequest
     *         ProjectDemandResourceRequest} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandResourceRequestDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProjectDemandResourceRequestDeleteFluentHelper
        deleteProjectDemandResourceRequest( @Nonnull final ProjectDemandResourceRequest projectDemandResourceRequest );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandService
     * ProjectDemandService} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandService
     *         ProjectDemandService} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandServiceFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProjectDemandServiceFluentHelper getAllProjectDemandService();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandService
     * ProjectDemandService} entity using key fields.
     *
     * @param projectDemandServiceUUID
     *            Global Identification for Service Demand
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandService
     *         ProjectDemandService} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandServiceByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProjectDemandServiceByKeyFluentHelper getProjectDemandServiceByKey( final UUID projectDemandServiceUUID );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandService
     * ProjectDemandService} entity and save it to the S/4HANA system.
     *
     * @param projectDemandService
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandService
     *            ProjectDemandService} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandService
     *         ProjectDemandService} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandServiceUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProjectDemandServiceUpdateFluentHelper updateProjectDemandService(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandService projectDemandService );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandServiceSupply
     * ProjectDemandServiceSupply} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandServiceSupply
     *         ProjectDemandServiceSupply} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandServiceSupplyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProjectDemandServiceSupplyFluentHelper getAllProjectDemandServiceSupply();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandServiceSupply
     * ProjectDemandServiceSupply} entity using key fields.
     *
     * @param projectDemandServiceSupplyUUID
     *            Global Identification for Service Supply
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandServiceSupply
     *         ProjectDemandServiceSupply} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandServiceSupplyByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProjectDemandServiceSupplyByKeyFluentHelper
        getProjectDemandServiceSupplyByKey( final UUID projectDemandServiceSupplyUUID );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandServiceSupply
     * ProjectDemandServiceSupply} entity and save it to the S/4HANA system.
     *
     * @param projectDemandServiceSupply
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandServiceSupply
     *            ProjectDemandServiceSupply} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandServiceSupply
     *         ProjectDemandServiceSupply} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandServiceSupplyUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProjectDemandServiceSupplyUpdateFluentHelper
        updateProjectDemandServiceSupply( @Nonnull final ProjectDemandServiceSupply projectDemandServiceSupply );

    /**
     * <p>
     * Creates a fluent helper for the <b>ResetDemandStatusToRequested</b> OData function import.
     * </p>
     *
     * @param projectDemandUUID
     *            Demand UUID
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: none
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ProjectDemandUUID</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>ResetDemandStatusToRequested</b> OData function import
     *         with the provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ResetDemandStatusToRequestedFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ResetDemandStatusToRequestedFluentHelper resetDemandStatusToRequested( @Nonnull final UUID projectDemandUUID );

    /**
     * <p>
     * Creates a fluent helper for the <b>SetDemandStatusToClosed</b> OData function import.
     * </p>
     *
     * @param projectDemandUUID
     *            Demand UUID
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: none
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ProjectDemandUUID</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>SetDemandStatusToClosed</b> OData function import with
     *         the provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.SetDemandStatusToClosedFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SetDemandStatusToClosedFluentHelper setDemandStatusToClosed( @Nonnull final UUID projectDemandUUID );

    /**
     * <p>
     * Creates a fluent helper for the <b>SetDemandStatusToRequested</b> OData function import.
     * </p>
     *
     * @param projectDemandUUID
     *            Demand UUID
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: none
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ProjectDemandUUID</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>SetDemandStatusToRequested</b> OData function import with
     *         the provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.SetDemandStatusToRequestedFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SetDemandStatusToRequestedFluentHelper setDemandStatusToRequested( @Nonnull final UUID projectDemandUUID );

    /**
     * <p>
     * Creates a fluent helper for the <b>SetDmndStsToRequestOnRelease</b> OData function import.
     * </p>
     *
     * @param projectDemandUUID
     *            Demand UUID
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: none
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ProjectDemandUUID</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>SetDmndStsToRequestOnRelease</b> OData function import
     *         with the provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.SetDmndStsToRequestOnReleaseFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SetDmndStsToRequestOnReleaseFluentHelper setDmndStsToRequestOnRelease( @Nonnull final UUID projectDemandUUID );

}
