/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.time.LocalDateTime;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.ApproveDocumentFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurContrItemConditionByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurContrItemConditionFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurCtrAccount;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurCtrAccountByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurCtrAccountCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurCtrAccountFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurCtrAccountUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurCtrAddress;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurCtrAddressByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurCtrAddressCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurCtrAddressFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurCtrAddressUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurCtrPartners;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurCtrPartnersByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurCtrPartnersCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurCtrPartnersFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurCtrPartnersUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurchaseContract;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurchaseContractByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurchaseContractCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurchaseContractFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurchaseContractItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurchaseContractItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurchaseContractItemCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurchaseContractItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurchaseContractItemUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurchaseContractUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.RejectDocumentFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.WithdrawFromApprovalFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.batch.PurchaseContractServiceBatch;

/**
 * <p>
 *
 * This service is based on the OData protocol. It enables you to read, create, and update purchase contracts through an
 * API call from a source system outside SAP S/4HANA Cloud. The service contains header, item, item conditions, account
 * assignment, address and partner nodes. .
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2208.latest/EN/34/3b465833a40846e10000000a441470/frameset.htm?profile=20020833'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_PURCHASECONTRACT_PROCESS_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_PURCHASECONTRACT_PROCESS_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.1.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2208</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Distributed Manufacturing Integration(SAP_COM_0077), Purchase Contract Integration(SAP_COM_0101)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/1NX'>Collaborative Manufacturing with SAP Digital Manufacturing
 * Cloud(1NX)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/JC1'>Dynamic Customer Profiling(JC1)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BNX'>Consumable Purchasing(BNX)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/J13'>Service and Material Procurement - Project-Based
 * Services(J13)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/J45'>Procurement of Direct Materials(J45)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/O45'>Procurement of Direct Materials(O45)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/ONX'>Consumable Purchasing(ONX)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BMD'>Purchase Contract(BMD)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OMD'>Purchase Contract(OMD)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Purchase Contract</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated as of release 2202 (Feb 2022). Please use the
 *             odata generator to generate the VDM.
 */
@Deprecated
public interface PurchaseContractService extends BatchService<PurchaseContractServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_PURCHASECONTRACT_PROCESS_SRV";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    PurchaseContractService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurchaseContract
     * PurchaseContract} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurchaseContract
     *         PurchaseContract} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurchaseContractFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PurchaseContractFluentHelper getAllPurchaseContract();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurchaseContract
     * PurchaseContract} entity using key fields.
     *
     * @param purchaseContract
     *            Purchasing Contract Header
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurchaseContract
     *         PurchaseContract} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurchaseContractByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PurchaseContractByKeyFluentHelper getPurchaseContractByKey( final String purchaseContract );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurchaseContract
     * PurchaseContract} entity and save it to the S/4HANA system.
     *
     * @param purchaseContract
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurchaseContract
     *            PurchaseContract} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurchaseContract
     *         PurchaseContract} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurchaseContractCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PurchaseContractCreateFluentHelper createPurchaseContract( @Nonnull final PurchaseContract purchaseContract );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurchaseContract
     * PurchaseContract} entity and save it to the S/4HANA system.
     *
     * @param purchaseContract
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurchaseContract
     *            PurchaseContract} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurchaseContract
     *         PurchaseContract} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurchaseContractUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PurchaseContractUpdateFluentHelper updatePurchaseContract( @Nonnull final PurchaseContract purchaseContract );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurchaseContractItem
     * PurchaseContractItem} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurchaseContractItem
     *         PurchaseContractItem} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurchaseContractItemFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PurchaseContractItemFluentHelper getAllPurchaseContractItem();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurchaseContractItem
     * PurchaseContractItem} entity using key fields.
     *
     * @param purchaseContract
     *            Purchasing Contract Header
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param purchaseContractItem
     *            Item Number of Purchasing Contract
     *            <p>
     *            Constraints: Not nullable, Maximum length: 5
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurchaseContractItem
     *         PurchaseContractItem} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurchaseContractItemByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PurchaseContractItemByKeyFluentHelper
        getPurchaseContractItemByKey( final String purchaseContract, final String purchaseContractItem );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurchaseContractItem
     * PurchaseContractItem} entity and save it to the S/4HANA system.
     *
     * @param purchaseContractItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurchaseContractItem
     *            PurchaseContractItem} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurchaseContractItem
     *         PurchaseContractItem} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurchaseContractItemCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PurchaseContractItemCreateFluentHelper
        createPurchaseContractItem( @Nonnull final PurchaseContractItem purchaseContractItem );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurchaseContractItem
     * PurchaseContractItem} entity and save it to the S/4HANA system.
     *
     * @param purchaseContractItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurchaseContractItem
     *            PurchaseContractItem} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurchaseContractItem
     *         PurchaseContractItem} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurchaseContractItemUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PurchaseContractItemUpdateFluentHelper
        updatePurchaseContractItem( @Nonnull final PurchaseContractItem purchaseContractItem );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurContrItemCondition
     * PurContrItemCondition} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurContrItemCondition
     *         PurContrItemCondition} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurContrItemConditionFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PurContrItemConditionFluentHelper getAllPurContrItemCondition();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurContrItemCondition
     * PurContrItemCondition} entity using key fields.
     *
     * @param conditionSequentialNumber
     *            Sequential number of the condition
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param conditionValidityEndDate
     *
     * @param purchaseContract
     *            Purchasing Document Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param conditionType
     *            Condition Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param purchaseContractItem
     *            Item Number of Purchasing Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 5
     *            </p>
     * @param conditionRecord
     *            Number of Condition Record
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurContrItemCondition
     *         PurContrItemCondition} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurContrItemConditionByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PurContrItemConditionByKeyFluentHelper getPurContrItemConditionByKey(
        final String purchaseContract,
        final String purchaseContractItem,
        final LocalDateTime conditionValidityEndDate,
        final String conditionType,
        final String conditionRecord,
        final String conditionSequentialNumber );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurCtrAccount
     * PurCtrAccount} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurCtrAccount PurCtrAccount}
     *         entities. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurCtrAccountFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PurCtrAccountFluentHelper getAllPurCtrAccount();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurCtrAccount
     * PurCtrAccount} entity using key fields.
     *
     * @param purchaseContract
     *            Purchasing Document Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param accountAssignment
     *            Sequential Number of Account Assignment
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param purchaseContractItem
     *            Item Number of Purchasing Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 5
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurCtrAccount PurCtrAccount}
     *         entity using key fields. This fluent helper allows methods which modify the underlying query to be called
     *         before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurCtrAccountByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PurCtrAccountByKeyFluentHelper getPurCtrAccountByKey(
        final String accountAssignment,
        final String purchaseContractItem,
        final String purchaseContract );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurCtrAccount
     * PurCtrAccount} entity and save it to the S/4HANA system.
     *
     * @param purCtrAccount
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurCtrAccount
     *            PurCtrAccount} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurCtrAccount PurCtrAccount}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurCtrAccountCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PurCtrAccountCreateFluentHelper createPurCtrAccount( @Nonnull final PurCtrAccount purCtrAccount );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurCtrAccount
     * PurCtrAccount} entity and save it to the S/4HANA system.
     *
     * @param purCtrAccount
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurCtrAccount
     *            PurCtrAccount} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurCtrAccount PurCtrAccount}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurCtrAccountUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PurCtrAccountUpdateFluentHelper updatePurCtrAccount( @Nonnull final PurCtrAccount purCtrAccount );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurCtrAddress
     * PurCtrAddress} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurCtrAddress PurCtrAddress}
     *         entities. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurCtrAddressFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PurCtrAddressFluentHelper getAllPurCtrAddress();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurCtrAddress
     * PurCtrAddress} entity using key fields.
     *
     * @param purchaseContract
     *            Purchasing Contract Header
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param purchaseContractItem
     *            Item Number of Purchasing Contract
     *            <p>
     *            Constraints: Not nullable, Maximum length: 5
     *            </p>
     * @param addressID
     *            Address Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurCtrAddress PurCtrAddress}
     *         entity using key fields. This fluent helper allows methods which modify the underlying query to be called
     *         before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurCtrAddressByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PurCtrAddressByKeyFluentHelper getPurCtrAddressByKey(
        final String purchaseContract,
        final String addressID,
        final String purchaseContractItem );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurCtrAddress
     * PurCtrAddress} entity and save it to the S/4HANA system.
     *
     * @param purCtrAddress
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurCtrAddress
     *            PurCtrAddress} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurCtrAddress PurCtrAddress}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurCtrAddressCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PurCtrAddressCreateFluentHelper createPurCtrAddress( @Nonnull final PurCtrAddress purCtrAddress );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurCtrAddress
     * PurCtrAddress} entity and save it to the S/4HANA system.
     *
     * @param purCtrAddress
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurCtrAddress
     *            PurCtrAddress} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurCtrAddress PurCtrAddress}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurCtrAddressUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PurCtrAddressUpdateFluentHelper updatePurCtrAddress( @Nonnull final PurCtrAddress purCtrAddress );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurCtrPartners
     * PurCtrPartners} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurCtrPartners
     *         PurCtrPartners} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurCtrPartnersFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PurCtrPartnersFluentHelper getAllPurCtrPartners();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurCtrPartners
     * PurCtrPartners} entity using key fields.
     *
     * @param partnerFunction
     *            Partner Function
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param purchaseContract
     *            Purchasing Document Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param plant
     *            Plant
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param purchasingOrganization
     *            Purchasing Organization
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param partnerCounter
     *            Partner counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @param purchaseContractItem
     *            Item Number of Purchasing Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 5
     *            </p>
     * @param supplierSubrange
     *            Supplier Subrange
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurCtrPartners
     *         PurCtrPartners} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurCtrPartnersByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PurCtrPartnersByKeyFluentHelper getPurCtrPartnersByKey(
        final String purchaseContract,
        final String purchaseContractItem,
        final String purchasingOrganization,
        final String partnerFunction,
        final String plant,
        final String supplierSubrange,
        final String partnerCounter );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurCtrPartners
     * PurCtrPartners} entity and save it to the S/4HANA system.
     *
     * @param purCtrPartners
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurCtrPartners
     *            PurCtrPartners} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurCtrPartners
     *         PurCtrPartners} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurCtrPartnersCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PurCtrPartnersCreateFluentHelper createPurCtrPartners( @Nonnull final PurCtrPartners purCtrPartners );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurCtrPartners
     * PurCtrPartners} entity and save it to the S/4HANA system.
     *
     * @param purCtrPartners
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurCtrPartners
     *            PurCtrPartners} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurCtrPartners
     *         PurCtrPartners} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurCtrPartnersUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PurCtrPartnersUpdateFluentHelper updatePurCtrPartners( @Nonnull final PurCtrPartners purCtrPartners );

    /**
     * <p>
     * Creates a fluent helper for the <b>WithdrawFromApproval</b> OData function import.
     * </p>
     *
     * @param purchaseContract
     *            Constraints: Not nullable, Maximum length: 10
     *            <p>
     *            Original parameter name from the Odata EDM: <b>PurchaseContract</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>WithdrawFromApproval</b> OData function import with the
     *         provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.WithdrawFromApprovalFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    WithdrawFromApprovalFluentHelper withdrawFromApproval( @Nonnull final String purchaseContract );

    /**
     * <p>
     * Creates a fluent helper for the <b>RejectDocument</b> OData function import.
     * </p>
     *
     * @param purchaseContract
     *            Constraints: Not nullable, Maximum length: 10
     *            <p>
     *            Original parameter name from the Odata EDM: <b>PurchaseContract</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>RejectDocument</b> OData function import with the
     *         provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.RejectDocumentFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    RejectDocumentFluentHelper rejectDocument( @Nonnull final String purchaseContract );

    /**
     * <p>
     * Creates a fluent helper for the <b>ApproveDocument</b> OData function import.
     * </p>
     *
     * @param purchaseContract
     *            Constraints: Not nullable, Maximum length: 10
     *            <p>
     *            Original parameter name from the Odata EDM: <b>PurchaseContract</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>ApproveDocument</b> OData function import with the
     *         provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.ApproveDocumentFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ApproveDocumentFluentHelper approveDocument( @Nonnull final String purchaseContract );

}
