/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.GetOutputBinaryDataFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.GetPDFFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.POSubcontractingComponent;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.POSubcontractingComponentByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.POSubcontractingComponentCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.POSubcontractingComponentDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.POSubcontractingComponentFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.POSubcontractingComponentUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurOrdAccountAssignment;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurOrdAccountAssignmentByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurOrdAccountAssignmentCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurOrdAccountAssignmentDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurOrdAccountAssignmentFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurOrdAccountAssignmentUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurOrdPricingElement;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurOrdPricingElementByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurOrdPricingElementCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurOrdPricingElementDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurOrdPricingElementFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurOrdPricingElementUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrder;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderItemCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderItemDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderItemNote;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderItemNoteByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderItemNoteCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderItemNoteDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderItemNoteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderItemNoteUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderItemUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderNote;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderNoteByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderNoteCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderNoteDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderNoteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderNoteUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderScheduleLine;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderScheduleLineByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderScheduleLineCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderScheduleLineDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderScheduleLineFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderScheduleLineUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.batch.PurchaseOrderServiceBatch;

/**
 * <p>
 *
 * This service enables you to create purchase orders through an API call from a source system outside SAP S/4HANA
 * Cloud. Furthermore, the service enables you to read, update or delete existing purchase orders from the SAP S/4HANA
 * Cloud system. The service is based on the OData protocol..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/ac/d2da57df6cc525e10000000a4450e5/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_PURCHASEORDER_PROCESS_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_PURCHASEORDER_PROCESS_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Purchase Order Integration(SAP_COM_0053), Distributed Manufacturing Integration(SAP_COM_0077)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/BNX'>Consumable Purchasing(BNX)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/J13'>Service and Material Procurement - Project-Based
 * Services(J13)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/J45'>Procurement of Direct Materials(J45)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/O45'>Procurement of Direct Materials(O45)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/ONX'>Consumable Purchasing(ONX)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/4R2'>Service Procurement with Ariba Network and SAP
 * Fieldglass(4R2)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/1NX'>Collaborative Manufacturing with SAP Digital
 * Manufacturing Cloud(1NX)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Purchase Order</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Deprecated
public interface PurchaseOrderService extends BatchService<PurchaseOrderServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_PURCHASEORDER_PROCESS_SRV";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    PurchaseOrderService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.POSubcontractingComponent
     * POSubcontractingComponent} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.POSubcontractingComponent
     *         POSubcontractingComponent} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.POSubcontractingComponentFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    POSubcontractingComponentFluentHelper getAllPOSubcontractingComponent();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.POSubcontractingComponent
     * POSubcontractingComponent} entity using key fields.
     *
     * @param reservationItem
     *            Reservation Item
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param recordType
     *            Reservation Record Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     * @param purchaseOrder
     *            Purchasing Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param scheduleLine
     *            Delivery Schedule Line Counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param purchaseOrderItem
     *            Purchasing Document Item
     *            <p>
     *            Constraints: Not nullable, Maximum length: 5
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.POSubcontractingComponent
     *         POSubcontractingComponent} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.POSubcontractingComponentByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    POSubcontractingComponentByKeyFluentHelper getPOSubcontractingComponentByKey(
        final String purchaseOrder,
        final String purchaseOrderItem,
        final String scheduleLine,
        final String reservationItem,
        final String recordType );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.POSubcontractingComponent
     * POSubcontractingComponent} entity and save it to the S/4HANA system.
     *
     * @param pOSubcontractingComponent
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.POSubcontractingComponent
     *            POSubcontractingComponent} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.POSubcontractingComponent
     *         POSubcontractingComponent} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.POSubcontractingComponentCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    POSubcontractingComponentCreateFluentHelper
        createPOSubcontractingComponent( @Nonnull final POSubcontractingComponent pOSubcontractingComponent );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.POSubcontractingComponent
     * POSubcontractingComponent} entity and save it to the S/4HANA system.
     *
     * @param pOSubcontractingComponent
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.POSubcontractingComponent
     *            POSubcontractingComponent} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.POSubcontractingComponent
     *         POSubcontractingComponent} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.POSubcontractingComponentUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    POSubcontractingComponentUpdateFluentHelper
        updatePOSubcontractingComponent( @Nonnull final POSubcontractingComponent pOSubcontractingComponent );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.POSubcontractingComponent
     * POSubcontractingComponent} entity in the S/4HANA system.
     *
     * @param pOSubcontractingComponent
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.POSubcontractingComponent
     *            POSubcontractingComponent} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.POSubcontractingComponent
     *         POSubcontractingComponent} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.POSubcontractingComponentDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    POSubcontractingComponentDeleteFluentHelper
        deletePOSubcontractingComponent( @Nonnull final POSubcontractingComponent pOSubcontractingComponent );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrder
     * PurchaseOrder} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrder PurchaseOrder}
     *         entities. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PurchaseOrderFluentHelper getAllPurchaseOrder();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrder
     * PurchaseOrder} entity using key fields.
     *
     * @param purchaseOrder
     *            Purchase Order Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrder PurchaseOrder}
     *         entity using key fields. This fluent helper allows methods which modify the underlying query to be called
     *         before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PurchaseOrderByKeyFluentHelper getPurchaseOrderByKey( final String purchaseOrder );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrder
     * PurchaseOrder} entity and save it to the S/4HANA system.
     *
     * @param purchaseOrder
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrder PurchaseOrder}
     *            entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrder PurchaseOrder}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PurchaseOrderCreateFluentHelper createPurchaseOrder( @Nonnull final PurchaseOrder purchaseOrder );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrder
     * PurchaseOrder} entity and save it to the S/4HANA system.
     *
     * @param purchaseOrder
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrder PurchaseOrder}
     *            entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrder PurchaseOrder}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PurchaseOrderUpdateFluentHelper updatePurchaseOrder( @Nonnull final PurchaseOrder purchaseOrder );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrder
     * PurchaseOrder} entity in the S/4HANA system.
     *
     * @param purchaseOrder
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrder PurchaseOrder}
     *            entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrder PurchaseOrder}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PurchaseOrderDeleteFluentHelper deletePurchaseOrder( @Nonnull final PurchaseOrder purchaseOrder );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderItem
     * PurchaseOrderItem} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderItem
     *         PurchaseOrderItem} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderItemFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PurchaseOrderItemFluentHelper getAllPurchaseOrderItem();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderItem
     * PurchaseOrderItem} entity using key fields.
     *
     * @param purchaseOrder
     *            Purchase Order Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param purchaseOrderItem
     *            Item Number of Purchase Order
     *            <p>
     *            Constraints: Not nullable, Maximum length: 5
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderItem
     *         PurchaseOrderItem} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderItemByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PurchaseOrderItemByKeyFluentHelper
        getPurchaseOrderItemByKey( final String purchaseOrder, final String purchaseOrderItem );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderItem
     * PurchaseOrderItem} entity and save it to the S/4HANA system.
     *
     * @param purchaseOrderItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderItem
     *            PurchaseOrderItem} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderItem
     *         PurchaseOrderItem} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderItemCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PurchaseOrderItemCreateFluentHelper createPurchaseOrderItem( @Nonnull final PurchaseOrderItem purchaseOrderItem );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderItem
     * PurchaseOrderItem} entity and save it to the S/4HANA system.
     *
     * @param purchaseOrderItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderItem
     *            PurchaseOrderItem} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderItem
     *         PurchaseOrderItem} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderItemUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PurchaseOrderItemUpdateFluentHelper updatePurchaseOrderItem( @Nonnull final PurchaseOrderItem purchaseOrderItem );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderItem
     * PurchaseOrderItem} entity in the S/4HANA system.
     *
     * @param purchaseOrderItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderItem
     *            PurchaseOrderItem} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderItem
     *         PurchaseOrderItem} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderItemDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PurchaseOrderItemDeleteFluentHelper deletePurchaseOrderItem( @Nonnull final PurchaseOrderItem purchaseOrderItem );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderItemNote
     * PurchaseOrderItemNote} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderItemNote
     *         PurchaseOrderItemNote} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderItemNoteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PurchaseOrderItemNoteFluentHelper getAllPurchaseOrderItemNote();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderItemNote
     * PurchaseOrderItemNote} entity using key fields.
     *
     * @param textObjectType
     *            Text ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param purchaseOrder
     *            Purchasing Document Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param purchaseOrderItem
     *            Item Number of Purchasing Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 5
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderItemNote
     *         PurchaseOrderItemNote} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderItemNoteByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PurchaseOrderItemNoteByKeyFluentHelper getPurchaseOrderItemNoteByKey(
        final String purchaseOrder,
        final String purchaseOrderItem,
        final String textObjectType,
        final String language );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderItemNote
     * PurchaseOrderItemNote} entity and save it to the S/4HANA system.
     *
     * @param purchaseOrderItemNote
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderItemNote
     *            PurchaseOrderItemNote} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderItemNote
     *         PurchaseOrderItemNote} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderItemNoteCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PurchaseOrderItemNoteCreateFluentHelper
        createPurchaseOrderItemNote( @Nonnull final PurchaseOrderItemNote purchaseOrderItemNote );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderItemNote
     * PurchaseOrderItemNote} entity and save it to the S/4HANA system.
     *
     * @param purchaseOrderItemNote
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderItemNote
     *            PurchaseOrderItemNote} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderItemNote
     *         PurchaseOrderItemNote} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderItemNoteUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PurchaseOrderItemNoteUpdateFluentHelper
        updatePurchaseOrderItemNote( @Nonnull final PurchaseOrderItemNote purchaseOrderItemNote );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderItemNote
     * PurchaseOrderItemNote} entity in the S/4HANA system.
     *
     * @param purchaseOrderItemNote
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderItemNote
     *            PurchaseOrderItemNote} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderItemNote
     *         PurchaseOrderItemNote} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderItemNoteDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PurchaseOrderItemNoteDeleteFluentHelper
        deletePurchaseOrderItemNote( @Nonnull final PurchaseOrderItemNote purchaseOrderItemNote );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderNote
     * PurchaseOrderNote} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderNote
     *         PurchaseOrderNote} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderNoteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PurchaseOrderNoteFluentHelper getAllPurchaseOrderNote();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderNote
     * PurchaseOrderNote} entity using key fields.
     *
     * @param textObjectType
     *            Text ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param purchaseOrder
     *            Purchasing Document Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderNote
     *         PurchaseOrderNote} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderNoteByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PurchaseOrderNoteByKeyFluentHelper
        getPurchaseOrderNoteByKey( final String purchaseOrder, final String textObjectType, final String language );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderNote
     * PurchaseOrderNote} entity and save it to the S/4HANA system.
     *
     * @param purchaseOrderNote
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderNote
     *            PurchaseOrderNote} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderNote
     *         PurchaseOrderNote} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderNoteCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PurchaseOrderNoteCreateFluentHelper createPurchaseOrderNote( @Nonnull final PurchaseOrderNote purchaseOrderNote );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderNote
     * PurchaseOrderNote} entity and save it to the S/4HANA system.
     *
     * @param purchaseOrderNote
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderNote
     *            PurchaseOrderNote} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderNote
     *         PurchaseOrderNote} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderNoteUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PurchaseOrderNoteUpdateFluentHelper updatePurchaseOrderNote( @Nonnull final PurchaseOrderNote purchaseOrderNote );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderNote
     * PurchaseOrderNote} entity in the S/4HANA system.
     *
     * @param purchaseOrderNote
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderNote
     *            PurchaseOrderNote} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderNote
     *         PurchaseOrderNote} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderNoteDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PurchaseOrderNoteDeleteFluentHelper deletePurchaseOrderNote( @Nonnull final PurchaseOrderNote purchaseOrderNote );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderScheduleLine
     * PurchaseOrderScheduleLine} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderScheduleLine
     *         PurchaseOrderScheduleLine} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderScheduleLineFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PurchaseOrderScheduleLineFluentHelper getAllPurchaseOrderScheduleLine();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderScheduleLine
     * PurchaseOrderScheduleLine} entity using key fields.
     *
     * @param purchasingDocument
     *            Purchasing Document Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param scheduleLine
     *            Delivery Schedule Line Counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param purchasingDocumentItem
     *            Item Number of Purchasing Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 5
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderScheduleLine
     *         PurchaseOrderScheduleLine} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderScheduleLineByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PurchaseOrderScheduleLineByKeyFluentHelper getPurchaseOrderScheduleLineByKey(
        final String purchasingDocument,
        final String purchasingDocumentItem,
        final String scheduleLine );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderScheduleLine
     * PurchaseOrderScheduleLine} entity and save it to the S/4HANA system.
     *
     * @param purchaseOrderScheduleLine
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderScheduleLine
     *            PurchaseOrderScheduleLine} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderScheduleLine
     *         PurchaseOrderScheduleLine} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderScheduleLineCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PurchaseOrderScheduleLineCreateFluentHelper
        createPurchaseOrderScheduleLine( @Nonnull final PurchaseOrderScheduleLine purchaseOrderScheduleLine );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderScheduleLine
     * PurchaseOrderScheduleLine} entity and save it to the S/4HANA system.
     *
     * @param purchaseOrderScheduleLine
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderScheduleLine
     *            PurchaseOrderScheduleLine} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderScheduleLine
     *         PurchaseOrderScheduleLine} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderScheduleLineUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PurchaseOrderScheduleLineUpdateFluentHelper
        updatePurchaseOrderScheduleLine( @Nonnull final PurchaseOrderScheduleLine purchaseOrderScheduleLine );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderScheduleLine
     * PurchaseOrderScheduleLine} entity in the S/4HANA system.
     *
     * @param purchaseOrderScheduleLine
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderScheduleLine
     *            PurchaseOrderScheduleLine} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderScheduleLine
     *         PurchaseOrderScheduleLine} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderScheduleLineDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PurchaseOrderScheduleLineDeleteFluentHelper
        deletePurchaseOrderScheduleLine( @Nonnull final PurchaseOrderScheduleLine purchaseOrderScheduleLine );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurOrdAccountAssignment
     * PurOrdAccountAssignment} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurOrdAccountAssignment
     *         PurOrdAccountAssignment} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurOrdAccountAssignmentFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PurOrdAccountAssignmentFluentHelper getAllPurOrdAccountAssignment();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurOrdAccountAssignment
     * PurOrdAccountAssignment} entity using key fields.
     *
     * @param purchaseOrder
     *            Purchasing Document Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param accountAssignmentNumber
     *            Sequential Number of Account Assignment
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param purchaseOrderItem
     *            Item Number of Purchasing Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 5
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurOrdAccountAssignment
     *         PurOrdAccountAssignment} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurOrdAccountAssignmentByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PurOrdAccountAssignmentByKeyFluentHelper getPurOrdAccountAssignmentByKey(
        final String purchaseOrder,
        final String purchaseOrderItem,
        final String accountAssignmentNumber );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurOrdAccountAssignment
     * PurOrdAccountAssignment} entity and save it to the S/4HANA system.
     *
     * @param purOrdAccountAssignment
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurOrdAccountAssignment
     *            PurOrdAccountAssignment} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurOrdAccountAssignment
     *         PurOrdAccountAssignment} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurOrdAccountAssignmentCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PurOrdAccountAssignmentCreateFluentHelper
        createPurOrdAccountAssignment( @Nonnull final PurOrdAccountAssignment purOrdAccountAssignment );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurOrdAccountAssignment
     * PurOrdAccountAssignment} entity and save it to the S/4HANA system.
     *
     * @param purOrdAccountAssignment
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurOrdAccountAssignment
     *            PurOrdAccountAssignment} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurOrdAccountAssignment
     *         PurOrdAccountAssignment} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurOrdAccountAssignmentUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PurOrdAccountAssignmentUpdateFluentHelper
        updatePurOrdAccountAssignment( @Nonnull final PurOrdAccountAssignment purOrdAccountAssignment );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurOrdAccountAssignment
     * PurOrdAccountAssignment} entity in the S/4HANA system.
     *
     * @param purOrdAccountAssignment
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurOrdAccountAssignment
     *            PurOrdAccountAssignment} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurOrdAccountAssignment
     *         PurOrdAccountAssignment} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurOrdAccountAssignmentDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PurOrdAccountAssignmentDeleteFluentHelper
        deletePurOrdAccountAssignment( @Nonnull final PurOrdAccountAssignment purOrdAccountAssignment );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurOrdPricingElement
     * PurOrdPricingElement} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurOrdPricingElement
     *         PurOrdPricingElement} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurOrdPricingElementFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PurOrdPricingElementFluentHelper getAllPurOrdPricingElement();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurOrdPricingElement
     * PurOrdPricingElement} entity using key fields.
     *
     * @param pricingDocumentItem
     *            Condition item number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param pricingProcedureCounter
     *            Condition Counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @param purchaseOrder
     *            Purchasing Document Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param purchaseOrderItem
     *            Item Number of Purchasing Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 5
     *            </p>
     * @param pricingProcedureStep
     *            Step Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @param pricingDocument
     *            Number of the Document Condition
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurOrdPricingElement
     *         PurOrdPricingElement} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurOrdPricingElementByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PurOrdPricingElementByKeyFluentHelper getPurOrdPricingElementByKey(
        final String purchaseOrder,
        final String purchaseOrderItem,
        final String pricingDocument,
        final String pricingDocumentItem,
        final String pricingProcedureStep,
        final String pricingProcedureCounter );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurOrdPricingElement
     * PurOrdPricingElement} entity and save it to the S/4HANA system.
     *
     * @param purOrdPricingElement
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurOrdPricingElement
     *            PurOrdPricingElement} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurOrdPricingElement
     *         PurOrdPricingElement} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurOrdPricingElementCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PurOrdPricingElementCreateFluentHelper
        createPurOrdPricingElement( @Nonnull final PurOrdPricingElement purOrdPricingElement );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurOrdPricingElement
     * PurOrdPricingElement} entity and save it to the S/4HANA system.
     *
     * @param purOrdPricingElement
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurOrdPricingElement
     *            PurOrdPricingElement} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurOrdPricingElement
     *         PurOrdPricingElement} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurOrdPricingElementUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PurOrdPricingElementUpdateFluentHelper
        updatePurOrdPricingElement( @Nonnull final PurOrdPricingElement purOrdPricingElement );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurOrdPricingElement
     * PurOrdPricingElement} entity in the S/4HANA system.
     *
     * @param purOrdPricingElement
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurOrdPricingElement
     *            PurOrdPricingElement} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurOrdPricingElement
     *         PurOrdPricingElement} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurOrdPricingElementDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PurOrdPricingElementDeleteFluentHelper
        deletePurOrdPricingElement( @Nonnull final PurOrdPricingElement purOrdPricingElement );

    /**
     * <p>
     * Creates a fluent helper for the <b>GetOutputBinaryData</b> OData function import.
     * </p>
     *
     * @param purchaseOrder
     *            Purchase Order
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 10
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>PurchaseOrder</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>GetOutputBinaryData</b> OData function import with the
     *         provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.GetOutputBinaryDataFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    GetOutputBinaryDataFluentHelper getOutputBinaryData( @Nullable final String purchaseOrder );

    /**
     * <p>
     * Creates a fluent helper for the <b>GetPDF</b> OData function import.
     * </p>
     *
     * @param purchaseOrder
     *            Constraints: Not nullable, Maximum length: 11000
     *            <p>
     *            Original parameter name from the Odata EDM: <b>PurchaseOrder</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>GetPDF</b> OData function import with the provided
     *         parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.GetPDFFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    GetPDFFluentHelper getPDF( @Nonnull final String purchaseOrder );

}
