/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.DiscardFromPurchasingFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.EnableForPurchasingFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqAddDelivery;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqAddDeliveryByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqAddDeliveryFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqAddDeliveryUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqnAcctAssgmt;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqnAcctAssgmtByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqnAcctAssgmtCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqnAcctAssgmtFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqnAcctAssgmtUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurchaseReqnItemText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurchaseReqnItemTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurchaseReqnItemTextCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurchaseReqnItemTextDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurchaseReqnItemTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurchaseReqnItemTextUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurchaseRequisitionHeader;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurchaseRequisitionHeaderByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurchaseRequisitionHeaderCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurchaseRequisitionHeaderFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurchaseRequisitionHeaderUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurchaseRequisitionItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurchaseRequisitionItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurchaseRequisitionItemCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurchaseRequisitionItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurchaseRequisitionItemUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.ValidateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.batch.PurchaseRequisitionServiceBatch;

/**
 * <p>
 * This service helps you to create, read, update and delete purchase requisitions through an API call from a source
 * system outside SAP S/4HANA Cloud. The service contains header, item, account assignment, delivery address, and item
 * text nodes. The information is sent in the request as a payload. The information is used when creating, reading or
 * updating a purchase requisition, with appropriate checks for restricted values and authorizations.
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/43/c43f584eff2160e10000000a44147b/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_PURCHASEREQ_PROCESS_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_PURCHASEREQ_PROCESS_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.1</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Purchase Requisition Integration(SAP_COM_0102), SAP S/4HANA Procurement Hub - Ariba GB - Hub to Ariba GB
 * Integration(SAP_COM_0292), Next-Generation Buying Experience Integration(SAP_COM_0545)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/2NV'>Guided Buying Capability with SAP Ariba Buying(2NV)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BNX'>Consumable Purchasing(BNX)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/J13'>Service and Material Procurement - Project-Based
 * Services(J13)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/J45'>Procurement of Direct Materials(J45)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/O45'>Procurement of Direct Materials(O45)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/O8J'>Requisitioning(O8J)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OML'>Physical Inventory - Inventory Count and Adjustment(OML)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/ONV'>Guided Buying Capability with SAP Ariba Buying(ONV)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/ONX'>Consumable Purchasing(ONX)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/18J'>Requisitioning(18J)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/4AI'>Next-Generation Buying Experience(4AI)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/3EN'>Guided Buying for Central Procurement with SAP Ariba
 * Buying(3EN)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Purchase Requisition</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Deprecated
public interface PurchaseRequisitionService extends BatchService<PurchaseRequisitionServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_PURCHASEREQ_PROCESS_SRV";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    PurchaseRequisitionService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurchaseReqnItemText
     * PurchaseReqnItemText} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurchaseReqnItemText
     *         PurchaseReqnItemText} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurchaseReqnItemTextFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PurchaseReqnItemTextFluentHelper getAllPurchaseReqnItemText();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurchaseReqnItemText
     * PurchaseReqnItemText} entity using key fields.
     *
     * @param technicalObjectType
     *            Texts: application object
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param purchaseRequisitionItem
     *            Item number of purchase requisition
     *            <p>
     *            Constraints: Not nullable, Maximum length: 5
     *            </p>
     * @param documentText
     *            Text ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param purchaseRequisition
     *            Purchase Requisition Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurchaseReqnItemText
     *         PurchaseReqnItemText} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurchaseReqnItemTextByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PurchaseReqnItemTextByKeyFluentHelper getPurchaseReqnItemTextByKey(
        final String purchaseRequisition,
        final String purchaseRequisitionItem,
        final String documentText,
        final String technicalObjectType,
        final String language );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurchaseReqnItemText
     * PurchaseReqnItemText} entity and save it to the S/4HANA system.
     *
     * @param purchaseReqnItemText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurchaseReqnItemText
     *            PurchaseReqnItemText} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurchaseReqnItemText
     *         PurchaseReqnItemText} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurchaseReqnItemTextCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PurchaseReqnItemTextCreateFluentHelper
        createPurchaseReqnItemText( @Nonnull final PurchaseReqnItemText purchaseReqnItemText );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurchaseReqnItemText
     * PurchaseReqnItemText} entity and save it to the S/4HANA system.
     *
     * @param purchaseReqnItemText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurchaseReqnItemText
     *            PurchaseReqnItemText} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurchaseReqnItemText
     *         PurchaseReqnItemText} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurchaseReqnItemTextUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PurchaseReqnItemTextUpdateFluentHelper
        updatePurchaseReqnItemText( @Nonnull final PurchaseReqnItemText purchaseReqnItemText );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurchaseReqnItemText
     * PurchaseReqnItemText} entity in the S/4HANA system.
     *
     * @param purchaseReqnItemText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurchaseReqnItemText
     *            PurchaseReqnItemText} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurchaseReqnItemText
     *         PurchaseReqnItemText} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurchaseReqnItemTextDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PurchaseReqnItemTextDeleteFluentHelper
        deletePurchaseReqnItemText( @Nonnull final PurchaseReqnItemText purchaseReqnItemText );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurchaseRequisitionHeader
     * PurchaseRequisitionHeader} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurchaseRequisitionHeader
     *         PurchaseRequisitionHeader} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurchaseRequisitionHeaderFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PurchaseRequisitionHeaderFluentHelper getAllPurchaseRequisitionHeader();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurchaseRequisitionHeader
     * PurchaseRequisitionHeader} entity using key fields.
     *
     * @param purchaseRequisition
     *            Purchase Requisition Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurchaseRequisitionHeader
     *         PurchaseRequisitionHeader} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurchaseRequisitionHeaderByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PurchaseRequisitionHeaderByKeyFluentHelper getPurchaseRequisitionHeaderByKey( final String purchaseRequisition );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurchaseRequisitionHeader
     * PurchaseRequisitionHeader} entity and save it to the S/4HANA system.
     *
     * @param purchaseRequisitionHeader
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurchaseRequisitionHeader
     *            PurchaseRequisitionHeader} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurchaseRequisitionHeader
     *         PurchaseRequisitionHeader} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurchaseRequisitionHeaderCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PurchaseRequisitionHeaderCreateFluentHelper
        createPurchaseRequisitionHeader( @Nonnull final PurchaseRequisitionHeader purchaseRequisitionHeader );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurchaseRequisitionHeader
     * PurchaseRequisitionHeader} entity and save it to the S/4HANA system.
     *
     * @param purchaseRequisitionHeader
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurchaseRequisitionHeader
     *            PurchaseRequisitionHeader} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurchaseRequisitionHeader
     *         PurchaseRequisitionHeader} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurchaseRequisitionHeaderUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PurchaseRequisitionHeaderUpdateFluentHelper
        updatePurchaseRequisitionHeader( @Nonnull final PurchaseRequisitionHeader purchaseRequisitionHeader );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurchaseRequisitionItem
     * PurchaseRequisitionItem} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurchaseRequisitionItem
     *         PurchaseRequisitionItem} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurchaseRequisitionItemFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PurchaseRequisitionItemFluentHelper getAllPurchaseRequisitionItem();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurchaseRequisitionItem
     * PurchaseRequisitionItem} entity using key fields.
     *
     * @param purchaseRequisitionItem
     *            Item number of purchase requisition
     *            <p>
     *            Constraints: Not nullable, Maximum length: 5
     *            </p>
     * @param purchaseRequisition
     *            Purchase Requisition Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurchaseRequisitionItem
     *         PurchaseRequisitionItem} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurchaseRequisitionItemByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PurchaseRequisitionItemByKeyFluentHelper
        getPurchaseRequisitionItemByKey( final String purchaseRequisition, final String purchaseRequisitionItem );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurchaseRequisitionItem
     * PurchaseRequisitionItem} entity and save it to the S/4HANA system.
     *
     * @param purchaseRequisitionItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurchaseRequisitionItem
     *            PurchaseRequisitionItem} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurchaseRequisitionItem
     *         PurchaseRequisitionItem} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurchaseRequisitionItemCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PurchaseRequisitionItemCreateFluentHelper
        createPurchaseRequisitionItem( @Nonnull final PurchaseRequisitionItem purchaseRequisitionItem );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurchaseRequisitionItem
     * PurchaseRequisitionItem} entity and save it to the S/4HANA system.
     *
     * @param purchaseRequisitionItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurchaseRequisitionItem
     *            PurchaseRequisitionItem} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurchaseRequisitionItem
     *         PurchaseRequisitionItem} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurchaseRequisitionItemUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PurchaseRequisitionItemUpdateFluentHelper
        updatePurchaseRequisitionItem( @Nonnull final PurchaseRequisitionItem purchaseRequisitionItem );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqAddDelivery
     * PurReqAddDelivery} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqAddDelivery
     *         PurReqAddDelivery} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqAddDeliveryFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PurReqAddDeliveryFluentHelper getAllPurReqAddDelivery();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqAddDelivery
     * PurReqAddDelivery} entity using key fields.
     *
     * @param purchaseRequisitionItem
     *            Item number of purchase requisition
     *            <p>
     *            Constraints: Not nullable, Maximum length: 5
     *            </p>
     * @param purchaseRequisition
     *            Purchase Requisition Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqAddDelivery
     *         PurReqAddDelivery} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqAddDeliveryByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PurReqAddDeliveryByKeyFluentHelper
        getPurReqAddDeliveryByKey( final String purchaseRequisition, final String purchaseRequisitionItem );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqAddDelivery
     * PurReqAddDelivery} entity and save it to the S/4HANA system.
     *
     * @param purReqAddDelivery
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqAddDelivery
     *            PurReqAddDelivery} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqAddDelivery
     *         PurReqAddDelivery} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqAddDeliveryUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PurReqAddDeliveryUpdateFluentHelper updatePurReqAddDelivery( @Nonnull final PurReqAddDelivery purReqAddDelivery );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqnAcctAssgmt
     * PurReqnAcctAssgmt} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqnAcctAssgmt
     *         PurReqnAcctAssgmt} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqnAcctAssgmtFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PurReqnAcctAssgmtFluentHelper getAllPurReqnAcctAssgmt();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqnAcctAssgmt
     * PurReqnAcctAssgmt} entity using key fields.
     *
     * @param purchaseRequisitionItem
     *            Item number of purchase requisition
     *            <p>
     *            Constraints: Not nullable, Maximum length: 5
     *            </p>
     * @param purchaseRequisition
     *            Purchase Requisition Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param purchaseReqnAcctAssgmtNumber
     *            Serial number for PReq account assignment segment
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqnAcctAssgmt
     *         PurReqnAcctAssgmt} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqnAcctAssgmtByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PurReqnAcctAssgmtByKeyFluentHelper getPurReqnAcctAssgmtByKey(
        final String purchaseRequisition,
        final String purchaseRequisitionItem,
        final String purchaseReqnAcctAssgmtNumber );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqnAcctAssgmt
     * PurReqnAcctAssgmt} entity and save it to the S/4HANA system.
     *
     * @param purReqnAcctAssgmt
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqnAcctAssgmt
     *            PurReqnAcctAssgmt} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqnAcctAssgmt
     *         PurReqnAcctAssgmt} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqnAcctAssgmtCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PurReqnAcctAssgmtCreateFluentHelper createPurReqnAcctAssgmt( @Nonnull final PurReqnAcctAssgmt purReqnAcctAssgmt );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqnAcctAssgmt
     * PurReqnAcctAssgmt} entity and save it to the S/4HANA system.
     *
     * @param purReqnAcctAssgmt
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqnAcctAssgmt
     *            PurReqnAcctAssgmt} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqnAcctAssgmt
     *         PurReqnAcctAssgmt} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqnAcctAssgmtUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PurReqnAcctAssgmtUpdateFluentHelper updatePurReqnAcctAssgmt( @Nonnull final PurReqnAcctAssgmt purReqnAcctAssgmt );

    /**
     * <p>
     * Creates a fluent helper for the <b>Validate</b> OData function import.
     * </p>
     *
     * @param purchaseRequisition
     *            Constraints: none
     *            <p>
     *            Original parameter name from the Odata EDM: <b>PurchaseRequisition</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>Validate</b> OData function import with the provided
     *         parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.ValidateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ValidateFluentHelper validate( @Nonnull final String purchaseRequisition );

    /**
     * <p>
     * Creates a fluent helper for the <b>DiscardFromPurchasing</b> OData function import.
     * </p>
     *
     * @param purchaseRequisitionItem
     *            Constraints: none
     *            <p>
     *            Original parameter name from the Odata EDM: <b>PurchaseRequisitionItem</b>
     *            </p>
     * @param purchaseRequisition
     *            Constraints: none
     *            <p>
     *            Original parameter name from the Odata EDM: <b>PurchaseRequisition</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>DiscardFromPurchasing</b> OData function import with the
     *         provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.DiscardFromPurchasingFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    DiscardFromPurchasingFluentHelper discardFromPurchasing(
        @Nonnull final String purchaseRequisitionItem,
        @Nonnull final String purchaseRequisition );

    /**
     * <p>
     * Creates a fluent helper for the <b>EnableForPurchasing</b> OData function import.
     * </p>
     *
     * @param purchaseRequisitionItem
     *            Constraints: none
     *            <p>
     *            Original parameter name from the Odata EDM: <b>PurchaseRequisitionItem</b>
     *            </p>
     * @param purchaseRequisition
     *            Constraints: none
     *            <p>
     *            Original parameter name from the Odata EDM: <b>PurchaseRequisition</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>EnableForPurchasing</b> OData function import with the
     *         provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.EnableForPurchasingFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EnableForPurchasingFluentHelper
        enableForPurchasing( @Nonnull final String purchaseRequisitionItem, @Nonnull final String purchaseRequisition );

}
