/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.time.LocalDateTime;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdPrcgCndn;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdPrcgCndnByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdPrcgCndnCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdPrcgCndnFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdPrcgCndnScale;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdPrcgCndnScaleByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdPrcgCndnScaleCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdPrcgCndnScaleDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdPrcgCndnScaleFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdPrcgCndnScaleUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdPrcgCndnUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdPrcgCndnValidity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdPrcgCndnValidityByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdPrcgCndnValidityCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdPrcgCndnValidityFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdPrcgCndnValidityUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdSuplmntPrcgCndn;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdSuplmntPrcgCndnByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdSuplmntPrcgCndnCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdSuplmntPrcgCndnDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdSuplmntPrcgCndnFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdSuplmntPrcgCndnUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurchasingInfoRecord;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurchasingInfoRecordByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurchasingInfoRecordCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurchasingInfoRecordFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurchasingInfoRecordUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurgInfoRecdOrgPlantData;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurgInfoRecdOrgPlantDataByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurgInfoRecdOrgPlantDataCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurgInfoRecdOrgPlantDataFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurgInfoRecdOrgPlantDataUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.batch.PurchasingInfoRecordServiceBatch;

/**
 * <p>
 *
 * This synchronous inbound service enables you to create, update, and delete purchasing info records with conditions.
 * The service contains general data, purchase organization data and conditions. It is based on the OData protocol. The
 * information is sent in the request as a payload.All information is used when creating a purchasing info record,
 * including conditions are checked for authorizations. Once the purchasinginfo record has been created, the purchasing
 * info record number is sent in the response. If there are any issues when the purchasing info recordis created, the
 * system displays error messages in the response. .
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/d0/9550c21c0249f39c4b79754077b8d4/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_INFORECORD_PROCESS_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_INFORECORD_PROCESS_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Purchasing Info Record Integration(SAP_COM_0145)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/BML'>Physical Inventory - Inventory Count and Adjustment(BML)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BNX'>Consumable Purchasing(BNX)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/J13'>Service and Material Procurement - Project-Based
 * Services(J13)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/J45'>Procurement of Direct Materials(J45)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/O45'>Procurement of Direct Materials(O45)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/ONX'>Consumable Purchasing(ONX)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Purchasing Info Record</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Deprecated
public interface PurchasingInfoRecordService extends BatchService<PurchasingInfoRecordServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_INFORECORD_PROCESS_SRV";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    PurchasingInfoRecordService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurchasingInfoRecord
     * PurchasingInfoRecord} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurchasingInfoRecord
     *         PurchasingInfoRecord} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurchasingInfoRecordFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PurchasingInfoRecordFluentHelper getAllPurchasingInfoRecord();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurchasingInfoRecord
     * PurchasingInfoRecord} entity using key fields.
     *
     * @param purchasingInfoRecord
     *            Number of purchasing info record
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurchasingInfoRecord
     *         PurchasingInfoRecord} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurchasingInfoRecordByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PurchasingInfoRecordByKeyFluentHelper getPurchasingInfoRecordByKey( final String purchasingInfoRecord );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurchasingInfoRecord
     * PurchasingInfoRecord} entity and save it to the S/4HANA system.
     *
     * @param purchasingInfoRecord
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurchasingInfoRecord
     *            PurchasingInfoRecord} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurchasingInfoRecord
     *         PurchasingInfoRecord} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurchasingInfoRecordCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PurchasingInfoRecordCreateFluentHelper
        createPurchasingInfoRecord( @Nonnull final PurchasingInfoRecord purchasingInfoRecord );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurchasingInfoRecord
     * PurchasingInfoRecord} entity and save it to the S/4HANA system.
     *
     * @param purchasingInfoRecord
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurchasingInfoRecord
     *            PurchasingInfoRecord} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurchasingInfoRecord
     *         PurchasingInfoRecord} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurchasingInfoRecordUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PurchasingInfoRecordUpdateFluentHelper
        updatePurchasingInfoRecord( @Nonnull final PurchasingInfoRecord purchasingInfoRecord );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurgInfoRecdOrgPlantData
     * PurgInfoRecdOrgPlantData} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurgInfoRecdOrgPlantData
     *         PurgInfoRecdOrgPlantData} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurgInfoRecdOrgPlantDataFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PurgInfoRecdOrgPlantDataFluentHelper getAllPurgInfoRecdOrgPlantData();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurgInfoRecdOrgPlantData
     * PurgInfoRecdOrgPlantData} entity using key fields.
     *
     * @param plant
     *            Plant
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param purchasingOrganization
     *            Purchasing Organization
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param purchasingInfoRecord
     *            Number of purchasing info record
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param purchasingInfoRecordCategory
     *            Purchasing info record category
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurgInfoRecdOrgPlantData
     *         PurgInfoRecdOrgPlantData} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurgInfoRecdOrgPlantDataByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PurgInfoRecdOrgPlantDataByKeyFluentHelper getPurgInfoRecdOrgPlantDataByKey(
        final String purchasingInfoRecord,
        final String purchasingInfoRecordCategory,
        final String purchasingOrganization,
        final String plant );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurgInfoRecdOrgPlantData
     * PurgInfoRecdOrgPlantData} entity and save it to the S/4HANA system.
     *
     * @param purgInfoRecdOrgPlantData
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurgInfoRecdOrgPlantData
     *            PurgInfoRecdOrgPlantData} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurgInfoRecdOrgPlantData
     *         PurgInfoRecdOrgPlantData} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurgInfoRecdOrgPlantDataCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PurgInfoRecdOrgPlantDataCreateFluentHelper
        createPurgInfoRecdOrgPlantData( @Nonnull final PurgInfoRecdOrgPlantData purgInfoRecdOrgPlantData );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurgInfoRecdOrgPlantData
     * PurgInfoRecdOrgPlantData} entity and save it to the S/4HANA system.
     *
     * @param purgInfoRecdOrgPlantData
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurgInfoRecdOrgPlantData
     *            PurgInfoRecdOrgPlantData} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurgInfoRecdOrgPlantData
     *         PurgInfoRecdOrgPlantData} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurgInfoRecdOrgPlantDataUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PurgInfoRecdOrgPlantDataUpdateFluentHelper
        updatePurgInfoRecdOrgPlantData( @Nonnull final PurgInfoRecdOrgPlantData purgInfoRecdOrgPlantData );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdPrcgCndn
     * PurInfoRecdPrcgCndn} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdPrcgCndn
     *         PurInfoRecdPrcgCndn} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdPrcgCndnFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PurInfoRecdPrcgCndnFluentHelper getAllPurInfoRecdPrcgCndn();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdPrcgCndn
     * PurInfoRecdPrcgCndn} entity using key fields.
     *
     * @param conditionRecord
     *            Number of Condition Record
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdPrcgCndn
     *         PurInfoRecdPrcgCndn} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdPrcgCndnByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PurInfoRecdPrcgCndnByKeyFluentHelper getPurInfoRecdPrcgCndnByKey( final String conditionRecord );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdPrcgCndn
     * PurInfoRecdPrcgCndn} entity and save it to the S/4HANA system.
     *
     * @param purInfoRecdPrcgCndn
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdPrcgCndn
     *            PurInfoRecdPrcgCndn} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdPrcgCndn
     *         PurInfoRecdPrcgCndn} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdPrcgCndnCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PurInfoRecdPrcgCndnCreateFluentHelper
        createPurInfoRecdPrcgCndn( @Nonnull final PurInfoRecdPrcgCndn purInfoRecdPrcgCndn );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdPrcgCndn
     * PurInfoRecdPrcgCndn} entity and save it to the S/4HANA system.
     *
     * @param purInfoRecdPrcgCndn
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdPrcgCndn
     *            PurInfoRecdPrcgCndn} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdPrcgCndn
     *         PurInfoRecdPrcgCndn} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdPrcgCndnUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PurInfoRecdPrcgCndnUpdateFluentHelper
        updatePurInfoRecdPrcgCndn( @Nonnull final PurInfoRecdPrcgCndn purInfoRecdPrcgCndn );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdPrcgCndnScale
     * PurInfoRecdPrcgCndnScale} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdPrcgCndnScale
     *         PurInfoRecdPrcgCndnScale} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdPrcgCndnScaleFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PurInfoRecdPrcgCndnScaleFluentHelper getAllPurInfoRecdPrcgCndnScale();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdPrcgCndnScale
     * PurInfoRecdPrcgCndnScale} entity using key fields.
     *
     * @param conditionSequentialNumber
     *            Sequential number of the condition
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param conditionRecord
     *            Number of Condition Record
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param conditionScaleLine
     *            Current number of the line scale
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdPrcgCndnScale
     *         PurInfoRecdPrcgCndnScale} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdPrcgCndnScaleByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PurInfoRecdPrcgCndnScaleByKeyFluentHelper getPurInfoRecdPrcgCndnScaleByKey(
        final String conditionRecord,
        final String conditionSequentialNumber,
        final String conditionScaleLine );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdPrcgCndnScale
     * PurInfoRecdPrcgCndnScale} entity and save it to the S/4HANA system.
     *
     * @param purInfoRecdPrcgCndnScale
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdPrcgCndnScale
     *            PurInfoRecdPrcgCndnScale} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdPrcgCndnScale
     *         PurInfoRecdPrcgCndnScale} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdPrcgCndnScaleCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PurInfoRecdPrcgCndnScaleCreateFluentHelper
        createPurInfoRecdPrcgCndnScale( @Nonnull final PurInfoRecdPrcgCndnScale purInfoRecdPrcgCndnScale );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdPrcgCndnScale
     * PurInfoRecdPrcgCndnScale} entity and save it to the S/4HANA system.
     *
     * @param purInfoRecdPrcgCndnScale
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdPrcgCndnScale
     *            PurInfoRecdPrcgCndnScale} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdPrcgCndnScale
     *         PurInfoRecdPrcgCndnScale} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdPrcgCndnScaleUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PurInfoRecdPrcgCndnScaleUpdateFluentHelper
        updatePurInfoRecdPrcgCndnScale( @Nonnull final PurInfoRecdPrcgCndnScale purInfoRecdPrcgCndnScale );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdPrcgCndnScale
     * PurInfoRecdPrcgCndnScale} entity in the S/4HANA system.
     *
     * @param purInfoRecdPrcgCndnScale
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdPrcgCndnScale
     *            PurInfoRecdPrcgCndnScale} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdPrcgCndnScale
     *         PurInfoRecdPrcgCndnScale} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdPrcgCndnScaleDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PurInfoRecdPrcgCndnScaleDeleteFluentHelper
        deletePurInfoRecdPrcgCndnScale( @Nonnull final PurInfoRecdPrcgCndnScale purInfoRecdPrcgCndnScale );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdPrcgCndnValidity
     * PurInfoRecdPrcgCndnValidity} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdPrcgCndnValidity
     *         PurInfoRecdPrcgCndnValidity} entities. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdPrcgCndnValidityFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PurInfoRecdPrcgCndnValidityFluentHelper getAllPurInfoRecdPrcgCndnValidity();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdPrcgCndnValidity
     * PurInfoRecdPrcgCndnValidity} entity using key fields.
     *
     * @param conditionValidityEndDate
     *            Validity end date of the condition record
     *            <p>
     *            Constraints: Not nullable, Precision: 0
     *            </p>
     * @param conditionRecord
     *            Number of Condition Record
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdPrcgCndnValidity
     *         PurInfoRecdPrcgCndnValidity} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdPrcgCndnValidityByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PurInfoRecdPrcgCndnValidityByKeyFluentHelper getPurInfoRecdPrcgCndnValidityByKey(
        final String conditionRecord,
        final LocalDateTime conditionValidityEndDate );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdPrcgCndnValidity
     * PurInfoRecdPrcgCndnValidity} entity and save it to the S/4HANA system.
     *
     * @param purInfoRecdPrcgCndnValidity
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdPrcgCndnValidity
     *            PurInfoRecdPrcgCndnValidity} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdPrcgCndnValidity
     *         PurInfoRecdPrcgCndnValidity} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdPrcgCndnValidityCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PurInfoRecdPrcgCndnValidityCreateFluentHelper
        createPurInfoRecdPrcgCndnValidity( @Nonnull final PurInfoRecdPrcgCndnValidity purInfoRecdPrcgCndnValidity );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdPrcgCndnValidity
     * PurInfoRecdPrcgCndnValidity} entity and save it to the S/4HANA system.
     *
     * @param purInfoRecdPrcgCndnValidity
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdPrcgCndnValidity
     *            PurInfoRecdPrcgCndnValidity} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdPrcgCndnValidity
     *         PurInfoRecdPrcgCndnValidity} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdPrcgCndnValidityUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PurInfoRecdPrcgCndnValidityUpdateFluentHelper
        updatePurInfoRecdPrcgCndnValidity( @Nonnull final PurInfoRecdPrcgCndnValidity purInfoRecdPrcgCndnValidity );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdSuplmntPrcgCndn
     * PurInfoRecdSuplmntPrcgCndn} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdSuplmntPrcgCndn
     *         PurInfoRecdSuplmntPrcgCndn} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdSuplmntPrcgCndnFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PurInfoRecdSuplmntPrcgCndnFluentHelper getAllPurInfoRecdSuplmntPrcgCndn();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdSuplmntPrcgCndn
     * PurInfoRecdSuplmntPrcgCndn} entity using key fields.
     *
     * @param conditionSequentialNumber
     *            Sequential number of the condition
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param conditionRecord
     *            Number of Condition Record
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdSuplmntPrcgCndn
     *         PurInfoRecdSuplmntPrcgCndn} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdSuplmntPrcgCndnByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PurInfoRecdSuplmntPrcgCndnByKeyFluentHelper
        getPurInfoRecdSuplmntPrcgCndnByKey( final String conditionRecord, final String conditionSequentialNumber );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdSuplmntPrcgCndn
     * PurInfoRecdSuplmntPrcgCndn} entity and save it to the S/4HANA system.
     *
     * @param purInfoRecdSuplmntPrcgCndn
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdSuplmntPrcgCndn
     *            PurInfoRecdSuplmntPrcgCndn} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdSuplmntPrcgCndn
     *         PurInfoRecdSuplmntPrcgCndn} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdSuplmntPrcgCndnCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PurInfoRecdSuplmntPrcgCndnCreateFluentHelper
        createPurInfoRecdSuplmntPrcgCndn( @Nonnull final PurInfoRecdSuplmntPrcgCndn purInfoRecdSuplmntPrcgCndn );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdSuplmntPrcgCndn
     * PurInfoRecdSuplmntPrcgCndn} entity and save it to the S/4HANA system.
     *
     * @param purInfoRecdSuplmntPrcgCndn
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdSuplmntPrcgCndn
     *            PurInfoRecdSuplmntPrcgCndn} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdSuplmntPrcgCndn
     *         PurInfoRecdSuplmntPrcgCndn} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdSuplmntPrcgCndnUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PurInfoRecdSuplmntPrcgCndnUpdateFluentHelper
        updatePurInfoRecdSuplmntPrcgCndn( @Nonnull final PurInfoRecdSuplmntPrcgCndn purInfoRecdSuplmntPrcgCndn );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdSuplmntPrcgCndn
     * PurInfoRecdSuplmntPrcgCndn} entity in the S/4HANA system.
     *
     * @param purInfoRecdSuplmntPrcgCndn
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdSuplmntPrcgCndn
     *            PurInfoRecdSuplmntPrcgCndn} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdSuplmntPrcgCndn
     *         PurInfoRecdSuplmntPrcgCndn} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdSuplmntPrcgCndnDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PurInfoRecdSuplmntPrcgCndnDeleteFluentHelper
        deletePurInfoRecdSuplmntPrcgCndn( @Nonnull final PurInfoRecdSuplmntPrcgCndn purInfoRecdSuplmntPrcgCndn );

}
