/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingquotaarrangement.PurchasingQuotaArrangement;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingquotaarrangement.PurchasingQuotaArrangementByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingquotaarrangement.PurchasingQuotaArrangementCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingquotaarrangement.PurchasingQuotaArrangementDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingquotaarrangement.PurchasingQuotaArrangementFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingquotaarrangement.PurchasingQuotaArrangementUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingquotaarrangement.PurgQuotaArrangementItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingquotaarrangement.PurgQuotaArrangementItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingquotaarrangement.PurgQuotaArrangementItemCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingquotaarrangement.PurgQuotaArrangementItemDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingquotaarrangement.PurgQuotaArrangementItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingquotaarrangement.PurgQuotaArrangementItemUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingquotaarrangement.batch.PurchasingQuotaArrangementServiceBatch;

/**
 * <p>
 * This service helps you to create, read, update, and delete quota arrangements through an API call from a source
 * system outside SAP S/4HANA Cloud or SAP S/4HANA. The service contains quota arrangement header and item. The
 * information is sent in the request as a payload. The information is used when creating, reading or updating a quota
 * arrangement, with appropriate checks for restricted values and authorizations.
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/4a/a0343345884bd2bf7195f1072d9679/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_PUR_QUOTA_ARRANGEMENT_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_PUR_QUOTA_ARRANGEMENT_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Purchasing Quota Arrangement Integration(SAP_COM_0166)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/BMR'>Scheduling Agreements in Procurement(BMR)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OML'>Physical Inventory - Inventory Count and Adjustment(OML)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OMR'>Scheduling Agreements in Procurement(OMR)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Purchasing Quota Arrangement</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Deprecated
public interface PurchasingQuotaArrangementService extends BatchService<PurchasingQuotaArrangementServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_PUR_QUOTA_ARRANGEMENT_SRV";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    PurchasingQuotaArrangementService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingquotaarrangement.PurchasingQuotaArrangement
     * PurchasingQuotaArrangement} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingquotaarrangement.PurchasingQuotaArrangement
     *         PurchasingQuotaArrangement} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingquotaarrangement.PurchasingQuotaArrangementFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PurchasingQuotaArrangementFluentHelper getAllPurchasingQuotaArrangement();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingquotaarrangement.PurchasingQuotaArrangement
     * PurchasingQuotaArrangement} entity using key fields.
     *
     * @param quotaArrangement
     *            Number of quota arrangement
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingquotaarrangement.PurchasingQuotaArrangement
     *         PurchasingQuotaArrangement} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingquotaarrangement.PurchasingQuotaArrangementByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PurchasingQuotaArrangementByKeyFluentHelper getPurchasingQuotaArrangementByKey( final String quotaArrangement );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingquotaarrangement.PurchasingQuotaArrangement
     * PurchasingQuotaArrangement} entity and save it to the S/4HANA system.
     *
     * @param purchasingQuotaArrangement
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingquotaarrangement.PurchasingQuotaArrangement
     *            PurchasingQuotaArrangement} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingquotaarrangement.PurchasingQuotaArrangement
     *         PurchasingQuotaArrangement} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingquotaarrangement.PurchasingQuotaArrangementCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PurchasingQuotaArrangementCreateFluentHelper
        createPurchasingQuotaArrangement( @Nonnull final PurchasingQuotaArrangement purchasingQuotaArrangement );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingquotaarrangement.PurchasingQuotaArrangement
     * PurchasingQuotaArrangement} entity and save it to the S/4HANA system.
     *
     * @param purchasingQuotaArrangement
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingquotaarrangement.PurchasingQuotaArrangement
     *            PurchasingQuotaArrangement} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingquotaarrangement.PurchasingQuotaArrangement
     *         PurchasingQuotaArrangement} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingquotaarrangement.PurchasingQuotaArrangementUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PurchasingQuotaArrangementUpdateFluentHelper
        updatePurchasingQuotaArrangement( @Nonnull final PurchasingQuotaArrangement purchasingQuotaArrangement );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingquotaarrangement.PurchasingQuotaArrangement
     * PurchasingQuotaArrangement} entity in the S/4HANA system.
     *
     * @param purchasingQuotaArrangement
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingquotaarrangement.PurchasingQuotaArrangement
     *            PurchasingQuotaArrangement} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingquotaarrangement.PurchasingQuotaArrangement
     *         PurchasingQuotaArrangement} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingquotaarrangement.PurchasingQuotaArrangementDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PurchasingQuotaArrangementDeleteFluentHelper
        deletePurchasingQuotaArrangement( @Nonnull final PurchasingQuotaArrangement purchasingQuotaArrangement );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingquotaarrangement.PurgQuotaArrangementItem
     * PurgQuotaArrangementItem} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingquotaarrangement.PurgQuotaArrangementItem
     *         PurgQuotaArrangementItem} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingquotaarrangement.PurgQuotaArrangementItemFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PurgQuotaArrangementItemFluentHelper getAllPurgQuotaArrangementItem();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingquotaarrangement.PurgQuotaArrangementItem
     * PurgQuotaArrangementItem} entity using key fields.
     *
     * @param quotaArrangement
     *            Number of quota arrangement
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param quotaArrangementItem
     *            Quota arrangement item
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingquotaarrangement.PurgQuotaArrangementItem
     *         PurgQuotaArrangementItem} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingquotaarrangement.PurgQuotaArrangementItemByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PurgQuotaArrangementItemByKeyFluentHelper
        getPurgQuotaArrangementItemByKey( final String quotaArrangement, final String quotaArrangementItem );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingquotaarrangement.PurgQuotaArrangementItem
     * PurgQuotaArrangementItem} entity and save it to the S/4HANA system.
     *
     * @param purgQuotaArrangementItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingquotaarrangement.PurgQuotaArrangementItem
     *            PurgQuotaArrangementItem} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingquotaarrangement.PurgQuotaArrangementItem
     *         PurgQuotaArrangementItem} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingquotaarrangement.PurgQuotaArrangementItemCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PurgQuotaArrangementItemCreateFluentHelper
        createPurgQuotaArrangementItem( @Nonnull final PurgQuotaArrangementItem purgQuotaArrangementItem );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingquotaarrangement.PurgQuotaArrangementItem
     * PurgQuotaArrangementItem} entity and save it to the S/4HANA system.
     *
     * @param purgQuotaArrangementItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingquotaarrangement.PurgQuotaArrangementItem
     *            PurgQuotaArrangementItem} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingquotaarrangement.PurgQuotaArrangementItem
     *         PurgQuotaArrangementItem} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingquotaarrangement.PurgQuotaArrangementItemUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PurgQuotaArrangementItemUpdateFluentHelper
        updatePurgQuotaArrangementItem( @Nonnull final PurgQuotaArrangementItem purgQuotaArrangementItem );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingquotaarrangement.PurgQuotaArrangementItem
     * PurgQuotaArrangementItem} entity in the S/4HANA system.
     *
     * @param purgQuotaArrangementItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingquotaarrangement.PurgQuotaArrangementItem
     *            PurgQuotaArrangementItem} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingquotaarrangement.PurgQuotaArrangementItem
     *         PurgQuotaArrangementItem} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingquotaarrangement.PurgQuotaArrangementItemDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PurgQuotaArrangementItemDeleteFluentHelper
        deletePurgQuotaArrangementItem( @Nonnull final PurgQuotaArrangementItem purgQuotaArrangementItem );

}
