/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingsource.PurchasingSource;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingsource.PurchasingSourceByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingsource.PurchasingSourceCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingsource.PurchasingSourceDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingsource.PurchasingSourceFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingsource.PurchasingSourceUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingsource.batch.PurchasingSourceServiceBatch;

/**
 * <p>
 * This synchronous inbound service enables you to create, update, and delete purchasing source lists. It is based on
 * the OData protocol. The information is sent in the request as a payload. All information is used when creating a
 * purchasing source list, and they are checked for authorizations. Once the purchasing source list has been created,
 * the purchasing source list number is sent in the response. If there are any issues when the purchasing source list is
 * created, the system displays error messages in the response.
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/56/92d23783a94d8282659356113c384f/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_PURCHASING_SOURCE_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_PURCHASING_SOURCE_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Purchasing Source Integration(SAP_COM_0162)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/BMD'>Purchase Contract(BMD)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OMD'>Purchase Contract(OMD)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Source List in Procurement</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Deprecated
public interface PurchasingSourceService extends BatchService<PurchasingSourceServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_PURCHASING_SOURCE_SRV";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    PurchasingSourceService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingsource.PurchasingSource
     * PurchasingSource} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingsource.PurchasingSource
     *         PurchasingSource} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingsource.PurchasingSourceFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PurchasingSourceFluentHelper getAllPurchasingSource();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingsource.PurchasingSource
     * PurchasingSource} entity using key fields.
     *
     * @param material
     *            Material Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @param plant
     *            Plant
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param sourceListRecord
     *            Number of Source List Record
     *            <p>
     *            Constraints: Not nullable, Maximum length: 5
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingsource.PurchasingSource
     *         PurchasingSource} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingsource.PurchasingSourceByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PurchasingSourceByKeyFluentHelper
        getPurchasingSourceByKey( final String material, final String plant, final String sourceListRecord );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingsource.PurchasingSource
     * PurchasingSource} entity and save it to the S/4HANA system.
     *
     * @param purchasingSource
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingsource.PurchasingSource
     *            PurchasingSource} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingsource.PurchasingSource
     *         PurchasingSource} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingsource.PurchasingSourceCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PurchasingSourceCreateFluentHelper createPurchasingSource( @Nonnull final PurchasingSource purchasingSource );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingsource.PurchasingSource
     * PurchasingSource} entity and save it to the S/4HANA system.
     *
     * @param purchasingSource
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingsource.PurchasingSource
     *            PurchasingSource} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingsource.PurchasingSource
     *         PurchasingSource} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingsource.PurchasingSourceUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PurchasingSourceUpdateFluentHelper updatePurchasingSource( @Nonnull final PurchasingSource purchasingSource );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingsource.PurchasingSource
     * PurchasingSource} entity in the S/4HANA system.
     *
     * @param purchasingSource
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingsource.PurchasingSource
     *            PurchasingSource} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingsource.PurchasingSource
     *         PurchasingSource} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingsource.PurchasingSourceDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PurchasingSourceDeleteFluentHelper deletePurchasingSource( @Nonnull final PurchasingSource purchasingSource );

}
