/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinforecord.QualityFirstArticleInspection;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinforecord.QualityFirstArticleInspectionByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinforecord.QualityFirstArticleInspectionCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinforecord.QualityFirstArticleInspectionDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinforecord.QualityFirstArticleInspectionFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinforecord.QualityFirstArticleInspectionUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinforecord.QualityInProcurement;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinforecord.QualityInProcurementByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinforecord.QualityInProcurementCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinforecord.QualityInProcurementDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinforecord.QualityInProcurementFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinforecord.QualityInProcurementUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinforecord.batch.QualityInfoRecordServiceBatch;

/**
 * <p>
 *
 * The data related to a quality info record and first article inspection has one entity type each. For read operations,
 * filter information must be sent according to the OData protocol. All filter information is utilized when retrieving
 * quality info records or data related to first article inspection. The detailed entity data is sent in the response.
 * If any issues arise when quality info records or data related to first article inspection is retrieved, the system
 * displays error messages in the response. .
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/a5/77b05467254dd6a186e78c9acd1f7b/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_QUALITYINFORECORD_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_QUALITYINFORECORD_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.2.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Quality Info Record Integration(SAP_COM_0358), Digital Manufacturing Cloud for Network with Quality Info Record
 * Integration(SAP_COM_0557)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/1FM'>Quality Management in Procurement(1FM)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Purchasing Quality Info Record</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Deprecated
public interface QualityInfoRecordService extends BatchService<QualityInfoRecordServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_QUALITYINFORECORD_SRV";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    QualityInfoRecordService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinforecord.QualityFirstArticleInspection
     * QualityFirstArticleInspection} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinforecord.QualityFirstArticleInspection
     *         QualityFirstArticleInspection} entities. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinforecord.QualityFirstArticleInspectionFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    QualityFirstArticleInspectionFluentHelper getAllQualityFirstArticleInspection();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinforecord.QualityFirstArticleInspection
     * QualityFirstArticleInspection} entity using key fields.
     *
     * @param material
     *            Material Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 18
     *            </p>
     * @param qltyInProcmt1stArticleInsp
     *            First Article Inspection Number in Quality Info Record
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param qltyInProcmtIntID
     *            Quality Info Record in Procurement Internal ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinforecord.QualityFirstArticleInspection
     *         QualityFirstArticleInspection} entity using key fields. This fluent helper allows methods which modify
     *         the underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinforecord.QualityFirstArticleInspectionByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    QualityFirstArticleInspectionByKeyFluentHelper getQualityFirstArticleInspectionByKey(
        final String material,
        final String qltyInProcmtIntID,
        final String qltyInProcmt1stArticleInsp );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinforecord.QualityFirstArticleInspection
     * QualityFirstArticleInspection} entity and save it to the S/4HANA system.
     *
     * @param qualityFirstArticleInspection
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinforecord.QualityFirstArticleInspection
     *            QualityFirstArticleInspection} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinforecord.QualityFirstArticleInspection
     *         QualityFirstArticleInspection} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinforecord.QualityFirstArticleInspectionCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    QualityFirstArticleInspectionCreateFluentHelper createQualityFirstArticleInspection(
        @Nonnull final QualityFirstArticleInspection qualityFirstArticleInspection );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinforecord.QualityFirstArticleInspection
     * QualityFirstArticleInspection} entity and save it to the S/4HANA system.
     *
     * @param qualityFirstArticleInspection
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinforecord.QualityFirstArticleInspection
     *            QualityFirstArticleInspection} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinforecord.QualityFirstArticleInspection
     *         QualityFirstArticleInspection} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinforecord.QualityFirstArticleInspectionUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    QualityFirstArticleInspectionUpdateFluentHelper updateQualityFirstArticleInspection(
        @Nonnull final QualityFirstArticleInspection qualityFirstArticleInspection );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinforecord.QualityFirstArticleInspection
     * QualityFirstArticleInspection} entity in the S/4HANA system.
     *
     * @param qualityFirstArticleInspection
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinforecord.QualityFirstArticleInspection
     *            QualityFirstArticleInspection} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinforecord.QualityFirstArticleInspection
     *         QualityFirstArticleInspection} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinforecord.QualityFirstArticleInspectionDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    QualityFirstArticleInspectionDeleteFluentHelper deleteQualityFirstArticleInspection(
        @Nonnull final QualityFirstArticleInspection qualityFirstArticleInspection );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinforecord.QualityInProcurement
     * QualityInProcurement} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinforecord.QualityInProcurement
     *         QualityInProcurement} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinforecord.QualityInProcurementFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    QualityInProcurementFluentHelper getAllQualityInProcurement();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinforecord.QualityInProcurement
     * QualityInProcurement} entity using key fields.
     *
     * @param material
     *            Material Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 18
     *            </p>
     * @param qltyInProcmtIntID
     *            Quality Info Record in Procurement Internal ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinforecord.QualityInProcurement
     *         QualityInProcurement} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinforecord.QualityInProcurementByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    QualityInProcurementByKeyFluentHelper
        getQualityInProcurementByKey( final String material, final String qltyInProcmtIntID );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinforecord.QualityInProcurement
     * QualityInProcurement} entity and save it to the S/4HANA system.
     *
     * @param qualityInProcurement
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinforecord.QualityInProcurement
     *            QualityInProcurement} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinforecord.QualityInProcurement
     *         QualityInProcurement} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinforecord.QualityInProcurementCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    QualityInProcurementCreateFluentHelper
        createQualityInProcurement( @Nonnull final QualityInProcurement qualityInProcurement );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinforecord.QualityInProcurement
     * QualityInProcurement} entity and save it to the S/4HANA system.
     *
     * @param qualityInProcurement
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinforecord.QualityInProcurement
     *            QualityInProcurement} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinforecord.QualityInProcurement
     *         QualityInProcurement} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinforecord.QualityInProcurementUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    QualityInProcurementUpdateFluentHelper
        updateQualityInProcurement( @Nonnull final QualityInProcurement qualityInProcurement );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinforecord.QualityInProcurement
     * QualityInProcurement} entity in the S/4HANA system.
     *
     * @param qualityInProcurement
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinforecord.QualityInProcurement
     *            QualityInProcurement} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinforecord.QualityInProcurement
     *         QualityInProcurement} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinforecord.QualityInProcurementDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    QualityInProcurementDeleteFluentHelper
        deleteQualityInProcurement( @Nonnull final QualityInProcurement qualityInProcurement );

}
