/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspLotMatlDocItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspLotMatlDocItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspLotMatlDocItemCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspLotMatlDocItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspLotMatlDocItmSrlNmbrByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspLotMatlDocItmSrlNmbrFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspLotSerialNumberByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspLotSerialNumberFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspLotUsageDecision;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspLotUsageDecisionByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspLotUsageDecisionCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspLotUsageDecisionFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspLotUsageDecisionUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspSampleCharacteristicByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspSampleCharacteristicFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspSampleResult;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspSampleResultByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspSampleResultCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspSampleResultFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspSampleResultUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionCharacteristic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionCharacteristicByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionCharacteristicCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionCharacteristicFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLotByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLotCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLotFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLotUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLotWithStatusByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLotWithStatusFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionOperationByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionOperationFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionResult;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionResultByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionResultCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionResultFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionResultUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionResultValue;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionResultValueByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionResultValueCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionResultValueFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionResultValueUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionSubset;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionSubsetByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionSubsetCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionSubsetFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionSubsetTrigger_valuationFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionSubsetUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.batch.QualityInspectionDataServiceBatch;

/**
 * <p>
 *
 * In the SAP system, you process quality inspections on the basis of inspection lots. The data relating to a quality
 * inspection is grouped into several entities. With this service it is possible, for example, to update inspection lot
 * header data or to create inspection results and usage decisions..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/61/ff4c3780864ce1b0822d9c5e6cd3bb/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_INSPECTIONLOT_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_INSPECTIONLOT_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.2.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Quality Inspection Process Integration(SAP_COM_0318)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/1E1'>Quality Management in Discrete Manufacturing(1E1)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/1FM'>Quality Management in Procurement(1FM)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/1MP'>Quality Management in Sales(1MP)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/1MR'>Quality Management in Stock Handling(1MR)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/2QN'>Nonconformance Management(2QN)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Inspection Lot</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Deprecated
public interface QualityInspectionDataService extends BatchService<QualityInspectionDataServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_INSPECTIONLOT_SRV";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    QualityInspectionDataService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionCharacteristic
     * InspectionCharacteristic} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionCharacteristic
     *         InspectionCharacteristic} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionCharacteristicFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    InspectionCharacteristicFluentHelper getAllInspectionCharacteristic();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionCharacteristic
     * InspectionCharacteristic} entity using key fields.
     *
     * @param inspPlanOperationInternalID
     *            Current Node Number from Order Counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param inspectionCharacteristic
     *            Inspection Characteristic Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param inspectionLot
     *            Inspection Lot Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionCharacteristic
     *         InspectionCharacteristic} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionCharacteristicByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    InspectionCharacteristicByKeyFluentHelper getInspectionCharacteristicByKey(
        final String inspectionLot,
        final String inspPlanOperationInternalID,
        final String inspectionCharacteristic );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionCharacteristic
     * InspectionCharacteristic} entity and save it to the S/4HANA system.
     *
     * @param inspectionCharacteristic
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionCharacteristic
     *            InspectionCharacteristic} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionCharacteristic
     *         InspectionCharacteristic} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionCharacteristicCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    InspectionCharacteristicCreateFluentHelper
        createInspectionCharacteristic( @Nonnull final InspectionCharacteristic inspectionCharacteristic );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot
     * InspectionLot} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot
     *         InspectionLot} entities. This fluent helper allows methods which modify the underlying query to be called
     *         before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLotFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    InspectionLotFluentHelper getAllInspectionLot();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot
     * InspectionLot} entity using key fields.
     *
     * @param inspectionLot
     *            Inspection Lot Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot
     *         InspectionLot} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLotByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    InspectionLotByKeyFluentHelper getInspectionLotByKey( final String inspectionLot );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot
     * InspectionLot} entity and save it to the S/4HANA system.
     *
     * @param inspectionLot
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot
     *            InspectionLot} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot
     *         InspectionLot} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLotCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    InspectionLotCreateFluentHelper createInspectionLot( @Nonnull final InspectionLot inspectionLot );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot
     * InspectionLot} entity and save it to the S/4HANA system.
     *
     * @param inspectionLot
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot
     *            InspectionLot} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLot
     *         InspectionLot} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLotUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    InspectionLotUpdateFluentHelper updateInspectionLot( @Nonnull final InspectionLot inspectionLot );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLotWithStatus
     * InspectionLotWithStatus} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLotWithStatus
     *         InspectionLotWithStatus} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLotWithStatusFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    InspectionLotWithStatusFluentHelper getAllInspectionLotWithStatus();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLotWithStatus
     * InspectionLotWithStatus} entity using key fields.
     *
     * @param inspectionLot
     *            Inspection Lot Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLotWithStatus
     *         InspectionLotWithStatus} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionLotWithStatusByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    InspectionLotWithStatusByKeyFluentHelper getInspectionLotWithStatusByKey( final String inspectionLot );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionOperation
     * InspectionOperation} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionOperation
     *         InspectionOperation} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionOperationFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    InspectionOperationFluentHelper getAllInspectionOperation();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionOperation
     * InspectionOperation} entity using key fields.
     *
     * @param inspPlanOperationInternalID
     *            Current Node Number from Order Counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param inspectionLot
     *            Inspection Lot Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionOperation
     *         InspectionOperation} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionOperationByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    InspectionOperationByKeyFluentHelper
        getInspectionOperationByKey( final String inspectionLot, final String inspPlanOperationInternalID );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionResult
     * InspectionResult} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionResult
     *         InspectionResult} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionResultFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    InspectionResultFluentHelper getAllInspectionResult();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionResult
     * InspectionResult} entity using key fields.
     *
     * @param inspPlanOperationInternalID
     *            Current Node Number from Order Counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param inspectionCharacteristic
     *            Inspection Characteristic Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param inspectionLot
     *            Inspection Lot Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionResult
     *         InspectionResult} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionResultByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    InspectionResultByKeyFluentHelper getInspectionResultByKey(
        final String inspectionLot,
        final String inspPlanOperationInternalID,
        final String inspectionCharacteristic );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionResult
     * InspectionResult} entity and save it to the S/4HANA system.
     *
     * @param inspectionResult
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionResult
     *            InspectionResult} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionResult
     *         InspectionResult} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionResultCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    InspectionResultCreateFluentHelper createInspectionResult( @Nonnull final InspectionResult inspectionResult );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionResult
     * InspectionResult} entity and save it to the S/4HANA system.
     *
     * @param inspectionResult
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionResult
     *            InspectionResult} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionResult
     *         InspectionResult} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionResultUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    InspectionResultUpdateFluentHelper updateInspectionResult( @Nonnull final InspectionResult inspectionResult );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionResultValue
     * InspectionResultValue} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionResultValue
     *         InspectionResultValue} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionResultValueFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    InspectionResultValueFluentHelper getAllInspectionResultValue();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionResultValue
     * InspectionResultValue} entity using key fields.
     *
     * @param inspPlanOperationInternalID
     *            Current Node Number from Order Counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param inspectionCharacteristic
     *            Inspection Characteristic Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param inspResultValueInternalID
     *            Number of Individual Result
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param inspectionLot
     *            Inspection Lot Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionResultValue
     *         InspectionResultValue} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionResultValueByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    InspectionResultValueByKeyFluentHelper getInspectionResultValueByKey(
        final String inspectionLot,
        final String inspPlanOperationInternalID,
        final String inspectionCharacteristic,
        final String inspResultValueInternalID );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionResultValue
     * InspectionResultValue} entity and save it to the S/4HANA system.
     *
     * @param inspectionResultValue
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionResultValue
     *            InspectionResultValue} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionResultValue
     *         InspectionResultValue} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionResultValueCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    InspectionResultValueCreateFluentHelper
        createInspectionResultValue( @Nonnull final InspectionResultValue inspectionResultValue );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionResultValue
     * InspectionResultValue} entity and save it to the S/4HANA system.
     *
     * @param inspectionResultValue
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionResultValue
     *            InspectionResultValue} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionResultValue
     *         InspectionResultValue} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionResultValueUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    InspectionResultValueUpdateFluentHelper
        updateInspectionResultValue( @Nonnull final InspectionResultValue inspectionResultValue );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionSubset
     * InspectionSubset} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionSubset
     *         InspectionSubset} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionSubsetFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    InspectionSubsetFluentHelper getAllInspectionSubset();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionSubset
     * InspectionSubset} entity using key fields.
     *
     * @param inspPlanOperationInternalID
     *            Current Node Number from Order Counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param inspectionLot
     *            Inspection Lot Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     * @param inspectionSubsetInternalID
     *            Sample Number (Based on an Inspection Point)
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionSubset
     *         InspectionSubset} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionSubsetByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    InspectionSubsetByKeyFluentHelper getInspectionSubsetByKey(
        final String inspectionLot,
        final String inspPlanOperationInternalID,
        final String inspectionSubsetInternalID );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionSubset
     * InspectionSubset} entity and save it to the S/4HANA system.
     *
     * @param inspectionSubset
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionSubset
     *            InspectionSubset} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionSubset
     *         InspectionSubset} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionSubsetCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    InspectionSubsetCreateFluentHelper createInspectionSubset( @Nonnull final InspectionSubset inspectionSubset );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionSubset
     * InspectionSubset} entity and save it to the S/4HANA system.
     *
     * @param inspectionSubset
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionSubset
     *            InspectionSubset} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionSubset
     *         InspectionSubset} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionSubsetUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    InspectionSubsetUpdateFluentHelper updateInspectionSubset( @Nonnull final InspectionSubset inspectionSubset );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspLotMatlDocItem
     * InspLotMatlDocItem} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspLotMatlDocItem
     *         InspLotMatlDocItem} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspLotMatlDocItemFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    InspLotMatlDocItemFluentHelper getAllInspLotMatlDocItem();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspLotMatlDocItem
     * InspLotMatlDocItem} entity using key fields.
     *
     * @param inspLotMatlDocItem
     *            Internal Counter for DB Objects
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param inspectionLot
     *            Inspection Lot Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspLotMatlDocItem
     *         InspLotMatlDocItem} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspLotMatlDocItemByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    InspLotMatlDocItemByKeyFluentHelper
        getInspLotMatlDocItemByKey( final String inspectionLot, final String inspLotMatlDocItem );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspLotMatlDocItem
     * InspLotMatlDocItem} entity and save it to the S/4HANA system.
     *
     * @param inspLotMatlDocItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspLotMatlDocItem
     *            InspLotMatlDocItem} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspLotMatlDocItem
     *         InspLotMatlDocItem} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspLotMatlDocItemCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    InspLotMatlDocItemCreateFluentHelper
        createInspLotMatlDocItem( @Nonnull final InspLotMatlDocItem inspLotMatlDocItem );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspLotMatlDocItmSrlNmbr
     * InspLotMatlDocItmSrlNmbr} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspLotMatlDocItmSrlNmbr
     *         InspLotMatlDocItmSrlNmbr} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspLotMatlDocItmSrlNmbrFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    InspLotMatlDocItmSrlNmbrFluentHelper getAllInspLotMatlDocItmSrlNmbr();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspLotMatlDocItmSrlNmbr
     * InspLotMatlDocItmSrlNmbr} entity using key fields.
     *
     * @param inspLotMatlDocItem
     *            Internal Counter for DB Objects
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param equipment
     *            Equipment Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 18
     *            </p>
     * @param inspectionLot
     *            Inspection Lot Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspLotMatlDocItmSrlNmbr
     *         InspLotMatlDocItmSrlNmbr} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspLotMatlDocItmSrlNmbrByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    InspLotMatlDocItmSrlNmbrByKeyFluentHelper getInspLotMatlDocItmSrlNmbrByKey(
        final String inspectionLot,
        final String inspLotMatlDocItem,
        final String equipment );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspLotSerialNumber
     * InspLotSerialNumber} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspLotSerialNumber
     *         InspLotSerialNumber} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspLotSerialNumberFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    InspLotSerialNumberFluentHelper getAllInspLotSerialNumber();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspLotSerialNumber
     * InspLotSerialNumber} entity using key fields.
     *
     * @param serialNumber
     *            Serial Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 18
     *            </p>
     * @param inspectionLot
     *            Inspection Lot Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspLotSerialNumber
     *         InspLotSerialNumber} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspLotSerialNumberByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    InspLotSerialNumberByKeyFluentHelper
        getInspLotSerialNumberByKey( final String inspectionLot, final String serialNumber );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspLotUsageDecision
     * InspLotUsageDecision} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspLotUsageDecision
     *         InspLotUsageDecision} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspLotUsageDecisionFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    InspLotUsageDecisionFluentHelper getAllInspLotUsageDecision();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspLotUsageDecision
     * InspLotUsageDecision} entity using key fields.
     *
     * @param inspectionLot
     *            Inspection Lot Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspLotUsageDecision
     *         InspLotUsageDecision} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspLotUsageDecisionByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    InspLotUsageDecisionByKeyFluentHelper getInspLotUsageDecisionByKey( final String inspectionLot );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspLotUsageDecision
     * InspLotUsageDecision} entity and save it to the S/4HANA system.
     *
     * @param inspLotUsageDecision
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspLotUsageDecision
     *            InspLotUsageDecision} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspLotUsageDecision
     *         InspLotUsageDecision} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspLotUsageDecisionCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    InspLotUsageDecisionCreateFluentHelper
        createInspLotUsageDecision( @Nonnull final InspLotUsageDecision inspLotUsageDecision );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspLotUsageDecision
     * InspLotUsageDecision} entity and save it to the S/4HANA system.
     *
     * @param inspLotUsageDecision
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspLotUsageDecision
     *            InspLotUsageDecision} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspLotUsageDecision
     *         InspLotUsageDecision} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspLotUsageDecisionUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    InspLotUsageDecisionUpdateFluentHelper
        updateInspLotUsageDecision( @Nonnull final InspLotUsageDecision inspLotUsageDecision );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspSampleCharacteristic
     * InspSampleCharacteristic} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspSampleCharacteristic
     *         InspSampleCharacteristic} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspSampleCharacteristicFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    InspSampleCharacteristicFluentHelper getAllInspSampleCharacteristic();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspSampleCharacteristic
     * InspSampleCharacteristic} entity using key fields.
     *
     * @param inspPlanOperationInternalID
     *            Current Node Number from Order Counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param inspectionCharacteristic
     *            Inspection Characteristic Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param inspectionLot
     *            Inspection Lot Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     * @param inspectionSubsetInternalID
     *            Inspection Sample Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspSampleCharacteristic
     *         InspSampleCharacteristic} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspSampleCharacteristicByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    InspSampleCharacteristicByKeyFluentHelper getInspSampleCharacteristicByKey(
        final String inspectionLot,
        final String inspPlanOperationInternalID,
        final String inspectionCharacteristic,
        final String inspectionSubsetInternalID );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspSampleResult
     * InspSampleResult} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspSampleResult
     *         InspSampleResult} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspSampleResultFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    InspSampleResultFluentHelper getAllInspSampleResult();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspSampleResult
     * InspSampleResult} entity using key fields.
     *
     * @param inspPlanOperationInternalID
     *            Current Node Number from Order Counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param inspectionCharacteristic
     *            Inspection Characteristic Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param inspectionLot
     *            Inspection Lot Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     * @param inspectionSubsetInternalID
     *            Number of Partial Sample
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspSampleResult
     *         InspSampleResult} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspSampleResultByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    InspSampleResultByKeyFluentHelper getInspSampleResultByKey(
        final String inspectionLot,
        final String inspPlanOperationInternalID,
        final String inspectionCharacteristic,
        final String inspectionSubsetInternalID );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspSampleResult
     * InspSampleResult} entity and save it to the S/4HANA system.
     *
     * @param inspSampleResult
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspSampleResult
     *            InspSampleResult} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspSampleResult
     *         InspSampleResult} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspSampleResultCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    InspSampleResultCreateFluentHelper createInspSampleResult( @Nonnull final InspSampleResult inspSampleResult );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspSampleResult
     * InspSampleResult} entity and save it to the S/4HANA system.
     *
     * @param inspSampleResult
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspSampleResult
     *            InspSampleResult} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspSampleResult
     *         InspSampleResult} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspSampleResultUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    InspSampleResultUpdateFluentHelper updateInspSampleResult( @Nonnull final InspSampleResult inspSampleResult );

    /**
     * <p>
     * Creates a fluent helper for the <b>A_InspectionSubsetTrigger_valuation</b> OData function import.
     * </p>
     *
     * @param inspPlanOperationInternalID
     *            Current Node No.
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>InspPlanOperationInternalID</b>
     *            </p>
     * @param inspectionLot
     *            Inspection Lot
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>InspectionLot</b>
     *            </p>
     * @param inspectionSubsetInternalID
     *            Sample
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>InspectionSubsetInternalID</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>A_InspectionSubsetTrigger_valuation</b> OData function
     *         import with the provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.qualityinspectiondata.InspectionSubsetTrigger_valuationFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    InspectionSubsetTrigger_valuationFluentHelper inspectionSubsetTrigger_valuation(
        @Nonnull final String inspectionLot,
        @Nonnull final String inspPlanOperationInternalID,
        @Nonnull final String inspectionSubsetInternalID );

}
