/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.Product;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductDescription;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductDescriptionByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductDescriptionCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductDescriptionDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductDescriptionFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductDescriptionUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductPlant;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductPlantByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductPlantCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductPlantFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductPlantUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductSalesDelivery;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductSalesDeliveryByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductSalesDeliveryCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductSalesDeliveryFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductSalesDeliveryUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductStorageLocation;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductStorageLocationByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductStorageLocationCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductStorageLocationFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductStorageLocationUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.RealSubstanceByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.RealSubstanceFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.SpecAssignedMatlForKeyDate;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.SpecAssignedMatlForKeyDateByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.SpecAssignedMatlForKeyDateCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.SpecAssignedMatlForKeyDateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.SpecAuthorizationGroupTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.SpecAuthorizationGroupTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.SpecCharByValueAssgmtInstByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.SpecCharByValueAssgmtInstFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.SpecIdentifierByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.SpecIdentifierFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.SpecStatusAttributesByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.SpecStatusAttributesFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.SpecStatusNextStatusByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.SpecStatusNextStatusFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.SpecStatusSchemaByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.SpecStatusSchemaFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.SpecValAssgmtInstanceWthCompByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.SpecValAssgmtInstanceWthCompFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.batch.RealSubstanceServiceBatch;

/**
 * <p>
 *
 * This service contains data belonging to the real substance header, such as creation date and header status, as well
 * as other important information, for example material assignments, language-dependent and independent descriptions,
 * estimated price, total solids, and density. You can also read a real substance&#39;s standard composition, as well as
 * diet, religious, GMO information..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/c8/004c0f6fd94c2fbf9803ddd77307ab/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference:
 * <a href='https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_REALSUBSTANCE?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_REALSUBSTANCE</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Product Lifecycle Management - Recipe Development Integration(SAP_COM_0136)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/1QA'>Specification Management for Recipes(1QA)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/1QC'>Formulation - Recipe Development(1QC)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Recipe Real Substance</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Deprecated
public interface RealSubstanceService extends BatchService<RealSubstanceServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_REALSUBSTANCE";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    RealSubstanceService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.Product Product}
     * entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.Product Product} entities. This
     *         fluent helper allows methods which modify the underlying query to be called before executing the query
     *         itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductFluentHelper getAllProduct();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.Product Product} entity
     * using key fields.
     *
     * @param product
     *            Product Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.Product Product} entity using
     *         key fields. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductByKeyFluentHelper getProductByKey( final String product );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.Product Product} entity and
     * save it to the S/4HANA system.
     *
     * @param product
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.Product Product} entity
     *            object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.Product Product} entity. To
     *         perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductCreateFluentHelper createProduct( @Nonnull final Product product );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.Product Product}
     * entity and save it to the S/4HANA system.
     *
     * @param product
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.Product Product} entity
     *            object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.Product Product} entity. To
     *         perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductUpdateFluentHelper updateProduct( @Nonnull final Product product );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductDescription
     * ProductDescription} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductDescription
     *         ProductDescription} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductDescriptionFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductDescriptionFluentHelper getAllProductDescription();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductDescription
     * ProductDescription} entity using key fields.
     *
     * @param product
     *            Product Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductDescription
     *         ProductDescription} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductDescriptionByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductDescriptionByKeyFluentHelper getProductDescriptionByKey( final String product, final String language );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductDescription
     * ProductDescription} entity and save it to the S/4HANA system.
     *
     * @param productDescription
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductDescription
     *            ProductDescription} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductDescription
     *         ProductDescription} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductDescriptionCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductDescriptionCreateFluentHelper
        createProductDescription( @Nonnull final ProductDescription productDescription );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductDescription
     * ProductDescription} entity and save it to the S/4HANA system.
     *
     * @param productDescription
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductDescription
     *            ProductDescription} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductDescription
     *         ProductDescription} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductDescriptionUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductDescriptionUpdateFluentHelper
        updateProductDescription( @Nonnull final ProductDescription productDescription );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductDescription
     * ProductDescription} entity in the S/4HANA system.
     *
     * @param productDescription
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductDescription
     *            ProductDescription} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductDescription
     *         ProductDescription} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductDescriptionDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductDescriptionDeleteFluentHelper
        deleteProductDescription( @Nonnull final ProductDescription productDescription );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductPlant
     * ProductPlant} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductPlant ProductPlant}
     *         entities. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductPlantFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductPlantFluentHelper getAllProductPlant();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductPlant
     * ProductPlant} entity using key fields.
     *
     * @param product
     *            Material Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @param plant
     *            Plant
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductPlant ProductPlant}
     *         entity using key fields. This fluent helper allows methods which modify the underlying query to be called
     *         before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductPlantByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductPlantByKeyFluentHelper getProductPlantByKey( final String product, final String plant );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductPlant ProductPlant}
     * entity and save it to the S/4HANA system.
     *
     * @param productPlant
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductPlant ProductPlant}
     *            entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductPlant ProductPlant}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductPlantCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductPlantCreateFluentHelper createProductPlant( @Nonnull final ProductPlant productPlant );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductPlant
     * ProductPlant} entity and save it to the S/4HANA system.
     *
     * @param productPlant
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductPlant ProductPlant}
     *            entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductPlant ProductPlant}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductPlantUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductPlantUpdateFluentHelper updateProductPlant( @Nonnull final ProductPlant productPlant );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductSalesDelivery
     * ProductSalesDelivery} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductSalesDelivery
     *         ProductSalesDelivery} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductSalesDeliveryFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductSalesDeliveryFluentHelper getAllProductSalesDelivery();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductSalesDelivery
     * ProductSalesDelivery} entity using key fields.
     *
     * @param product
     *            Product Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @param productDistributionChnl
     *            Distribution Channel
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param productSalesOrg
     *            Sales Organization
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductSalesDelivery
     *         ProductSalesDelivery} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductSalesDeliveryByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductSalesDeliveryByKeyFluentHelper getProductSalesDeliveryByKey(
        final String product,
        final String productSalesOrg,
        final String productDistributionChnl );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductSalesDelivery
     * ProductSalesDelivery} entity and save it to the S/4HANA system.
     *
     * @param productSalesDelivery
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductSalesDelivery
     *            ProductSalesDelivery} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductSalesDelivery
     *         ProductSalesDelivery} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductSalesDeliveryCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductSalesDeliveryCreateFluentHelper
        createProductSalesDelivery( @Nonnull final ProductSalesDelivery productSalesDelivery );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductSalesDelivery
     * ProductSalesDelivery} entity and save it to the S/4HANA system.
     *
     * @param productSalesDelivery
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductSalesDelivery
     *            ProductSalesDelivery} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductSalesDelivery
     *         ProductSalesDelivery} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductSalesDeliveryUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductSalesDeliveryUpdateFluentHelper
        updateProductSalesDelivery( @Nonnull final ProductSalesDelivery productSalesDelivery );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductStorageLocation
     * ProductStorageLocation} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductStorageLocation
     *         ProductStorageLocation} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductStorageLocationFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductStorageLocationFluentHelper getAllProductStorageLocation();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductStorageLocation
     * ProductStorageLocation} entity using key fields.
     *
     * @param product
     *            Material Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @param plant
     *            Plant
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param storageLocation
     *            Storage Location
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductStorageLocation
     *         ProductStorageLocation} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductStorageLocationByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductStorageLocationByKeyFluentHelper
        getProductStorageLocationByKey( final String product, final String plant, final String storageLocation );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductStorageLocation
     * ProductStorageLocation} entity and save it to the S/4HANA system.
     *
     * @param productStorageLocation
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductStorageLocation
     *            ProductStorageLocation} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductStorageLocation
     *         ProductStorageLocation} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductStorageLocationCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductStorageLocationCreateFluentHelper
        createProductStorageLocation( @Nonnull final ProductStorageLocation productStorageLocation );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductStorageLocation
     * ProductStorageLocation} entity and save it to the S/4HANA system.
     *
     * @param productStorageLocation
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductStorageLocation
     *            ProductStorageLocation} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductStorageLocation
     *         ProductStorageLocation} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductStorageLocationUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductStorageLocationUpdateFluentHelper
        updateProductStorageLocation( @Nonnull final ProductStorageLocation productStorageLocation );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.RealSubstance
     * RealSubstance} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.RealSubstance RealSubstance}
     *         entities. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.RealSubstanceFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    RealSubstanceFluentHelper getAllRealSubstance();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.RealSubstance
     * RealSubstance} entity using key fields.
     *
     * @param realSubstanceInternalID
     *            Sequential Number of Data Record
     *            <p>
     *            Constraints: Not nullable, Maximum length: 20
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.RealSubstance RealSubstance}
     *         entity using key fields. This fluent helper allows methods which modify the underlying query to be called
     *         before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.RealSubstanceByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    RealSubstanceByKeyFluentHelper getRealSubstanceByKey( final String realSubstanceInternalID );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.SpecAssignedMatlForKeyDate
     * SpecAssignedMatlForKeyDate} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.SpecAssignedMatlForKeyDate
     *         SpecAssignedMatlForKeyDate} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.SpecAssignedMatlForKeyDateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SpecAssignedMatlForKeyDateFluentHelper getAllSpecAssignedMatlForKeyDate();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.SpecAssignedMatlForKeyDate
     * SpecAssignedMatlForKeyDate} entity using key fields.
     *
     * @param specMaterialAssgmtInternalID
     *            Sequential Number of Data Record
     *            <p>
     *            Constraints: Not nullable, Maximum length: 20
     *            </p>
     * @param specMaterialAssgmtChangeState
     *            Sequential Number of the Change State
     *            <p>
     *            Constraints: Not nullable, Maximum length: 20
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.SpecAssignedMatlForKeyDate
     *         SpecAssignedMatlForKeyDate} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.SpecAssignedMatlForKeyDateByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SpecAssignedMatlForKeyDateByKeyFluentHelper getSpecAssignedMatlForKeyDateByKey(
        final String specMaterialAssgmtInternalID,
        final String specMaterialAssgmtChangeState );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.SpecAssignedMatlForKeyDate
     * SpecAssignedMatlForKeyDate} entity and save it to the S/4HANA system.
     *
     * @param specAssignedMatlForKeyDate
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.SpecAssignedMatlForKeyDate
     *            SpecAssignedMatlForKeyDate} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.SpecAssignedMatlForKeyDate
     *         SpecAssignedMatlForKeyDate} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.SpecAssignedMatlForKeyDateCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SpecAssignedMatlForKeyDateCreateFluentHelper
        createSpecAssignedMatlForKeyDate( @Nonnull final SpecAssignedMatlForKeyDate specAssignedMatlForKeyDate );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.SpecAuthorizationGroupText
     * SpecAuthorizationGroupText} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.SpecAuthorizationGroupText
     *         SpecAuthorizationGroupText} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.SpecAuthorizationGroupTextFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SpecAuthorizationGroupTextFluentHelper getAllSpecAuthorizationGroupText();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.SpecAuthorizationGroupText
     * SpecAuthorizationGroupText} entity using key fields.
     *
     * @param specificationAuthznGroup
     *            Recipe Authorization Group
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.SpecAuthorizationGroupText
     *         SpecAuthorizationGroupText} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.SpecAuthorizationGroupTextByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SpecAuthorizationGroupTextByKeyFluentHelper
        getSpecAuthorizationGroupTextByKey( final String specificationAuthznGroup, final String language );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.SpecCharByValueAssgmtInst
     * SpecCharByValueAssgmtInst} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.SpecCharByValueAssgmtInst
     *         SpecCharByValueAssgmtInst} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.SpecCharByValueAssgmtInstFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SpecCharByValueAssgmtInstFluentHelper getAllSpecCharByValueAssgmtInst();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.SpecCharByValueAssgmtInst
     * SpecCharByValueAssgmtInst} entity using key fields.
     *
     * @param specValAssgmtType
     *            Value Assignment Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 30
     *            </p>
     * @param specificationRating
     *            Rating
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param specificationValidityArea
     *            Validity Area
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param specificationInternalID
     *            Sequential Number of Data Record
     *            <p>
     *            Constraints: Not nullable, Maximum length: 20
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.SpecCharByValueAssgmtInst
     *         SpecCharByValueAssgmtInst} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.SpecCharByValueAssgmtInstByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SpecCharByValueAssgmtInstByKeyFluentHelper getSpecCharByValueAssgmtInstByKey(
        final String specificationInternalID,
        final String specValAssgmtType,
        final String specificationRating,
        final String specificationValidityArea );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.SpecIdentifier
     * SpecIdentifier} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.SpecIdentifier SpecIdentifier}
     *         entities. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.SpecIdentifierFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SpecIdentifierFluentHelper getAllSpecIdentifier();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.SpecIdentifier
     * SpecIdentifier} entity using key fields.
     *
     * @param specIdfgDescInternalID
     *            Sequential Number of Data Record
     *            <p>
     *            Constraints: Not nullable, Maximum length: 20
     *            </p>
     * @param specIdfgDescChangeState
     *            Sequential Number of the Change State
     *            <p>
     *            Constraints: Not nullable, Maximum length: 20
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.SpecIdentifier SpecIdentifier}
     *         entity using key fields. This fluent helper allows methods which modify the underlying query to be called
     *         before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.SpecIdentifierByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SpecIdentifierByKeyFluentHelper
        getSpecIdentifierByKey( final String specIdfgDescInternalID, final String specIdfgDescChangeState );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.SpecStatusAttributes
     * SpecStatusAttributes} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.SpecStatusAttributes
     *         SpecStatusAttributes} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.SpecStatusAttributesFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SpecStatusAttributesFluentHelper getAllSpecStatusAttributes();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.SpecStatusAttributes
     * SpecStatusAttributes} entity using key fields.
     *
     * @param specificationHeaderStatus
     *            Status Identification
     *            <p>
     *            Constraints: Not nullable, Maximum length: 20
     *            </p>
     * @param specificationHdrStsAttribute
     *            Attribute per Object Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 20
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.SpecStatusAttributes
     *         SpecStatusAttributes} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.SpecStatusAttributesByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SpecStatusAttributesByKeyFluentHelper getSpecStatusAttributesByKey(
        final String specificationHeaderStatus,
        final String specificationHdrStsAttribute );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.SpecStatusNextStatus
     * SpecStatusNextStatus} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.SpecStatusNextStatus
     *         SpecStatusNextStatus} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.SpecStatusNextStatusFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SpecStatusNextStatusFluentHelper getAllSpecStatusNextStatus();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.SpecStatusNextStatus
     * SpecStatusNextStatus} entity using key fields.
     *
     * @param specificationHdrStsSchema
     *            Status Scheme
     *            <p>
     *            Constraints: Not nullable, Maximum length: 20
     *            </p>
     * @param specificationHdrStsSchemaToSts
     *            Status To
     *            <p>
     *            Constraints: Not nullable, Maximum length: 20
     *            </p>
     * @param specificationHdrStsSchemaFrSts
     *            Status Identification
     *            <p>
     *            Constraints: Not nullable, Maximum length: 20
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.SpecStatusNextStatus
     *         SpecStatusNextStatus} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.SpecStatusNextStatusByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SpecStatusNextStatusByKeyFluentHelper getSpecStatusNextStatusByKey(
        final String specificationHdrStsSchema,
        final String specificationHdrStsSchemaFrSts,
        final String specificationHdrStsSchemaToSts );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.SpecStatusSchema
     * SpecStatusSchema} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.SpecStatusSchema
     *         SpecStatusSchema} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.SpecStatusSchemaFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SpecStatusSchemaFluentHelper getAllSpecStatusSchema();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.SpecStatusSchema
     * SpecStatusSchema} entity using key fields.
     *
     * @param specificationHdrStsSchema
     *            Status Scheme
     *            <p>
     *            Constraints: Not nullable, Maximum length: 20
     *            </p>
     * @param specificationType
     *            Subordinate Object Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 20
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.SpecStatusSchema
     *         SpecStatusSchema} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.SpecStatusSchemaByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SpecStatusSchemaByKeyFluentHelper
        getSpecStatusSchemaByKey( final String specificationType, final String specificationHdrStsSchema );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.SpecValAssgmtInstanceWthComp
     * SpecValAssgmtInstanceWthComp} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.SpecValAssgmtInstanceWthComp
     *         SpecValAssgmtInstanceWthComp} entities. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.SpecValAssgmtInstanceWthCompFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SpecValAssgmtInstanceWthCompFluentHelper getAllSpecValAssgmtInstanceWthComp();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.SpecValAssgmtInstanceWthComp
     * SpecValAssgmtInstanceWthComp} entity using key fields.
     *
     * @param specValAssgmtType
     *            Value Assignment Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 30
     *            </p>
     * @param specificationRating
     *            Rating
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param componentSpecificationIntID
     *            Reference to Specification Header of a Component
     *            <p>
     *            Constraints: Not nullable, Maximum length: 20
     *            </p>
     * @param specificationValidityArea
     *            Validity Area
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param specificationInternalID
     *            Sequential Number of Data Record
     *            <p>
     *            Constraints: Not nullable, Maximum length: 20
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.SpecValAssgmtInstanceWthComp
     *         SpecValAssgmtInstanceWthComp} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.SpecValAssgmtInstanceWthCompByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SpecValAssgmtInstanceWthCompByKeyFluentHelper getSpecValAssgmtInstanceWthCompByKey(
        final String specificationInternalID,
        final String specValAssgmtType,
        final String specificationRating,
        final String specificationValidityArea,
        final String componentSpecificationIntID );

}
