/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.util.UUID;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecProcEquipRqmtCharcByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecProcEquipRqmtCharcFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecProcEquipRqmtCharcValueByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecProcEquipRqmtCharcValueFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecProcEquipRqmtClassByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecProcEquipRqmtClassCharcByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecProcEquipRqmtClassCharcFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecProcEquipRqmtClassFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecProcParamValCharcByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecProcParamValCharcFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecProcParamValCharcValueByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecProcParamValCharcValueFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecProcParamValClassByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecProcParamValClassCharcByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecProcParamValClassCharcFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecProcParamValClassFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.Recipe;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeCharcByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeCharcFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeCharcValueByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeCharcValueFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeClassByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeClassCharcByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeClassCharcFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeClassFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeFormulaItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeFormulaItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeFormulaItemCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeFormulaItemDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeFormulaItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeFormulaItemUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessElement;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessElementByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessElementCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessElementDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessElementFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessElementText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessElementTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessElementTextCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessElementTextDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessElementTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessElementTextUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessElementUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessEquipRqmt;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessEquipRqmtByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessEquipRqmtCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessEquipRqmtDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessEquipRqmtFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessEquipRqmtText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessEquipRqmtTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessEquipRqmtTextCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessEquipRqmtTextDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessEquipRqmtTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessEquipRqmtTextUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessEquipRqmtUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessParamByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessParamFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessParamTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessParamTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessParamValue;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessParamValueByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessParamValueCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessParamValueDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessParamValueFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessParamValueTxt;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessParamValueTxtByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessParamValueTxtCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessParamValueTxtDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessParamValueTxtFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessParamValueTxtUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessParamValueUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeTextCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeTextDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeTextUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.batch.RecipeHeaderAndFormulaServiceBatch;

/**
 * <p>
 *
 * The service contains information belonging to the recipe header, such as status, validity, and creation date, as well
 * as formula data, including a list of ingredients with their quantities. Details of the recipe process, like process
 * elements, process parameters, and equipment requirements are also available in the service. You can also read all
 * classification data pertaining to a recipe..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/69/01bbc0b71d4e5b8c9eb3ad20800eb2/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference:
 * <a href='https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_RECIPE?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_RECIPE</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Product Lifecycle Management - Recipe Development Integration(SAP_COM_0136)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/1QA'>Specification Management for Recipes(1QA)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/1QC'>Formulation - Recipe Development(1QC)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Recipe</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Deprecated
public interface RecipeHeaderAndFormulaService extends BatchService<RecipeHeaderAndFormulaServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_RECIPE";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    RecipeHeaderAndFormulaService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.Recipe Recipe}
     * entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.Recipe Recipe}
     *         entities. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    RecipeFluentHelper getAllRecipe();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.Recipe Recipe}
     * entity using key fields.
     *
     * @param recipeUUID
     *            Common Recipe GUID
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.Recipe Recipe} entity
     *         using key fields. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    RecipeByKeyFluentHelper getRecipeByKey( final UUID recipeUUID );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.Recipe Recipe}
     * entity and save it to the S/4HANA system.
     *
     * @param recipe
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.Recipe Recipe}
     *            entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.Recipe Recipe} entity.
     *         To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    RecipeCreateFluentHelper createRecipe( @Nonnull final Recipe recipe );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.Recipe
     * Recipe} entity and save it to the S/4HANA system.
     *
     * @param recipe
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.Recipe Recipe}
     *            entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.Recipe Recipe} entity.
     *         To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    RecipeUpdateFluentHelper updateRecipe( @Nonnull final Recipe recipe );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.Recipe
     * Recipe} entity in the S/4HANA system.
     *
     * @param recipe
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.Recipe Recipe}
     *            entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.Recipe Recipe} entity.
     *         To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    RecipeDeleteFluentHelper deleteRecipe( @Nonnull final Recipe recipe );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeCharc
     * RecipeCharc} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeCharc
     *         RecipeCharc} entities. This fluent helper allows methods which modify the underlying query to be called
     *         before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeCharcFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    RecipeCharcFluentHelper getAllRecipeCharc();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeCharc
     * RecipeCharc} entity using key fields.
     *
     * @param charcInternalID
     *            Characteristic Internal ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param recipeUUID
     *            Common Recipe GUID
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @param classType
     *            Class Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeCharc
     *         RecipeCharc} entity using key fields. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeCharcByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    RecipeCharcByKeyFluentHelper
        getRecipeCharcByKey( final UUID recipeUUID, final String charcInternalID, final String classType );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeCharcValue
     * RecipeCharcValue} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeCharcValue
     *         RecipeCharcValue} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeCharcValueFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    RecipeCharcValueFluentHelper getAllRecipeCharcValue();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeCharcValue
     * RecipeCharcValue} entity using key fields.
     *
     * @param charcValuePositionNumber
     *            Characteristic value counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @param charcInternalID
     *            Characteristic Internal ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param recipeUUID
     *            Common Recipe GUID
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @param classType
     *            Class Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeCharcValue
     *         RecipeCharcValue} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeCharcValueByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    RecipeCharcValueByKeyFluentHelper getRecipeCharcValueByKey(
        final UUID recipeUUID,
        final String classType,
        final String charcInternalID,
        final String charcValuePositionNumber );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeClass
     * RecipeClass} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeClass
     *         RecipeClass} entities. This fluent helper allows methods which modify the underlying query to be called
     *         before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeClassFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    RecipeClassFluentHelper getAllRecipeClass();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeClass
     * RecipeClass} entity using key fields.
     *
     * @param recipeUUID
     *            Common Recipe GUID
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @param classInternalID
     *            Internal Class Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeClass
     *         RecipeClass} entity using key fields. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeClassByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    RecipeClassByKeyFluentHelper getRecipeClassByKey( final UUID recipeUUID, final String classInternalID );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeClassCharc
     * RecipeClassCharc} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeClassCharc
     *         RecipeClassCharc} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeClassCharcFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    RecipeClassCharcFluentHelper getAllRecipeClassCharc();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeClassCharc
     * RecipeClassCharc} entity using key fields.
     *
     * @param charcInternalID
     *            Characteristic Internal ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param recipeUUID
     *            Common Recipe GUID
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @param classInternalID
     *            Internal Class Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeClassCharc
     *         RecipeClassCharc} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeClassCharcByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    RecipeClassCharcByKeyFluentHelper
        getRecipeClassCharcByKey( final UUID recipeUUID, final String classInternalID, final String charcInternalID );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeFormulaItem
     * RecipeFormulaItem} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeFormulaItem
     *         RecipeFormulaItem} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeFormulaItemFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    RecipeFormulaItemFluentHelper getAllRecipeFormulaItem();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeFormulaItem
     * RecipeFormulaItem} entity using key fields.
     *
     * @param rcpFmlaItemUUID
     *            Formula Item GUID
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeFormulaItem
     *         RecipeFormulaItem} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeFormulaItemByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    RecipeFormulaItemByKeyFluentHelper getRecipeFormulaItemByKey( final UUID rcpFmlaItemUUID );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeFormulaItem
     * RecipeFormulaItem} entity and save it to the S/4HANA system.
     *
     * @param recipeFormulaItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeFormulaItem
     *            RecipeFormulaItem} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeFormulaItem
     *         RecipeFormulaItem} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeFormulaItemCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    RecipeFormulaItemCreateFluentHelper createRecipeFormulaItem( @Nonnull final RecipeFormulaItem recipeFormulaItem );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeFormulaItem
     * RecipeFormulaItem} entity and save it to the S/4HANA system.
     *
     * @param recipeFormulaItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeFormulaItem
     *            RecipeFormulaItem} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeFormulaItem
     *         RecipeFormulaItem} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeFormulaItemUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    RecipeFormulaItemUpdateFluentHelper updateRecipeFormulaItem( @Nonnull final RecipeFormulaItem recipeFormulaItem );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeFormulaItem
     * RecipeFormulaItem} entity in the S/4HANA system.
     *
     * @param recipeFormulaItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeFormulaItem
     *            RecipeFormulaItem} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeFormulaItem
     *         RecipeFormulaItem} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeFormulaItemDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    RecipeFormulaItemDeleteFluentHelper deleteRecipeFormulaItem( @Nonnull final RecipeFormulaItem recipeFormulaItem );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessElement
     * RecipeProcessElement} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessElement
     *         RecipeProcessElement} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessElementFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    RecipeProcessElementFluentHelper getAllRecipeProcessElement();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessElement
     * RecipeProcessElement} entity using key fields.
     *
     * @param recipeProcessElementUUID
     *            Process Element GUID
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessElement
     *         RecipeProcessElement} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessElementByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    RecipeProcessElementByKeyFluentHelper getRecipeProcessElementByKey( final UUID recipeProcessElementUUID );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessElement
     * RecipeProcessElement} entity and save it to the S/4HANA system.
     *
     * @param recipeProcessElement
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessElement
     *            RecipeProcessElement} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessElement
     *         RecipeProcessElement} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessElementCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    RecipeProcessElementCreateFluentHelper
        createRecipeProcessElement( @Nonnull final RecipeProcessElement recipeProcessElement );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessElement
     * RecipeProcessElement} entity and save it to the S/4HANA system.
     *
     * @param recipeProcessElement
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessElement
     *            RecipeProcessElement} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessElement
     *         RecipeProcessElement} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessElementUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    RecipeProcessElementUpdateFluentHelper
        updateRecipeProcessElement( @Nonnull final RecipeProcessElement recipeProcessElement );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessElement
     * RecipeProcessElement} entity in the S/4HANA system.
     *
     * @param recipeProcessElement
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessElement
     *            RecipeProcessElement} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessElement
     *         RecipeProcessElement} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessElementDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    RecipeProcessElementDeleteFluentHelper
        deleteRecipeProcessElement( @Nonnull final RecipeProcessElement recipeProcessElement );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessElementText
     * RecipeProcessElementText} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessElementText
     *         RecipeProcessElementText} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessElementTextFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    RecipeProcessElementTextFluentHelper getAllRecipeProcessElementText();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessElementText
     * RecipeProcessElementText} entity using key fields.
     *
     * @param recipeProcessElementUUID
     *            Process Element GUID
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessElementText
     *         RecipeProcessElementText} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessElementTextByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    RecipeProcessElementTextByKeyFluentHelper
        getRecipeProcessElementTextByKey( final UUID recipeProcessElementUUID, final String language );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessElementText
     * RecipeProcessElementText} entity and save it to the S/4HANA system.
     *
     * @param recipeProcessElementText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessElementText
     *            RecipeProcessElementText} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessElementText
     *         RecipeProcessElementText} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessElementTextCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    RecipeProcessElementTextCreateFluentHelper
        createRecipeProcessElementText( @Nonnull final RecipeProcessElementText recipeProcessElementText );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessElementText
     * RecipeProcessElementText} entity and save it to the S/4HANA system.
     *
     * @param recipeProcessElementText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessElementText
     *            RecipeProcessElementText} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessElementText
     *         RecipeProcessElementText} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessElementTextUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    RecipeProcessElementTextUpdateFluentHelper
        updateRecipeProcessElementText( @Nonnull final RecipeProcessElementText recipeProcessElementText );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessElementText
     * RecipeProcessElementText} entity in the S/4HANA system.
     *
     * @param recipeProcessElementText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessElementText
     *            RecipeProcessElementText} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessElementText
     *         RecipeProcessElementText} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessElementTextDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    RecipeProcessElementTextDeleteFluentHelper
        deleteRecipeProcessElementText( @Nonnull final RecipeProcessElementText recipeProcessElementText );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessEquipRqmt
     * RecipeProcessEquipRqmt} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessEquipRqmt
     *         RecipeProcessEquipRqmt} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessEquipRqmtFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    RecipeProcessEquipRqmtFluentHelper getAllRecipeProcessEquipRqmt();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessEquipRqmt
     * RecipeProcessEquipRqmt} entity using key fields.
     *
     * @param recipeProcessEquipRqmtUUID
     *            Equipment Requirement GUID
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessEquipRqmt
     *         RecipeProcessEquipRqmt} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessEquipRqmtByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    RecipeProcessEquipRqmtByKeyFluentHelper getRecipeProcessEquipRqmtByKey( final UUID recipeProcessEquipRqmtUUID );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessEquipRqmt
     * RecipeProcessEquipRqmt} entity and save it to the S/4HANA system.
     *
     * @param recipeProcessEquipRqmt
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessEquipRqmt
     *            RecipeProcessEquipRqmt} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessEquipRqmt
     *         RecipeProcessEquipRqmt} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessEquipRqmtCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    RecipeProcessEquipRqmtCreateFluentHelper
        createRecipeProcessEquipRqmt( @Nonnull final RecipeProcessEquipRqmt recipeProcessEquipRqmt );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessEquipRqmt
     * RecipeProcessEquipRqmt} entity and save it to the S/4HANA system.
     *
     * @param recipeProcessEquipRqmt
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessEquipRqmt
     *            RecipeProcessEquipRqmt} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessEquipRqmt
     *         RecipeProcessEquipRqmt} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessEquipRqmtUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    RecipeProcessEquipRqmtUpdateFluentHelper
        updateRecipeProcessEquipRqmt( @Nonnull final RecipeProcessEquipRqmt recipeProcessEquipRqmt );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessEquipRqmt
     * RecipeProcessEquipRqmt} entity in the S/4HANA system.
     *
     * @param recipeProcessEquipRqmt
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessEquipRqmt
     *            RecipeProcessEquipRqmt} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessEquipRqmt
     *         RecipeProcessEquipRqmt} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessEquipRqmtDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    RecipeProcessEquipRqmtDeleteFluentHelper
        deleteRecipeProcessEquipRqmt( @Nonnull final RecipeProcessEquipRqmt recipeProcessEquipRqmt );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessEquipRqmtText
     * RecipeProcessEquipRqmtText} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessEquipRqmtText
     *         RecipeProcessEquipRqmtText} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessEquipRqmtTextFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    RecipeProcessEquipRqmtTextFluentHelper getAllRecipeProcessEquipRqmtText();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessEquipRqmtText
     * RecipeProcessEquipRqmtText} entity using key fields.
     *
     * @param recipeProcessEquipRqmtUUID
     *            Equipment Requirement GUID
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessEquipRqmtText
     *         RecipeProcessEquipRqmtText} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessEquipRqmtTextByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    RecipeProcessEquipRqmtTextByKeyFluentHelper
        getRecipeProcessEquipRqmtTextByKey( final UUID recipeProcessEquipRqmtUUID, final String language );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessEquipRqmtText
     * RecipeProcessEquipRqmtText} entity and save it to the S/4HANA system.
     *
     * @param recipeProcessEquipRqmtText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessEquipRqmtText
     *            RecipeProcessEquipRqmtText} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessEquipRqmtText
     *         RecipeProcessEquipRqmtText} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessEquipRqmtTextCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    RecipeProcessEquipRqmtTextCreateFluentHelper
        createRecipeProcessEquipRqmtText( @Nonnull final RecipeProcessEquipRqmtText recipeProcessEquipRqmtText );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessEquipRqmtText
     * RecipeProcessEquipRqmtText} entity and save it to the S/4HANA system.
     *
     * @param recipeProcessEquipRqmtText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessEquipRqmtText
     *            RecipeProcessEquipRqmtText} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessEquipRqmtText
     *         RecipeProcessEquipRqmtText} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessEquipRqmtTextUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    RecipeProcessEquipRqmtTextUpdateFluentHelper
        updateRecipeProcessEquipRqmtText( @Nonnull final RecipeProcessEquipRqmtText recipeProcessEquipRqmtText );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessEquipRqmtText
     * RecipeProcessEquipRqmtText} entity in the S/4HANA system.
     *
     * @param recipeProcessEquipRqmtText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessEquipRqmtText
     *            RecipeProcessEquipRqmtText} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessEquipRqmtText
     *         RecipeProcessEquipRqmtText} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessEquipRqmtTextDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    RecipeProcessEquipRqmtTextDeleteFluentHelper
        deleteRecipeProcessEquipRqmtText( @Nonnull final RecipeProcessEquipRqmtText recipeProcessEquipRqmtText );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessParam
     * RecipeProcessParam} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessParam
     *         RecipeProcessParam} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessParamFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    RecipeProcessParamFluentHelper getAllRecipeProcessParam();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessParam
     * RecipeProcessParam} entity using key fields.
     *
     * @param recipeProcessParamUUID
     *            Process Parameter Master Data Key
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessParam
     *         RecipeProcessParam} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessParamByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    RecipeProcessParamByKeyFluentHelper getRecipeProcessParamByKey( final UUID recipeProcessParamUUID );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessParamText
     * RecipeProcessParamText} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessParamText
     *         RecipeProcessParamText} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessParamTextFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    RecipeProcessParamTextFluentHelper getAllRecipeProcessParamText();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessParamText
     * RecipeProcessParamText} entity using key fields.
     *
     * @param recipeProcessParamUUID
     *            Process Parameter Master Data Key
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessParamText
     *         RecipeProcessParamText} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessParamTextByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    RecipeProcessParamTextByKeyFluentHelper
        getRecipeProcessParamTextByKey( final UUID recipeProcessParamUUID, final String language );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessParamValue
     * RecipeProcessParamValue} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessParamValue
     *         RecipeProcessParamValue} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessParamValueFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    RecipeProcessParamValueFluentHelper getAllRecipeProcessParamValue();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessParamValue
     * RecipeProcessParamValue} entity using key fields.
     *
     * @param recipeProcessParamValUUID
     *            Process Parameter Value Key
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessParamValue
     *         RecipeProcessParamValue} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessParamValueByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    RecipeProcessParamValueByKeyFluentHelper getRecipeProcessParamValueByKey( final UUID recipeProcessParamValUUID );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessParamValue
     * RecipeProcessParamValue} entity and save it to the S/4HANA system.
     *
     * @param recipeProcessParamValue
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessParamValue
     *            RecipeProcessParamValue} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessParamValue
     *         RecipeProcessParamValue} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessParamValueCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    RecipeProcessParamValueCreateFluentHelper
        createRecipeProcessParamValue( @Nonnull final RecipeProcessParamValue recipeProcessParamValue );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessParamValue
     * RecipeProcessParamValue} entity and save it to the S/4HANA system.
     *
     * @param recipeProcessParamValue
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessParamValue
     *            RecipeProcessParamValue} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessParamValue
     *         RecipeProcessParamValue} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessParamValueUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    RecipeProcessParamValueUpdateFluentHelper
        updateRecipeProcessParamValue( @Nonnull final RecipeProcessParamValue recipeProcessParamValue );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessParamValue
     * RecipeProcessParamValue} entity in the S/4HANA system.
     *
     * @param recipeProcessParamValue
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessParamValue
     *            RecipeProcessParamValue} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessParamValue
     *         RecipeProcessParamValue} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessParamValueDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    RecipeProcessParamValueDeleteFluentHelper
        deleteRecipeProcessParamValue( @Nonnull final RecipeProcessParamValue recipeProcessParamValue );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessParamValueTxt
     * RecipeProcessParamValueTxt} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessParamValueTxt
     *         RecipeProcessParamValueTxt} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessParamValueTxtFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    RecipeProcessParamValueTxtFluentHelper getAllRecipeProcessParamValueTxt();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessParamValueTxt
     * RecipeProcessParamValueTxt} entity using key fields.
     *
     * @param recipeProcessParamValUUID
     *            Process Parameter Value Key
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessParamValueTxt
     *         RecipeProcessParamValueTxt} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessParamValueTxtByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    RecipeProcessParamValueTxtByKeyFluentHelper
        getRecipeProcessParamValueTxtByKey( final UUID recipeProcessParamValUUID, final String language );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessParamValueTxt
     * RecipeProcessParamValueTxt} entity and save it to the S/4HANA system.
     *
     * @param recipeProcessParamValueTxt
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessParamValueTxt
     *            RecipeProcessParamValueTxt} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessParamValueTxt
     *         RecipeProcessParamValueTxt} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessParamValueTxtCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    RecipeProcessParamValueTxtCreateFluentHelper
        createRecipeProcessParamValueTxt( @Nonnull final RecipeProcessParamValueTxt recipeProcessParamValueTxt );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessParamValueTxt
     * RecipeProcessParamValueTxt} entity and save it to the S/4HANA system.
     *
     * @param recipeProcessParamValueTxt
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessParamValueTxt
     *            RecipeProcessParamValueTxt} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessParamValueTxt
     *         RecipeProcessParamValueTxt} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessParamValueTxtUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    RecipeProcessParamValueTxtUpdateFluentHelper
        updateRecipeProcessParamValueTxt( @Nonnull final RecipeProcessParamValueTxt recipeProcessParamValueTxt );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessParamValueTxt
     * RecipeProcessParamValueTxt} entity in the S/4HANA system.
     *
     * @param recipeProcessParamValueTxt
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessParamValueTxt
     *            RecipeProcessParamValueTxt} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessParamValueTxt
     *         RecipeProcessParamValueTxt} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessParamValueTxtDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    RecipeProcessParamValueTxtDeleteFluentHelper
        deleteRecipeProcessParamValueTxt( @Nonnull final RecipeProcessParamValueTxt recipeProcessParamValueTxt );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeText
     * RecipeText} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeText RecipeText}
     *         entities. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeTextFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    RecipeTextFluentHelper getAllRecipeText();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeText
     * RecipeText} entity using key fields.
     *
     * @param recipeUUID
     *            Common Recipe GUID
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeText RecipeText}
     *         entity using key fields. This fluent helper allows methods which modify the underlying query to be called
     *         before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeTextByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    RecipeTextByKeyFluentHelper getRecipeTextByKey( final UUID recipeUUID, final String language );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeText
     * RecipeText} entity and save it to the S/4HANA system.
     *
     * @param recipeText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeText
     *            RecipeText} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeText RecipeText}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeTextCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    RecipeTextCreateFluentHelper createRecipeText( @Nonnull final RecipeText recipeText );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeText
     * RecipeText} entity and save it to the S/4HANA system.
     *
     * @param recipeText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeText
     *            RecipeText} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeText RecipeText}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeTextUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    RecipeTextUpdateFluentHelper updateRecipeText( @Nonnull final RecipeText recipeText );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeText
     * RecipeText} entity in the S/4HANA system.
     *
     * @param recipeText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeText
     *            RecipeText} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeText RecipeText}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeTextDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    RecipeTextDeleteFluentHelper deleteRecipeText( @Nonnull final RecipeText recipeText );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecProcEquipRqmtCharc
     * RecProcEquipRqmtCharc} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecProcEquipRqmtCharc
     *         RecProcEquipRqmtCharc} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecProcEquipRqmtCharcFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    RecProcEquipRqmtCharcFluentHelper getAllRecProcEquipRqmtCharc();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecProcEquipRqmtCharc
     * RecProcEquipRqmtCharc} entity using key fields.
     *
     * @param recipeProcessEquipRqmtUUID
     *            Equipment Requirement GUID
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @param charcInternalID
     *            Characteristic Internal ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param classType
     *            Class Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecProcEquipRqmtCharc
     *         RecProcEquipRqmtCharc} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecProcEquipRqmtCharcByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    RecProcEquipRqmtCharcByKeyFluentHelper getRecProcEquipRqmtCharcByKey(
        final UUID recipeProcessEquipRqmtUUID,
        final String charcInternalID,
        final String classType );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecProcEquipRqmtCharcValue
     * RecProcEquipRqmtCharcValue} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecProcEquipRqmtCharcValue
     *         RecProcEquipRqmtCharcValue} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecProcEquipRqmtCharcValueFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    RecProcEquipRqmtCharcValueFluentHelper getAllRecProcEquipRqmtCharcValue();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecProcEquipRqmtCharcValue
     * RecProcEquipRqmtCharcValue} entity using key fields.
     *
     * @param recipeProcessEquipRqmtUUID
     *            Equipment Requirement GUID
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @param charcValuePositionNumber
     *            Characteristic value counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @param charcInternalID
     *            Characteristic Internal ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param classType
     *            Class Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecProcEquipRqmtCharcValue
     *         RecProcEquipRqmtCharcValue} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecProcEquipRqmtCharcValueByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    RecProcEquipRqmtCharcValueByKeyFluentHelper getRecProcEquipRqmtCharcValueByKey(
        final UUID recipeProcessEquipRqmtUUID,
        final String classType,
        final String charcInternalID,
        final String charcValuePositionNumber );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecProcEquipRqmtClass
     * RecProcEquipRqmtClass} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecProcEquipRqmtClass
     *         RecProcEquipRqmtClass} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecProcEquipRqmtClassFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    RecProcEquipRqmtClassFluentHelper getAllRecProcEquipRqmtClass();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecProcEquipRqmtClass
     * RecProcEquipRqmtClass} entity using key fields.
     *
     * @param recipeProcessEquipRqmtUUID
     *            Equipment Requirement GUID
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @param classInternalID
     *            Internal Class Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecProcEquipRqmtClass
     *         RecProcEquipRqmtClass} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecProcEquipRqmtClassByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    RecProcEquipRqmtClassByKeyFluentHelper
        getRecProcEquipRqmtClassByKey( final UUID recipeProcessEquipRqmtUUID, final String classInternalID );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecProcEquipRqmtClassCharc
     * RecProcEquipRqmtClassCharc} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecProcEquipRqmtClassCharc
     *         RecProcEquipRqmtClassCharc} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecProcEquipRqmtClassCharcFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    RecProcEquipRqmtClassCharcFluentHelper getAllRecProcEquipRqmtClassCharc();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecProcEquipRqmtClassCharc
     * RecProcEquipRqmtClassCharc} entity using key fields.
     *
     * @param recipeProcessEquipRqmtUUID
     *            Equipment Requirement GUID
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @param charcInternalID
     *            Characteristic Internal ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param classInternalID
     *            Internal Class Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecProcEquipRqmtClassCharc
     *         RecProcEquipRqmtClassCharc} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecProcEquipRqmtClassCharcByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    RecProcEquipRqmtClassCharcByKeyFluentHelper getRecProcEquipRqmtClassCharcByKey(
        final UUID recipeProcessEquipRqmtUUID,
        final String classInternalID,
        final String charcInternalID );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecProcParamValCharc
     * RecProcParamValCharc} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecProcParamValCharc
     *         RecProcParamValCharc} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecProcParamValCharcFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    RecProcParamValCharcFluentHelper getAllRecProcParamValCharc();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecProcParamValCharc
     * RecProcParamValCharc} entity using key fields.
     *
     * @param charcInternalID
     *            Characteristic Internal ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param recipeProcessParamValUUID
     *            Process Parameter Value Key
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @param classType
     *            Class Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecProcParamValCharc
     *         RecProcParamValCharc} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecProcParamValCharcByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    RecProcParamValCharcByKeyFluentHelper getRecProcParamValCharcByKey(
        final UUID recipeProcessParamValUUID,
        final String charcInternalID,
        final String classType );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecProcParamValCharcValue
     * RecProcParamValCharcValue} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecProcParamValCharcValue
     *         RecProcParamValCharcValue} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecProcParamValCharcValueFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    RecProcParamValCharcValueFluentHelper getAllRecProcParamValCharcValue();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecProcParamValCharcValue
     * RecProcParamValCharcValue} entity using key fields.
     *
     * @param charcValuePositionNumber
     *            Characteristic value counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @param charcInternalID
     *            Characteristic Internal ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param recipeProcessParamValUUID
     *            Process Parameter Value Key
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @param classType
     *            Class Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecProcParamValCharcValue
     *         RecProcParamValCharcValue} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecProcParamValCharcValueByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    RecProcParamValCharcValueByKeyFluentHelper getRecProcParamValCharcValueByKey(
        final UUID recipeProcessParamValUUID,
        final String classType,
        final String charcInternalID,
        final String charcValuePositionNumber );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecProcParamValClass
     * RecProcParamValClass} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecProcParamValClass
     *         RecProcParamValClass} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecProcParamValClassFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    RecProcParamValClassFluentHelper getAllRecProcParamValClass();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecProcParamValClass
     * RecProcParamValClass} entity using key fields.
     *
     * @param recipeProcessParamValUUID
     *            Process Parameter Value Key
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @param classInternalID
     *            Internal Class Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecProcParamValClass
     *         RecProcParamValClass} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecProcParamValClassByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    RecProcParamValClassByKeyFluentHelper
        getRecProcParamValClassByKey( final UUID recipeProcessParamValUUID, final String classInternalID );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecProcParamValClassCharc
     * RecProcParamValClassCharc} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecProcParamValClassCharc
     *         RecProcParamValClassCharc} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecProcParamValClassCharcFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    RecProcParamValClassCharcFluentHelper getAllRecProcParamValClassCharc();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecProcParamValClassCharc
     * RecProcParamValClassCharc} entity using key fields.
     *
     * @param charcInternalID
     *            Characteristic Internal ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param recipeProcessParamValUUID
     *            Process Parameter Value Key
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @param classInternalID
     *            Internal Class Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecProcParamValClassCharc
     *         RecProcParamValClassCharc} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecProcParamValClassCharcByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    RecProcParamValClassCharcByKeyFluentHelper getRecProcParamValClassCharcByKey(
        final UUID recipeProcessParamValUUID,
        final String classInternalID,
        final String charcInternalID );

}
