/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.CancelFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.CompleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotation;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotationBidder;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotationBidderByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotationBidderCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotationBidderDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotationBidderFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotationBidderUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotationByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotationCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotationDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotationFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotationItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotationItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotationItemCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotationItemDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotationItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotationItemUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotationUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.SubmitForApprovalFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.batch.RequestsForQuotationServiceBatch;

/**
 * <p>
 *
 * The service contains header, item, and bidder nodes. The information is sent in the request as a payload. All
 * information is utilized when creating an RFQ with appropriate checks for restricted values and authorizations. Once
 * the RFQ has been successfully created, the RFQ number is sent in the response with the data included in the RFQ. If
 * any issues arise when the RFQ is created, the system displays error messages in the response. .
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/07/47b64b221046a08c552f55a4b9d292/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_RFQ_PROCESS_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_RFQ_PROCESS_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Distributed Manufacturing Integration(SAP_COM_0077), Purchase Request for Quotation
 * Integration(SAP_COM_0113)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/1NX'>Collaborative Manufacturing with SAP Digital Manufacturing
 * Cloud(1NX)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/BNX'>Consumable Purchasing(BNX)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/ONX'>Consumable Purchasing(ONX)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/1A0'>Sourcing with SAP Ariba Sourcing(1A0)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/1L2'>Supplier Quote Automation with SAP Ariba Commerce
 * Automation(1L2)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/1XF'>Request for Price(1XF)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OA0'>Sourcing with SAP Ariba Sourcing(OA0)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OXF'>Request for Price(OXF)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Request For Quotation</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Deprecated
public interface RequestsForQuotationService extends BatchService<RequestsForQuotationServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_RFQ_PROCESS_SRV";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    RequestsForQuotationService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotation
     * RequestForQuotation} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotation
     *         RequestForQuotation} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotationFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    RequestForQuotationFluentHelper getAllRequestForQuotation();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotation
     * RequestForQuotation} entity using key fields.
     *
     * @param requestForQuotation
     *            Request for Quotation
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotation
     *         RequestForQuotation} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotationByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    RequestForQuotationByKeyFluentHelper getRequestForQuotationByKey( final String requestForQuotation );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotation
     * RequestForQuotation} entity and save it to the S/4HANA system.
     *
     * @param requestForQuotation
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotation
     *            RequestForQuotation} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotation
     *         RequestForQuotation} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotationCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    RequestForQuotationCreateFluentHelper
        createRequestForQuotation( @Nonnull final RequestForQuotation requestForQuotation );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotation
     * RequestForQuotation} entity and save it to the S/4HANA system.
     *
     * @param requestForQuotation
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotation
     *            RequestForQuotation} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotation
     *         RequestForQuotation} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotationUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    RequestForQuotationUpdateFluentHelper
        updateRequestForQuotation( @Nonnull final RequestForQuotation requestForQuotation );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotation
     * RequestForQuotation} entity in the S/4HANA system.
     *
     * @param requestForQuotation
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotation
     *            RequestForQuotation} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotation
     *         RequestForQuotation} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotationDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    RequestForQuotationDeleteFluentHelper
        deleteRequestForQuotation( @Nonnull final RequestForQuotation requestForQuotation );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotationBidder
     * RequestForQuotationBidder} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotationBidder
     *         RequestForQuotationBidder} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotationBidderFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    RequestForQuotationBidderFluentHelper getAllRequestForQuotationBidder();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotationBidder
     * RequestForQuotationBidder} entity using key fields.
     *
     * @param partnerCounter
     *            Partner counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @param requestForQuotation
     *            Purchasing Document Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotationBidder
     *         RequestForQuotationBidder} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotationBidderByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    RequestForQuotationBidderByKeyFluentHelper
        getRequestForQuotationBidderByKey( final String requestForQuotation, final String partnerCounter );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotationBidder
     * RequestForQuotationBidder} entity and save it to the S/4HANA system.
     *
     * @param requestForQuotationBidder
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotationBidder
     *            RequestForQuotationBidder} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotationBidder
     *         RequestForQuotationBidder} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotationBidderCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    RequestForQuotationBidderCreateFluentHelper
        createRequestForQuotationBidder( @Nonnull final RequestForQuotationBidder requestForQuotationBidder );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotationBidder
     * RequestForQuotationBidder} entity and save it to the S/4HANA system.
     *
     * @param requestForQuotationBidder
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotationBidder
     *            RequestForQuotationBidder} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotationBidder
     *         RequestForQuotationBidder} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotationBidderUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    RequestForQuotationBidderUpdateFluentHelper
        updateRequestForQuotationBidder( @Nonnull final RequestForQuotationBidder requestForQuotationBidder );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotationBidder
     * RequestForQuotationBidder} entity in the S/4HANA system.
     *
     * @param requestForQuotationBidder
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotationBidder
     *            RequestForQuotationBidder} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotationBidder
     *         RequestForQuotationBidder} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotationBidderDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    RequestForQuotationBidderDeleteFluentHelper
        deleteRequestForQuotationBidder( @Nonnull final RequestForQuotationBidder requestForQuotationBidder );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotationItem
     * RequestForQuotationItem} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotationItem
     *         RequestForQuotationItem} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotationItemFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    RequestForQuotationItemFluentHelper getAllRequestForQuotationItem();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotationItem
     * RequestForQuotationItem} entity using key fields.
     *
     * @param requestForQuotationItem
     *            Item Number of Request For Quotation
     *            <p>
     *            Constraints: Not nullable, Maximum length: 5
     *            </p>
     * @param requestForQuotation
     *            Purchasing Document Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotationItem
     *         RequestForQuotationItem} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotationItemByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    RequestForQuotationItemByKeyFluentHelper
        getRequestForQuotationItemByKey( final String requestForQuotationItem, final String requestForQuotation );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotationItem
     * RequestForQuotationItem} entity and save it to the S/4HANA system.
     *
     * @param requestForQuotationItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotationItem
     *            RequestForQuotationItem} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotationItem
     *         RequestForQuotationItem} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotationItemCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    RequestForQuotationItemCreateFluentHelper
        createRequestForQuotationItem( @Nonnull final RequestForQuotationItem requestForQuotationItem );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotationItem
     * RequestForQuotationItem} entity and save it to the S/4HANA system.
     *
     * @param requestForQuotationItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotationItem
     *            RequestForQuotationItem} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotationItem
     *         RequestForQuotationItem} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotationItemUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    RequestForQuotationItemUpdateFluentHelper
        updateRequestForQuotationItem( @Nonnull final RequestForQuotationItem requestForQuotationItem );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotationItem
     * RequestForQuotationItem} entity in the S/4HANA system.
     *
     * @param requestForQuotationItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotationItem
     *            RequestForQuotationItem} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotationItem
     *         RequestForQuotationItem} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.RequestForQuotationItemDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    RequestForQuotationItemDeleteFluentHelper
        deleteRequestForQuotationItem( @Nonnull final RequestForQuotationItem requestForQuotationItem );

    /**
     * <p>
     * Creates a fluent helper for the <b>Complete</b> OData function import.
     * </p>
     *
     * @param requestForQuotation
     *            Request for Quotation
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>RequestForQuotation</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>Complete</b> OData function import with the provided
     *         parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.CompleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CompleteFluentHelper complete( @Nonnull final String requestForQuotation );

    /**
     * <p>
     * Creates a fluent helper for the <b>Cancel</b> OData function import.
     * </p>
     *
     * @param requestForQuotation
     *            Request for Quotation
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>RequestForQuotation</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>Cancel</b> OData function import with the provided
     *         parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.CancelFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CancelFluentHelper cancel( @Nonnull final String requestForQuotation );

    /**
     * <p>
     * Creates a fluent helper for the <b>SubmitForApproval</b> OData function import.
     * </p>
     *
     * @param requestForQuotation
     *            Request for Quotation
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>RequestForQuotation</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>SubmitForApproval</b> OData function import with the
     *         provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.requestsforquotation.SubmitForApprovalFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SubmitForApprovalFluentHelper submitForApproval( @Nonnull final String requestForQuotation );

}
