/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.reservationdocument.ReservationDocumentHeader;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.reservationdocument.ReservationDocumentHeaderByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.reservationdocument.ReservationDocumentHeaderCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.reservationdocument.ReservationDocumentHeaderDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.reservationdocument.ReservationDocumentHeaderFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.reservationdocument.ReservationDocumentItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.reservationdocument.ReservationDocumentItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.reservationdocument.batch.ReservationDocumentServiceBatch;

/**
 * <p>
 *
 * For example, a user might create a reservation for a material with some quantity and assign that reserved material to
 * a cost center, a sales order or an asset. A reservation can also be created for a transfer posting from one plant to
 * another. For an existing reservation, you can change the updatable fields of the items. The service also allows to
 * delete existing reservation documents. It can be consumed by external systems and user interfaces..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/51/86af9bebab426984f5c399a5b2664b/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_RESERVATION_DOCUMENT_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_RESERVATION_DOCUMENT_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Reservation Integration(SAP_COM_0112)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/BMC'>Core Inventory Management(BMC)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OMC'>Core Inventory Management(OMC)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Reservation Document</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Deprecated
public interface ReservationDocumentService extends BatchService<ReservationDocumentServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_RESERVATION_DOCUMENT_SRV";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    ReservationDocumentService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.reservationdocument.ReservationDocumentHeader
     * ReservationDocumentHeader} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.reservationdocument.ReservationDocumentHeader
     *         ReservationDocumentHeader} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.reservationdocument.ReservationDocumentHeaderFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ReservationDocumentHeaderFluentHelper getAllReservationDocumentHeader();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.reservationdocument.ReservationDocumentHeader
     * ReservationDocumentHeader} entity using key fields.
     *
     * @param reservation
     *            Number of reservation/dependent requirements
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.reservationdocument.ReservationDocumentHeader
     *         ReservationDocumentHeader} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.reservationdocument.ReservationDocumentHeaderByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ReservationDocumentHeaderByKeyFluentHelper getReservationDocumentHeaderByKey( final String reservation );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.reservationdocument.ReservationDocumentHeader
     * ReservationDocumentHeader} entity and save it to the S/4HANA system.
     *
     * @param reservationDocumentHeader
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.reservationdocument.ReservationDocumentHeader
     *            ReservationDocumentHeader} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.reservationdocument.ReservationDocumentHeader
     *         ReservationDocumentHeader} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.reservationdocument.ReservationDocumentHeaderCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ReservationDocumentHeaderCreateFluentHelper
        createReservationDocumentHeader( @Nonnull final ReservationDocumentHeader reservationDocumentHeader );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.reservationdocument.ReservationDocumentHeader
     * ReservationDocumentHeader} entity in the S/4HANA system.
     *
     * @param reservationDocumentHeader
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.reservationdocument.ReservationDocumentHeader
     *            ReservationDocumentHeader} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.reservationdocument.ReservationDocumentHeader
     *         ReservationDocumentHeader} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.reservationdocument.ReservationDocumentHeaderDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ReservationDocumentHeaderDeleteFluentHelper
        deleteReservationDocumentHeader( @Nonnull final ReservationDocumentHeader reservationDocumentHeader );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.reservationdocument.ReservationDocumentItem
     * ReservationDocumentItem} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.reservationdocument.ReservationDocumentItem
     *         ReservationDocumentItem} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.reservationdocument.ReservationDocumentItemFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ReservationDocumentItemFluentHelper getAllReservationDocumentItem();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.reservationdocument.ReservationDocumentItem
     * ReservationDocumentItem} entity using key fields.
     *
     * @param reservationItem
     *            Item Number of Reservation / Dependent Requirements
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param recordType
     *            Record type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     * @param reservation
     *            Number of reservation/dependent requirements
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.reservationdocument.ReservationDocumentItem
     *         ReservationDocumentItem} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.reservationdocument.ReservationDocumentItemByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ReservationDocumentItemByKeyFluentHelper getReservationDocumentItemByKey(
        final String reservation,
        final String reservationItem,
        final String recordType );

}
