/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.RejectApprovalRequestFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.ReleaseApprovalRequestFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContract;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItemCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItemDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItemPartner;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItemPartnerByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItemPartnerDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItemPartnerFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItemPartnerUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItemPrcgElmnt;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItemPrcgElmntByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItemPrcgElmntDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItemPrcgElmntFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItemPrcgElmntUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItemText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItemTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItemTextDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItemTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItemTextUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItemUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractPartner;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractPartnerByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractPartnerCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractPartnerDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractPartnerFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractPartnerUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractPrcgElmnt;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractPrcgElmntByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractPrcgElmntDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractPrcgElmntFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractPrcgElmntUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractTextDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractTextUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.batch.SalesContractServiceBatch;

/**
 * <p>
 * The service contains header and item entities, as well as their sub-entities for partners and pricing elements. Once
 * the sales contract has been created, the sales contract number is sent in the response with the data included in the
 * sales contract. If there are any issues when creating, retrieving, updating, or deleting the sales contract, the
 * system displays error messages in the response.
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/bc/2d6c95d98e4b96ae70e7db2de4cca1/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_SALES_CONTRACT_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_SALES_CONTRACT_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Sales Contract Integration(SAP_COM_0119)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/I9I'>Sales Contract Management(I9I)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Sales Contract</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Deprecated
public interface SalesContractService extends BatchService<SalesContractServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_SALES_CONTRACT_SRV";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    SalesContractService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContract
     * SalesContract} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContract SalesContract}
     *         entities. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesContractFluentHelper getAllSalesContract();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContract
     * SalesContract} entity using key fields.
     *
     * @param salesContract
     *            Sales Contract
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContract SalesContract}
     *         entity using key fields. This fluent helper allows methods which modify the underlying query to be called
     *         before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesContractByKeyFluentHelper getSalesContractByKey( final String salesContract );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContract
     * SalesContract} entity and save it to the S/4HANA system.
     *
     * @param salesContract
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContract SalesContract}
     *            entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContract SalesContract}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesContractCreateFluentHelper createSalesContract( @Nonnull final SalesContract salesContract );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContract
     * SalesContract} entity and save it to the S/4HANA system.
     *
     * @param salesContract
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContract SalesContract}
     *            entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContract SalesContract}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesContractUpdateFluentHelper updateSalesContract( @Nonnull final SalesContract salesContract );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContract
     * SalesContract} entity in the S/4HANA system.
     *
     * @param salesContract
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContract SalesContract}
     *            entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContract SalesContract}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesContractDeleteFluentHelper deleteSalesContract( @Nonnull final SalesContract salesContract );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItem
     * SalesContractItem} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItem
     *         SalesContractItem} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItemFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesContractItemFluentHelper getAllSalesContractItem();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItem
     * SalesContractItem} entity using key fields.
     *
     * @param salesContractItem
     *            Sales Contract Item
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param salesContract
     *            Sales Contract
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItem
     *         SalesContractItem} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItemByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesContractItemByKeyFluentHelper
        getSalesContractItemByKey( final String salesContract, final String salesContractItem );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItem
     * SalesContractItem} entity and save it to the S/4HANA system.
     *
     * @param salesContractItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItem
     *            SalesContractItem} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItem
     *         SalesContractItem} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItemCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesContractItemCreateFluentHelper createSalesContractItem( @Nonnull final SalesContractItem salesContractItem );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItem
     * SalesContractItem} entity and save it to the S/4HANA system.
     *
     * @param salesContractItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItem
     *            SalesContractItem} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItem
     *         SalesContractItem} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItemUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesContractItemUpdateFluentHelper updateSalesContractItem( @Nonnull final SalesContractItem salesContractItem );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItem
     * SalesContractItem} entity in the S/4HANA system.
     *
     * @param salesContractItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItem
     *            SalesContractItem} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItem
     *         SalesContractItem} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItemDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesContractItemDeleteFluentHelper deleteSalesContractItem( @Nonnull final SalesContractItem salesContractItem );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItemPartner
     * SalesContractItemPartner} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItemPartner
     *         SalesContractItemPartner} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItemPartnerFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesContractItemPartnerFluentHelper getAllSalesContractItemPartner();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItemPartner
     * SalesContractItemPartner} entity using key fields.
     *
     * @param salesContractItem
     *            Sales Contract Item
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param partnerFunction
     *            Partner Function
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param salesContract
     *            Sales Contract
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItemPartner
     *         SalesContractItemPartner} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItemPartnerByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesContractItemPartnerByKeyFluentHelper getSalesContractItemPartnerByKey(
        final String salesContract,
        final String salesContractItem,
        final String partnerFunction );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItemPartner
     * SalesContractItemPartner} entity and save it to the S/4HANA system.
     *
     * @param salesContractItemPartner
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItemPartner
     *            SalesContractItemPartner} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItemPartner
     *         SalesContractItemPartner} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItemPartnerUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesContractItemPartnerUpdateFluentHelper
        updateSalesContractItemPartner( @Nonnull final SalesContractItemPartner salesContractItemPartner );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItemPartner
     * SalesContractItemPartner} entity in the S/4HANA system.
     *
     * @param salesContractItemPartner
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItemPartner
     *            SalesContractItemPartner} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItemPartner
     *         SalesContractItemPartner} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItemPartnerDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesContractItemPartnerDeleteFluentHelper
        deleteSalesContractItemPartner( @Nonnull final SalesContractItemPartner salesContractItemPartner );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItemPrcgElmnt
     * SalesContractItemPrcgElmnt} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItemPrcgElmnt
     *         SalesContractItemPrcgElmnt} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItemPrcgElmntFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesContractItemPrcgElmntFluentHelper getAllSalesContractItemPrcgElmnt();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItemPrcgElmnt
     * SalesContractItemPrcgElmnt} entity using key fields.
     *
     * @param salesContractItem
     *            Sales Contract Item
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param salesContract
     *            Sales Contract
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param pricingProcedureCounter
     *            Condition Counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @param pricingProcedureStep
     *            Step Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItemPrcgElmnt
     *         SalesContractItemPrcgElmnt} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItemPrcgElmntByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesContractItemPrcgElmntByKeyFluentHelper getSalesContractItemPrcgElmntByKey(
        final String salesContract,
        final String salesContractItem,
        final String pricingProcedureStep,
        final String pricingProcedureCounter );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItemPrcgElmnt
     * SalesContractItemPrcgElmnt} entity and save it to the S/4HANA system.
     *
     * @param salesContractItemPrcgElmnt
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItemPrcgElmnt
     *            SalesContractItemPrcgElmnt} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItemPrcgElmnt
     *         SalesContractItemPrcgElmnt} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItemPrcgElmntUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesContractItemPrcgElmntUpdateFluentHelper
        updateSalesContractItemPrcgElmnt( @Nonnull final SalesContractItemPrcgElmnt salesContractItemPrcgElmnt );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItemPrcgElmnt
     * SalesContractItemPrcgElmnt} entity in the S/4HANA system.
     *
     * @param salesContractItemPrcgElmnt
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItemPrcgElmnt
     *            SalesContractItemPrcgElmnt} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItemPrcgElmnt
     *         SalesContractItemPrcgElmnt} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItemPrcgElmntDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesContractItemPrcgElmntDeleteFluentHelper
        deleteSalesContractItemPrcgElmnt( @Nonnull final SalesContractItemPrcgElmnt salesContractItemPrcgElmnt );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItemText
     * SalesContractItemText} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItemText
     *         SalesContractItemText} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItemTextFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesContractItemTextFluentHelper getAllSalesContractItemText();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItemText
     * SalesContractItemText} entity using key fields.
     *
     * @param salesContractItem
     *            Sales Contract Item
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param salesContract
     *            Sales Contract
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param longTextID
     *            Text ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItemText
     *         SalesContractItemText} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItemTextByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesContractItemTextByKeyFluentHelper getSalesContractItemTextByKey(
        final String salesContract,
        final String salesContractItem,
        final String language,
        final String longTextID );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItemText
     * SalesContractItemText} entity and save it to the S/4HANA system.
     *
     * @param salesContractItemText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItemText
     *            SalesContractItemText} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItemText
     *         SalesContractItemText} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItemTextUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesContractItemTextUpdateFluentHelper
        updateSalesContractItemText( @Nonnull final SalesContractItemText salesContractItemText );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItemText
     * SalesContractItemText} entity in the S/4HANA system.
     *
     * @param salesContractItemText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItemText
     *            SalesContractItemText} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItemText
     *         SalesContractItemText} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractItemTextDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesContractItemTextDeleteFluentHelper
        deleteSalesContractItemText( @Nonnull final SalesContractItemText salesContractItemText );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractPartner
     * SalesContractPartner} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractPartner
     *         SalesContractPartner} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractPartnerFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesContractPartnerFluentHelper getAllSalesContractPartner();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractPartner
     * SalesContractPartner} entity using key fields.
     *
     * @param partnerFunction
     *            Partner Function
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param salesContract
     *            Sales Contract
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractPartner
     *         SalesContractPartner} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractPartnerByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesContractPartnerByKeyFluentHelper
        getSalesContractPartnerByKey( final String salesContract, final String partnerFunction );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractPartner
     * SalesContractPartner} entity and save it to the S/4HANA system.
     *
     * @param salesContractPartner
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractPartner
     *            SalesContractPartner} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractPartner
     *         SalesContractPartner} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractPartnerCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesContractPartnerCreateFluentHelper
        createSalesContractPartner( @Nonnull final SalesContractPartner salesContractPartner );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractPartner
     * SalesContractPartner} entity and save it to the S/4HANA system.
     *
     * @param salesContractPartner
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractPartner
     *            SalesContractPartner} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractPartner
     *         SalesContractPartner} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractPartnerUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesContractPartnerUpdateFluentHelper
        updateSalesContractPartner( @Nonnull final SalesContractPartner salesContractPartner );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractPartner
     * SalesContractPartner} entity in the S/4HANA system.
     *
     * @param salesContractPartner
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractPartner
     *            SalesContractPartner} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractPartner
     *         SalesContractPartner} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractPartnerDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesContractPartnerDeleteFluentHelper
        deleteSalesContractPartner( @Nonnull final SalesContractPartner salesContractPartner );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractPrcgElmnt
     * SalesContractPrcgElmnt} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractPrcgElmnt
     *         SalesContractPrcgElmnt} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractPrcgElmntFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesContractPrcgElmntFluentHelper getAllSalesContractPrcgElmnt();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractPrcgElmnt
     * SalesContractPrcgElmnt} entity using key fields.
     *
     * @param salesContract
     *            Sales Contract
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param pricingProcedureCounter
     *            Condition Counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @param pricingProcedureStep
     *            Step Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractPrcgElmnt
     *         SalesContractPrcgElmnt} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractPrcgElmntByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesContractPrcgElmntByKeyFluentHelper getSalesContractPrcgElmntByKey(
        final String salesContract,
        final String pricingProcedureStep,
        final String pricingProcedureCounter );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractPrcgElmnt
     * SalesContractPrcgElmnt} entity and save it to the S/4HANA system.
     *
     * @param salesContractPrcgElmnt
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractPrcgElmnt
     *            SalesContractPrcgElmnt} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractPrcgElmnt
     *         SalesContractPrcgElmnt} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractPrcgElmntUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesContractPrcgElmntUpdateFluentHelper
        updateSalesContractPrcgElmnt( @Nonnull final SalesContractPrcgElmnt salesContractPrcgElmnt );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractPrcgElmnt
     * SalesContractPrcgElmnt} entity in the S/4HANA system.
     *
     * @param salesContractPrcgElmnt
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractPrcgElmnt
     *            SalesContractPrcgElmnt} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractPrcgElmnt
     *         SalesContractPrcgElmnt} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractPrcgElmntDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesContractPrcgElmntDeleteFluentHelper
        deleteSalesContractPrcgElmnt( @Nonnull final SalesContractPrcgElmnt salesContractPrcgElmnt );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractText
     * SalesContractText} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractText
     *         SalesContractText} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractTextFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesContractTextFluentHelper getAllSalesContractText();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractText
     * SalesContractText} entity using key fields.
     *
     * @param salesContract
     *            Sales Contract
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param longTextID
     *            Text ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractText
     *         SalesContractText} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractTextByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesContractTextByKeyFluentHelper
        getSalesContractTextByKey( final String salesContract, final String language, final String longTextID );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractText
     * SalesContractText} entity and save it to the S/4HANA system.
     *
     * @param salesContractText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractText
     *            SalesContractText} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractText
     *         SalesContractText} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractTextUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesContractTextUpdateFluentHelper updateSalesContractText( @Nonnull final SalesContractText salesContractText );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractText
     * SalesContractText} entity in the S/4HANA system.
     *
     * @param salesContractText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractText
     *            SalesContractText} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractText
     *         SalesContractText} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.SalesContractTextDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesContractTextDeleteFluentHelper deleteSalesContractText( @Nonnull final SalesContractText salesContractText );

    /**
     * <p>
     * Creates a fluent helper for the <b>releaseApprovalRequest</b> OData function import.
     * </p>
     *
     * @param salesContract
     *            Constraints: Not nullable, Maximum length: 10
     *            <p>
     *            Original parameter name from the Odata EDM: <b>SalesContract</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>releaseApprovalRequest</b> OData function import with the
     *         provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.ReleaseApprovalRequestFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ReleaseApprovalRequestFluentHelper releaseApprovalRequest( @Nonnull final String salesContract );

    /**
     * <p>
     * Creates a fluent helper for the <b>rejectApprovalRequest</b> OData function import.
     * </p>
     *
     * @param salesContract
     *            Constraints: Not nullable, Maximum length: 10
     *            <p>
     *            Original parameter name from the Odata EDM: <b>SalesContract</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>rejectApprovalRequest</b> OData function import with the
     *         provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salescontract.RejectApprovalRequestFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    RejectApprovalRequestFluentHelper rejectApprovalRequest( @Nonnull final String salesContract );

}
