/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesdocumentwithcreditblocks.CheckCreditBlockFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesdocumentwithcreditblocks.CreditBlockedSalesDocumentByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesdocumentwithcreditblocks.CreditBlockedSalesDocumentFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesdocumentwithcreditblocks.RejectCreditBlockFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesdocumentwithcreditblocks.ReleaseCreditBlockFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesdocumentwithcreditblocks.SalesDocumentRjcnReasonByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesdocumentwithcreditblocks.SalesDocumentRjcnReasonFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesdocumentwithcreditblocks.batch.SalesDocumentWithCreditBlocksServiceBatch;

/**
 * <p>
 * The service contains entities for credit blocked sales document and reject reason. Once the sales document has been
 * checked, released, or rejected, a success message containing the document number is sent in the response. Once the
 * credit blocked sales document has been retrieved, the data is sent in the response. If there are any issues when
 * reading, checking, releasing, or rejecting the credit blocked sales document, the system displays error messages in
 * the response.
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/4f/6bd74343554c3cbaa43df5ff34363d/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_SLS_DOC_WITH_CREDIT_BLOCK?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_SLS_DOC_WITH_CREDIT_BLOCK</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Sales Credit Management Integration(SAP_COM_0325)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/BD6'>Basic Credit Management(BD6)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Sales Order</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Deprecated
public interface SalesDocumentWithCreditBlocksService extends BatchService<SalesDocumentWithCreditBlocksServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_SLS_DOC_WITH_CREDIT_BLOCK";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    SalesDocumentWithCreditBlocksService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesdocumentwithcreditblocks.CreditBlockedSalesDocument
     * CreditBlockedSalesDocument} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesdocumentwithcreditblocks.CreditBlockedSalesDocument
     *         CreditBlockedSalesDocument} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesdocumentwithcreditblocks.CreditBlockedSalesDocumentFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CreditBlockedSalesDocumentFluentHelper getAllCreditBlockedSalesDocument();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesdocumentwithcreditblocks.CreditBlockedSalesDocument
     * CreditBlockedSalesDocument} entity using key fields.
     *
     * @param salesDocument
     *            Sales Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesdocumentwithcreditblocks.CreditBlockedSalesDocument
     *         CreditBlockedSalesDocument} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesdocumentwithcreditblocks.CreditBlockedSalesDocumentByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CreditBlockedSalesDocumentByKeyFluentHelper getCreditBlockedSalesDocumentByKey( final String salesDocument );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesdocumentwithcreditblocks.SalesDocumentRjcnReason
     * SalesDocumentRjcnReason} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesdocumentwithcreditblocks.SalesDocumentRjcnReason
     *         SalesDocumentRjcnReason} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesdocumentwithcreditblocks.SalesDocumentRjcnReasonFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesDocumentRjcnReasonFluentHelper getAllSalesDocumentRjcnReason();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesdocumentwithcreditblocks.SalesDocumentRjcnReason
     * SalesDocumentRjcnReason} entity using key fields.
     *
     * @param salesDocumentRjcnReason
     *            Reason for Rejection of Sales Documents
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesdocumentwithcreditblocks.SalesDocumentRjcnReason
     *         SalesDocumentRjcnReason} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesdocumentwithcreditblocks.SalesDocumentRjcnReasonByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesDocumentRjcnReasonByKeyFluentHelper getSalesDocumentRjcnReasonByKey( final String salesDocumentRjcnReason );

    /**
     * <p>
     * Creates a fluent helper for the <b>CheckCreditBlock</b> OData function import.
     * </p>
     *
     * @param salesDocument
     *            Constraints: none
     *            <p>
     *            Original parameter name from the Odata EDM: <b>SalesDocument</b>
     *            </p>
     * @param sDDocumentCategory
     *            Constraints: none
     *            <p>
     *            Original parameter name from the Odata EDM: <b>SDDocumentCategory</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>CheckCreditBlock</b> OData function import with the
     *         provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesdocumentwithcreditblocks.CheckCreditBlockFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CheckCreditBlockFluentHelper
        checkCreditBlock( @Nonnull final String sDDocumentCategory, @Nonnull final String salesDocument );

    /**
     * <p>
     * Creates a fluent helper for the <b>RejectCreditBlock</b> OData function import.
     * </p>
     *
     * @param salesDocument
     *            Constraints: none
     *            <p>
     *            Original parameter name from the Odata EDM: <b>SalesDocument</b>
     *            </p>
     * @param sDDocumentCategory
     *            Constraints: none
     *            <p>
     *            Original parameter name from the Odata EDM: <b>SDDocumentCategory</b>
     *            </p>
     * @param salesDocumentRjcnReason
     *            Constraints: none
     *            <p>
     *            Original parameter name from the Odata EDM: <b>SalesDocumentRjcnReason</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>RejectCreditBlock</b> OData function import with the
     *         provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesdocumentwithcreditblocks.RejectCreditBlockFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    RejectCreditBlockFluentHelper rejectCreditBlock(
        @Nonnull final String sDDocumentCategory,
        @Nonnull final String salesDocumentRjcnReason,
        @Nonnull final String salesDocument );

    /**
     * <p>
     * Creates a fluent helper for the <b>ReleaseCreditBlock</b> OData function import.
     * </p>
     *
     * @param salesDocument
     *            Constraints: none
     *            <p>
     *            Original parameter name from the Odata EDM: <b>SalesDocument</b>
     *            </p>
     * @param sDDocumentCategory
     *            Constraints: none
     *            <p>
     *            Original parameter name from the Odata EDM: <b>SDDocumentCategory</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>ReleaseCreditBlock</b> OData function import with the
     *         provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesdocumentwithcreditblocks.ReleaseCreditBlockFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ReleaseCreditBlockFluentHelper
        releaseCreditBlock( @Nonnull final String salesDocument, @Nonnull final String sDDocumentCategory );

}
