/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.util.UUID;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.RejectApprovalRequestFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.ReleaseApprovalRequestFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrder;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderBillingPlan;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderBillingPlanByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderBillingPlanCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderBillingPlanFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderBillingPlanItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderBillingPlanItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderBillingPlanItemCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderBillingPlanItemDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderBillingPlanItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderBillingPlanItemUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderBillingPlanUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderHeaderPartner;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderHeaderPartnerByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderHeaderPartnerCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderHeaderPartnerDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderHeaderPartnerFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderHeaderPartnerUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderHeaderPrElement;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderHeaderPrElementByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderHeaderPrElementCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderHeaderPrElementDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderHeaderPrElementFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderHeaderPrElementUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemBillingPlan;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemBillingPlanByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemBillingPlanCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemBillingPlanFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemBillingPlanUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemPartner;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemPartnerAddress;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemPartnerAddressByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemPartnerAddressFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemPartnerAddressUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemPartnerByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemPartnerCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemPartnerDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemPartnerFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemPartnerUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemPrElement;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemPrElementByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemPrElementCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemPrElementDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemPrElementFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemPrElementUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemRelatedObject;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemRelatedObjectByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemRelatedObjectCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemRelatedObjectDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemRelatedObjectFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemTextCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemTextDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemTextUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItmPrecdgProcFlowByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItmPrecdgProcFlowFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItmSubsqntProcFlowByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItmSubsqntProcFlowFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderPartnerAddress;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderPartnerAddressByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderPartnerAddressFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderPartnerAddressUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderPrecdgProcFlowByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderPrecdgProcFlowFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderRelatedObject;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderRelatedObjectByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderRelatedObjectCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderRelatedObjectDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderRelatedObjectFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderScheduleLine;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderScheduleLineByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderScheduleLineCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderScheduleLineDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderScheduleLineFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderScheduleLineUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderSubsqntProcFlowByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderSubsqntProcFlowFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderTextCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderTextDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderTextUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SlsOrdPaymentPlanItemDetails;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SlsOrdPaymentPlanItemDetailsByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SlsOrdPaymentPlanItemDetailsCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SlsOrdPaymentPlanItemDetailsDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SlsOrdPaymentPlanItemDetailsFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SlsOrdPaymentPlanItemDetailsUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SlsOrderItemBillingPlanItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SlsOrderItemBillingPlanItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SlsOrderItemBillingPlanItemCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SlsOrderItemBillingPlanItemDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SlsOrderItemBillingPlanItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SlsOrderItemBillingPlanItemUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.batch.SalesOrderServiceBatch;

/**
 * <p>
 * In every API call, you can make use of the following operations: - You can read entire sales orders or only parts of
 * the data, using the provided filters. - You can create sales orders. You can use deep insert requests, that is, you
 * create a header plus at least one of the following entities: header partner, header partner address, header pricing
 * element, header billing plan, header billing plan item, header text, payment plan, header related object, item, item
 * partner, item partner address, item pricing element, item billing plan, item billing plan item, item text, and item
 * related object. If the header already exists, you can create the following sub-entities on their own: header partner,
 * header pricing element, header text, payment plan, header related object, item partner, item pricing element, item
 * text, and item related object. - For existing sales orders, you can create new items. You can use deep insert
 * requests, that is, you create an item plus at least one of the following entities: item partner, item partner
 * address, item pricing element, item billing plan, item billing plan item, item text, and item related object. If the
 * item already exists, you can create the following sub-entities on their own: item partner, item pricing element, item
 * text, item related object, and item schedule line. - For existing sales orders, you can update the following entities
 * (that is, you can change the content of their properties): header, header partner, header partner address, header
 * pricing element, header billing plan, header billing plan item, header text, payment plan, item, item partner, item
 * partner address, item pricing element, item billing plan, item billing plan item, item text, and item schedule line.
 * - For existing sales orders, you can delete the following entities: header, header partner, header pricing element,
 * header billing plan item, header text, payment plan, header related object, item, item partner, item pricing element,
 * item billing plan item, item text, item related object, and item schedule line. - You can accept or deny approval
 * requests for sales orders that cannot be processed without the consent of an approver..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/00/d244581efca007e10000000a441470/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_SALES_ORDER_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_SALES_ORDER_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Sales Order Integration(SAP_COM_0109), Delivery Insights Replication App Integration
 * (Obsolete)(SAP_COM_0571)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/BD9'>Sell from Stock(BD9)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OD9'>Sell from Stock(OD9)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/1IU'>Customer Consignment(1IU)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/1QI'>Opportunity-to-Order with Third-Party Sales Force Automation Apps
 * (Deprecated)(1QI)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/2TY'>B2B Order Fulfillment with SAP Commerce
 * Cloud(2TY)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/4IH'>Delivery Insights Enabled by IoT(4IH)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Sales Order</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Deprecated
public interface SalesOrderService extends BatchService<SalesOrderServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_SALES_ORDER_SRV";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    SalesOrderService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrder SalesOrder}
     * entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrder SalesOrder} entities.
     *         This fluent helper allows methods which modify the underlying query to be called before executing the
     *         query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesOrderFluentHelper getAllSalesOrder();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrder SalesOrder}
     * entity using key fields.
     *
     * @param salesOrder
     *            Sales Order
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrder SalesOrder} entity using
     *         key fields. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesOrderByKeyFluentHelper getSalesOrderByKey( final String salesOrder );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrder SalesOrder} entity
     * and save it to the S/4HANA system.
     *
     * @param salesOrder
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrder SalesOrder} entity
     *            object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrder SalesOrder} entity. To
     *         perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesOrderCreateFluentHelper createSalesOrder( @Nonnull final SalesOrder salesOrder );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrder SalesOrder}
     * entity and save it to the S/4HANA system.
     *
     * @param salesOrder
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrder SalesOrder} entity
     *            object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrder SalesOrder} entity. To
     *         perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesOrderUpdateFluentHelper updateSalesOrder( @Nonnull final SalesOrder salesOrder );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrder SalesOrder}
     * entity in the S/4HANA system.
     *
     * @param salesOrder
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrder SalesOrder} entity
     *            object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrder SalesOrder} entity. To
     *         perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesOrderDeleteFluentHelper deleteSalesOrder( @Nonnull final SalesOrder salesOrder );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderBillingPlan
     * SalesOrderBillingPlan} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderBillingPlan
     *         SalesOrderBillingPlan} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderBillingPlanFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesOrderBillingPlanFluentHelper getAllSalesOrderBillingPlan();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderBillingPlan
     * SalesOrderBillingPlan} entity using key fields.
     *
     * @param billingPlan
     *            Billing Plan Number / Invoicing Plan Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param salesOrder
     *            Sales Order
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderBillingPlan
     *         SalesOrderBillingPlan} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderBillingPlanByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesOrderBillingPlanByKeyFluentHelper
        getSalesOrderBillingPlanByKey( final String salesOrder, final String billingPlan );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderBillingPlan
     * SalesOrderBillingPlan} entity and save it to the S/4HANA system.
     *
     * @param salesOrderBillingPlan
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderBillingPlan
     *            SalesOrderBillingPlan} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderBillingPlan
     *         SalesOrderBillingPlan} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderBillingPlanCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesOrderBillingPlanCreateFluentHelper
        createSalesOrderBillingPlan( @Nonnull final SalesOrderBillingPlan salesOrderBillingPlan );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderBillingPlan
     * SalesOrderBillingPlan} entity and save it to the S/4HANA system.
     *
     * @param salesOrderBillingPlan
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderBillingPlan
     *            SalesOrderBillingPlan} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderBillingPlan
     *         SalesOrderBillingPlan} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderBillingPlanUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesOrderBillingPlanUpdateFluentHelper
        updateSalesOrderBillingPlan( @Nonnull final SalesOrderBillingPlan salesOrderBillingPlan );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderBillingPlanItem
     * SalesOrderBillingPlanItem} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderBillingPlanItem
     *         SalesOrderBillingPlanItem} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderBillingPlanItemFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesOrderBillingPlanItemFluentHelper getAllSalesOrderBillingPlanItem();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderBillingPlanItem
     * SalesOrderBillingPlanItem} entity using key fields.
     *
     * @param billingPlan
     *            Billing Plan Number / Invoicing Plan Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param salesOrder
     *            Sales Order
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param billingPlanItem
     *            Item for billing plan/invoice plan/payment cards
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderBillingPlanItem
     *         SalesOrderBillingPlanItem} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderBillingPlanItemByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesOrderBillingPlanItemByKeyFluentHelper getSalesOrderBillingPlanItemByKey(
        final String salesOrder,
        final String billingPlan,
        final String billingPlanItem );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderBillingPlanItem
     * SalesOrderBillingPlanItem} entity and save it to the S/4HANA system.
     *
     * @param salesOrderBillingPlanItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderBillingPlanItem
     *            SalesOrderBillingPlanItem} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderBillingPlanItem
     *         SalesOrderBillingPlanItem} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderBillingPlanItemCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesOrderBillingPlanItemCreateFluentHelper
        createSalesOrderBillingPlanItem( @Nonnull final SalesOrderBillingPlanItem salesOrderBillingPlanItem );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderBillingPlanItem
     * SalesOrderBillingPlanItem} entity and save it to the S/4HANA system.
     *
     * @param salesOrderBillingPlanItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderBillingPlanItem
     *            SalesOrderBillingPlanItem} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderBillingPlanItem
     *         SalesOrderBillingPlanItem} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderBillingPlanItemUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesOrderBillingPlanItemUpdateFluentHelper
        updateSalesOrderBillingPlanItem( @Nonnull final SalesOrderBillingPlanItem salesOrderBillingPlanItem );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderBillingPlanItem
     * SalesOrderBillingPlanItem} entity in the S/4HANA system.
     *
     * @param salesOrderBillingPlanItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderBillingPlanItem
     *            SalesOrderBillingPlanItem} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderBillingPlanItem
     *         SalesOrderBillingPlanItem} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderBillingPlanItemDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesOrderBillingPlanItemDeleteFluentHelper
        deleteSalesOrderBillingPlanItem( @Nonnull final SalesOrderBillingPlanItem salesOrderBillingPlanItem );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderHeaderPartner
     * SalesOrderHeaderPartner} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderHeaderPartner
     *         SalesOrderHeaderPartner} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderHeaderPartnerFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesOrderHeaderPartnerFluentHelper getAllSalesOrderHeaderPartner();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderHeaderPartner
     * SalesOrderHeaderPartner} entity using key fields.
     *
     * @param partnerFunction
     *            Partner Function
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param salesOrder
     *            Sales Order
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderHeaderPartner
     *         SalesOrderHeaderPartner} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderHeaderPartnerByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesOrderHeaderPartnerByKeyFluentHelper
        getSalesOrderHeaderPartnerByKey( final String salesOrder, final String partnerFunction );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderHeaderPartner
     * SalesOrderHeaderPartner} entity and save it to the S/4HANA system.
     *
     * @param salesOrderHeaderPartner
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderHeaderPartner
     *            SalesOrderHeaderPartner} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderHeaderPartner
     *         SalesOrderHeaderPartner} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderHeaderPartnerCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesOrderHeaderPartnerCreateFluentHelper
        createSalesOrderHeaderPartner( @Nonnull final SalesOrderHeaderPartner salesOrderHeaderPartner );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderHeaderPartner
     * SalesOrderHeaderPartner} entity and save it to the S/4HANA system.
     *
     * @param salesOrderHeaderPartner
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderHeaderPartner
     *            SalesOrderHeaderPartner} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderHeaderPartner
     *         SalesOrderHeaderPartner} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderHeaderPartnerUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesOrderHeaderPartnerUpdateFluentHelper
        updateSalesOrderHeaderPartner( @Nonnull final SalesOrderHeaderPartner salesOrderHeaderPartner );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderHeaderPartner
     * SalesOrderHeaderPartner} entity in the S/4HANA system.
     *
     * @param salesOrderHeaderPartner
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderHeaderPartner
     *            SalesOrderHeaderPartner} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderHeaderPartner
     *         SalesOrderHeaderPartner} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderHeaderPartnerDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesOrderHeaderPartnerDeleteFluentHelper
        deleteSalesOrderHeaderPartner( @Nonnull final SalesOrderHeaderPartner salesOrderHeaderPartner );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderHeaderPrElement
     * SalesOrderHeaderPrElement} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderHeaderPrElement
     *         SalesOrderHeaderPrElement} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderHeaderPrElementFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesOrderHeaderPrElementFluentHelper getAllSalesOrderHeaderPrElement();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderHeaderPrElement
     * SalesOrderHeaderPrElement} entity using key fields.
     *
     * @param pricingProcedureCounter
     *            Condition Counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @param salesOrder
     *            Sales Order
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param pricingProcedureStep
     *            Step Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderHeaderPrElement
     *         SalesOrderHeaderPrElement} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderHeaderPrElementByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesOrderHeaderPrElementByKeyFluentHelper getSalesOrderHeaderPrElementByKey(
        final String salesOrder,
        final String pricingProcedureStep,
        final String pricingProcedureCounter );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderHeaderPrElement
     * SalesOrderHeaderPrElement} entity and save it to the S/4HANA system.
     *
     * @param salesOrderHeaderPrElement
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderHeaderPrElement
     *            SalesOrderHeaderPrElement} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderHeaderPrElement
     *         SalesOrderHeaderPrElement} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderHeaderPrElementCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesOrderHeaderPrElementCreateFluentHelper
        createSalesOrderHeaderPrElement( @Nonnull final SalesOrderHeaderPrElement salesOrderHeaderPrElement );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderHeaderPrElement
     * SalesOrderHeaderPrElement} entity and save it to the S/4HANA system.
     *
     * @param salesOrderHeaderPrElement
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderHeaderPrElement
     *            SalesOrderHeaderPrElement} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderHeaderPrElement
     *         SalesOrderHeaderPrElement} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderHeaderPrElementUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesOrderHeaderPrElementUpdateFluentHelper
        updateSalesOrderHeaderPrElement( @Nonnull final SalesOrderHeaderPrElement salesOrderHeaderPrElement );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderHeaderPrElement
     * SalesOrderHeaderPrElement} entity in the S/4HANA system.
     *
     * @param salesOrderHeaderPrElement
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderHeaderPrElement
     *            SalesOrderHeaderPrElement} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderHeaderPrElement
     *         SalesOrderHeaderPrElement} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderHeaderPrElementDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesOrderHeaderPrElementDeleteFluentHelper
        deleteSalesOrderHeaderPrElement( @Nonnull final SalesOrderHeaderPrElement salesOrderHeaderPrElement );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItem
     * SalesOrderItem} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItem SalesOrderItem}
     *         entities. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesOrderItemFluentHelper getAllSalesOrderItem();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItem
     * SalesOrderItem} entity using key fields.
     *
     * @param salesOrderItem
     *            Sales Order Item
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param salesOrder
     *            Sales Order
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItem SalesOrderItem}
     *         entity using key fields. This fluent helper allows methods which modify the underlying query to be called
     *         before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesOrderItemByKeyFluentHelper getSalesOrderItemByKey( final String salesOrder, final String salesOrderItem );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItem SalesOrderItem}
     * entity and save it to the S/4HANA system.
     *
     * @param salesOrderItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItem SalesOrderItem}
     *            entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItem SalesOrderItem}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesOrderItemCreateFluentHelper createSalesOrderItem( @Nonnull final SalesOrderItem salesOrderItem );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItem
     * SalesOrderItem} entity and save it to the S/4HANA system.
     *
     * @param salesOrderItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItem SalesOrderItem}
     *            entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItem SalesOrderItem}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesOrderItemUpdateFluentHelper updateSalesOrderItem( @Nonnull final SalesOrderItem salesOrderItem );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItem
     * SalesOrderItem} entity in the S/4HANA system.
     *
     * @param salesOrderItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItem SalesOrderItem}
     *            entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItem SalesOrderItem}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesOrderItemDeleteFluentHelper deleteSalesOrderItem( @Nonnull final SalesOrderItem salesOrderItem );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemBillingPlan
     * SalesOrderItemBillingPlan} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemBillingPlan
     *         SalesOrderItemBillingPlan} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemBillingPlanFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesOrderItemBillingPlanFluentHelper getAllSalesOrderItemBillingPlan();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemBillingPlan
     * SalesOrderItemBillingPlan} entity using key fields.
     *
     * @param salesOrderItem
     *            Sales Order Item
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param billingPlan
     *            Billing Plan Number / Invoicing Plan Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param salesOrder
     *            Sales Order
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemBillingPlan
     *         SalesOrderItemBillingPlan} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemBillingPlanByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesOrderItemBillingPlanByKeyFluentHelper getSalesOrderItemBillingPlanByKey(
        final String salesOrder,
        final String salesOrderItem,
        final String billingPlan );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemBillingPlan
     * SalesOrderItemBillingPlan} entity and save it to the S/4HANA system.
     *
     * @param salesOrderItemBillingPlan
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemBillingPlan
     *            SalesOrderItemBillingPlan} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemBillingPlan
     *         SalesOrderItemBillingPlan} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemBillingPlanCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesOrderItemBillingPlanCreateFluentHelper
        createSalesOrderItemBillingPlan( @Nonnull final SalesOrderItemBillingPlan salesOrderItemBillingPlan );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemBillingPlan
     * SalesOrderItemBillingPlan} entity and save it to the S/4HANA system.
     *
     * @param salesOrderItemBillingPlan
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemBillingPlan
     *            SalesOrderItemBillingPlan} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemBillingPlan
     *         SalesOrderItemBillingPlan} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemBillingPlanUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesOrderItemBillingPlanUpdateFluentHelper
        updateSalesOrderItemBillingPlan( @Nonnull final SalesOrderItemBillingPlan salesOrderItemBillingPlan );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemPartner
     * SalesOrderItemPartner} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemPartner
     *         SalesOrderItemPartner} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemPartnerFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesOrderItemPartnerFluentHelper getAllSalesOrderItemPartner();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemPartner
     * SalesOrderItemPartner} entity using key fields.
     *
     * @param partnerFunction
     *            Partner Function
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param salesOrderItem
     *            Sales Order Item
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param salesOrder
     *            Sales Order
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemPartner
     *         SalesOrderItemPartner} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemPartnerByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesOrderItemPartnerByKeyFluentHelper getSalesOrderItemPartnerByKey(
        final String salesOrder,
        final String salesOrderItem,
        final String partnerFunction );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemPartner
     * SalesOrderItemPartner} entity and save it to the S/4HANA system.
     *
     * @param salesOrderItemPartner
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemPartner
     *            SalesOrderItemPartner} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemPartner
     *         SalesOrderItemPartner} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemPartnerCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesOrderItemPartnerCreateFluentHelper
        createSalesOrderItemPartner( @Nonnull final SalesOrderItemPartner salesOrderItemPartner );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemPartner
     * SalesOrderItemPartner} entity and save it to the S/4HANA system.
     *
     * @param salesOrderItemPartner
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemPartner
     *            SalesOrderItemPartner} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemPartner
     *         SalesOrderItemPartner} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemPartnerUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesOrderItemPartnerUpdateFluentHelper
        updateSalesOrderItemPartner( @Nonnull final SalesOrderItemPartner salesOrderItemPartner );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemPartner
     * SalesOrderItemPartner} entity in the S/4HANA system.
     *
     * @param salesOrderItemPartner
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemPartner
     *            SalesOrderItemPartner} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemPartner
     *         SalesOrderItemPartner} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemPartnerDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesOrderItemPartnerDeleteFluentHelper
        deleteSalesOrderItemPartner( @Nonnull final SalesOrderItemPartner salesOrderItemPartner );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemPartnerAddress
     * SalesOrderItemPartnerAddress} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemPartnerAddress
     *         SalesOrderItemPartnerAddress} entities. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemPartnerAddressFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesOrderItemPartnerAddressFluentHelper getAllSalesOrderItemPartnerAddress();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemPartnerAddress
     * SalesOrderItemPartnerAddress} entity using key fields.
     *
     * @param partnerFunction
     *            Partner Function
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param salesOrderItem
     *            Item number of the SD document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param addressRepresentationCode
     *            Version ID for International Addresses
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     * @param salesOrder
     *            Sales and Distribution Document Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemPartnerAddress
     *         SalesOrderItemPartnerAddress} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemPartnerAddressByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesOrderItemPartnerAddressByKeyFluentHelper getSalesOrderItemPartnerAddressByKey(
        final String salesOrder,
        final String salesOrderItem,
        final String partnerFunction,
        final String addressRepresentationCode );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemPartnerAddress
     * SalesOrderItemPartnerAddress} entity and save it to the S/4HANA system.
     *
     * @param salesOrderItemPartnerAddress
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemPartnerAddress
     *            SalesOrderItemPartnerAddress} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemPartnerAddress
     *         SalesOrderItemPartnerAddress} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemPartnerAddressUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesOrderItemPartnerAddressUpdateFluentHelper
        updateSalesOrderItemPartnerAddress( @Nonnull final SalesOrderItemPartnerAddress salesOrderItemPartnerAddress );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemPrElement
     * SalesOrderItemPrElement} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemPrElement
     *         SalesOrderItemPrElement} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemPrElementFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesOrderItemPrElementFluentHelper getAllSalesOrderItemPrElement();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemPrElement
     * SalesOrderItemPrElement} entity using key fields.
     *
     * @param salesOrderItem
     *            Sales Order Item
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param pricingProcedureCounter
     *            Condition Counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @param salesOrder
     *            Sales Order
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param pricingProcedureStep
     *            Step Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemPrElement
     *         SalesOrderItemPrElement} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemPrElementByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesOrderItemPrElementByKeyFluentHelper getSalesOrderItemPrElementByKey(
        final String salesOrder,
        final String salesOrderItem,
        final String pricingProcedureStep,
        final String pricingProcedureCounter );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemPrElement
     * SalesOrderItemPrElement} entity and save it to the S/4HANA system.
     *
     * @param salesOrderItemPrElement
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemPrElement
     *            SalesOrderItemPrElement} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemPrElement
     *         SalesOrderItemPrElement} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemPrElementCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesOrderItemPrElementCreateFluentHelper
        createSalesOrderItemPrElement( @Nonnull final SalesOrderItemPrElement salesOrderItemPrElement );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemPrElement
     * SalesOrderItemPrElement} entity and save it to the S/4HANA system.
     *
     * @param salesOrderItemPrElement
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemPrElement
     *            SalesOrderItemPrElement} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemPrElement
     *         SalesOrderItemPrElement} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemPrElementUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesOrderItemPrElementUpdateFluentHelper
        updateSalesOrderItemPrElement( @Nonnull final SalesOrderItemPrElement salesOrderItemPrElement );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemPrElement
     * SalesOrderItemPrElement} entity in the S/4HANA system.
     *
     * @param salesOrderItemPrElement
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemPrElement
     *            SalesOrderItemPrElement} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemPrElement
     *         SalesOrderItemPrElement} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemPrElementDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesOrderItemPrElementDeleteFluentHelper
        deleteSalesOrderItemPrElement( @Nonnull final SalesOrderItemPrElement salesOrderItemPrElement );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemRelatedObject
     * SalesOrderItemRelatedObject} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemRelatedObject
     *         SalesOrderItemRelatedObject} entities. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemRelatedObjectFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesOrderItemRelatedObjectFluentHelper getAllSalesOrderItemRelatedObject();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemRelatedObject
     * SalesOrderItemRelatedObject} entity using key fields.
     *
     * @param salesOrderItem
     *            Sales Order Item
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param sDDocRelatedObjectSequenceNmbr
     *            Sequence Number of the Related Object of an SD Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param salesOrder
     *            Sales Order
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemRelatedObject
     *         SalesOrderItemRelatedObject} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemRelatedObjectByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesOrderItemRelatedObjectByKeyFluentHelper getSalesOrderItemRelatedObjectByKey(
        final String salesOrder,
        final String salesOrderItem,
        final String sDDocRelatedObjectSequenceNmbr );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemRelatedObject
     * SalesOrderItemRelatedObject} entity and save it to the S/4HANA system.
     *
     * @param salesOrderItemRelatedObject
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemRelatedObject
     *            SalesOrderItemRelatedObject} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemRelatedObject
     *         SalesOrderItemRelatedObject} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemRelatedObjectCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesOrderItemRelatedObjectCreateFluentHelper
        createSalesOrderItemRelatedObject( @Nonnull final SalesOrderItemRelatedObject salesOrderItemRelatedObject );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemRelatedObject
     * SalesOrderItemRelatedObject} entity in the S/4HANA system.
     *
     * @param salesOrderItemRelatedObject
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemRelatedObject
     *            SalesOrderItemRelatedObject} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemRelatedObject
     *         SalesOrderItemRelatedObject} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemRelatedObjectDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesOrderItemRelatedObjectDeleteFluentHelper
        deleteSalesOrderItemRelatedObject( @Nonnull final SalesOrderItemRelatedObject salesOrderItemRelatedObject );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemText
     * SalesOrderItemText} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemText
     *         SalesOrderItemText} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemTextFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesOrderItemTextFluentHelper getAllSalesOrderItemText();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemText
     * SalesOrderItemText} entity using key fields.
     *
     * @param salesOrderItem
     *            Sales Order Item
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param longTextID
     *            Text ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param salesOrder
     *            Sales Order
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemText
     *         SalesOrderItemText} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemTextByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesOrderItemTextByKeyFluentHelper getSalesOrderItemTextByKey(
        final String salesOrder,
        final String salesOrderItem,
        final String language,
        final String longTextID );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemText
     * SalesOrderItemText} entity and save it to the S/4HANA system.
     *
     * @param salesOrderItemText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemText
     *            SalesOrderItemText} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemText
     *         SalesOrderItemText} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemTextCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesOrderItemTextCreateFluentHelper
        createSalesOrderItemText( @Nonnull final SalesOrderItemText salesOrderItemText );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemText
     * SalesOrderItemText} entity and save it to the S/4HANA system.
     *
     * @param salesOrderItemText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemText
     *            SalesOrderItemText} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemText
     *         SalesOrderItemText} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemTextUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesOrderItemTextUpdateFluentHelper
        updateSalesOrderItemText( @Nonnull final SalesOrderItemText salesOrderItemText );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemText
     * SalesOrderItemText} entity in the S/4HANA system.
     *
     * @param salesOrderItemText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemText
     *            SalesOrderItemText} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemText
     *         SalesOrderItemText} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemTextDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesOrderItemTextDeleteFluentHelper
        deleteSalesOrderItemText( @Nonnull final SalesOrderItemText salesOrderItemText );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItmPrecdgProcFlow
     * SalesOrderItmPrecdgProcFlow} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItmPrecdgProcFlow
     *         SalesOrderItmPrecdgProcFlow} entities. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItmPrecdgProcFlowFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesOrderItmPrecdgProcFlowFluentHelper getAllSalesOrderItmPrecdgProcFlow();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItmPrecdgProcFlow
     * SalesOrderItmPrecdgProcFlow} entity using key fields.
     *
     * @param docRelationshipUUID
     *            SD Unique Document Relationship Identification
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @param salesOrderItem
     *            Subsequent Item of an SD Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param salesOrder
     *            Subsequent Sales and Distribution Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItmPrecdgProcFlow
     *         SalesOrderItmPrecdgProcFlow} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItmPrecdgProcFlowByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesOrderItmPrecdgProcFlowByKeyFluentHelper getSalesOrderItmPrecdgProcFlowByKey(
        final String salesOrder,
        final String salesOrderItem,
        final UUID docRelationshipUUID );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItmSubsqntProcFlow
     * SalesOrderItmSubsqntProcFlow} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItmSubsqntProcFlow
     *         SalesOrderItmSubsqntProcFlow} entities. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItmSubsqntProcFlowFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesOrderItmSubsqntProcFlowFluentHelper getAllSalesOrderItmSubsqntProcFlow();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItmSubsqntProcFlow
     * SalesOrderItmSubsqntProcFlow} entity using key fields.
     *
     * @param docRelationshipUUID
     *            SD Unique Document Relationship Identification
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @param salesOrderItem
     *            Preceding Item of an SD Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param salesOrder
     *            Preceding sales and distribution document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItmSubsqntProcFlow
     *         SalesOrderItmSubsqntProcFlow} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItmSubsqntProcFlowByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesOrderItmSubsqntProcFlowByKeyFluentHelper getSalesOrderItmSubsqntProcFlowByKey(
        final String salesOrder,
        final String salesOrderItem,
        final UUID docRelationshipUUID );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderPartnerAddress
     * SalesOrderPartnerAddress} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderPartnerAddress
     *         SalesOrderPartnerAddress} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderPartnerAddressFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesOrderPartnerAddressFluentHelper getAllSalesOrderPartnerAddress();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderPartnerAddress
     * SalesOrderPartnerAddress} entity using key fields.
     *
     * @param partnerFunction
     *            Partner Function
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param addressRepresentationCode
     *            Version ID for International Addresses
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     * @param salesOrder
     *            Sales and Distribution Document Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderPartnerAddress
     *         SalesOrderPartnerAddress} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderPartnerAddressByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesOrderPartnerAddressByKeyFluentHelper getSalesOrderPartnerAddressByKey(
        final String salesOrder,
        final String partnerFunction,
        final String addressRepresentationCode );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderPartnerAddress
     * SalesOrderPartnerAddress} entity and save it to the S/4HANA system.
     *
     * @param salesOrderPartnerAddress
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderPartnerAddress
     *            SalesOrderPartnerAddress} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderPartnerAddress
     *         SalesOrderPartnerAddress} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderPartnerAddressUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesOrderPartnerAddressUpdateFluentHelper
        updateSalesOrderPartnerAddress( @Nonnull final SalesOrderPartnerAddress salesOrderPartnerAddress );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderPrecdgProcFlow
     * SalesOrderPrecdgProcFlow} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderPrecdgProcFlow
     *         SalesOrderPrecdgProcFlow} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderPrecdgProcFlowFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesOrderPrecdgProcFlowFluentHelper getAllSalesOrderPrecdgProcFlow();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderPrecdgProcFlow
     * SalesOrderPrecdgProcFlow} entity using key fields.
     *
     * @param docRelationshipUUID
     *            SD Unique Document Relationship Identification
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @param salesOrder
     *            Subsequent Sales and Distribution Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderPrecdgProcFlow
     *         SalesOrderPrecdgProcFlow} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderPrecdgProcFlowByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesOrderPrecdgProcFlowByKeyFluentHelper
        getSalesOrderPrecdgProcFlowByKey( final String salesOrder, final UUID docRelationshipUUID );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderRelatedObject
     * SalesOrderRelatedObject} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderRelatedObject
     *         SalesOrderRelatedObject} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderRelatedObjectFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesOrderRelatedObjectFluentHelper getAllSalesOrderRelatedObject();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderRelatedObject
     * SalesOrderRelatedObject} entity using key fields.
     *
     * @param sDDocRelatedObjectSequenceNmbr
     *            Sequence Number of the Related Object of an SD Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param salesOrder
     *            Sales Order
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderRelatedObject
     *         SalesOrderRelatedObject} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderRelatedObjectByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesOrderRelatedObjectByKeyFluentHelper
        getSalesOrderRelatedObjectByKey( final String salesOrder, final String sDDocRelatedObjectSequenceNmbr );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderRelatedObject
     * SalesOrderRelatedObject} entity and save it to the S/4HANA system.
     *
     * @param salesOrderRelatedObject
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderRelatedObject
     *            SalesOrderRelatedObject} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderRelatedObject
     *         SalesOrderRelatedObject} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderRelatedObjectCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesOrderRelatedObjectCreateFluentHelper
        createSalesOrderRelatedObject( @Nonnull final SalesOrderRelatedObject salesOrderRelatedObject );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderRelatedObject
     * SalesOrderRelatedObject} entity in the S/4HANA system.
     *
     * @param salesOrderRelatedObject
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderRelatedObject
     *            SalesOrderRelatedObject} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderRelatedObject
     *         SalesOrderRelatedObject} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderRelatedObjectDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesOrderRelatedObjectDeleteFluentHelper
        deleteSalesOrderRelatedObject( @Nonnull final SalesOrderRelatedObject salesOrderRelatedObject );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderScheduleLine
     * SalesOrderScheduleLine} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderScheduleLine
     *         SalesOrderScheduleLine} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderScheduleLineFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesOrderScheduleLineFluentHelper getAllSalesOrderScheduleLine();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderScheduleLine
     * SalesOrderScheduleLine} entity using key fields.
     *
     * @param salesOrderItem
     *            Sales Document Item
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param scheduleLine
     *            Schedule Line Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param salesOrder
     *            Sales Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderScheduleLine
     *         SalesOrderScheduleLine} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderScheduleLineByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesOrderScheduleLineByKeyFluentHelper getSalesOrderScheduleLineByKey(
        final String salesOrder,
        final String salesOrderItem,
        final String scheduleLine );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderScheduleLine
     * SalesOrderScheduleLine} entity and save it to the S/4HANA system.
     *
     * @param salesOrderScheduleLine
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderScheduleLine
     *            SalesOrderScheduleLine} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderScheduleLine
     *         SalesOrderScheduleLine} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderScheduleLineCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesOrderScheduleLineCreateFluentHelper
        createSalesOrderScheduleLine( @Nonnull final SalesOrderScheduleLine salesOrderScheduleLine );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderScheduleLine
     * SalesOrderScheduleLine} entity and save it to the S/4HANA system.
     *
     * @param salesOrderScheduleLine
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderScheduleLine
     *            SalesOrderScheduleLine} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderScheduleLine
     *         SalesOrderScheduleLine} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderScheduleLineUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesOrderScheduleLineUpdateFluentHelper
        updateSalesOrderScheduleLine( @Nonnull final SalesOrderScheduleLine salesOrderScheduleLine );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderScheduleLine
     * SalesOrderScheduleLine} entity in the S/4HANA system.
     *
     * @param salesOrderScheduleLine
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderScheduleLine
     *            SalesOrderScheduleLine} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderScheduleLine
     *         SalesOrderScheduleLine} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderScheduleLineDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesOrderScheduleLineDeleteFluentHelper
        deleteSalesOrderScheduleLine( @Nonnull final SalesOrderScheduleLine salesOrderScheduleLine );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderSubsqntProcFlow
     * SalesOrderSubsqntProcFlow} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderSubsqntProcFlow
     *         SalesOrderSubsqntProcFlow} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderSubsqntProcFlowFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesOrderSubsqntProcFlowFluentHelper getAllSalesOrderSubsqntProcFlow();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderSubsqntProcFlow
     * SalesOrderSubsqntProcFlow} entity using key fields.
     *
     * @param docRelationshipUUID
     *            SD Unique Document Relationship Identification
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @param salesOrder
     *            Preceding sales and distribution document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderSubsqntProcFlow
     *         SalesOrderSubsqntProcFlow} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderSubsqntProcFlowByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesOrderSubsqntProcFlowByKeyFluentHelper
        getSalesOrderSubsqntProcFlowByKey( final String salesOrder, final UUID docRelationshipUUID );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderText
     * SalesOrderText} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderText SalesOrderText}
     *         entities. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderTextFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesOrderTextFluentHelper getAllSalesOrderText();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderText
     * SalesOrderText} entity using key fields.
     *
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param longTextID
     *            Text ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param salesOrder
     *            Sales Order
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderText SalesOrderText}
     *         entity using key fields. This fluent helper allows methods which modify the underlying query to be called
     *         before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderTextByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesOrderTextByKeyFluentHelper
        getSalesOrderTextByKey( final String salesOrder, final String language, final String longTextID );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderText SalesOrderText}
     * entity and save it to the S/4HANA system.
     *
     * @param salesOrderText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderText SalesOrderText}
     *            entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderText SalesOrderText}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderTextCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesOrderTextCreateFluentHelper createSalesOrderText( @Nonnull final SalesOrderText salesOrderText );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderText
     * SalesOrderText} entity and save it to the S/4HANA system.
     *
     * @param salesOrderText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderText SalesOrderText}
     *            entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderText SalesOrderText}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderTextUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesOrderTextUpdateFluentHelper updateSalesOrderText( @Nonnull final SalesOrderText salesOrderText );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderText
     * SalesOrderText} entity in the S/4HANA system.
     *
     * @param salesOrderText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderText SalesOrderText}
     *            entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderText SalesOrderText}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderTextDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesOrderTextDeleteFluentHelper deleteSalesOrderText( @Nonnull final SalesOrderText salesOrderText );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SlsOrderItemBillingPlanItem
     * SlsOrderItemBillingPlanItem} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SlsOrderItemBillingPlanItem
     *         SlsOrderItemBillingPlanItem} entities. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SlsOrderItemBillingPlanItemFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SlsOrderItemBillingPlanItemFluentHelper getAllSlsOrderItemBillingPlanItem();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SlsOrderItemBillingPlanItem
     * SlsOrderItemBillingPlanItem} entity using key fields.
     *
     * @param salesOrderItem
     *            Sales Order Item
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param billingPlan
     *            Billing Plan Number / Invoicing Plan Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param salesOrder
     *            Sales Order
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param billingPlanItem
     *            Item for billing plan/invoice plan/payment cards
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SlsOrderItemBillingPlanItem
     *         SlsOrderItemBillingPlanItem} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SlsOrderItemBillingPlanItemByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SlsOrderItemBillingPlanItemByKeyFluentHelper getSlsOrderItemBillingPlanItemByKey(
        final String salesOrder,
        final String salesOrderItem,
        final String billingPlan,
        final String billingPlanItem );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SlsOrderItemBillingPlanItem
     * SlsOrderItemBillingPlanItem} entity and save it to the S/4HANA system.
     *
     * @param slsOrderItemBillingPlanItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SlsOrderItemBillingPlanItem
     *            SlsOrderItemBillingPlanItem} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SlsOrderItemBillingPlanItem
     *         SlsOrderItemBillingPlanItem} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SlsOrderItemBillingPlanItemCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SlsOrderItemBillingPlanItemCreateFluentHelper
        createSlsOrderItemBillingPlanItem( @Nonnull final SlsOrderItemBillingPlanItem slsOrderItemBillingPlanItem );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SlsOrderItemBillingPlanItem
     * SlsOrderItemBillingPlanItem} entity and save it to the S/4HANA system.
     *
     * @param slsOrderItemBillingPlanItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SlsOrderItemBillingPlanItem
     *            SlsOrderItemBillingPlanItem} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SlsOrderItemBillingPlanItem
     *         SlsOrderItemBillingPlanItem} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SlsOrderItemBillingPlanItemUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SlsOrderItemBillingPlanItemUpdateFluentHelper
        updateSlsOrderItemBillingPlanItem( @Nonnull final SlsOrderItemBillingPlanItem slsOrderItemBillingPlanItem );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SlsOrderItemBillingPlanItem
     * SlsOrderItemBillingPlanItem} entity in the S/4HANA system.
     *
     * @param slsOrderItemBillingPlanItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SlsOrderItemBillingPlanItem
     *            SlsOrderItemBillingPlanItem} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SlsOrderItemBillingPlanItem
     *         SlsOrderItemBillingPlanItem} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SlsOrderItemBillingPlanItemDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SlsOrderItemBillingPlanItemDeleteFluentHelper
        deleteSlsOrderItemBillingPlanItem( @Nonnull final SlsOrderItemBillingPlanItem slsOrderItemBillingPlanItem );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SlsOrdPaymentPlanItemDetails
     * SlsOrdPaymentPlanItemDetails} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SlsOrdPaymentPlanItemDetails
     *         SlsOrdPaymentPlanItemDetails} entities. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SlsOrdPaymentPlanItemDetailsFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SlsOrdPaymentPlanItemDetailsFluentHelper getAllSlsOrdPaymentPlanItemDetails();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SlsOrdPaymentPlanItemDetails
     * SlsOrdPaymentPlanItemDetails} entity using key fields.
     *
     * @param paymentPlanItem
     *            Item for billing plan/invoice plan/payment cards
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param salesOrder
     *            Sales Order
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SlsOrdPaymentPlanItemDetails
     *         SlsOrdPaymentPlanItemDetails} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SlsOrdPaymentPlanItemDetailsByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SlsOrdPaymentPlanItemDetailsByKeyFluentHelper
        getSlsOrdPaymentPlanItemDetailsByKey( final String salesOrder, final String paymentPlanItem );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SlsOrdPaymentPlanItemDetails
     * SlsOrdPaymentPlanItemDetails} entity and save it to the S/4HANA system.
     *
     * @param slsOrdPaymentPlanItemDetails
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SlsOrdPaymentPlanItemDetails
     *            SlsOrdPaymentPlanItemDetails} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SlsOrdPaymentPlanItemDetails
     *         SlsOrdPaymentPlanItemDetails} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SlsOrdPaymentPlanItemDetailsCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SlsOrdPaymentPlanItemDetailsCreateFluentHelper
        createSlsOrdPaymentPlanItemDetails( @Nonnull final SlsOrdPaymentPlanItemDetails slsOrdPaymentPlanItemDetails );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SlsOrdPaymentPlanItemDetails
     * SlsOrdPaymentPlanItemDetails} entity and save it to the S/4HANA system.
     *
     * @param slsOrdPaymentPlanItemDetails
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SlsOrdPaymentPlanItemDetails
     *            SlsOrdPaymentPlanItemDetails} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SlsOrdPaymentPlanItemDetails
     *         SlsOrdPaymentPlanItemDetails} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SlsOrdPaymentPlanItemDetailsUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SlsOrdPaymentPlanItemDetailsUpdateFluentHelper
        updateSlsOrdPaymentPlanItemDetails( @Nonnull final SlsOrdPaymentPlanItemDetails slsOrdPaymentPlanItemDetails );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SlsOrdPaymentPlanItemDetails
     * SlsOrdPaymentPlanItemDetails} entity in the S/4HANA system.
     *
     * @param slsOrdPaymentPlanItemDetails
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SlsOrdPaymentPlanItemDetails
     *            SlsOrdPaymentPlanItemDetails} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SlsOrdPaymentPlanItemDetails
     *         SlsOrdPaymentPlanItemDetails} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SlsOrdPaymentPlanItemDetailsDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SlsOrdPaymentPlanItemDetailsDeleteFluentHelper
        deleteSlsOrdPaymentPlanItemDetails( @Nonnull final SlsOrdPaymentPlanItemDetails slsOrdPaymentPlanItemDetails );

    /**
     * <p>
     * Creates a fluent helper for the <b>rejectApprovalRequest</b> OData function import.
     * </p>
     *
     * @param salesOrder
     *            Constraints: Not nullable, Maximum length: 11000
     *            <p>
     *            Original parameter name from the Odata EDM: <b>SalesOrder</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>rejectApprovalRequest</b> OData function import with the
     *         provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.RejectApprovalRequestFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    RejectApprovalRequestFluentHelper rejectApprovalRequest( @Nonnull final String salesOrder );

    /**
     * <p>
     * Creates a fluent helper for the <b>releaseApprovalRequest</b> OData function import.
     * </p>
     *
     * @param salesOrder
     *            Constraints: Not nullable, Maximum length: 11000
     *            <p>
     *            Original parameter name from the Odata EDM: <b>SalesOrder</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>releaseApprovalRequest</b> OData function import with the
     *         provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.ReleaseApprovalRequestFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ReleaseApprovalRequestFluentHelper releaseApprovalRequest( @Nonnull final String salesOrder );

}
