/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SalesOrderWithoutCharge;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SalesOrderWithoutChargeByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SalesOrderWithoutChargeCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SalesOrderWithoutChargeDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SalesOrderWithoutChargeFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SalesOrderWithoutChargeItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SalesOrderWithoutChargeItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SalesOrderWithoutChargeItemCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SalesOrderWithoutChargeItemDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SalesOrderWithoutChargeItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SalesOrderWithoutChargeItemUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SalesOrderWithoutChargeUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgItmPartner;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgItmPartnerByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgItmPartnerDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgItmPartnerFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgItmPartnerUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgItmText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgItmTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgItmTextDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgItmTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgItmTextUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgPartner;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgPartnerByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgPartnerDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgPartnerFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgPartnerUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgSchedLineByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgSchedLineFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgTextDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgTextUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.batch.SalesOrderWithoutChargeServiceBatch;

/**
 * <p>
 * In every API call, you can make use of the following operations: - You can read entire sales orders without charge or
 * only parts of the data, using the provided filters. - You can create sales orders without charge. Note that you must
 * use “deep insert” requests (a header plus the following entities: header partner, item and item partner). You cannot
 * create entities without including any related entities. - For existing sales orders without charge, you can create
 * new items. Note that you must use “deep insert” requests (with the entity: item partner). You cannot create entities
 * without including any related entities. - For existing sales orders without charge, you can update the header, header
 * partner, item and item partner. - For existing sales orders without charge, you can delete the header, header
 * partner, item and item partner..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/1e/b3e97d4e314e769d614b8d5b16468d/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_SALES_ORDER_WITHOUT_CHARGE_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_SALES_ORDER_WITHOUT_CHARGE_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Sales Order Without Charge Integration(SAP_COM_0334)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/BDA'>Free of Charge Delivery(BDA)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Sales Order Without Charge</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Deprecated
public interface SalesOrderWithoutChargeService extends BatchService<SalesOrderWithoutChargeServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_SALES_ORDER_WITHOUT_CHARGE_SRV";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    SalesOrderWithoutChargeService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SalesOrderWithoutCharge
     * SalesOrderWithoutCharge} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SalesOrderWithoutCharge
     *         SalesOrderWithoutCharge} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SalesOrderWithoutChargeFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesOrderWithoutChargeFluentHelper getAllSalesOrderWithoutCharge();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SalesOrderWithoutCharge
     * SalesOrderWithoutCharge} entity using key fields.
     *
     * @param salesOrderWithoutCharge
     *            Sales Order Without Charge
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SalesOrderWithoutCharge
     *         SalesOrderWithoutCharge} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SalesOrderWithoutChargeByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesOrderWithoutChargeByKeyFluentHelper getSalesOrderWithoutChargeByKey( final String salesOrderWithoutCharge );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SalesOrderWithoutCharge
     * SalesOrderWithoutCharge} entity and save it to the S/4HANA system.
     *
     * @param salesOrderWithoutCharge
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SalesOrderWithoutCharge
     *            SalesOrderWithoutCharge} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SalesOrderWithoutCharge
     *         SalesOrderWithoutCharge} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SalesOrderWithoutChargeCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesOrderWithoutChargeCreateFluentHelper
        createSalesOrderWithoutCharge( @Nonnull final SalesOrderWithoutCharge salesOrderWithoutCharge );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SalesOrderWithoutCharge
     * SalesOrderWithoutCharge} entity and save it to the S/4HANA system.
     *
     * @param salesOrderWithoutCharge
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SalesOrderWithoutCharge
     *            SalesOrderWithoutCharge} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SalesOrderWithoutCharge
     *         SalesOrderWithoutCharge} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SalesOrderWithoutChargeUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesOrderWithoutChargeUpdateFluentHelper
        updateSalesOrderWithoutCharge( @Nonnull final SalesOrderWithoutCharge salesOrderWithoutCharge );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SalesOrderWithoutCharge
     * SalesOrderWithoutCharge} entity in the S/4HANA system.
     *
     * @param salesOrderWithoutCharge
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SalesOrderWithoutCharge
     *            SalesOrderWithoutCharge} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SalesOrderWithoutCharge
     *         SalesOrderWithoutCharge} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SalesOrderWithoutChargeDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesOrderWithoutChargeDeleteFluentHelper
        deleteSalesOrderWithoutCharge( @Nonnull final SalesOrderWithoutCharge salesOrderWithoutCharge );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SalesOrderWithoutChargeItem
     * SalesOrderWithoutChargeItem} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SalesOrderWithoutChargeItem
     *         SalesOrderWithoutChargeItem} entities. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SalesOrderWithoutChargeItemFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesOrderWithoutChargeItemFluentHelper getAllSalesOrderWithoutChargeItem();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SalesOrderWithoutChargeItem
     * SalesOrderWithoutChargeItem} entity using key fields.
     *
     * @param salesOrderWithoutChargeItem
     *            Sales Order Without Charge Item
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param salesOrderWithoutCharge
     *            Sales Order Without Charge
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SalesOrderWithoutChargeItem
     *         SalesOrderWithoutChargeItem} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SalesOrderWithoutChargeItemByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesOrderWithoutChargeItemByKeyFluentHelper getSalesOrderWithoutChargeItemByKey(
        final String salesOrderWithoutCharge,
        final String salesOrderWithoutChargeItem );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SalesOrderWithoutChargeItem
     * SalesOrderWithoutChargeItem} entity and save it to the S/4HANA system.
     *
     * @param salesOrderWithoutChargeItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SalesOrderWithoutChargeItem
     *            SalesOrderWithoutChargeItem} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SalesOrderWithoutChargeItem
     *         SalesOrderWithoutChargeItem} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SalesOrderWithoutChargeItemCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesOrderWithoutChargeItemCreateFluentHelper
        createSalesOrderWithoutChargeItem( @Nonnull final SalesOrderWithoutChargeItem salesOrderWithoutChargeItem );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SalesOrderWithoutChargeItem
     * SalesOrderWithoutChargeItem} entity and save it to the S/4HANA system.
     *
     * @param salesOrderWithoutChargeItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SalesOrderWithoutChargeItem
     *            SalesOrderWithoutChargeItem} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SalesOrderWithoutChargeItem
     *         SalesOrderWithoutChargeItem} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SalesOrderWithoutChargeItemUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesOrderWithoutChargeItemUpdateFluentHelper
        updateSalesOrderWithoutChargeItem( @Nonnull final SalesOrderWithoutChargeItem salesOrderWithoutChargeItem );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SalesOrderWithoutChargeItem
     * SalesOrderWithoutChargeItem} entity in the S/4HANA system.
     *
     * @param salesOrderWithoutChargeItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SalesOrderWithoutChargeItem
     *            SalesOrderWithoutChargeItem} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SalesOrderWithoutChargeItem
     *         SalesOrderWithoutChargeItem} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SalesOrderWithoutChargeItemDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesOrderWithoutChargeItemDeleteFluentHelper
        deleteSalesOrderWithoutChargeItem( @Nonnull final SalesOrderWithoutChargeItem salesOrderWithoutChargeItem );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgItmPartner
     * SlsOrdWthoutChrgItmPartner} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgItmPartner
     *         SlsOrdWthoutChrgItmPartner} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgItmPartnerFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SlsOrdWthoutChrgItmPartnerFluentHelper getAllSlsOrdWthoutChrgItmPartner();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgItmPartner
     * SlsOrdWthoutChrgItmPartner} entity using key fields.
     *
     * @param partnerFunction
     *            Partner Function
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param salesOrderWithoutChargeItem
     *            Sales Order Without Charge Item
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param salesOrderWithoutCharge
     *            Sales Order Without Charge
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgItmPartner
     *         SlsOrdWthoutChrgItmPartner} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgItmPartnerByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SlsOrdWthoutChrgItmPartnerByKeyFluentHelper getSlsOrdWthoutChrgItmPartnerByKey(
        final String salesOrderWithoutCharge,
        final String salesOrderWithoutChargeItem,
        final String partnerFunction );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgItmPartner
     * SlsOrdWthoutChrgItmPartner} entity and save it to the S/4HANA system.
     *
     * @param slsOrdWthoutChrgItmPartner
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgItmPartner
     *            SlsOrdWthoutChrgItmPartner} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgItmPartner
     *         SlsOrdWthoutChrgItmPartner} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgItmPartnerUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SlsOrdWthoutChrgItmPartnerUpdateFluentHelper
        updateSlsOrdWthoutChrgItmPartner( @Nonnull final SlsOrdWthoutChrgItmPartner slsOrdWthoutChrgItmPartner );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgItmPartner
     * SlsOrdWthoutChrgItmPartner} entity in the S/4HANA system.
     *
     * @param slsOrdWthoutChrgItmPartner
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgItmPartner
     *            SlsOrdWthoutChrgItmPartner} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgItmPartner
     *         SlsOrdWthoutChrgItmPartner} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgItmPartnerDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SlsOrdWthoutChrgItmPartnerDeleteFluentHelper
        deleteSlsOrdWthoutChrgItmPartner( @Nonnull final SlsOrdWthoutChrgItmPartner slsOrdWthoutChrgItmPartner );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgItmText
     * SlsOrdWthoutChrgItmText} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgItmText
     *         SlsOrdWthoutChrgItmText} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgItmTextFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SlsOrdWthoutChrgItmTextFluentHelper getAllSlsOrdWthoutChrgItmText();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgItmText
     * SlsOrdWthoutChrgItmText} entity using key fields.
     *
     * @param salesOrderWithoutChargeItem
     *            Sales Order Without Charge Item
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param salesOrderWithoutCharge
     *            Sales Order Without Charge
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param longTextID
     *            Text ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgItmText
     *         SlsOrdWthoutChrgItmText} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgItmTextByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SlsOrdWthoutChrgItmTextByKeyFluentHelper getSlsOrdWthoutChrgItmTextByKey(
        final String salesOrderWithoutCharge,
        final String salesOrderWithoutChargeItem,
        final String language,
        final String longTextID );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgItmText
     * SlsOrdWthoutChrgItmText} entity and save it to the S/4HANA system.
     *
     * @param slsOrdWthoutChrgItmText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgItmText
     *            SlsOrdWthoutChrgItmText} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgItmText
     *         SlsOrdWthoutChrgItmText} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgItmTextUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SlsOrdWthoutChrgItmTextUpdateFluentHelper
        updateSlsOrdWthoutChrgItmText( @Nonnull final SlsOrdWthoutChrgItmText slsOrdWthoutChrgItmText );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgItmText
     * SlsOrdWthoutChrgItmText} entity in the S/4HANA system.
     *
     * @param slsOrdWthoutChrgItmText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgItmText
     *            SlsOrdWthoutChrgItmText} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgItmText
     *         SlsOrdWthoutChrgItmText} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgItmTextDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SlsOrdWthoutChrgItmTextDeleteFluentHelper
        deleteSlsOrdWthoutChrgItmText( @Nonnull final SlsOrdWthoutChrgItmText slsOrdWthoutChrgItmText );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgPartner
     * SlsOrdWthoutChrgPartner} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgPartner
     *         SlsOrdWthoutChrgPartner} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgPartnerFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SlsOrdWthoutChrgPartnerFluentHelper getAllSlsOrdWthoutChrgPartner();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgPartner
     * SlsOrdWthoutChrgPartner} entity using key fields.
     *
     * @param partnerFunction
     *            Partner Function
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param salesOrderWithoutCharge
     *            Sales Order Without Charge
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgPartner
     *         SlsOrdWthoutChrgPartner} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgPartnerByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SlsOrdWthoutChrgPartnerByKeyFluentHelper
        getSlsOrdWthoutChrgPartnerByKey( final String salesOrderWithoutCharge, final String partnerFunction );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgPartner
     * SlsOrdWthoutChrgPartner} entity and save it to the S/4HANA system.
     *
     * @param slsOrdWthoutChrgPartner
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgPartner
     *            SlsOrdWthoutChrgPartner} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgPartner
     *         SlsOrdWthoutChrgPartner} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgPartnerUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SlsOrdWthoutChrgPartnerUpdateFluentHelper
        updateSlsOrdWthoutChrgPartner( @Nonnull final SlsOrdWthoutChrgPartner slsOrdWthoutChrgPartner );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgPartner
     * SlsOrdWthoutChrgPartner} entity in the S/4HANA system.
     *
     * @param slsOrdWthoutChrgPartner
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgPartner
     *            SlsOrdWthoutChrgPartner} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgPartner
     *         SlsOrdWthoutChrgPartner} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgPartnerDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SlsOrdWthoutChrgPartnerDeleteFluentHelper
        deleteSlsOrdWthoutChrgPartner( @Nonnull final SlsOrdWthoutChrgPartner slsOrdWthoutChrgPartner );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgSchedLine
     * SlsOrdWthoutChrgSchedLine} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgSchedLine
     *         SlsOrdWthoutChrgSchedLine} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgSchedLineFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SlsOrdWthoutChrgSchedLineFluentHelper getAllSlsOrdWthoutChrgSchedLine();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgSchedLine
     * SlsOrdWthoutChrgSchedLine} entity using key fields.
     *
     * @param salesOrderWithoutChargeItem
     *            Sales Document Item
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param scheduleLine
     *            Schedule Line Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param salesOrderWithoutCharge
     *            Sales Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgSchedLine
     *         SlsOrdWthoutChrgSchedLine} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgSchedLineByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SlsOrdWthoutChrgSchedLineByKeyFluentHelper getSlsOrdWthoutChrgSchedLineByKey(
        final String salesOrderWithoutCharge,
        final String salesOrderWithoutChargeItem,
        final String scheduleLine );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgText
     * SlsOrdWthoutChrgText} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgText
     *         SlsOrdWthoutChrgText} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgTextFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SlsOrdWthoutChrgTextFluentHelper getAllSlsOrdWthoutChrgText();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgText
     * SlsOrdWthoutChrgText} entity using key fields.
     *
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param salesOrderWithoutCharge
     *            Sales Order Without Charge
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param longTextID
     *            Text ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgText
     *         SlsOrdWthoutChrgText} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgTextByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SlsOrdWthoutChrgTextByKeyFluentHelper getSlsOrdWthoutChrgTextByKey(
        final String salesOrderWithoutCharge,
        final String language,
        final String longTextID );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgText
     * SlsOrdWthoutChrgText} entity and save it to the S/4HANA system.
     *
     * @param slsOrdWthoutChrgText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgText
     *            SlsOrdWthoutChrgText} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgText
     *         SlsOrdWthoutChrgText} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgTextUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SlsOrdWthoutChrgTextUpdateFluentHelper
        updateSlsOrdWthoutChrgText( @Nonnull final SlsOrdWthoutChrgText slsOrdWthoutChrgText );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgText
     * SlsOrdWthoutChrgText} entity in the S/4HANA system.
     *
     * @param slsOrdWthoutChrgText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgText
     *            SlsOrdWthoutChrgText} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgText
     *         SlsOrdWthoutChrgText} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgTextDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SlsOrdWthoutChrgTextDeleteFluentHelper
        deleteSlsOrdWthoutChrgText( @Nonnull final SlsOrdWthoutChrgText slsOrdWthoutChrgText );

}
