/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.math.BigDecimal;
import java.time.LocalDateTime;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.CreateCorrectionDeliveryFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmt;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtDelivSchedByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtDelivSchedFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtItemCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtItemDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtItemPartner;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtItemPartnerByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtItemPartnerDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtItemPartnerFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtItemPartnerUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtItemText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtItemTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtItemTextDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtItemTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtItemTextUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtItemUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtItmPrcgElmnt;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtItmPrcgElmntByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtItmPrcgElmntDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtItmPrcgElmntFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtItmPrcgElmntUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtPartner;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtPartnerByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtPartnerDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtPartnerFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtPartnerUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtPrcgElement;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtPrcgElementByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtPrcgElementDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtPrcgElementFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtPrcgElementUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtSchedLineByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtSchedLineFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtTextDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtTextUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.batch.SalesSchedulingAgreementServiceBatch;

/**
 * <p>
 *
 * The service contains header, item, delivery schedule, and schedule line entities, as well as header and item
 * sub-entities for partners and pricing elements. Once the sales scheduling agreement has been created, the sales
 * scheduling agreement number is sent in the response with the data included in the sales scheduling agreement. If
 * there are any issues when creating, retrieving, updating, or deleting the sales scheduling agreement, the system
 * displays error messages in the response..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/90/4b06b7cbb84ce48e7f71c58db856e0/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_SALES_SCHEDULING_AGREEMENT?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_SALES_SCHEDULING_AGREEMENT</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Sales Scheduling Agreements Integration(SAP_COM_0360)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/3NR'>Sales Scheduling Agreements(3NR)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/4LZ'>Sales Scheduling Agreement with Consignment(4LZ)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Sales Scheduling Agreement</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Deprecated
public interface SalesSchedulingAgreementService extends BatchService<SalesSchedulingAgreementServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_SALES_SCHEDULING_AGREEMENT";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    SalesSchedulingAgreementService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmt
     * SalesSchedgAgrmt} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmt
     *         SalesSchedgAgrmt} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesSchedgAgrmtFluentHelper getAllSalesSchedgAgrmt();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmt
     * SalesSchedgAgrmt} entity using key fields.
     *
     * @param salesSchedulingAgreement
     *            Sales Scheduling Agreement
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmt
     *         SalesSchedgAgrmt} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesSchedgAgrmtByKeyFluentHelper getSalesSchedgAgrmtByKey( final String salesSchedulingAgreement );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmt
     * SalesSchedgAgrmt} entity and save it to the S/4HANA system.
     *
     * @param salesSchedgAgrmt
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmt
     *            SalesSchedgAgrmt} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmt
     *         SalesSchedgAgrmt} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesSchedgAgrmtCreateFluentHelper createSalesSchedgAgrmt( @Nonnull final SalesSchedgAgrmt salesSchedgAgrmt );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmt
     * SalesSchedgAgrmt} entity and save it to the S/4HANA system.
     *
     * @param salesSchedgAgrmt
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmt
     *            SalesSchedgAgrmt} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmt
     *         SalesSchedgAgrmt} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesSchedgAgrmtUpdateFluentHelper updateSalesSchedgAgrmt( @Nonnull final SalesSchedgAgrmt salesSchedgAgrmt );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmt
     * SalesSchedgAgrmt} entity in the S/4HANA system.
     *
     * @param salesSchedgAgrmt
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmt
     *            SalesSchedgAgrmt} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmt
     *         SalesSchedgAgrmt} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesSchedgAgrmtDeleteFluentHelper deleteSalesSchedgAgrmt( @Nonnull final SalesSchedgAgrmt salesSchedgAgrmt );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtDelivSched
     * SalesSchedgAgrmtDelivSched} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtDelivSched
     *         SalesSchedgAgrmtDelivSched} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtDelivSchedFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesSchedgAgrmtDelivSchedFluentHelper getAllSalesSchedgAgrmtDelivSched();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtDelivSched
     * SalesSchedgAgrmtDelivSched} entity using key fields.
     *
     * @param salesSchedulingAgreement
     *            Sales Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param schedulingAgreementReleaseType
     *            Release type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     * @param intDeliveryScheduleNumber
     *            Internal delivery schedule number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param salesSchedulingAgreementItem
     *            Sales Document Item
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtDelivSched
     *         SalesSchedgAgrmtDelivSched} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtDelivSchedByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesSchedgAgrmtDelivSchedByKeyFluentHelper getSalesSchedgAgrmtDelivSchedByKey(
        final String salesSchedulingAgreement,
        final String salesSchedulingAgreementItem,
        final String intDeliveryScheduleNumber,
        final String schedulingAgreementReleaseType );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtItem
     * SalesSchedgAgrmtItem} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtItem
     *         SalesSchedgAgrmtItem} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtItemFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesSchedgAgrmtItemFluentHelper getAllSalesSchedgAgrmtItem();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtItem
     * SalesSchedgAgrmtItem} entity using key fields.
     *
     * @param salesSchedulingAgreement
     *            Sales Scheduling Agreement
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param salesSchedulingAgreementItem
     *            Sales Scheduling Agreement Item
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtItem
     *         SalesSchedgAgrmtItem} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtItemByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesSchedgAgrmtItemByKeyFluentHelper getSalesSchedgAgrmtItemByKey(
        final String salesSchedulingAgreement,
        final String salesSchedulingAgreementItem );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtItem
     * SalesSchedgAgrmtItem} entity and save it to the S/4HANA system.
     *
     * @param salesSchedgAgrmtItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtItem
     *            SalesSchedgAgrmtItem} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtItem
     *         SalesSchedgAgrmtItem} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtItemCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesSchedgAgrmtItemCreateFluentHelper
        createSalesSchedgAgrmtItem( @Nonnull final SalesSchedgAgrmtItem salesSchedgAgrmtItem );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtItem
     * SalesSchedgAgrmtItem} entity and save it to the S/4HANA system.
     *
     * @param salesSchedgAgrmtItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtItem
     *            SalesSchedgAgrmtItem} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtItem
     *         SalesSchedgAgrmtItem} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtItemUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesSchedgAgrmtItemUpdateFluentHelper
        updateSalesSchedgAgrmtItem( @Nonnull final SalesSchedgAgrmtItem salesSchedgAgrmtItem );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtItem
     * SalesSchedgAgrmtItem} entity in the S/4HANA system.
     *
     * @param salesSchedgAgrmtItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtItem
     *            SalesSchedgAgrmtItem} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtItem
     *         SalesSchedgAgrmtItem} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtItemDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesSchedgAgrmtItemDeleteFluentHelper
        deleteSalesSchedgAgrmtItem( @Nonnull final SalesSchedgAgrmtItem salesSchedgAgrmtItem );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtItemPartner
     * SalesSchedgAgrmtItemPartner} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtItemPartner
     *         SalesSchedgAgrmtItemPartner} entities. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtItemPartnerFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesSchedgAgrmtItemPartnerFluentHelper getAllSalesSchedgAgrmtItemPartner();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtItemPartner
     * SalesSchedgAgrmtItemPartner} entity using key fields.
     *
     * @param partnerFunction
     *            Partner Function
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param salesSchedulingAgreement
     *            Sales Scheduling Agreement
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param salesSchedulingAgreementItem
     *            Sales Scheduling Agreement Item
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtItemPartner
     *         SalesSchedgAgrmtItemPartner} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtItemPartnerByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesSchedgAgrmtItemPartnerByKeyFluentHelper getSalesSchedgAgrmtItemPartnerByKey(
        final String salesSchedulingAgreement,
        final String salesSchedulingAgreementItem,
        final String partnerFunction );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtItemPartner
     * SalesSchedgAgrmtItemPartner} entity and save it to the S/4HANA system.
     *
     * @param salesSchedgAgrmtItemPartner
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtItemPartner
     *            SalesSchedgAgrmtItemPartner} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtItemPartner
     *         SalesSchedgAgrmtItemPartner} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtItemPartnerUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesSchedgAgrmtItemPartnerUpdateFluentHelper
        updateSalesSchedgAgrmtItemPartner( @Nonnull final SalesSchedgAgrmtItemPartner salesSchedgAgrmtItemPartner );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtItemPartner
     * SalesSchedgAgrmtItemPartner} entity in the S/4HANA system.
     *
     * @param salesSchedgAgrmtItemPartner
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtItemPartner
     *            SalesSchedgAgrmtItemPartner} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtItemPartner
     *         SalesSchedgAgrmtItemPartner} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtItemPartnerDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesSchedgAgrmtItemPartnerDeleteFluentHelper
        deleteSalesSchedgAgrmtItemPartner( @Nonnull final SalesSchedgAgrmtItemPartner salesSchedgAgrmtItemPartner );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtItemText
     * SalesSchedgAgrmtItemText} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtItemText
     *         SalesSchedgAgrmtItemText} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtItemTextFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesSchedgAgrmtItemTextFluentHelper getAllSalesSchedgAgrmtItemText();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtItemText
     * SalesSchedgAgrmtItemText} entity using key fields.
     *
     * @param salesSchedulingAgreement
     *            Sales Scheduling Agreement
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param longTextID
     *            Text ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param salesSchedulingAgreementItem
     *            Sales Scheduling Agreement Item
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtItemText
     *         SalesSchedgAgrmtItemText} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtItemTextByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesSchedgAgrmtItemTextByKeyFluentHelper getSalesSchedgAgrmtItemTextByKey(
        final String salesSchedulingAgreement,
        final String salesSchedulingAgreementItem,
        final String language,
        final String longTextID );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtItemText
     * SalesSchedgAgrmtItemText} entity and save it to the S/4HANA system.
     *
     * @param salesSchedgAgrmtItemText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtItemText
     *            SalesSchedgAgrmtItemText} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtItemText
     *         SalesSchedgAgrmtItemText} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtItemTextUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesSchedgAgrmtItemTextUpdateFluentHelper
        updateSalesSchedgAgrmtItemText( @Nonnull final SalesSchedgAgrmtItemText salesSchedgAgrmtItemText );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtItemText
     * SalesSchedgAgrmtItemText} entity in the S/4HANA system.
     *
     * @param salesSchedgAgrmtItemText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtItemText
     *            SalesSchedgAgrmtItemText} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtItemText
     *         SalesSchedgAgrmtItemText} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtItemTextDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesSchedgAgrmtItemTextDeleteFluentHelper
        deleteSalesSchedgAgrmtItemText( @Nonnull final SalesSchedgAgrmtItemText salesSchedgAgrmtItemText );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtItmPrcgElmnt
     * SalesSchedgAgrmtItmPrcgElmnt} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtItmPrcgElmnt
     *         SalesSchedgAgrmtItmPrcgElmnt} entities. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtItmPrcgElmntFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesSchedgAgrmtItmPrcgElmntFluentHelper getAllSalesSchedgAgrmtItmPrcgElmnt();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtItmPrcgElmnt
     * SalesSchedgAgrmtItmPrcgElmnt} entity using key fields.
     *
     * @param salesSchedulingAgreement
     *            Sales Scheduling Agreement
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param pricingProcedureCounter
     *            Condition Counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @param pricingProcedureStep
     *            Step Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @param salesSchedulingAgreementItem
     *            Sales Scheduling Agreement Item
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtItmPrcgElmnt
     *         SalesSchedgAgrmtItmPrcgElmnt} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtItmPrcgElmntByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesSchedgAgrmtItmPrcgElmntByKeyFluentHelper getSalesSchedgAgrmtItmPrcgElmntByKey(
        final String salesSchedulingAgreement,
        final String salesSchedulingAgreementItem,
        final String pricingProcedureStep,
        final String pricingProcedureCounter );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtItmPrcgElmnt
     * SalesSchedgAgrmtItmPrcgElmnt} entity and save it to the S/4HANA system.
     *
     * @param salesSchedgAgrmtItmPrcgElmnt
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtItmPrcgElmnt
     *            SalesSchedgAgrmtItmPrcgElmnt} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtItmPrcgElmnt
     *         SalesSchedgAgrmtItmPrcgElmnt} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtItmPrcgElmntUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesSchedgAgrmtItmPrcgElmntUpdateFluentHelper
        updateSalesSchedgAgrmtItmPrcgElmnt( @Nonnull final SalesSchedgAgrmtItmPrcgElmnt salesSchedgAgrmtItmPrcgElmnt );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtItmPrcgElmnt
     * SalesSchedgAgrmtItmPrcgElmnt} entity in the S/4HANA system.
     *
     * @param salesSchedgAgrmtItmPrcgElmnt
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtItmPrcgElmnt
     *            SalesSchedgAgrmtItmPrcgElmnt} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtItmPrcgElmnt
     *         SalesSchedgAgrmtItmPrcgElmnt} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtItmPrcgElmntDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesSchedgAgrmtItmPrcgElmntDeleteFluentHelper
        deleteSalesSchedgAgrmtItmPrcgElmnt( @Nonnull final SalesSchedgAgrmtItmPrcgElmnt salesSchedgAgrmtItmPrcgElmnt );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtPartner
     * SalesSchedgAgrmtPartner} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtPartner
     *         SalesSchedgAgrmtPartner} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtPartnerFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesSchedgAgrmtPartnerFluentHelper getAllSalesSchedgAgrmtPartner();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtPartner
     * SalesSchedgAgrmtPartner} entity using key fields.
     *
     * @param partnerFunction
     *            Partner Function
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param salesSchedulingAgreement
     *            Sales Scheduling Agreement
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtPartner
     *         SalesSchedgAgrmtPartner} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtPartnerByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesSchedgAgrmtPartnerByKeyFluentHelper
        getSalesSchedgAgrmtPartnerByKey( final String salesSchedulingAgreement, final String partnerFunction );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtPartner
     * SalesSchedgAgrmtPartner} entity and save it to the S/4HANA system.
     *
     * @param salesSchedgAgrmtPartner
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtPartner
     *            SalesSchedgAgrmtPartner} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtPartner
     *         SalesSchedgAgrmtPartner} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtPartnerUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesSchedgAgrmtPartnerUpdateFluentHelper
        updateSalesSchedgAgrmtPartner( @Nonnull final SalesSchedgAgrmtPartner salesSchedgAgrmtPartner );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtPartner
     * SalesSchedgAgrmtPartner} entity in the S/4HANA system.
     *
     * @param salesSchedgAgrmtPartner
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtPartner
     *            SalesSchedgAgrmtPartner} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtPartner
     *         SalesSchedgAgrmtPartner} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtPartnerDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesSchedgAgrmtPartnerDeleteFluentHelper
        deleteSalesSchedgAgrmtPartner( @Nonnull final SalesSchedgAgrmtPartner salesSchedgAgrmtPartner );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtPrcgElement
     * SalesSchedgAgrmtPrcgElement} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtPrcgElement
     *         SalesSchedgAgrmtPrcgElement} entities. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtPrcgElementFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesSchedgAgrmtPrcgElementFluentHelper getAllSalesSchedgAgrmtPrcgElement();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtPrcgElement
     * SalesSchedgAgrmtPrcgElement} entity using key fields.
     *
     * @param salesSchedulingAgreement
     *            Sales Scheduling Agreement
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param pricingProcedureCounter
     *            Condition Counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @param pricingProcedureStep
     *            Step Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtPrcgElement
     *         SalesSchedgAgrmtPrcgElement} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtPrcgElementByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesSchedgAgrmtPrcgElementByKeyFluentHelper getSalesSchedgAgrmtPrcgElementByKey(
        final String salesSchedulingAgreement,
        final String pricingProcedureStep,
        final String pricingProcedureCounter );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtPrcgElement
     * SalesSchedgAgrmtPrcgElement} entity and save it to the S/4HANA system.
     *
     * @param salesSchedgAgrmtPrcgElement
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtPrcgElement
     *            SalesSchedgAgrmtPrcgElement} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtPrcgElement
     *         SalesSchedgAgrmtPrcgElement} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtPrcgElementUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesSchedgAgrmtPrcgElementUpdateFluentHelper
        updateSalesSchedgAgrmtPrcgElement( @Nonnull final SalesSchedgAgrmtPrcgElement salesSchedgAgrmtPrcgElement );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtPrcgElement
     * SalesSchedgAgrmtPrcgElement} entity in the S/4HANA system.
     *
     * @param salesSchedgAgrmtPrcgElement
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtPrcgElement
     *            SalesSchedgAgrmtPrcgElement} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtPrcgElement
     *         SalesSchedgAgrmtPrcgElement} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtPrcgElementDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesSchedgAgrmtPrcgElementDeleteFluentHelper
        deleteSalesSchedgAgrmtPrcgElement( @Nonnull final SalesSchedgAgrmtPrcgElement salesSchedgAgrmtPrcgElement );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtSchedLine
     * SalesSchedgAgrmtSchedLine} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtSchedLine
     *         SalesSchedgAgrmtSchedLine} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtSchedLineFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesSchedgAgrmtSchedLineFluentHelper getAllSalesSchedgAgrmtSchedLine();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtSchedLine
     * SalesSchedgAgrmtSchedLine} entity using key fields.
     *
     * @param salesSchedulingAgreement
     *            Sales Scheduling Agreement
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param scheduleLine
     *            Schedule Line Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param salesSchedulingAgreementItem
     *            Sales Scheduling Agreement Item
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtSchedLine
     *         SalesSchedgAgrmtSchedLine} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtSchedLineByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesSchedgAgrmtSchedLineByKeyFluentHelper getSalesSchedgAgrmtSchedLineByKey(
        final String salesSchedulingAgreement,
        final String salesSchedulingAgreementItem,
        final String scheduleLine );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtText
     * SalesSchedgAgrmtText} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtText
     *         SalesSchedgAgrmtText} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtTextFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesSchedgAgrmtTextFluentHelper getAllSalesSchedgAgrmtText();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtText
     * SalesSchedgAgrmtText} entity using key fields.
     *
     * @param salesSchedulingAgreement
     *            Sales Scheduling Agreement
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param longTextID
     *            Text ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtText
     *         SalesSchedgAgrmtText} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtTextByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesSchedgAgrmtTextByKeyFluentHelper getSalesSchedgAgrmtTextByKey(
        final String salesSchedulingAgreement,
        final String language,
        final String longTextID );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtText
     * SalesSchedgAgrmtText} entity and save it to the S/4HANA system.
     *
     * @param salesSchedgAgrmtText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtText
     *            SalesSchedgAgrmtText} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtText
     *         SalesSchedgAgrmtText} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtTextUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesSchedgAgrmtTextUpdateFluentHelper
        updateSalesSchedgAgrmtText( @Nonnull final SalesSchedgAgrmtText salesSchedgAgrmtText );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtText
     * SalesSchedgAgrmtText} entity in the S/4HANA system.
     *
     * @param salesSchedgAgrmtText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtText
     *            SalesSchedgAgrmtText} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtText
     *         SalesSchedgAgrmtText} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.SalesSchedgAgrmtTextDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesSchedgAgrmtTextDeleteFluentHelper
        deleteSalesSchedgAgrmtText( @Nonnull final SalesSchedgAgrmtText salesSchedgAgrmtText );

    /**
     * <p>
     * Creates a fluent helper for the <b>CreateCorrectionDelivery</b> OData function import.
     * </p>
     *
     * @param correctionDeliveryDate
     *            Date and Time of Correction Delivery
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Precision: 0
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>CorrectionDeliveryDate</b>
     *            </p>
     * @param correctionDeliveryQuantity
     *            Quantity of Correction Delivery
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Precision: 31, Scale: 0
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>CorrectionDeliveryQuantity</b>
     *            </p>
     * @param salesSchedulingAgreement
     *            Sales Scheduling Agreement
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>SalesSchedulingAgreement</b>
     *            </p>
     * @param salesSchedulingAgreementItem
     *            Sales Scheduling Agreement Item
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>SalesSchedulingAgreementItem</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>CreateCorrectionDelivery</b> OData function import with
     *         the provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesschedulingagreement.CreateCorrectionDeliveryFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CreateCorrectionDeliveryFluentHelper createCorrectionDelivery(
        @Nonnull final String salesSchedulingAgreementItem,
        @Nonnull final String salesSchedulingAgreement,
        @Nonnull final BigDecimal correctionDeliveryQuantity,
        @Nonnull final LocalDateTime correctionDeliveryDate );

}
