/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.HeaderReleaseFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.ItemReleaseFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtAcCnt;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtAcCntByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtAcCntCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtAcCntFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtAcCntUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtHeader;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtHeaderByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtHeaderCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtHeaderFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtHeaderUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtItemCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtItemUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtPartnerByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtPartnerFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtSchLine;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtSchLineByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtSchLineCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtSchLineDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtSchLineFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtSchLineUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtDeliveryAddress;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtDeliveryAddressByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtDeliveryAddressCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtDeliveryAddressFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtDeliveryAddressUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtHdrNotes;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtHdrNotesByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtHdrNotesCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtHdrNotesDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtHdrNotesFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtHdrNotesUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtItmNotes;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtItmNotesByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtItmNotesCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtItmNotesDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtItmNotesFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtItmNotesUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtSubcontrgComp;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtSubcontrgCompByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtSubcontrgCompDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtSubcontrgCompFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtSubcontrgCompUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.WithdrawFromApprovalFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.batch.SchedulingAgreementServiceBatch;

/**
 * <p>
 * This service enables you to create, read, update and delete purchase scheduling agreements from any external system
 * through an API call. Once the purchase scheduling agreement has been created or updated, the scheduling agreement
 * number is sent in the response. If there are any issues while managing (create, read or update) purchase scheduling
 * agreements, the system displays error messages in the response.
 *
 * # .
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/c7/584658aac4a007e10000000a441470/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_SCHED_AGRMT_PROCESS_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_SCHED_AGRMT_PROCESS_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Purchase Scheduling Agreement Integration(SAP_COM_0103)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/BMR'>Scheduling Agreements in Procurement(BMR)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BNX'>Consumable Purchasing(BNX)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/J45'>Procurement of Direct Materials(J45)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/O45'>Procurement of Direct Materials(O45)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/ONX'>Consumable Purchasing(ONX)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Purchase Scheduling Agreement</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Deprecated
public interface SchedulingAgreementService extends BatchService<SchedulingAgreementServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_SCHED_AGRMT_PROCESS_SRV";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    SchedulingAgreementService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtAcCnt
     * SchAgrmtAcCnt} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtAcCnt
     *         SchAgrmtAcCnt} entities. This fluent helper allows methods which modify the underlying query to be called
     *         before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtAcCntFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SchAgrmtAcCntFluentHelper getAllSchAgrmtAcCnt();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtAcCnt
     * SchAgrmtAcCnt} entity using key fields.
     *
     * @param schedulingAgreement
     *            Purchasing Document Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param accountAssignmentNumber
     *            Sequential Number of Account Assignment
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param schedulingAgreementItem
     *            Item Number of Purchasing Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 5
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtAcCnt
     *         SchAgrmtAcCnt} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtAcCntByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SchAgrmtAcCntByKeyFluentHelper getSchAgrmtAcCntByKey(
        final String accountAssignmentNumber,
        final String schedulingAgreementItem,
        final String schedulingAgreement );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtAcCnt
     * SchAgrmtAcCnt} entity and save it to the S/4HANA system.
     *
     * @param schAgrmtAcCnt
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtAcCnt
     *            SchAgrmtAcCnt} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtAcCnt
     *         SchAgrmtAcCnt} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtAcCntCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SchAgrmtAcCntCreateFluentHelper createSchAgrmtAcCnt( @Nonnull final SchAgrmtAcCnt schAgrmtAcCnt );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtAcCnt
     * SchAgrmtAcCnt} entity and save it to the S/4HANA system.
     *
     * @param schAgrmtAcCnt
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtAcCnt
     *            SchAgrmtAcCnt} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtAcCnt
     *         SchAgrmtAcCnt} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtAcCntUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SchAgrmtAcCntUpdateFluentHelper updateSchAgrmtAcCnt( @Nonnull final SchAgrmtAcCnt schAgrmtAcCnt );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtHeader
     * SchAgrmtHeader} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtHeader
     *         SchAgrmtHeader} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtHeaderFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SchAgrmtHeaderFluentHelper getAllSchAgrmtHeader();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtHeader
     * SchAgrmtHeader} entity using key fields.
     *
     * @param schedulingAgreement
     *            Purchasing Document Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtHeader
     *         SchAgrmtHeader} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtHeaderByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SchAgrmtHeaderByKeyFluentHelper getSchAgrmtHeaderByKey( final String schedulingAgreement );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtHeader
     * SchAgrmtHeader} entity and save it to the S/4HANA system.
     *
     * @param schAgrmtHeader
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtHeader
     *            SchAgrmtHeader} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtHeader
     *         SchAgrmtHeader} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtHeaderCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SchAgrmtHeaderCreateFluentHelper createSchAgrmtHeader( @Nonnull final SchAgrmtHeader schAgrmtHeader );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtHeader
     * SchAgrmtHeader} entity and save it to the S/4HANA system.
     *
     * @param schAgrmtHeader
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtHeader
     *            SchAgrmtHeader} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtHeader
     *         SchAgrmtHeader} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtHeaderUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SchAgrmtHeaderUpdateFluentHelper updateSchAgrmtHeader( @Nonnull final SchAgrmtHeader schAgrmtHeader );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtItem
     * SchAgrmtItem} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtItem SchAgrmtItem}
     *         entities. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtItemFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SchAgrmtItemFluentHelper getAllSchAgrmtItem();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtItem
     * SchAgrmtItem} entity using key fields.
     *
     * @param schedulingAgreement
     *            Purchasing Document Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param schedulingAgreementItem
     *            Item Number of Purchasing Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 5
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtItem SchAgrmtItem}
     *         entity using key fields. This fluent helper allows methods which modify the underlying query to be called
     *         before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtItemByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SchAgrmtItemByKeyFluentHelper
        getSchAgrmtItemByKey( final String schedulingAgreement, final String schedulingAgreementItem );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtItem
     * SchAgrmtItem} entity and save it to the S/4HANA system.
     *
     * @param schAgrmtItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtItem
     *            SchAgrmtItem} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtItem SchAgrmtItem}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtItemCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SchAgrmtItemCreateFluentHelper createSchAgrmtItem( @Nonnull final SchAgrmtItem schAgrmtItem );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtItem
     * SchAgrmtItem} entity and save it to the S/4HANA system.
     *
     * @param schAgrmtItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtItem
     *            SchAgrmtItem} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtItem SchAgrmtItem}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtItemUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SchAgrmtItemUpdateFluentHelper updateSchAgrmtItem( @Nonnull final SchAgrmtItem schAgrmtItem );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtPartner
     * SchAgrmtPartner} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtPartner
     *         SchAgrmtPartner} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtPartnerFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SchAgrmtPartnerFluentHelper getAllSchAgrmtPartner();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtPartner
     * SchAgrmtPartner} entity using key fields.
     *
     * @param schedulingAgreement
     *            Purchasing Document Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param partnerFunction
     *            Partner Function
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param plant
     *            Plant
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param purchasingOrganization
     *            Purchasing Organization
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param partnerCounter
     *            Partner counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @param supplierSubrange
     *            Supplier Subrange
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param schedulingAgreementItem
     *            Item Number of Purchasing Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 5
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtPartner
     *         SchAgrmtPartner} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtPartnerByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SchAgrmtPartnerByKeyFluentHelper getSchAgrmtPartnerByKey(
        final String schedulingAgreement,
        final String schedulingAgreementItem,
        final String purchasingOrganization,
        final String supplierSubrange,
        final String plant,
        final String partnerFunction,
        final String partnerCounter );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtSchLine
     * SchAgrmtSchLine} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtSchLine
     *         SchAgrmtSchLine} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtSchLineFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SchAgrmtSchLineFluentHelper getAllSchAgrmtSchLine();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtSchLine
     * SchAgrmtSchLine} entity using key fields.
     *
     * @param schedulingAgreement
     *            Purchasing Document Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param scheduleLine
     *            Delivery Schedule Line Counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param schedulingAgreementItem
     *            Item Number of Purchasing Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 5
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtSchLine
     *         SchAgrmtSchLine} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtSchLineByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SchAgrmtSchLineByKeyFluentHelper getSchAgrmtSchLineByKey(
        final String schedulingAgreement,
        final String schedulingAgreementItem,
        final String scheduleLine );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtSchLine
     * SchAgrmtSchLine} entity and save it to the S/4HANA system.
     *
     * @param schAgrmtSchLine
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtSchLine
     *            SchAgrmtSchLine} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtSchLine
     *         SchAgrmtSchLine} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtSchLineCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SchAgrmtSchLineCreateFluentHelper createSchAgrmtSchLine( @Nonnull final SchAgrmtSchLine schAgrmtSchLine );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtSchLine
     * SchAgrmtSchLine} entity and save it to the S/4HANA system.
     *
     * @param schAgrmtSchLine
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtSchLine
     *            SchAgrmtSchLine} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtSchLine
     *         SchAgrmtSchLine} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtSchLineUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SchAgrmtSchLineUpdateFluentHelper updateSchAgrmtSchLine( @Nonnull final SchAgrmtSchLine schAgrmtSchLine );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtSchLine SchAgrmtSchLine}
     * entity in the S/4HANA system.
     *
     * @param schAgrmtSchLine
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtSchLine
     *            SchAgrmtSchLine} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtSchLine
     *         SchAgrmtSchLine} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtSchLineDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SchAgrmtSchLineDeleteFluentHelper deleteSchAgrmtSchLine( @Nonnull final SchAgrmtSchLine schAgrmtSchLine );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtDeliveryAddress
     * SchedgAgrmtDeliveryAddress} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtDeliveryAddress
     *         SchedgAgrmtDeliveryAddress} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtDeliveryAddressFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SchedgAgrmtDeliveryAddressFluentHelper getAllSchedgAgrmtDeliveryAddress();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtDeliveryAddress
     * SchedgAgrmtDeliveryAddress} entity using key fields.
     *
     * @param schedulingAgreement
     *            Purchasing Document Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param schedulingAgreementItem
     *            Item Number of Purchasing Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 5
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtDeliveryAddress
     *         SchedgAgrmtDeliveryAddress} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtDeliveryAddressByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SchedgAgrmtDeliveryAddressByKeyFluentHelper
        getSchedgAgrmtDeliveryAddressByKey( final String schedulingAgreement, final String schedulingAgreementItem );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtDeliveryAddress
     * SchedgAgrmtDeliveryAddress} entity and save it to the S/4HANA system.
     *
     * @param schedgAgrmtDeliveryAddress
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtDeliveryAddress
     *            SchedgAgrmtDeliveryAddress} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtDeliveryAddress
     *         SchedgAgrmtDeliveryAddress} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtDeliveryAddressCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SchedgAgrmtDeliveryAddressCreateFluentHelper
        createSchedgAgrmtDeliveryAddress( @Nonnull final SchedgAgrmtDeliveryAddress schedgAgrmtDeliveryAddress );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtDeliveryAddress
     * SchedgAgrmtDeliveryAddress} entity and save it to the S/4HANA system.
     *
     * @param schedgAgrmtDeliveryAddress
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtDeliveryAddress
     *            SchedgAgrmtDeliveryAddress} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtDeliveryAddress
     *         SchedgAgrmtDeliveryAddress} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtDeliveryAddressUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SchedgAgrmtDeliveryAddressUpdateFluentHelper
        updateSchedgAgrmtDeliveryAddress( @Nonnull final SchedgAgrmtDeliveryAddress schedgAgrmtDeliveryAddress );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtHdrNotes
     * SchedgAgrmtHdrNotes} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtHdrNotes
     *         SchedgAgrmtHdrNotes} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtHdrNotesFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SchedgAgrmtHdrNotesFluentHelper getAllSchedgAgrmtHdrNotes();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtHdrNotes
     * SchedgAgrmtHdrNotes} entity using key fields.
     *
     * @param schedulingAgreement
     *            Purchasing Document Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param technicalObjectType
     *            Texts: application object
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param documentText
     *            Text ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param archObjectNumber
     *            Name
     *            <p>
     *            Constraints: Not nullable, Maximum length: 70
     *            </p>
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtHdrNotes
     *         SchedgAgrmtHdrNotes} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtHdrNotesByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SchedgAgrmtHdrNotesByKeyFluentHelper getSchedgAgrmtHdrNotesByKey(
        final String language,
        final String documentText,
        final String technicalObjectType,
        final String archObjectNumber,
        final String schedulingAgreement );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtHdrNotes
     * SchedgAgrmtHdrNotes} entity and save it to the S/4HANA system.
     *
     * @param schedgAgrmtHdrNotes
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtHdrNotes
     *            SchedgAgrmtHdrNotes} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtHdrNotes
     *         SchedgAgrmtHdrNotes} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtHdrNotesCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SchedgAgrmtHdrNotesCreateFluentHelper
        createSchedgAgrmtHdrNotes( @Nonnull final SchedgAgrmtHdrNotes schedgAgrmtHdrNotes );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtHdrNotes
     * SchedgAgrmtHdrNotes} entity and save it to the S/4HANA system.
     *
     * @param schedgAgrmtHdrNotes
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtHdrNotes
     *            SchedgAgrmtHdrNotes} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtHdrNotes
     *         SchedgAgrmtHdrNotes} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtHdrNotesUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SchedgAgrmtHdrNotesUpdateFluentHelper
        updateSchedgAgrmtHdrNotes( @Nonnull final SchedgAgrmtHdrNotes schedgAgrmtHdrNotes );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtHdrNotes
     * SchedgAgrmtHdrNotes} entity in the S/4HANA system.
     *
     * @param schedgAgrmtHdrNotes
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtHdrNotes
     *            SchedgAgrmtHdrNotes} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtHdrNotes
     *         SchedgAgrmtHdrNotes} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtHdrNotesDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SchedgAgrmtHdrNotesDeleteFluentHelper
        deleteSchedgAgrmtHdrNotes( @Nonnull final SchedgAgrmtHdrNotes schedgAgrmtHdrNotes );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtItmNotes
     * SchedgAgrmtItmNotes} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtItmNotes
     *         SchedgAgrmtItmNotes} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtItmNotesFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SchedgAgrmtItmNotesFluentHelper getAllSchedgAgrmtItmNotes();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtItmNotes
     * SchedgAgrmtItmNotes} entity using key fields.
     *
     * @param technicalObjectType
     *            Texts: application object
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param documentText
     *            Text ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param archObjectNumber
     *            Name
     *            <p>
     *            Constraints: Not nullable, Maximum length: 70
     *            </p>
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtItmNotes
     *         SchedgAgrmtItmNotes} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtItmNotesByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SchedgAgrmtItmNotesByKeyFluentHelper getSchedgAgrmtItmNotesByKey(
        final String language,
        final String documentText,
        final String technicalObjectType,
        final String archObjectNumber );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtItmNotes
     * SchedgAgrmtItmNotes} entity and save it to the S/4HANA system.
     *
     * @param schedgAgrmtItmNotes
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtItmNotes
     *            SchedgAgrmtItmNotes} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtItmNotes
     *         SchedgAgrmtItmNotes} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtItmNotesCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SchedgAgrmtItmNotesCreateFluentHelper
        createSchedgAgrmtItmNotes( @Nonnull final SchedgAgrmtItmNotes schedgAgrmtItmNotes );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtItmNotes
     * SchedgAgrmtItmNotes} entity and save it to the S/4HANA system.
     *
     * @param schedgAgrmtItmNotes
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtItmNotes
     *            SchedgAgrmtItmNotes} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtItmNotes
     *         SchedgAgrmtItmNotes} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtItmNotesUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SchedgAgrmtItmNotesUpdateFluentHelper
        updateSchedgAgrmtItmNotes( @Nonnull final SchedgAgrmtItmNotes schedgAgrmtItmNotes );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtItmNotes
     * SchedgAgrmtItmNotes} entity in the S/4HANA system.
     *
     * @param schedgAgrmtItmNotes
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtItmNotes
     *            SchedgAgrmtItmNotes} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtItmNotes
     *         SchedgAgrmtItmNotes} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtItmNotesDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SchedgAgrmtItmNotesDeleteFluentHelper
        deleteSchedgAgrmtItmNotes( @Nonnull final SchedgAgrmtItmNotes schedgAgrmtItmNotes );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtSubcontrgComp
     * SchedgAgrmtSubcontrgComp} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtSubcontrgComp
     *         SchedgAgrmtSubcontrgComp} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtSubcontrgCompFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SchedgAgrmtSubcontrgCompFluentHelper getAllSchedgAgrmtSubcontrgComp();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtSubcontrgComp
     * SchedgAgrmtSubcontrgComp} entity using key fields.
     *
     * @param schedulingAgreement
     *            Purchasing Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param reservationItem
     *            Reservation Item
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param recordType
     *            Reservation Record Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     * @param scheduleLine
     *            Delivery Schedule Line Counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param schedulingAgreementItem
     *            Purchasing Document Item
     *            <p>
     *            Constraints: Not nullable, Maximum length: 5
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtSubcontrgComp
     *         SchedgAgrmtSubcontrgComp} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtSubcontrgCompByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SchedgAgrmtSubcontrgCompByKeyFluentHelper getSchedgAgrmtSubcontrgCompByKey(
        final String schedulingAgreement,
        final String schedulingAgreementItem,
        final String scheduleLine,
        final String reservationItem,
        final String recordType );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtSubcontrgComp
     * SchedgAgrmtSubcontrgComp} entity and save it to the S/4HANA system.
     *
     * @param schedgAgrmtSubcontrgComp
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtSubcontrgComp
     *            SchedgAgrmtSubcontrgComp} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtSubcontrgComp
     *         SchedgAgrmtSubcontrgComp} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtSubcontrgCompUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SchedgAgrmtSubcontrgCompUpdateFluentHelper
        updateSchedgAgrmtSubcontrgComp( @Nonnull final SchedgAgrmtSubcontrgComp schedgAgrmtSubcontrgComp );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtSubcontrgComp
     * SchedgAgrmtSubcontrgComp} entity in the S/4HANA system.
     *
     * @param schedgAgrmtSubcontrgComp
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtSubcontrgComp
     *            SchedgAgrmtSubcontrgComp} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtSubcontrgComp
     *         SchedgAgrmtSubcontrgComp} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtSubcontrgCompDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SchedgAgrmtSubcontrgCompDeleteFluentHelper
        deleteSchedgAgrmtSubcontrgComp( @Nonnull final SchedgAgrmtSubcontrgComp schedgAgrmtSubcontrgComp );

    /**
     * Withdarw Scheduling Agreement from Approval
     * <p>
     * </p>
     * <p>
     * Creates a fluent helper for the <b>WithdrawFromApproval</b> OData function import.
     * </p>
     *
     * @param schedulingAgreement
     *            SchedulingAgreement
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>SchedulingAgreement</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>WithdrawFromApproval</b> OData function import with the
     *         provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.WithdrawFromApprovalFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    WithdrawFromApprovalFluentHelper withdrawFromApproval( @Nonnull final String schedulingAgreement );

    /**
     * Scheduling Agreement Header Release
     * <p>
     * </p>
     * <p>
     * Creates a fluent helper for the <b>HeaderRelease</b> OData function import.
     * </p>
     *
     * @param schedgAgreementWithJitProfile
     *            Scheduling Agreement Jit Release Strategy Profile
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: none
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>SchedgAgreementWithJitProfile</b>
     *            </p>
     * @param schedgAgreementCreateWoutSline
     *            Create without Schedule Line
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: none
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>SchedgAgreementCreateWoutSline</b>
     *            </p>
     * @param schedgAgreementCreateFrcOnly
     *            Forecast Only
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: none
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>SchedgAgreementCreateFrcOnly</b>
     *            </p>
     * @param schedgAgreementdeactJitTolChck
     *            Deactivate Jit Tolerance Check
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: none
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>SchedgAgreementdeactJitTolChck</b>
     *            </p>
     * @param schedgAgreementStandardRelDate
     *            Schediling Agreement Release Date
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>SchedgAgreementStandardRelDate</b>
     *            </p>
     * @param schedgAgreementMoveCreateDate
     *            Move Release Creation Date
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>SchedgAgreementMoveCreateDate</b>
     *            </p>
     * @param schedgAgreementSelectionScope
     *            Scope of Selection
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>SchedgAgreementSelectionScope</b>
     *            </p>
     * @param schedgAgreementCreateFrcAndJit
     *            Forecast And Jit Schedule
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: none
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>SchedgAgreementCreateFrcAndJit</b>
     *            </p>
     * @param schedgAgreementOffFrcDynStop
     *            Deactivate Forecast Dynamic Stopping
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: none
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>SchedgAgreementOffFrcDynStop</b>
     *            </p>
     * @param schedulingAgreement
     *            Scheduling Agreement
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>SchedulingAgreement</b>
     *            </p>
     * @param schedgAgreementOffJitDynStop
     *            Deactivate Jit Dynamic Stopping
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: none
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>SchedgAgreementOffJitDynStop</b>
     *            </p>
     * @param schedgAgreementWithFrcProfile
     *            Scheduling Agreement Forecast Release Strategy Profile
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: none
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>SchedgAgreementWithFrcProfile</b>
     *            </p>
     * @param schedgAgreementDeactFrcTolChck
     *            Deactivate Forecast Tolearance Check
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: none
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>SchedgAgreementDeactFrcTolChck</b>
     *            </p>
     * @param schedgAgreementCreateJitOnly
     *            Jit Only
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: none
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>SchedgAgreementCreateJitOnly</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>HeaderRelease</b> OData function import with the provided
     *         parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.HeaderReleaseFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    HeaderReleaseFluentHelper headerRelease(
        @Nonnull final String schedulingAgreement,
        @Nonnull final Boolean schedgAgreementWithJitProfile,
        @Nonnull final Boolean schedgAgreementWithFrcProfile,
        @Nonnull final Boolean schedgAgreementCreateFrcAndJit,
        @Nonnull final Boolean schedgAgreementCreateFrcOnly,
        @Nonnull final Boolean schedgAgreementCreateJitOnly,
        @Nonnull final Boolean schedgAgreementCreateWoutSline,
        @Nonnull final Boolean schedgAgreementDeactFrcTolChck,
        @Nonnull final Boolean schedgAgreementdeactJitTolChck,
        @Nonnull final String schedgAgreementMoveCreateDate,
        @Nonnull final Boolean schedgAgreementOffFrcDynStop,
        @Nonnull final Boolean schedgAgreementOffJitDynStop,
        @Nonnull final String schedgAgreementSelectionScope,
        @Nonnull final String schedgAgreementStandardRelDate );

    /**
     * Scheduling Agreement Item Release
     * <p>
     * </p>
     * <p>
     * Creates a fluent helper for the <b>ItemRelease</b> OData function import.
     * </p>
     *
     * @param schedulingAgreement
     *            Scheduling Agreement
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>SchedulingAgreement</b>
     *            </p>
     * @param schedulingAgreementReleaseType
     *            Scheduling Agreement Release Type
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>SchedulingAgreementReleaseType</b>
     *            </p>
     * @param schedulingAgreementItem
     *            Scheduling Agreement Item
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 5
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>SchedulingAgreementItem</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>ItemRelease</b> OData function import with the provided
     *         parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.ItemReleaseFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ItemReleaseFluentHelper itemRelease(
        @Nonnull final String schedulingAgreement,
        @Nonnull final String schedulingAgreementItem,
        @Nonnull final String schedulingAgreementReleaseType );

}
