/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfItemPriceElement;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfItemPriceElementByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfItemPriceElementCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfItemPriceElementFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfItemPriceElementUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfItemUserStatus;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfItemUserStatusByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfItemUserStatusCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfItemUserStatusDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfItemUserStatusFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfItmRefObject;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfItmRefObjectByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfItmRefObjectCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfItmRefObjectDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfItmRefObjectFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfPersonResp;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfPersonRespByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfPersonRespCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfPersonRespDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfPersonRespFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfPersonRespUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfPriceElement;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfPriceElementByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfPriceElementCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfPriceElementFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfPriceElementUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfRefObject;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfRefObjectByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfRefObjectCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfRefObjectDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfRefObjectFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfUserStatus;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfUserStatusByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfUserStatusCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfUserStatusDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfUserStatusFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfirmation;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfirmationByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfirmationCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfirmationFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfirmationItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfirmationItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfirmationItemCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfirmationItemDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfirmationItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfirmationItemText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfirmationItemTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfirmationItemTextCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfirmationItemTextDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfirmationItemTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfirmationItemTextUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfirmationItemUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfirmationText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfirmationTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfirmationTextCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfirmationTextDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfirmationTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfirmationTextUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfirmationUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfAppointment;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfAppointmentByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfAppointmentCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfAppointmentFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfAppointmentUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfDuration;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfDurationByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfDurationCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfDurationFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfDurationUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfItemAppointment;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfItemAppointmentByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfItemAppointmentCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfItemAppointmentFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfItemAppointmentUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfItemDuration;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfItemDurationByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfItemDurationCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfItemDurationFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfItemDurationUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfItemPartner;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfItemPartnerByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfItemPartnerCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfItemPartnerDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfItemPartnerFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfItemPartnerUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfItmPartnerAddress;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfItmPartnerAddressByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfItmPartnerAddressFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfItmPartnerAddressUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfPartner;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfPartnerAddress;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfPartnerAddressByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfPartnerAddressFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfPartnerAddressUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfPartnerByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfPartnerCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfPartnerDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfPartnerFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfPartnerUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.batch.ServiceConfirmationServiceBatch;

/**
 * <p>
 *
 * You can use this service to integrate external applications with service confirmation processing in SAP S/4HANA
 * Cloud. In each API call, you can use the following operations: - Retrieve service confirmations. - Create service
 * confirmations. Note: You must use “deep insert” requests (a header plus the following entities: header person
 * responsible, header reference object, header pricing element, header text, and item). - Create new items for existing
 * service confirmations. - Create an item reference object, item pricing element, and an item text for existing service
 * confirmation items. - Update the header, header person responsible, header reference object, header pricing element,
 * header text, item, item reference object, item pricing element, and item text for existing service confirmations. -
 * Delete the header person responsible, header reference object, header text, item, item reference object, and item
 * text for existing service confirmations.
 *
 * This service enables you to add attachments to service confirmation items by making an API call to the service
 * Attachments (API_CV_ATTACHMENT_SRV). You can also use the service Attachments to download and delete attachments from
 * service confirmation items..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/a4/6bcadb5c914c06ae8b84c9a6dc368f/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_SERVICE_CONFIRMATION_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_SERVICE_CONFIRMATION_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.3.1</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Service Confirmation OData Integration(SAP_COM_0352), Service - Repair Confirmation
 * Integration(SAP_COM_0933)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/3D2'>Service Order Management and Monitoring(3D2)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/3XK'>In-House Repair(3XK)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Service Confirmation</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Deprecated
public interface ServiceConfirmationService extends BatchService<ServiceConfirmationServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_SERVICE_CONFIRMATION_SRV";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    ServiceConfirmationService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfirmation
     * ServiceConfirmation} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfirmation
     *         ServiceConfirmation} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfirmationFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceConfirmationFluentHelper getAllServiceConfirmation();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfirmation
     * ServiceConfirmation} entity using key fields.
     *
     * @param serviceConfirmation
     *            Transaction ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfirmation
     *         ServiceConfirmation} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfirmationByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceConfirmationByKeyFluentHelper getServiceConfirmationByKey( final String serviceConfirmation );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfirmation
     * ServiceConfirmation} entity and save it to the S/4HANA system.
     *
     * @param serviceConfirmation
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfirmation
     *            ServiceConfirmation} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfirmation
     *         ServiceConfirmation} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfirmationCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceConfirmationCreateFluentHelper
        createServiceConfirmation( @Nonnull final ServiceConfirmation serviceConfirmation );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfirmation
     * ServiceConfirmation} entity and save it to the S/4HANA system.
     *
     * @param serviceConfirmation
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfirmation
     *            ServiceConfirmation} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfirmation
     *         ServiceConfirmation} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfirmationUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceConfirmationUpdateFluentHelper
        updateServiceConfirmation( @Nonnull final ServiceConfirmation serviceConfirmation );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfirmationItem
     * ServiceConfirmationItem} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfirmationItem
     *         ServiceConfirmationItem} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfirmationItemFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceConfirmationItemFluentHelper getAllServiceConfirmationItem();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfirmationItem
     * ServiceConfirmationItem} entity using key fields.
     *
     * @param serviceConfirmationItem
     *            Shortened Item Number in Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param serviceConfirmation
     *            Transaction ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfirmationItem
     *         ServiceConfirmationItem} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfirmationItemByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceConfirmationItemByKeyFluentHelper
        getServiceConfirmationItemByKey( final String serviceConfirmation, final String serviceConfirmationItem );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfirmationItem
     * ServiceConfirmationItem} entity and save it to the S/4HANA system.
     *
     * @param serviceConfirmationItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfirmationItem
     *            ServiceConfirmationItem} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfirmationItem
     *         ServiceConfirmationItem} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfirmationItemCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceConfirmationItemCreateFluentHelper
        createServiceConfirmationItem( @Nonnull final ServiceConfirmationItem serviceConfirmationItem );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfirmationItem
     * ServiceConfirmationItem} entity and save it to the S/4HANA system.
     *
     * @param serviceConfirmationItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfirmationItem
     *            ServiceConfirmationItem} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfirmationItem
     *         ServiceConfirmationItem} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfirmationItemUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceConfirmationItemUpdateFluentHelper
        updateServiceConfirmationItem( @Nonnull final ServiceConfirmationItem serviceConfirmationItem );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfirmationItem
     * ServiceConfirmationItem} entity in the S/4HANA system.
     *
     * @param serviceConfirmationItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfirmationItem
     *            ServiceConfirmationItem} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfirmationItem
     *         ServiceConfirmationItem} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfirmationItemDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceConfirmationItemDeleteFluentHelper
        deleteServiceConfirmationItem( @Nonnull final ServiceConfirmationItem serviceConfirmationItem );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfirmationItemText
     * ServiceConfirmationItemText} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfirmationItemText
     *         ServiceConfirmationItemText} entities. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfirmationItemTextFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceConfirmationItemTextFluentHelper getAllServiceConfirmationItemText();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfirmationItemText
     * ServiceConfirmationItemText} entity using key fields.
     *
     * @param serviceConfirmationItem
     *            Shortened Item Number in Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param serviceConfirmation
     *            Transaction ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param longTextID
     *            Text ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfirmationItemText
     *         ServiceConfirmationItemText} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfirmationItemTextByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceConfirmationItemTextByKeyFluentHelper getServiceConfirmationItemTextByKey(
        final String serviceConfirmation,
        final String serviceConfirmationItem,
        final String language,
        final String longTextID );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfirmationItemText
     * ServiceConfirmationItemText} entity and save it to the S/4HANA system.
     *
     * @param serviceConfirmationItemText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfirmationItemText
     *            ServiceConfirmationItemText} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfirmationItemText
     *         ServiceConfirmationItemText} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfirmationItemTextCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceConfirmationItemTextCreateFluentHelper
        createServiceConfirmationItemText( @Nonnull final ServiceConfirmationItemText serviceConfirmationItemText );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfirmationItemText
     * ServiceConfirmationItemText} entity and save it to the S/4HANA system.
     *
     * @param serviceConfirmationItemText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfirmationItemText
     *            ServiceConfirmationItemText} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfirmationItemText
     *         ServiceConfirmationItemText} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfirmationItemTextUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceConfirmationItemTextUpdateFluentHelper
        updateServiceConfirmationItemText( @Nonnull final ServiceConfirmationItemText serviceConfirmationItemText );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfirmationItemText
     * ServiceConfirmationItemText} entity in the S/4HANA system.
     *
     * @param serviceConfirmationItemText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfirmationItemText
     *            ServiceConfirmationItemText} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfirmationItemText
     *         ServiceConfirmationItemText} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfirmationItemTextDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceConfirmationItemTextDeleteFluentHelper
        deleteServiceConfirmationItemText( @Nonnull final ServiceConfirmationItemText serviceConfirmationItemText );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfirmationText
     * ServiceConfirmationText} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfirmationText
     *         ServiceConfirmationText} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfirmationTextFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceConfirmationTextFluentHelper getAllServiceConfirmationText();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfirmationText
     * ServiceConfirmationText} entity using key fields.
     *
     * @param serviceConfirmation
     *            Transaction ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param longTextID
     *            Text ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfirmationText
     *         ServiceConfirmationText} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfirmationTextByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceConfirmationTextByKeyFluentHelper getServiceConfirmationTextByKey(
        final String serviceConfirmation,
        final String language,
        final String longTextID );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfirmationText
     * ServiceConfirmationText} entity and save it to the S/4HANA system.
     *
     * @param serviceConfirmationText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfirmationText
     *            ServiceConfirmationText} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfirmationText
     *         ServiceConfirmationText} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfirmationTextCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceConfirmationTextCreateFluentHelper
        createServiceConfirmationText( @Nonnull final ServiceConfirmationText serviceConfirmationText );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfirmationText
     * ServiceConfirmationText} entity and save it to the S/4HANA system.
     *
     * @param serviceConfirmationText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfirmationText
     *            ServiceConfirmationText} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfirmationText
     *         ServiceConfirmationText} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfirmationTextUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceConfirmationTextUpdateFluentHelper
        updateServiceConfirmationText( @Nonnull final ServiceConfirmationText serviceConfirmationText );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfirmationText
     * ServiceConfirmationText} entity in the S/4HANA system.
     *
     * @param serviceConfirmationText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfirmationText
     *            ServiceConfirmationText} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfirmationText
     *         ServiceConfirmationText} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfirmationTextDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceConfirmationTextDeleteFluentHelper
        deleteServiceConfirmationText( @Nonnull final ServiceConfirmationText serviceConfirmationText );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfItemPriceElement
     * ServiceConfItemPriceElement} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfItemPriceElement
     *         ServiceConfItemPriceElement} entities. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfItemPriceElementFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceConfItemPriceElementFluentHelper getAllServiceConfItemPriceElement();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfItemPriceElement
     * ServiceConfItemPriceElement} entity using key fields.
     *
     * @param serviceConfirmationItem
     *            Shortened Item Number in Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param serviceConfirmation
     *            Transaction ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param pricingProcedureCounter
     *            Condition Counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @param pricingProcedureStep
     *            Step Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfItemPriceElement
     *         ServiceConfItemPriceElement} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfItemPriceElementByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceConfItemPriceElementByKeyFluentHelper getServiceConfItemPriceElementByKey(
        final String serviceConfirmation,
        final String serviceConfirmationItem,
        final String pricingProcedureStep,
        final String pricingProcedureCounter );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfItemPriceElement
     * ServiceConfItemPriceElement} entity and save it to the S/4HANA system.
     *
     * @param serviceConfItemPriceElement
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfItemPriceElement
     *            ServiceConfItemPriceElement} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfItemPriceElement
     *         ServiceConfItemPriceElement} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfItemPriceElementCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceConfItemPriceElementCreateFluentHelper
        createServiceConfItemPriceElement( @Nonnull final ServiceConfItemPriceElement serviceConfItemPriceElement );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfItemPriceElement
     * ServiceConfItemPriceElement} entity and save it to the S/4HANA system.
     *
     * @param serviceConfItemPriceElement
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfItemPriceElement
     *            ServiceConfItemPriceElement} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfItemPriceElement
     *         ServiceConfItemPriceElement} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfItemPriceElementUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceConfItemPriceElementUpdateFluentHelper
        updateServiceConfItemPriceElement( @Nonnull final ServiceConfItemPriceElement serviceConfItemPriceElement );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfItemUserStatus
     * ServiceConfItemUserStatus} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfItemUserStatus
     *         ServiceConfItemUserStatus} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfItemUserStatusFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceConfItemUserStatusFluentHelper getAllServiceConfItemUserStatus();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfItemUserStatus
     * ServiceConfItemUserStatus} entity using key fields.
     *
     * @param serviceConfirmationItem
     *            Shortened Item Number in Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param serviceConfirmation
     *            Transaction ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param srvcConfItemUserStatus
     *            Object Status
     *            <p>
     *            Constraints: Not nullable, Maximum length: 5
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfItemUserStatus
     *         ServiceConfItemUserStatus} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfItemUserStatusByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceConfItemUserStatusByKeyFluentHelper getServiceConfItemUserStatusByKey(
        final String serviceConfirmation,
        final String serviceConfirmationItem,
        final String srvcConfItemUserStatus );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfItemUserStatus
     * ServiceConfItemUserStatus} entity and save it to the S/4HANA system.
     *
     * @param serviceConfItemUserStatus
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfItemUserStatus
     *            ServiceConfItemUserStatus} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfItemUserStatus
     *         ServiceConfItemUserStatus} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfItemUserStatusCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceConfItemUserStatusCreateFluentHelper
        createServiceConfItemUserStatus( @Nonnull final ServiceConfItemUserStatus serviceConfItemUserStatus );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfItemUserStatus
     * ServiceConfItemUserStatus} entity in the S/4HANA system.
     *
     * @param serviceConfItemUserStatus
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfItemUserStatus
     *            ServiceConfItemUserStatus} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfItemUserStatus
     *         ServiceConfItemUserStatus} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfItemUserStatusDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceConfItemUserStatusDeleteFluentHelper
        deleteServiceConfItemUserStatus( @Nonnull final ServiceConfItemUserStatus serviceConfItemUserStatus );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfItmRefObject
     * ServiceConfItmRefObject} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfItmRefObject
     *         ServiceConfItmRefObject} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfItmRefObjectFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceConfItmRefObjectFluentHelper getAllServiceConfItmRefObject();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfItmRefObject
     * ServiceConfItmRefObject} entity using key fields.
     *
     * @param serviceConfirmationItem
     *            Shortened Item Number in Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param serviceConfirmation
     *            Transaction ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param serviceRefFunctionalLocation
     *            Functional Location
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @param serviceReferenceEquipment
     *            Equipment Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 18
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfItmRefObject
     *         ServiceConfItmRefObject} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfItmRefObjectByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceConfItmRefObjectByKeyFluentHelper getServiceConfItmRefObjectByKey(
        final String serviceConfirmation,
        final String serviceConfirmationItem,
        final String serviceReferenceEquipment,
        final String serviceRefFunctionalLocation );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfItmRefObject
     * ServiceConfItmRefObject} entity and save it to the S/4HANA system.
     *
     * @param serviceConfItmRefObject
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfItmRefObject
     *            ServiceConfItmRefObject} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfItmRefObject
     *         ServiceConfItmRefObject} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfItmRefObjectCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceConfItmRefObjectCreateFluentHelper
        createServiceConfItmRefObject( @Nonnull final ServiceConfItmRefObject serviceConfItmRefObject );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfItmRefObject
     * ServiceConfItmRefObject} entity in the S/4HANA system.
     *
     * @param serviceConfItmRefObject
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfItmRefObject
     *            ServiceConfItmRefObject} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfItmRefObject
     *         ServiceConfItmRefObject} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfItmRefObjectDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceConfItmRefObjectDeleteFluentHelper
        deleteServiceConfItmRefObject( @Nonnull final ServiceConfItmRefObject serviceConfItmRefObject );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfPersonResp
     * ServiceConfPersonResp} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfPersonResp
     *         ServiceConfPersonResp} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfPersonRespFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceConfPersonRespFluentHelper getAllServiceConfPersonResp();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfPersonResp
     * ServiceConfPersonResp} entity using key fields.
     *
     * @param serviceConfirmation
     *            Transaction ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param personResponsible
     *            Business Partner Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfPersonResp
     *         ServiceConfPersonResp} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfPersonRespByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceConfPersonRespByKeyFluentHelper
        getServiceConfPersonRespByKey( final String serviceConfirmation, final String personResponsible );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfPersonResp
     * ServiceConfPersonResp} entity and save it to the S/4HANA system.
     *
     * @param serviceConfPersonResp
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfPersonResp
     *            ServiceConfPersonResp} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfPersonResp
     *         ServiceConfPersonResp} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfPersonRespCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceConfPersonRespCreateFluentHelper
        createServiceConfPersonResp( @Nonnull final ServiceConfPersonResp serviceConfPersonResp );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfPersonResp
     * ServiceConfPersonResp} entity and save it to the S/4HANA system.
     *
     * @param serviceConfPersonResp
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfPersonResp
     *            ServiceConfPersonResp} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfPersonResp
     *         ServiceConfPersonResp} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfPersonRespUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceConfPersonRespUpdateFluentHelper
        updateServiceConfPersonResp( @Nonnull final ServiceConfPersonResp serviceConfPersonResp );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfPersonResp
     * ServiceConfPersonResp} entity in the S/4HANA system.
     *
     * @param serviceConfPersonResp
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfPersonResp
     *            ServiceConfPersonResp} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfPersonResp
     *         ServiceConfPersonResp} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfPersonRespDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceConfPersonRespDeleteFluentHelper
        deleteServiceConfPersonResp( @Nonnull final ServiceConfPersonResp serviceConfPersonResp );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfPriceElement
     * ServiceConfPriceElement} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfPriceElement
     *         ServiceConfPriceElement} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfPriceElementFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceConfPriceElementFluentHelper getAllServiceConfPriceElement();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfPriceElement
     * ServiceConfPriceElement} entity using key fields.
     *
     * @param serviceConfirmation
     *            Transaction ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param pricingProcedureCounter
     *            Condition Counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @param pricingProcedureStep
     *            Step Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfPriceElement
     *         ServiceConfPriceElement} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfPriceElementByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceConfPriceElementByKeyFluentHelper getServiceConfPriceElementByKey(
        final String serviceConfirmation,
        final String pricingProcedureStep,
        final String pricingProcedureCounter );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfPriceElement
     * ServiceConfPriceElement} entity and save it to the S/4HANA system.
     *
     * @param serviceConfPriceElement
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfPriceElement
     *            ServiceConfPriceElement} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfPriceElement
     *         ServiceConfPriceElement} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfPriceElementCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceConfPriceElementCreateFluentHelper
        createServiceConfPriceElement( @Nonnull final ServiceConfPriceElement serviceConfPriceElement );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfPriceElement
     * ServiceConfPriceElement} entity and save it to the S/4HANA system.
     *
     * @param serviceConfPriceElement
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfPriceElement
     *            ServiceConfPriceElement} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfPriceElement
     *         ServiceConfPriceElement} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfPriceElementUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceConfPriceElementUpdateFluentHelper
        updateServiceConfPriceElement( @Nonnull final ServiceConfPriceElement serviceConfPriceElement );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfRefObject
     * ServiceConfRefObject} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfRefObject
     *         ServiceConfRefObject} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfRefObjectFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceConfRefObjectFluentHelper getAllServiceConfRefObject();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfRefObject
     * ServiceConfRefObject} entity using key fields.
     *
     * @param serviceConfirmation
     *            Transaction ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param serviceRefFunctionalLocation
     *            Functional Location
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @param serviceReferenceEquipment
     *            Equipment Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 18
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfRefObject
     *         ServiceConfRefObject} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfRefObjectByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceConfRefObjectByKeyFluentHelper getServiceConfRefObjectByKey(
        final String serviceConfirmation,
        final String serviceReferenceEquipment,
        final String serviceRefFunctionalLocation );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfRefObject
     * ServiceConfRefObject} entity and save it to the S/4HANA system.
     *
     * @param serviceConfRefObject
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfRefObject
     *            ServiceConfRefObject} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfRefObject
     *         ServiceConfRefObject} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfRefObjectCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceConfRefObjectCreateFluentHelper
        createServiceConfRefObject( @Nonnull final ServiceConfRefObject serviceConfRefObject );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfRefObject
     * ServiceConfRefObject} entity in the S/4HANA system.
     *
     * @param serviceConfRefObject
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfRefObject
     *            ServiceConfRefObject} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfRefObject
     *         ServiceConfRefObject} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfRefObjectDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceConfRefObjectDeleteFluentHelper
        deleteServiceConfRefObject( @Nonnull final ServiceConfRefObject serviceConfRefObject );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfUserStatus
     * ServiceConfUserStatus} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfUserStatus
     *         ServiceConfUserStatus} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfUserStatusFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceConfUserStatusFluentHelper getAllServiceConfUserStatus();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfUserStatus
     * ServiceConfUserStatus} entity using key fields.
     *
     * @param serviceConfirmation
     *            Transaction ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param srvcConfUserStatus
     *            Object Status
     *            <p>
     *            Constraints: Not nullable, Maximum length: 5
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfUserStatus
     *         ServiceConfUserStatus} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfUserStatusByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceConfUserStatusByKeyFluentHelper
        getServiceConfUserStatusByKey( final String serviceConfirmation, final String srvcConfUserStatus );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfUserStatus
     * ServiceConfUserStatus} entity and save it to the S/4HANA system.
     *
     * @param serviceConfUserStatus
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfUserStatus
     *            ServiceConfUserStatus} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfUserStatus
     *         ServiceConfUserStatus} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfUserStatusCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceConfUserStatusCreateFluentHelper
        createServiceConfUserStatus( @Nonnull final ServiceConfUserStatus serviceConfUserStatus );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfUserStatus
     * ServiceConfUserStatus} entity in the S/4HANA system.
     *
     * @param serviceConfUserStatus
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfUserStatus
     *            ServiceConfUserStatus} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfUserStatus
     *         ServiceConfUserStatus} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfUserStatusDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceConfUserStatusDeleteFluentHelper
        deleteServiceConfUserStatus( @Nonnull final ServiceConfUserStatus serviceConfUserStatus );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfAppointment
     * SrvcConfAppointment} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfAppointment
     *         SrvcConfAppointment} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfAppointmentFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SrvcConfAppointmentFluentHelper getAllSrvcConfAppointment();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfAppointment
     * SrvcConfAppointment} entity using key fields.
     *
     * @param serviceConfirmation
     *            Transaction ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param srvcDocAppointmentType
     *            Technical Date Type Name
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfAppointment
     *         SrvcConfAppointment} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfAppointmentByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SrvcConfAppointmentByKeyFluentHelper
        getSrvcConfAppointmentByKey( final String serviceConfirmation, final String srvcDocAppointmentType );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfAppointment
     * SrvcConfAppointment} entity and save it to the S/4HANA system.
     *
     * @param srvcConfAppointment
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfAppointment
     *            SrvcConfAppointment} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfAppointment
     *         SrvcConfAppointment} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfAppointmentCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SrvcConfAppointmentCreateFluentHelper
        createSrvcConfAppointment( @Nonnull final SrvcConfAppointment srvcConfAppointment );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfAppointment
     * SrvcConfAppointment} entity and save it to the S/4HANA system.
     *
     * @param srvcConfAppointment
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfAppointment
     *            SrvcConfAppointment} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfAppointment
     *         SrvcConfAppointment} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfAppointmentUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SrvcConfAppointmentUpdateFluentHelper
        updateSrvcConfAppointment( @Nonnull final SrvcConfAppointment srvcConfAppointment );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfDuration
     * SrvcConfDuration} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfDuration
     *         SrvcConfDuration} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfDurationFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SrvcConfDurationFluentHelper getAllSrvcConfDuration();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfDuration
     * SrvcConfDuration} entity using key fields.
     *
     * @param serviceConfirmation
     *            Transaction ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param srvcDocDurationType
     *            Name for Type of Time Duration
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfDuration
     *         SrvcConfDuration} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfDurationByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SrvcConfDurationByKeyFluentHelper
        getSrvcConfDurationByKey( final String serviceConfirmation, final String srvcDocDurationType );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfDuration
     * SrvcConfDuration} entity and save it to the S/4HANA system.
     *
     * @param srvcConfDuration
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfDuration
     *            SrvcConfDuration} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfDuration
     *         SrvcConfDuration} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfDurationCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SrvcConfDurationCreateFluentHelper createSrvcConfDuration( @Nonnull final SrvcConfDuration srvcConfDuration );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfDuration SrvcConfDuration}
     * entity and save it to the S/4HANA system.
     *
     * @param srvcConfDuration
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfDuration
     *            SrvcConfDuration} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfDuration
     *         SrvcConfDuration} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfDurationUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SrvcConfDurationUpdateFluentHelper updateSrvcConfDuration( @Nonnull final SrvcConfDuration srvcConfDuration );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfItemAppointment
     * SrvcConfItemAppointment} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfItemAppointment
     *         SrvcConfItemAppointment} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfItemAppointmentFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SrvcConfItemAppointmentFluentHelper getAllSrvcConfItemAppointment();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfItemAppointment
     * SrvcConfItemAppointment} entity using key fields.
     *
     * @param serviceConfirmationItem
     *            Shortened Item Number in Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param serviceConfirmation
     *            Transaction ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param srvcDocAppointmentType
     *            Technical Date Type Name
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfItemAppointment
     *         SrvcConfItemAppointment} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfItemAppointmentByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SrvcConfItemAppointmentByKeyFluentHelper getSrvcConfItemAppointmentByKey(
        final String serviceConfirmation,
        final String serviceConfirmationItem,
        final String srvcDocAppointmentType );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfItemAppointment
     * SrvcConfItemAppointment} entity and save it to the S/4HANA system.
     *
     * @param srvcConfItemAppointment
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfItemAppointment
     *            SrvcConfItemAppointment} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfItemAppointment
     *         SrvcConfItemAppointment} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfItemAppointmentCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SrvcConfItemAppointmentCreateFluentHelper
        createSrvcConfItemAppointment( @Nonnull final SrvcConfItemAppointment srvcConfItemAppointment );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfItemAppointment
     * SrvcConfItemAppointment} entity and save it to the S/4HANA system.
     *
     * @param srvcConfItemAppointment
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfItemAppointment
     *            SrvcConfItemAppointment} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfItemAppointment
     *         SrvcConfItemAppointment} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfItemAppointmentUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SrvcConfItemAppointmentUpdateFluentHelper
        updateSrvcConfItemAppointment( @Nonnull final SrvcConfItemAppointment srvcConfItemAppointment );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfItemDuration
     * SrvcConfItemDuration} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfItemDuration
     *         SrvcConfItemDuration} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfItemDurationFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SrvcConfItemDurationFluentHelper getAllSrvcConfItemDuration();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfItemDuration
     * SrvcConfItemDuration} entity using key fields.
     *
     * @param serviceConfirmationItem
     *            Shortened Item Number in Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param serviceConfirmation
     *            Transaction ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param srvcDocDurationType
     *            Name for Type of Time Duration
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfItemDuration
     *         SrvcConfItemDuration} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfItemDurationByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SrvcConfItemDurationByKeyFluentHelper getSrvcConfItemDurationByKey(
        final String serviceConfirmation,
        final String serviceConfirmationItem,
        final String srvcDocDurationType );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfItemDuration
     * SrvcConfItemDuration} entity and save it to the S/4HANA system.
     *
     * @param srvcConfItemDuration
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfItemDuration
     *            SrvcConfItemDuration} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfItemDuration
     *         SrvcConfItemDuration} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfItemDurationCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SrvcConfItemDurationCreateFluentHelper
        createSrvcConfItemDuration( @Nonnull final SrvcConfItemDuration srvcConfItemDuration );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfItemDuration
     * SrvcConfItemDuration} entity and save it to the S/4HANA system.
     *
     * @param srvcConfItemDuration
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfItemDuration
     *            SrvcConfItemDuration} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfItemDuration
     *         SrvcConfItemDuration} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfItemDurationUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SrvcConfItemDurationUpdateFluentHelper
        updateSrvcConfItemDuration( @Nonnull final SrvcConfItemDuration srvcConfItemDuration );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfItemPartner
     * SrvcConfItemPartner} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfItemPartner
     *         SrvcConfItemPartner} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfItemPartnerFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SrvcConfItemPartnerFluentHelper getAllSrvcConfItemPartner();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfItemPartner
     * SrvcConfItemPartner} entity using key fields.
     *
     * @param serviceConfirmationItem
     *            Shortened Item Number in Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param custMgmtBusinessPartner
     *            Business Partner Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param serviceConfirmation
     *            Transaction ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param custMgmtPartnerFunction
     *
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfItemPartner
     *         SrvcConfItemPartner} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfItemPartnerByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SrvcConfItemPartnerByKeyFluentHelper getSrvcConfItemPartnerByKey(
        final String serviceConfirmation,
        final String serviceConfirmationItem,
        final String custMgmtPartnerFunction,
        final String custMgmtBusinessPartner );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfItemPartner
     * SrvcConfItemPartner} entity and save it to the S/4HANA system.
     *
     * @param srvcConfItemPartner
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfItemPartner
     *            SrvcConfItemPartner} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfItemPartner
     *         SrvcConfItemPartner} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfItemPartnerCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SrvcConfItemPartnerCreateFluentHelper
        createSrvcConfItemPartner( @Nonnull final SrvcConfItemPartner srvcConfItemPartner );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfItemPartner
     * SrvcConfItemPartner} entity and save it to the S/4HANA system.
     *
     * @param srvcConfItemPartner
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfItemPartner
     *            SrvcConfItemPartner} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfItemPartner
     *         SrvcConfItemPartner} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfItemPartnerUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SrvcConfItemPartnerUpdateFluentHelper
        updateSrvcConfItemPartner( @Nonnull final SrvcConfItemPartner srvcConfItemPartner );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfItemPartner
     * SrvcConfItemPartner} entity in the S/4HANA system.
     *
     * @param srvcConfItemPartner
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfItemPartner
     *            SrvcConfItemPartner} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfItemPartner
     *         SrvcConfItemPartner} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfItemPartnerDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SrvcConfItemPartnerDeleteFluentHelper
        deleteSrvcConfItemPartner( @Nonnull final SrvcConfItemPartner srvcConfItemPartner );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfItmPartnerAddress
     * SrvcConfItmPartnerAddress} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfItmPartnerAddress
     *         SrvcConfItmPartnerAddress} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfItmPartnerAddressFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SrvcConfItmPartnerAddressFluentHelper getAllSrvcConfItmPartnerAddress();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfItmPartnerAddress
     * SrvcConfItmPartnerAddress} entity using key fields.
     *
     * @param serviceConfirmationItem
     *            Shortened Item Number in Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param custMgmtBusinessPartner
     *            Business Partner Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param serviceConfirmation
     *            Transaction ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param custMgmtPartnerFunction
     *
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfItmPartnerAddress
     *         SrvcConfItmPartnerAddress} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfItmPartnerAddressByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SrvcConfItmPartnerAddressByKeyFluentHelper getSrvcConfItmPartnerAddressByKey(
        final String serviceConfirmation,
        final String serviceConfirmationItem,
        final String custMgmtPartnerFunction,
        final String custMgmtBusinessPartner );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfItmPartnerAddress
     * SrvcConfItmPartnerAddress} entity and save it to the S/4HANA system.
     *
     * @param srvcConfItmPartnerAddress
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfItmPartnerAddress
     *            SrvcConfItmPartnerAddress} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfItmPartnerAddress
     *         SrvcConfItmPartnerAddress} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfItmPartnerAddressUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SrvcConfItmPartnerAddressUpdateFluentHelper
        updateSrvcConfItmPartnerAddress( @Nonnull final SrvcConfItmPartnerAddress srvcConfItmPartnerAddress );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfPartner
     * SrvcConfPartner} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfPartner
     *         SrvcConfPartner} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfPartnerFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SrvcConfPartnerFluentHelper getAllSrvcConfPartner();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfPartner
     * SrvcConfPartner} entity using key fields.
     *
     * @param custMgmtBusinessPartner
     *            Business Partner Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param serviceConfirmation
     *            Transaction ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param custMgmtPartnerFunction
     *
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfPartner
     *         SrvcConfPartner} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfPartnerByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SrvcConfPartnerByKeyFluentHelper getSrvcConfPartnerByKey(
        final String serviceConfirmation,
        final String custMgmtPartnerFunction,
        final String custMgmtBusinessPartner );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfPartner
     * SrvcConfPartner} entity and save it to the S/4HANA system.
     *
     * @param srvcConfPartner
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfPartner
     *            SrvcConfPartner} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfPartner
     *         SrvcConfPartner} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfPartnerCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SrvcConfPartnerCreateFluentHelper createSrvcConfPartner( @Nonnull final SrvcConfPartner srvcConfPartner );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfPartner
     * SrvcConfPartner} entity and save it to the S/4HANA system.
     *
     * @param srvcConfPartner
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfPartner
     *            SrvcConfPartner} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfPartner
     *         SrvcConfPartner} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfPartnerUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SrvcConfPartnerUpdateFluentHelper updateSrvcConfPartner( @Nonnull final SrvcConfPartner srvcConfPartner );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfPartner SrvcConfPartner}
     * entity in the S/4HANA system.
     *
     * @param srvcConfPartner
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfPartner
     *            SrvcConfPartner} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfPartner
     *         SrvcConfPartner} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfPartnerDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SrvcConfPartnerDeleteFluentHelper deleteSrvcConfPartner( @Nonnull final SrvcConfPartner srvcConfPartner );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfPartnerAddress
     * SrvcConfPartnerAddress} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfPartnerAddress
     *         SrvcConfPartnerAddress} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfPartnerAddressFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SrvcConfPartnerAddressFluentHelper getAllSrvcConfPartnerAddress();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfPartnerAddress
     * SrvcConfPartnerAddress} entity using key fields.
     *
     * @param custMgmtBusinessPartner
     *            Business Partner Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param serviceConfirmation
     *            Transaction ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param custMgmtPartnerFunction
     *
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfPartnerAddress
     *         SrvcConfPartnerAddress} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfPartnerAddressByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SrvcConfPartnerAddressByKeyFluentHelper getSrvcConfPartnerAddressByKey(
        final String serviceConfirmation,
        final String custMgmtPartnerFunction,
        final String custMgmtBusinessPartner );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfPartnerAddress
     * SrvcConfPartnerAddress} entity and save it to the S/4HANA system.
     *
     * @param srvcConfPartnerAddress
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfPartnerAddress
     *            SrvcConfPartnerAddress} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfPartnerAddress
     *         SrvcConfPartnerAddress} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfPartnerAddressUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SrvcConfPartnerAddressUpdateFluentHelper
        updateSrvcConfPartnerAddress( @Nonnull final SrvcConfPartnerAddress srvcConfPartnerAddress );

}
