/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.util.UUID;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.ServiceContrItemObjectListByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.ServiceContrItemObjectListFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.ServiceContrItemPriceElementByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.ServiceContrItemPriceElementFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.ServiceContrItmReleasedOrderByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.ServiceContrItmReleasedOrderFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.ServiceContractByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.ServiceContractFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.ServiceContractItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.ServiceContractItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.ServiceContractItemTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.ServiceContractItemTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.ServiceContractTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.ServiceContractTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.SrvcContrBillgReqItmPrcElmntByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.SrvcContrBillgReqItmPrcElmntFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.SrvcContrItemProductByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.SrvcContrItemProductFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.SrvcContrItmBillgReqItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.SrvcContrItmBillgReqItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.batch.ServiceContractServiceBatch;

/**
 * <p>
 *
 * You can use this service to integrate external applications with service contract processing in SAP S/4HANA Cloud.
 * The service contains entities of service contract header, header text, item text, item, item object list, item
 * product list, item price element, item released order, and billing request line. In each API call, you can use the
 * operation to retrieve service contracts. You can apply any of the filters provided or retrieve all existing data..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/40/e8f572cd8a4a41bfe34b3094ef638e/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_SERVICE_CONTRACT_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_SERVICE_CONTRACT_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Service Contract OData Integration(SAP_COM_0558)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/3MO'>Service Contract Management(3MO)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Service Contract</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Deprecated
public interface ServiceContractService extends BatchService<ServiceContractServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_SERVICE_CONTRACT_SRV";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    ServiceContractService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.ServiceContract
     * ServiceContract} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.ServiceContract
     *         ServiceContract} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.ServiceContractFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceContractFluentHelper getAllServiceContract();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.ServiceContract
     * ServiceContract} entity using key fields.
     *
     * @param serviceContract
     *            Transaction ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.ServiceContract
     *         ServiceContract} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.ServiceContractByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceContractByKeyFluentHelper getServiceContractByKey( final String serviceContract );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.ServiceContractItem
     * ServiceContractItem} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.ServiceContractItem
     *         ServiceContractItem} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.ServiceContractItemFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceContractItemFluentHelper getAllServiceContractItem();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.ServiceContractItem
     * ServiceContractItem} entity using key fields.
     *
     * @param serviceContractItem
     *            Shortened Item Number in Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param serviceContract
     *            Transaction ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.ServiceContractItem
     *         ServiceContractItem} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.ServiceContractItemByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceContractItemByKeyFluentHelper
        getServiceContractItemByKey( final String serviceContract, final String serviceContractItem );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.ServiceContractItemText
     * ServiceContractItemText} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.ServiceContractItemText
     *         ServiceContractItemText} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.ServiceContractItemTextFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceContractItemTextFluentHelper getAllServiceContractItemText();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.ServiceContractItemText
     * ServiceContractItemText} entity using key fields.
     *
     * @param serviceContractItem
     *            Shortened Item Number in Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param serviceContract
     *            Transaction ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param longTextID
     *            Text ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.ServiceContractItemText
     *         ServiceContractItemText} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.ServiceContractItemTextByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceContractItemTextByKeyFluentHelper getServiceContractItemTextByKey(
        final String serviceContract,
        final String serviceContractItem,
        final String language,
        final String longTextID );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.ServiceContractText
     * ServiceContractText} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.ServiceContractText
     *         ServiceContractText} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.ServiceContractTextFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceContractTextFluentHelper getAllServiceContractText();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.ServiceContractText
     * ServiceContractText} entity using key fields.
     *
     * @param serviceContract
     *            Transaction ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param longTextID
     *            Text ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.ServiceContractText
     *         ServiceContractText} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.ServiceContractTextByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceContractTextByKeyFluentHelper
        getServiceContractTextByKey( final String serviceContract, final String language, final String longTextID );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.ServiceContrItemObjectList
     * ServiceContrItemObjectList} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.ServiceContrItemObjectList
     *         ServiceContrItemObjectList} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.ServiceContrItemObjectListFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceContrItemObjectListFluentHelper getAllServiceContrItemObjectList();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.ServiceContrItemObjectList
     * ServiceContrItemObjectList} entity using key fields.
     *
     * @param serviceContractItem
     *            Shortened Item Number in Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param serviceContract
     *            Transaction ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param serviceRefObjectSequenceNumber
     *            Reference Object Counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.ServiceContrItemObjectList
     *         ServiceContrItemObjectList} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.ServiceContrItemObjectListByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceContrItemObjectListByKeyFluentHelper getServiceContrItemObjectListByKey(
        final String serviceContract,
        final String serviceContractItem,
        final String serviceRefObjectSequenceNumber );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.ServiceContrItemPriceElement
     * ServiceContrItemPriceElement} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.ServiceContrItemPriceElement
     *         ServiceContrItemPriceElement} entities. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.ServiceContrItemPriceElementFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceContrItemPriceElementFluentHelper getAllServiceContrItemPriceElement();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.ServiceContrItemPriceElement
     * ServiceContrItemPriceElement} entity using key fields.
     *
     * @param serviceContractItem
     *            Shortened Item Number in Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param pricingProcedureCounter
     *            Condition Counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @param serviceContract
     *            Transaction ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param pricingProcedureStep
     *            Step Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.ServiceContrItemPriceElement
     *         ServiceContrItemPriceElement} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.ServiceContrItemPriceElementByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceContrItemPriceElementByKeyFluentHelper getServiceContrItemPriceElementByKey(
        final String serviceContract,
        final String serviceContractItem,
        final String pricingProcedureStep,
        final String pricingProcedureCounter );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.ServiceContrItmReleasedOrder
     * ServiceContrItmReleasedOrder} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.ServiceContrItmReleasedOrder
     *         ServiceContrItmReleasedOrder} entities. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.ServiceContrItmReleasedOrderFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceContrItmReleasedOrderFluentHelper getAllServiceContrItmReleasedOrder();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.ServiceContrItmReleasedOrder
     * ServiceContrItmReleasedOrder} entity using key fields.
     *
     * @param serviceDocumentItmRelationUUID
     *            Object Relationship Service : GUID binary link
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @param serviceDocItmRltnSqncNumber
     *            Sequential Number of Segment in IDoc Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.ServiceContrItmReleasedOrder
     *         ServiceContrItmReleasedOrder} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.ServiceContrItmReleasedOrderByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceContrItmReleasedOrderByKeyFluentHelper getServiceContrItmReleasedOrderByKey(
        final UUID serviceDocumentItmRelationUUID,
        final String serviceDocItmRltnSqncNumber );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.SrvcContrBillgReqItmPrcElmnt
     * SrvcContrBillgReqItmPrcElmnt} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.SrvcContrBillgReqItmPrcElmnt
     *         SrvcContrBillgReqItmPrcElmnt} entities. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.SrvcContrBillgReqItmPrcElmntFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SrvcContrBillgReqItmPrcElmntFluentHelper getAllSrvcContrBillgReqItmPrcElmnt();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.SrvcContrBillgReqItmPrcElmnt
     * SrvcContrBillgReqItmPrcElmnt} entity using key fields.
     *
     * @param pricingProcedureCounter
     *            Condition Counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @param serviceContract
     *            Transaction ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param billingRequestItem
     *            Shortened Item Number in Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param pricingProcedureStep
     *            Step Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.SrvcContrBillgReqItmPrcElmnt
     *         SrvcContrBillgReqItmPrcElmnt} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.SrvcContrBillgReqItmPrcElmntByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SrvcContrBillgReqItmPrcElmntByKeyFluentHelper getSrvcContrBillgReqItmPrcElmntByKey(
        final String serviceContract,
        final String billingRequestItem,
        final String pricingProcedureStep,
        final String pricingProcedureCounter );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.SrvcContrItemProduct
     * SrvcContrItemProduct} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.SrvcContrItemProduct
     *         SrvcContrItemProduct} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.SrvcContrItemProductFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SrvcContrItemProductFluentHelper getAllSrvcContrItemProduct();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.SrvcContrItemProduct
     * SrvcContrItemProduct} entity using key fields.
     *
     * @param serviceContractItem
     *            Shortened Item Number in Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param serviceProductListItem
     *            Counter for CRMS4D_ORDPRP_I product list
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param serviceContract
     *            Transaction ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.SrvcContrItemProduct
     *         SrvcContrItemProduct} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.SrvcContrItemProductByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SrvcContrItemProductByKeyFluentHelper getSrvcContrItemProductByKey(
        final String serviceContract,
        final String serviceContractItem,
        final String serviceProductListItem );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.SrvcContrItmBillgReqItem
     * SrvcContrItmBillgReqItem} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.SrvcContrItmBillgReqItem
     *         SrvcContrItmBillgReqItem} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.SrvcContrItmBillgReqItemFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SrvcContrItmBillgReqItemFluentHelper getAllSrvcContrItmBillgReqItem();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.SrvcContrItmBillgReqItem
     * SrvcContrItmBillgReqItem} entity using key fields.
     *
     * @param serviceContractItem
     *            Shortened Item Number in Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param serviceContract
     *            Transaction ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param billingRequestItem
     *            Billing Request Item No
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.SrvcContrItmBillgReqItem
     *         SrvcContrItmBillgReqItem} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.SrvcContrItmBillgReqItemByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SrvcContrItmBillgReqItemByKeyFluentHelper getSrvcContrItmBillgReqItemByKey(
        final String serviceContract,
        final String serviceContractItem,
        final String billingRequestItem );

}
