/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.RevokeApprovalFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.ServiceEntrySheet;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.ServiceEntrySheetByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.ServiceEntrySheetCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.ServiceEntrySheetFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.ServiceEntrySheetItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.ServiceEntrySheetItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.ServiceEntrySheetItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.ServiceEntrySheetItemUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.ServiceEntrySheetUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.SrvcEntrShtAcctAssignment;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.SrvcEntrShtAcctAssignmentByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.SrvcEntrShtAcctAssignmentFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.SrvcEntrShtAcctAssignmentUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.SubmitForApprovalFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.WithdrawFromApprovalFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.batch.ServiceEntrySheetServiceBatch;

/**
 * <p>
 *
 * This service enables a remote system to read, create and update service entry sheets from or in the SAP S/4HANA Cloud
 * system. It also provides service nodes to submit a service entry sheet for approval, withdraw a service entry sheet
 * from approval or revoke approval of an already approved service entry sheet..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/0f/17c815dc784fa39b4fc7c0fe9f72b5/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_SERVICE_ENTRY_SHEET_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_SERVICE_ENTRY_SHEET_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.2.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Service Entry Sheet Integration(SAP_COM_0146)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/BNX'>Consumable Purchasing(BNX)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/J13'>Service and Material Procurement - Project-Based
 * Services(J13)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/ONX'>Consumable Purchasing(ONX)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/22Z'>Procurement of Services(22Z)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Service Entry Sheet</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Deprecated
public interface ServiceEntrySheetService extends BatchService<ServiceEntrySheetServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_SERVICE_ENTRY_SHEET_SRV";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    ServiceEntrySheetService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.ServiceEntrySheet
     * ServiceEntrySheet} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.ServiceEntrySheet
     *         ServiceEntrySheet} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.ServiceEntrySheetFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceEntrySheetFluentHelper getAllServiceEntrySheet();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.ServiceEntrySheet
     * ServiceEntrySheet} entity using key fields.
     *
     * @param serviceEntrySheet
     *            Service Entry Sheet
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.ServiceEntrySheet
     *         ServiceEntrySheet} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.ServiceEntrySheetByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceEntrySheetByKeyFluentHelper getServiceEntrySheetByKey( final String serviceEntrySheet );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.ServiceEntrySheet
     * ServiceEntrySheet} entity and save it to the S/4HANA system.
     *
     * @param serviceEntrySheet
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.ServiceEntrySheet
     *            ServiceEntrySheet} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.ServiceEntrySheet
     *         ServiceEntrySheet} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.ServiceEntrySheetCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceEntrySheetCreateFluentHelper createServiceEntrySheet( @Nonnull final ServiceEntrySheet serviceEntrySheet );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.ServiceEntrySheet
     * ServiceEntrySheet} entity and save it to the S/4HANA system.
     *
     * @param serviceEntrySheet
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.ServiceEntrySheet
     *            ServiceEntrySheet} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.ServiceEntrySheet
     *         ServiceEntrySheet} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.ServiceEntrySheetUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceEntrySheetUpdateFluentHelper updateServiceEntrySheet( @Nonnull final ServiceEntrySheet serviceEntrySheet );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.ServiceEntrySheetItem
     * ServiceEntrySheetItem} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.ServiceEntrySheetItem
     *         ServiceEntrySheetItem} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.ServiceEntrySheetItemFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceEntrySheetItemFluentHelper getAllServiceEntrySheetItem();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.ServiceEntrySheetItem
     * ServiceEntrySheetItem} entity using key fields.
     *
     * @param serviceEntrySheetItem
     *            Item Number of Service Entry Sheet
     *            <p>
     *            Constraints: Not nullable, Maximum length: 5
     *            </p>
     * @param serviceEntrySheet
     *            Service Entry Sheet
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.ServiceEntrySheetItem
     *         ServiceEntrySheetItem} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.ServiceEntrySheetItemByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceEntrySheetItemByKeyFluentHelper
        getServiceEntrySheetItemByKey( final String serviceEntrySheet, final String serviceEntrySheetItem );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.ServiceEntrySheetItem
     * ServiceEntrySheetItem} entity and save it to the S/4HANA system.
     *
     * @param serviceEntrySheetItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.ServiceEntrySheetItem
     *            ServiceEntrySheetItem} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.ServiceEntrySheetItem
     *         ServiceEntrySheetItem} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.ServiceEntrySheetItemUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceEntrySheetItemUpdateFluentHelper
        updateServiceEntrySheetItem( @Nonnull final ServiceEntrySheetItem serviceEntrySheetItem );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.SrvcEntrShtAcctAssignment
     * SrvcEntrShtAcctAssignment} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.SrvcEntrShtAcctAssignment
     *         SrvcEntrShtAcctAssignment} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.SrvcEntrShtAcctAssignmentFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SrvcEntrShtAcctAssignmentFluentHelper getAllSrvcEntrShtAcctAssignment();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.SrvcEntrShtAcctAssignment
     * SrvcEntrShtAcctAssignment} entity using key fields.
     *
     * @param accountAssignment
     *            Sequential Number of Account Assignment
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param serviceEntrySheetItem
     *            Item Number of Service Entry Sheet
     *            <p>
     *            Constraints: Not nullable, Maximum length: 5
     *            </p>
     * @param serviceEntrySheet
     *            Service Entry Sheet
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.SrvcEntrShtAcctAssignment
     *         SrvcEntrShtAcctAssignment} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.SrvcEntrShtAcctAssignmentByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SrvcEntrShtAcctAssignmentByKeyFluentHelper getSrvcEntrShtAcctAssignmentByKey(
        final String serviceEntrySheet,
        final String serviceEntrySheetItem,
        final String accountAssignment );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.SrvcEntrShtAcctAssignment
     * SrvcEntrShtAcctAssignment} entity and save it to the S/4HANA system.
     *
     * @param srvcEntrShtAcctAssignment
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.SrvcEntrShtAcctAssignment
     *            SrvcEntrShtAcctAssignment} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.SrvcEntrShtAcctAssignment
     *         SrvcEntrShtAcctAssignment} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.SrvcEntrShtAcctAssignmentUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SrvcEntrShtAcctAssignmentUpdateFluentHelper
        updateSrvcEntrShtAcctAssignment( @Nonnull final SrvcEntrShtAcctAssignment srvcEntrShtAcctAssignment );

    /**
     * <p>
     * Creates a fluent helper for the <b>SubmitForApproval</b> OData function import.
     * </p>
     *
     * @param serviceEntrySheet
     *            Service Entry Sheet
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ServiceEntrySheet</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>SubmitForApproval</b> OData function import with the
     *         provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.SubmitForApprovalFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SubmitForApprovalFluentHelper submitForApproval( @Nonnull final String serviceEntrySheet );

    /**
     * <p>
     * Creates a fluent helper for the <b>RevokeApproval</b> OData function import.
     * </p>
     *
     * @param serviceEntrySheet
     *            Service Entry Sheet
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ServiceEntrySheet</b>
     *            </p>
     * @param postingDate
     *            Posting Date
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>PostingDate</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>RevokeApproval</b> OData function import with the
     *         provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.RevokeApprovalFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    RevokeApprovalFluentHelper
        revokeApproval( @Nonnull final String postingDate, @Nonnull final String serviceEntrySheet );

    /**
     * <p>
     * Creates a fluent helper for the <b>WithdrawFromApproval</b> OData function import.
     * </p>
     *
     * @param serviceEntrySheet
     *            Service Entry Sheet
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ServiceEntrySheet</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>WithdrawFromApproval</b> OData function import with the
     *         provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.WithdrawFromApprovalFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    WithdrawFromApprovalFluentHelper withdrawFromApproval( @Nonnull final String serviceEntrySheet );

}
