/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrdItemUserStatus;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrdItemUserStatusByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrdItemUserStatusCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrdItemUserStatusDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrdItemUserStatusFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrdUserStatus;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrdUserStatusByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrdUserStatusCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrdUserStatusDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrdUserStatusFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrder;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderConfirmationByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderConfirmationFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderDefect;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderDefectByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderDefectCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderDefectDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderDefectFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderDefectUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItemConfirmationByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItemConfirmationFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItemCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItemDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItemPriceElement;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItemPriceElementByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItemPriceElementCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItemPriceElementFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItemPriceElementUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItemRefObject;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItemRefObjectByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItemRefObjectCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItemRefObjectDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItemRefObjectFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItemText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItemTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItemTextCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItemTextDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItemTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItemTextUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItemUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderPersonResp;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderPersonRespByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderPersonRespCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderPersonRespDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderPersonRespFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderPersonRespUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderPriceElement;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderPriceElementByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderPriceElementCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderPriceElementFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderPriceElementUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderRefObject;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderRefObjectByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderRefObjectCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderRefObjectDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderRefObjectFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderTextCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderTextDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderTextUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdAppointment;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdAppointmentByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdAppointmentCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdAppointmentFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdAppointmentUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdDuration;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdDurationByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdDurationCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdDurationFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdDurationUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItemAppointment;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItemAppointmentByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItemAppointmentCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItemAppointmentFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItemAppointmentUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItemDuration;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItemDurationByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItemDurationCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItemDurationFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItemDurationUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItmPartner;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItmPartnerAddress;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItmPartnerAddressByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItmPartnerAddressFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItmPartnerAddressUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItmPartnerByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItmPartnerCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItmPartnerDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItmPartnerFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItmPartnerUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItmProdRefObject;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItmProdRefObjectByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItmProdRefObjectCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItmProdRefObjectDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItmProdRefObjectFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdPartner;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdPartnerAddress;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdPartnerAddressByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdPartnerAddressFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdPartnerAddressUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdPartnerByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdPartnerCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdPartnerDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdPartnerFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdPartnerUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdProdRefObject;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdProdRefObjectByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdProdRefObjectCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdProdRefObjectDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdProdRefObjectFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdRefServiceContractByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdRefServiceContractFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.batch.ServiceOrderServiceBatch;

/**
 * <p>
 *
 * You can use this service to integrate external applications with service order processing in SAP S/4HANA Cloud. In
 * each API call, you can use the following operations: - Retrieve service orders. - Create service orders. Note: You
 * must use “deep insert” requests (a header plus the following entities: header person responsible, header pricing
 * element, header reference object, header defect, header text, and item). - Create new items for existing service
 * orders. - Create an item reference object, item pricing element, and an item text for existing service orders items.
 * - Update the header, header person responsible, header pricing element, header defect, header text, item, item
 * pricing element, and item text for existing service orders. - Delete the header person responsible, header reference
 * object, header defect, header text, item, item reference object, and item text for existing service orders.
 *
 * This service enables you to add attachments to a service order header and service order items by making an API call
 * to the service Attachments (API_CV_ATTACHMENT_SRV). You can also use the service Attachments to download and delete
 * attachments from a service order header and service order items..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/dd/fe570e96c84075b2ff3e5b1be9714b/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_SERVICE_ORDER_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_SERVICE_ORDER_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.3.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Service Order OData Integration(SAP_COM_0350), Service - Repair Order Integration(SAP_COM_0742)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/3D2'>Service Order Management and Monitoring(3D2)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/3XK'>In-House Repair(3XK)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Service Order</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Deprecated
public interface ServiceOrderService extends BatchService<ServiceOrderServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_SERVICE_ORDER_SRV";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    ServiceOrderService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrder ServiceOrder}
     * entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrder ServiceOrder}
     *         entities. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceOrderFluentHelper getAllServiceOrder();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrder ServiceOrder}
     * entity using key fields.
     *
     * @param serviceOrder
     *            Transaction ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrder ServiceOrder} entity
     *         using key fields. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceOrderByKeyFluentHelper getServiceOrderByKey( final String serviceOrder );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrder ServiceOrder}
     * entity and save it to the S/4HANA system.
     *
     * @param serviceOrder
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrder ServiceOrder}
     *            entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrder ServiceOrder}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceOrderCreateFluentHelper createServiceOrder( @Nonnull final ServiceOrder serviceOrder );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrder
     * ServiceOrder} entity and save it to the S/4HANA system.
     *
     * @param serviceOrder
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrder ServiceOrder}
     *            entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrder ServiceOrder}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceOrderUpdateFluentHelper updateServiceOrder( @Nonnull final ServiceOrder serviceOrder );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderConfirmation
     * ServiceOrderConfirmation} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderConfirmation
     *         ServiceOrderConfirmation} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderConfirmationFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceOrderConfirmationFluentHelper getAllServiceOrderConfirmation();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderConfirmation
     * ServiceOrderConfirmation} entity using key fields.
     *
     * @param serviceConfirmation
     *            Transaction ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param serviceOrder
     *            Transaction ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderConfirmation
     *         ServiceOrderConfirmation} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderConfirmationByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceOrderConfirmationByKeyFluentHelper
        getServiceOrderConfirmationByKey( final String serviceOrder, final String serviceConfirmation );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderDefect
     * ServiceOrderDefect} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderDefect
     *         ServiceOrderDefect} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderDefectFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceOrderDefectFluentHelper getAllServiceOrderDefect();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderDefect
     * ServiceOrderDefect} entity using key fields.
     *
     * @param serviceDefectSequence
     *            Sort Field
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @param serviceOrder
     *            Transaction ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param srvcDocTypeDefectCodeProfType
     *            Subject Profile Category
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderDefect
     *         ServiceOrderDefect} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderDefectByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceOrderDefectByKeyFluentHelper getServiceOrderDefectByKey(
        final String serviceOrder,
        final String srvcDocTypeDefectCodeProfType,
        final Short serviceDefectSequence );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderDefect
     * ServiceOrderDefect} entity and save it to the S/4HANA system.
     *
     * @param serviceOrderDefect
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderDefect
     *            ServiceOrderDefect} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderDefect
     *         ServiceOrderDefect} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderDefectCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceOrderDefectCreateFluentHelper
        createServiceOrderDefect( @Nonnull final ServiceOrderDefect serviceOrderDefect );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderDefect
     * ServiceOrderDefect} entity and save it to the S/4HANA system.
     *
     * @param serviceOrderDefect
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderDefect
     *            ServiceOrderDefect} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderDefect
     *         ServiceOrderDefect} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderDefectUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceOrderDefectUpdateFluentHelper
        updateServiceOrderDefect( @Nonnull final ServiceOrderDefect serviceOrderDefect );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderDefect
     * ServiceOrderDefect} entity in the S/4HANA system.
     *
     * @param serviceOrderDefect
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderDefect
     *            ServiceOrderDefect} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderDefect
     *         ServiceOrderDefect} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderDefectDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceOrderDefectDeleteFluentHelper
        deleteServiceOrderDefect( @Nonnull final ServiceOrderDefect serviceOrderDefect );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItem
     * ServiceOrderItem} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItem
     *         ServiceOrderItem} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItemFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceOrderItemFluentHelper getAllServiceOrderItem();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItem
     * ServiceOrderItem} entity using key fields.
     *
     * @param serviceOrderItem
     *            Shortened Item Number in Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param serviceOrder
     *            Transaction ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItem
     *         ServiceOrderItem} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItemByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceOrderItemByKeyFluentHelper
        getServiceOrderItemByKey( final String serviceOrder, final String serviceOrderItem );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItem
     * ServiceOrderItem} entity and save it to the S/4HANA system.
     *
     * @param serviceOrderItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItem
     *            ServiceOrderItem} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItem
     *         ServiceOrderItem} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItemCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceOrderItemCreateFluentHelper createServiceOrderItem( @Nonnull final ServiceOrderItem serviceOrderItem );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItem
     * ServiceOrderItem} entity and save it to the S/4HANA system.
     *
     * @param serviceOrderItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItem
     *            ServiceOrderItem} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItem
     *         ServiceOrderItem} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItemUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceOrderItemUpdateFluentHelper updateServiceOrderItem( @Nonnull final ServiceOrderItem serviceOrderItem );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItem
     * ServiceOrderItem} entity in the S/4HANA system.
     *
     * @param serviceOrderItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItem
     *            ServiceOrderItem} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItem
     *         ServiceOrderItem} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItemDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceOrderItemDeleteFluentHelper deleteServiceOrderItem( @Nonnull final ServiceOrderItem serviceOrderItem );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItemConfirmation
     * ServiceOrderItemConfirmation} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItemConfirmation
     *         ServiceOrderItemConfirmation} entities. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItemConfirmationFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceOrderItemConfirmationFluentHelper getAllServiceOrderItemConfirmation();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItemConfirmation
     * ServiceOrderItemConfirmation} entity using key fields.
     *
     * @param serviceConfirmationItem
     *            Shortened Item Number in Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param serviceOrderItem
     *            Shortened Item Number in Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param serviceConfirmation
     *            Transaction ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param serviceOrder
     *            Transaction ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItemConfirmation
     *         ServiceOrderItemConfirmation} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItemConfirmationByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceOrderItemConfirmationByKeyFluentHelper getServiceOrderItemConfirmationByKey(
        final String serviceOrder,
        final String serviceOrderItem,
        final String serviceConfirmation,
        final String serviceConfirmationItem );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItemPriceElement
     * ServiceOrderItemPriceElement} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItemPriceElement
     *         ServiceOrderItemPriceElement} entities. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItemPriceElementFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceOrderItemPriceElementFluentHelper getAllServiceOrderItemPriceElement();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItemPriceElement
     * ServiceOrderItemPriceElement} entity using key fields.
     *
     * @param serviceOrderItem
     *            Shortened Item Number in Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param pricingProcedureCounter
     *            Condition Counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @param serviceOrder
     *            Transaction ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param pricingProcedureStep
     *            Step Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItemPriceElement
     *         ServiceOrderItemPriceElement} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItemPriceElementByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceOrderItemPriceElementByKeyFluentHelper getServiceOrderItemPriceElementByKey(
        final String serviceOrder,
        final String serviceOrderItem,
        final String pricingProcedureStep,
        final String pricingProcedureCounter );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItemPriceElement
     * ServiceOrderItemPriceElement} entity and save it to the S/4HANA system.
     *
     * @param serviceOrderItemPriceElement
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItemPriceElement
     *            ServiceOrderItemPriceElement} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItemPriceElement
     *         ServiceOrderItemPriceElement} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItemPriceElementCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceOrderItemPriceElementCreateFluentHelper
        createServiceOrderItemPriceElement( @Nonnull final ServiceOrderItemPriceElement serviceOrderItemPriceElement );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItemPriceElement
     * ServiceOrderItemPriceElement} entity and save it to the S/4HANA system.
     *
     * @param serviceOrderItemPriceElement
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItemPriceElement
     *            ServiceOrderItemPriceElement} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItemPriceElement
     *         ServiceOrderItemPriceElement} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItemPriceElementUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceOrderItemPriceElementUpdateFluentHelper
        updateServiceOrderItemPriceElement( @Nonnull final ServiceOrderItemPriceElement serviceOrderItemPriceElement );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItemRefObject
     * ServiceOrderItemRefObject} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItemRefObject
     *         ServiceOrderItemRefObject} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItemRefObjectFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceOrderItemRefObjectFluentHelper getAllServiceOrderItemRefObject();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItemRefObject
     * ServiceOrderItemRefObject} entity using key fields.
     *
     * @param serviceOrderItem
     *            Shortened Item Number in Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param serviceRefFunctionalLocation
     *            Functional Location
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @param serviceOrder
     *            Transaction ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param serviceReferenceEquipment
     *            Equipment Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 18
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItemRefObject
     *         ServiceOrderItemRefObject} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItemRefObjectByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceOrderItemRefObjectByKeyFluentHelper getServiceOrderItemRefObjectByKey(
        final String serviceOrder,
        final String serviceOrderItem,
        final String serviceReferenceEquipment,
        final String serviceRefFunctionalLocation );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItemRefObject
     * ServiceOrderItemRefObject} entity and save it to the S/4HANA system.
     *
     * @param serviceOrderItemRefObject
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItemRefObject
     *            ServiceOrderItemRefObject} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItemRefObject
     *         ServiceOrderItemRefObject} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItemRefObjectCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceOrderItemRefObjectCreateFluentHelper
        createServiceOrderItemRefObject( @Nonnull final ServiceOrderItemRefObject serviceOrderItemRefObject );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItemRefObject
     * ServiceOrderItemRefObject} entity in the S/4HANA system.
     *
     * @param serviceOrderItemRefObject
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItemRefObject
     *            ServiceOrderItemRefObject} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItemRefObject
     *         ServiceOrderItemRefObject} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItemRefObjectDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceOrderItemRefObjectDeleteFluentHelper
        deleteServiceOrderItemRefObject( @Nonnull final ServiceOrderItemRefObject serviceOrderItemRefObject );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItemText
     * ServiceOrderItemText} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItemText
     *         ServiceOrderItemText} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItemTextFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceOrderItemTextFluentHelper getAllServiceOrderItemText();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItemText
     * ServiceOrderItemText} entity using key fields.
     *
     * @param serviceOrderItem
     *            Shortened Item Number in Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param serviceOrder
     *            Transaction ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param longTextID
     *            Text ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItemText
     *         ServiceOrderItemText} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItemTextByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceOrderItemTextByKeyFluentHelper getServiceOrderItemTextByKey(
        final String serviceOrder,
        final String serviceOrderItem,
        final String language,
        final String longTextID );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItemText
     * ServiceOrderItemText} entity and save it to the S/4HANA system.
     *
     * @param serviceOrderItemText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItemText
     *            ServiceOrderItemText} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItemText
     *         ServiceOrderItemText} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItemTextCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceOrderItemTextCreateFluentHelper
        createServiceOrderItemText( @Nonnull final ServiceOrderItemText serviceOrderItemText );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItemText
     * ServiceOrderItemText} entity and save it to the S/4HANA system.
     *
     * @param serviceOrderItemText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItemText
     *            ServiceOrderItemText} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItemText
     *         ServiceOrderItemText} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItemTextUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceOrderItemTextUpdateFluentHelper
        updateServiceOrderItemText( @Nonnull final ServiceOrderItemText serviceOrderItemText );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItemText
     * ServiceOrderItemText} entity in the S/4HANA system.
     *
     * @param serviceOrderItemText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItemText
     *            ServiceOrderItemText} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItemText
     *         ServiceOrderItemText} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItemTextDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceOrderItemTextDeleteFluentHelper
        deleteServiceOrderItemText( @Nonnull final ServiceOrderItemText serviceOrderItemText );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderPersonResp
     * ServiceOrderPersonResp} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderPersonResp
     *         ServiceOrderPersonResp} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderPersonRespFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceOrderPersonRespFluentHelper getAllServiceOrderPersonResp();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderPersonResp
     * ServiceOrderPersonResp} entity using key fields.
     *
     * @param personResponsible
     *            Business Partner Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param serviceOrder
     *            Transaction ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderPersonResp
     *         ServiceOrderPersonResp} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderPersonRespByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceOrderPersonRespByKeyFluentHelper
        getServiceOrderPersonRespByKey( final String serviceOrder, final String personResponsible );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderPersonResp
     * ServiceOrderPersonResp} entity and save it to the S/4HANA system.
     *
     * @param serviceOrderPersonResp
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderPersonResp
     *            ServiceOrderPersonResp} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderPersonResp
     *         ServiceOrderPersonResp} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderPersonRespCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceOrderPersonRespCreateFluentHelper
        createServiceOrderPersonResp( @Nonnull final ServiceOrderPersonResp serviceOrderPersonResp );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderPersonResp
     * ServiceOrderPersonResp} entity and save it to the S/4HANA system.
     *
     * @param serviceOrderPersonResp
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderPersonResp
     *            ServiceOrderPersonResp} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderPersonResp
     *         ServiceOrderPersonResp} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderPersonRespUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceOrderPersonRespUpdateFluentHelper
        updateServiceOrderPersonResp( @Nonnull final ServiceOrderPersonResp serviceOrderPersonResp );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderPersonResp
     * ServiceOrderPersonResp} entity in the S/4HANA system.
     *
     * @param serviceOrderPersonResp
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderPersonResp
     *            ServiceOrderPersonResp} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderPersonResp
     *         ServiceOrderPersonResp} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderPersonRespDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceOrderPersonRespDeleteFluentHelper
        deleteServiceOrderPersonResp( @Nonnull final ServiceOrderPersonResp serviceOrderPersonResp );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderPriceElement
     * ServiceOrderPriceElement} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderPriceElement
     *         ServiceOrderPriceElement} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderPriceElementFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceOrderPriceElementFluentHelper getAllServiceOrderPriceElement();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderPriceElement
     * ServiceOrderPriceElement} entity using key fields.
     *
     * @param pricingProcedureCounter
     *            Condition Counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @param serviceOrder
     *            Transaction ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param pricingProcedureStep
     *            Step Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderPriceElement
     *         ServiceOrderPriceElement} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderPriceElementByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceOrderPriceElementByKeyFluentHelper getServiceOrderPriceElementByKey(
        final String serviceOrder,
        final String pricingProcedureStep,
        final String pricingProcedureCounter );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderPriceElement
     * ServiceOrderPriceElement} entity and save it to the S/4HANA system.
     *
     * @param serviceOrderPriceElement
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderPriceElement
     *            ServiceOrderPriceElement} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderPriceElement
     *         ServiceOrderPriceElement} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderPriceElementCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceOrderPriceElementCreateFluentHelper
        createServiceOrderPriceElement( @Nonnull final ServiceOrderPriceElement serviceOrderPriceElement );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderPriceElement
     * ServiceOrderPriceElement} entity and save it to the S/4HANA system.
     *
     * @param serviceOrderPriceElement
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderPriceElement
     *            ServiceOrderPriceElement} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderPriceElement
     *         ServiceOrderPriceElement} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderPriceElementUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceOrderPriceElementUpdateFluentHelper
        updateServiceOrderPriceElement( @Nonnull final ServiceOrderPriceElement serviceOrderPriceElement );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderRefObject
     * ServiceOrderRefObject} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderRefObject
     *         ServiceOrderRefObject} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderRefObjectFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceOrderRefObjectFluentHelper getAllServiceOrderRefObject();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderRefObject
     * ServiceOrderRefObject} entity using key fields.
     *
     * @param serviceRefFunctionalLocation
     *            Functional Location
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @param serviceOrder
     *            Transaction ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param serviceReferenceEquipment
     *            Equipment Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 18
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderRefObject
     *         ServiceOrderRefObject} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderRefObjectByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceOrderRefObjectByKeyFluentHelper getServiceOrderRefObjectByKey(
        final String serviceOrder,
        final String serviceReferenceEquipment,
        final String serviceRefFunctionalLocation );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderRefObject
     * ServiceOrderRefObject} entity and save it to the S/4HANA system.
     *
     * @param serviceOrderRefObject
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderRefObject
     *            ServiceOrderRefObject} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderRefObject
     *         ServiceOrderRefObject} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderRefObjectCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceOrderRefObjectCreateFluentHelper
        createServiceOrderRefObject( @Nonnull final ServiceOrderRefObject serviceOrderRefObject );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderRefObject
     * ServiceOrderRefObject} entity in the S/4HANA system.
     *
     * @param serviceOrderRefObject
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderRefObject
     *            ServiceOrderRefObject} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderRefObject
     *         ServiceOrderRefObject} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderRefObjectDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceOrderRefObjectDeleteFluentHelper
        deleteServiceOrderRefObject( @Nonnull final ServiceOrderRefObject serviceOrderRefObject );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderText
     * ServiceOrderText} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderText
     *         ServiceOrderText} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderTextFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceOrderTextFluentHelper getAllServiceOrderText();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderText
     * ServiceOrderText} entity using key fields.
     *
     * @param serviceOrder
     *            Transaction ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param longTextID
     *            Text ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderText
     *         ServiceOrderText} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderTextByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceOrderTextByKeyFluentHelper
        getServiceOrderTextByKey( final String serviceOrder, final String language, final String longTextID );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderText
     * ServiceOrderText} entity and save it to the S/4HANA system.
     *
     * @param serviceOrderText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderText
     *            ServiceOrderText} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderText
     *         ServiceOrderText} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderTextCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceOrderTextCreateFluentHelper createServiceOrderText( @Nonnull final ServiceOrderText serviceOrderText );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderText
     * ServiceOrderText} entity and save it to the S/4HANA system.
     *
     * @param serviceOrderText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderText
     *            ServiceOrderText} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderText
     *         ServiceOrderText} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderTextUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceOrderTextUpdateFluentHelper updateServiceOrderText( @Nonnull final ServiceOrderText serviceOrderText );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderText
     * ServiceOrderText} entity in the S/4HANA system.
     *
     * @param serviceOrderText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderText
     *            ServiceOrderText} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderText
     *         ServiceOrderText} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderTextDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceOrderTextDeleteFluentHelper deleteServiceOrderText( @Nonnull final ServiceOrderText serviceOrderText );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrdItemUserStatus
     * ServiceOrdItemUserStatus} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrdItemUserStatus
     *         ServiceOrdItemUserStatus} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrdItemUserStatusFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceOrdItemUserStatusFluentHelper getAllServiceOrdItemUserStatus();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrdItemUserStatus
     * ServiceOrdItemUserStatus} entity using key fields.
     *
     * @param srvcOrdItemUserStatus
     *            Object Status
     *            <p>
     *            Constraints: Not nullable, Maximum length: 5
     *            </p>
     * @param serviceOrderItem
     *            Shortened Item Number in Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param serviceOrder
     *            Transaction ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrdItemUserStatus
     *         ServiceOrdItemUserStatus} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrdItemUserStatusByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceOrdItemUserStatusByKeyFluentHelper getServiceOrdItemUserStatusByKey(
        final String serviceOrder,
        final String serviceOrderItem,
        final String srvcOrdItemUserStatus );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrdItemUserStatus
     * ServiceOrdItemUserStatus} entity and save it to the S/4HANA system.
     *
     * @param serviceOrdItemUserStatus
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrdItemUserStatus
     *            ServiceOrdItemUserStatus} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrdItemUserStatus
     *         ServiceOrdItemUserStatus} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrdItemUserStatusCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceOrdItemUserStatusCreateFluentHelper
        createServiceOrdItemUserStatus( @Nonnull final ServiceOrdItemUserStatus serviceOrdItemUserStatus );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrdItemUserStatus
     * ServiceOrdItemUserStatus} entity in the S/4HANA system.
     *
     * @param serviceOrdItemUserStatus
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrdItemUserStatus
     *            ServiceOrdItemUserStatus} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrdItemUserStatus
     *         ServiceOrdItemUserStatus} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrdItemUserStatusDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceOrdItemUserStatusDeleteFluentHelper
        deleteServiceOrdItemUserStatus( @Nonnull final ServiceOrdItemUserStatus serviceOrdItemUserStatus );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrdUserStatus
     * ServiceOrdUserStatus} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrdUserStatus
     *         ServiceOrdUserStatus} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrdUserStatusFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceOrdUserStatusFluentHelper getAllServiceOrdUserStatus();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrdUserStatus
     * ServiceOrdUserStatus} entity using key fields.
     *
     * @param serviceOrder
     *            Transaction ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param srvcOrdUserStatus
     *            Object Status
     *            <p>
     *            Constraints: Not nullable, Maximum length: 5
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrdUserStatus
     *         ServiceOrdUserStatus} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrdUserStatusByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceOrdUserStatusByKeyFluentHelper
        getServiceOrdUserStatusByKey( final String serviceOrder, final String srvcOrdUserStatus );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrdUserStatus
     * ServiceOrdUserStatus} entity and save it to the S/4HANA system.
     *
     * @param serviceOrdUserStatus
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrdUserStatus
     *            ServiceOrdUserStatus} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrdUserStatus
     *         ServiceOrdUserStatus} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrdUserStatusCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceOrdUserStatusCreateFluentHelper
        createServiceOrdUserStatus( @Nonnull final ServiceOrdUserStatus serviceOrdUserStatus );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrdUserStatus
     * ServiceOrdUserStatus} entity in the S/4HANA system.
     *
     * @param serviceOrdUserStatus
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrdUserStatus
     *            ServiceOrdUserStatus} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrdUserStatus
     *         ServiceOrdUserStatus} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrdUserStatusDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceOrdUserStatusDeleteFluentHelper
        deleteServiceOrdUserStatus( @Nonnull final ServiceOrdUserStatus serviceOrdUserStatus );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdAppointment
     * SrvcOrdAppointment} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdAppointment
     *         SrvcOrdAppointment} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdAppointmentFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SrvcOrdAppointmentFluentHelper getAllSrvcOrdAppointment();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdAppointment
     * SrvcOrdAppointment} entity using key fields.
     *
     * @param srvcDocAppointmentType
     *            Technical Date Type Name
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     * @param serviceOrder
     *            Transaction ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdAppointment
     *         SrvcOrdAppointment} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdAppointmentByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SrvcOrdAppointmentByKeyFluentHelper
        getSrvcOrdAppointmentByKey( final String serviceOrder, final String srvcDocAppointmentType );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdAppointment
     * SrvcOrdAppointment} entity and save it to the S/4HANA system.
     *
     * @param srvcOrdAppointment
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdAppointment
     *            SrvcOrdAppointment} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdAppointment
     *         SrvcOrdAppointment} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdAppointmentCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SrvcOrdAppointmentCreateFluentHelper
        createSrvcOrdAppointment( @Nonnull final SrvcOrdAppointment srvcOrdAppointment );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdAppointment
     * SrvcOrdAppointment} entity and save it to the S/4HANA system.
     *
     * @param srvcOrdAppointment
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdAppointment
     *            SrvcOrdAppointment} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdAppointment
     *         SrvcOrdAppointment} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdAppointmentUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SrvcOrdAppointmentUpdateFluentHelper
        updateSrvcOrdAppointment( @Nonnull final SrvcOrdAppointment srvcOrdAppointment );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdDuration
     * SrvcOrdDuration} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdDuration SrvcOrdDuration}
     *         entities. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdDurationFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SrvcOrdDurationFluentHelper getAllSrvcOrdDuration();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdDuration
     * SrvcOrdDuration} entity using key fields.
     *
     * @param srvcDocDurationType
     *            Name for Type of Time Duration
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     * @param serviceOrder
     *            Transaction ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdDuration SrvcOrdDuration}
     *         entity using key fields. This fluent helper allows methods which modify the underlying query to be called
     *         before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdDurationByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SrvcOrdDurationByKeyFluentHelper
        getSrvcOrdDurationByKey( final String serviceOrder, final String srvcDocDurationType );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdDuration
     * SrvcOrdDuration} entity and save it to the S/4HANA system.
     *
     * @param srvcOrdDuration
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdDuration
     *            SrvcOrdDuration} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdDuration SrvcOrdDuration}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdDurationCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SrvcOrdDurationCreateFluentHelper createSrvcOrdDuration( @Nonnull final SrvcOrdDuration srvcOrdDuration );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdDuration
     * SrvcOrdDuration} entity and save it to the S/4HANA system.
     *
     * @param srvcOrdDuration
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdDuration
     *            SrvcOrdDuration} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdDuration SrvcOrdDuration}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdDurationUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SrvcOrdDurationUpdateFluentHelper updateSrvcOrdDuration( @Nonnull final SrvcOrdDuration srvcOrdDuration );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItemAppointment
     * SrvcOrdItemAppointment} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItemAppointment
     *         SrvcOrdItemAppointment} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItemAppointmentFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SrvcOrdItemAppointmentFluentHelper getAllSrvcOrdItemAppointment();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItemAppointment
     * SrvcOrdItemAppointment} entity using key fields.
     *
     * @param serviceOrderItem
     *            Shortened Item Number in Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param srvcDocAppointmentType
     *            Technical Date Type Name
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     * @param serviceOrder
     *            Transaction ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItemAppointment
     *         SrvcOrdItemAppointment} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItemAppointmentByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SrvcOrdItemAppointmentByKeyFluentHelper getSrvcOrdItemAppointmentByKey(
        final String serviceOrder,
        final String serviceOrderItem,
        final String srvcDocAppointmentType );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItemAppointment
     * SrvcOrdItemAppointment} entity and save it to the S/4HANA system.
     *
     * @param srvcOrdItemAppointment
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItemAppointment
     *            SrvcOrdItemAppointment} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItemAppointment
     *         SrvcOrdItemAppointment} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItemAppointmentCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SrvcOrdItemAppointmentCreateFluentHelper
        createSrvcOrdItemAppointment( @Nonnull final SrvcOrdItemAppointment srvcOrdItemAppointment );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItemAppointment
     * SrvcOrdItemAppointment} entity and save it to the S/4HANA system.
     *
     * @param srvcOrdItemAppointment
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItemAppointment
     *            SrvcOrdItemAppointment} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItemAppointment
     *         SrvcOrdItemAppointment} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItemAppointmentUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SrvcOrdItemAppointmentUpdateFluentHelper
        updateSrvcOrdItemAppointment( @Nonnull final SrvcOrdItemAppointment srvcOrdItemAppointment );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItemDuration
     * SrvcOrdItemDuration} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItemDuration
     *         SrvcOrdItemDuration} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItemDurationFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SrvcOrdItemDurationFluentHelper getAllSrvcOrdItemDuration();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItemDuration
     * SrvcOrdItemDuration} entity using key fields.
     *
     * @param serviceOrderItem
     *            Shortened Item Number in Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param srvcDocDurationType
     *            Name for Type of Time Duration
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     * @param serviceOrder
     *            Transaction ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItemDuration
     *         SrvcOrdItemDuration} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItemDurationByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SrvcOrdItemDurationByKeyFluentHelper getSrvcOrdItemDurationByKey(
        final String serviceOrder,
        final String serviceOrderItem,
        final String srvcDocDurationType );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItemDuration
     * SrvcOrdItemDuration} entity and save it to the S/4HANA system.
     *
     * @param srvcOrdItemDuration
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItemDuration
     *            SrvcOrdItemDuration} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItemDuration
     *         SrvcOrdItemDuration} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItemDurationCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SrvcOrdItemDurationCreateFluentHelper
        createSrvcOrdItemDuration( @Nonnull final SrvcOrdItemDuration srvcOrdItemDuration );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItemDuration
     * SrvcOrdItemDuration} entity and save it to the S/4HANA system.
     *
     * @param srvcOrdItemDuration
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItemDuration
     *            SrvcOrdItemDuration} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItemDuration
     *         SrvcOrdItemDuration} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItemDurationUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SrvcOrdItemDurationUpdateFluentHelper
        updateSrvcOrdItemDuration( @Nonnull final SrvcOrdItemDuration srvcOrdItemDuration );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItmPartner
     * SrvcOrdItmPartner} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItmPartner
     *         SrvcOrdItmPartner} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItmPartnerFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SrvcOrdItmPartnerFluentHelper getAllSrvcOrdItmPartner();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItmPartner
     * SrvcOrdItmPartner} entity using key fields.
     *
     * @param custMgmtBusinessPartner
     *            Business Partner Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param serviceOrderItem
     *            Shortened Item Number in Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param custMgmtPartnerFunction
     *
     * @param serviceOrder
     *            Transaction ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItmPartner
     *         SrvcOrdItmPartner} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItmPartnerByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SrvcOrdItmPartnerByKeyFluentHelper getSrvcOrdItmPartnerByKey(
        final String serviceOrder,
        final String serviceOrderItem,
        final String custMgmtPartnerFunction,
        final String custMgmtBusinessPartner );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItmPartner
     * SrvcOrdItmPartner} entity and save it to the S/4HANA system.
     *
     * @param srvcOrdItmPartner
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItmPartner
     *            SrvcOrdItmPartner} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItmPartner
     *         SrvcOrdItmPartner} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItmPartnerCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SrvcOrdItmPartnerCreateFluentHelper createSrvcOrdItmPartner( @Nonnull final SrvcOrdItmPartner srvcOrdItmPartner );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItmPartner
     * SrvcOrdItmPartner} entity and save it to the S/4HANA system.
     *
     * @param srvcOrdItmPartner
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItmPartner
     *            SrvcOrdItmPartner} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItmPartner
     *         SrvcOrdItmPartner} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItmPartnerUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SrvcOrdItmPartnerUpdateFluentHelper updateSrvcOrdItmPartner( @Nonnull final SrvcOrdItmPartner srvcOrdItmPartner );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItmPartner
     * SrvcOrdItmPartner} entity in the S/4HANA system.
     *
     * @param srvcOrdItmPartner
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItmPartner
     *            SrvcOrdItmPartner} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItmPartner
     *         SrvcOrdItmPartner} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItmPartnerDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SrvcOrdItmPartnerDeleteFluentHelper deleteSrvcOrdItmPartner( @Nonnull final SrvcOrdItmPartner srvcOrdItmPartner );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItmPartnerAddress
     * SrvcOrdItmPartnerAddress} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItmPartnerAddress
     *         SrvcOrdItmPartnerAddress} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItmPartnerAddressFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SrvcOrdItmPartnerAddressFluentHelper getAllSrvcOrdItmPartnerAddress();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItmPartnerAddress
     * SrvcOrdItmPartnerAddress} entity using key fields.
     *
     * @param custMgmtBusinessPartner
     *            Business Partner Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param serviceOrderItem
     *            Shortened Item Number in Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param custMgmtPartnerFunction
     *
     * @param serviceOrder
     *            Transaction ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItmPartnerAddress
     *         SrvcOrdItmPartnerAddress} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItmPartnerAddressByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SrvcOrdItmPartnerAddressByKeyFluentHelper getSrvcOrdItmPartnerAddressByKey(
        final String serviceOrder,
        final String serviceOrderItem,
        final String custMgmtPartnerFunction,
        final String custMgmtBusinessPartner );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItmPartnerAddress
     * SrvcOrdItmPartnerAddress} entity and save it to the S/4HANA system.
     *
     * @param srvcOrdItmPartnerAddress
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItmPartnerAddress
     *            SrvcOrdItmPartnerAddress} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItmPartnerAddress
     *         SrvcOrdItmPartnerAddress} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItmPartnerAddressUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SrvcOrdItmPartnerAddressUpdateFluentHelper
        updateSrvcOrdItmPartnerAddress( @Nonnull final SrvcOrdItmPartnerAddress srvcOrdItmPartnerAddress );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItmProdRefObject
     * SrvcOrdItmProdRefObject} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItmProdRefObject
     *         SrvcOrdItmProdRefObject} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItmProdRefObjectFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SrvcOrdItmProdRefObjectFluentHelper getAllSrvcOrdItmProdRefObject();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItmProdRefObject
     * SrvcOrdItmProdRefObject} entity using key fields.
     *
     * @param serviceOrderItem
     *            Shortened Item Number in Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param serviceOrder
     *            Transaction ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param serviceReferenceProduct
     *            Material Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItmProdRefObject
     *         SrvcOrdItmProdRefObject} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItmProdRefObjectByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SrvcOrdItmProdRefObjectByKeyFluentHelper getSrvcOrdItmProdRefObjectByKey(
        final String serviceOrder,
        final String serviceOrderItem,
        final String serviceReferenceProduct );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItmProdRefObject
     * SrvcOrdItmProdRefObject} entity and save it to the S/4HANA system.
     *
     * @param srvcOrdItmProdRefObject
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItmProdRefObject
     *            SrvcOrdItmProdRefObject} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItmProdRefObject
     *         SrvcOrdItmProdRefObject} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItmProdRefObjectCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SrvcOrdItmProdRefObjectCreateFluentHelper
        createSrvcOrdItmProdRefObject( @Nonnull final SrvcOrdItmProdRefObject srvcOrdItmProdRefObject );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItmProdRefObject
     * SrvcOrdItmProdRefObject} entity in the S/4HANA system.
     *
     * @param srvcOrdItmProdRefObject
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItmProdRefObject
     *            SrvcOrdItmProdRefObject} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItmProdRefObject
     *         SrvcOrdItmProdRefObject} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItmProdRefObjectDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SrvcOrdItmProdRefObjectDeleteFluentHelper
        deleteSrvcOrdItmProdRefObject( @Nonnull final SrvcOrdItmProdRefObject srvcOrdItmProdRefObject );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdPartner
     * SrvcOrdPartner} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdPartner SrvcOrdPartner}
     *         entities. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdPartnerFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SrvcOrdPartnerFluentHelper getAllSrvcOrdPartner();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdPartner
     * SrvcOrdPartner} entity using key fields.
     *
     * @param custMgmtBusinessPartner
     *            Business Partner Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param custMgmtPartnerFunction
     *
     * @param serviceOrder
     *            Transaction ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdPartner SrvcOrdPartner}
     *         entity using key fields. This fluent helper allows methods which modify the underlying query to be called
     *         before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdPartnerByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SrvcOrdPartnerByKeyFluentHelper getSrvcOrdPartnerByKey(
        final String serviceOrder,
        final String custMgmtPartnerFunction,
        final String custMgmtBusinessPartner );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdPartner
     * SrvcOrdPartner} entity and save it to the S/4HANA system.
     *
     * @param srvcOrdPartner
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdPartner SrvcOrdPartner}
     *            entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdPartner SrvcOrdPartner}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdPartnerCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SrvcOrdPartnerCreateFluentHelper createSrvcOrdPartner( @Nonnull final SrvcOrdPartner srvcOrdPartner );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdPartner
     * SrvcOrdPartner} entity and save it to the S/4HANA system.
     *
     * @param srvcOrdPartner
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdPartner SrvcOrdPartner}
     *            entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdPartner SrvcOrdPartner}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdPartnerUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SrvcOrdPartnerUpdateFluentHelper updateSrvcOrdPartner( @Nonnull final SrvcOrdPartner srvcOrdPartner );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdPartner
     * SrvcOrdPartner} entity in the S/4HANA system.
     *
     * @param srvcOrdPartner
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdPartner SrvcOrdPartner}
     *            entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdPartner SrvcOrdPartner}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdPartnerDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SrvcOrdPartnerDeleteFluentHelper deleteSrvcOrdPartner( @Nonnull final SrvcOrdPartner srvcOrdPartner );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdPartnerAddress
     * SrvcOrdPartnerAddress} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdPartnerAddress
     *         SrvcOrdPartnerAddress} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdPartnerAddressFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SrvcOrdPartnerAddressFluentHelper getAllSrvcOrdPartnerAddress();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdPartnerAddress
     * SrvcOrdPartnerAddress} entity using key fields.
     *
     * @param custMgmtBusinessPartner
     *            Business Partner Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param custMgmtPartnerFunction
     *
     * @param serviceOrder
     *            Transaction ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdPartnerAddress
     *         SrvcOrdPartnerAddress} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdPartnerAddressByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SrvcOrdPartnerAddressByKeyFluentHelper getSrvcOrdPartnerAddressByKey(
        final String serviceOrder,
        final String custMgmtPartnerFunction,
        final String custMgmtBusinessPartner );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdPartnerAddress
     * SrvcOrdPartnerAddress} entity and save it to the S/4HANA system.
     *
     * @param srvcOrdPartnerAddress
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdPartnerAddress
     *            SrvcOrdPartnerAddress} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdPartnerAddress
     *         SrvcOrdPartnerAddress} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdPartnerAddressUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SrvcOrdPartnerAddressUpdateFluentHelper
        updateSrvcOrdPartnerAddress( @Nonnull final SrvcOrdPartnerAddress srvcOrdPartnerAddress );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdProdRefObject
     * SrvcOrdProdRefObject} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdProdRefObject
     *         SrvcOrdProdRefObject} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdProdRefObjectFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SrvcOrdProdRefObjectFluentHelper getAllSrvcOrdProdRefObject();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdProdRefObject
     * SrvcOrdProdRefObject} entity using key fields.
     *
     * @param serviceOrder
     *            Transaction ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param serviceReferenceProduct
     *            Material Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdProdRefObject
     *         SrvcOrdProdRefObject} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdProdRefObjectByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SrvcOrdProdRefObjectByKeyFluentHelper
        getSrvcOrdProdRefObjectByKey( final String serviceOrder, final String serviceReferenceProduct );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdProdRefObject
     * SrvcOrdProdRefObject} entity and save it to the S/4HANA system.
     *
     * @param srvcOrdProdRefObject
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdProdRefObject
     *            SrvcOrdProdRefObject} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdProdRefObject
     *         SrvcOrdProdRefObject} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdProdRefObjectCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SrvcOrdProdRefObjectCreateFluentHelper
        createSrvcOrdProdRefObject( @Nonnull final SrvcOrdProdRefObject srvcOrdProdRefObject );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdProdRefObject
     * SrvcOrdProdRefObject} entity in the S/4HANA system.
     *
     * @param srvcOrdProdRefObject
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdProdRefObject
     *            SrvcOrdProdRefObject} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdProdRefObject
     *         SrvcOrdProdRefObject} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdProdRefObjectDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SrvcOrdProdRefObjectDeleteFluentHelper
        deleteSrvcOrdProdRefObject( @Nonnull final SrvcOrdProdRefObject srvcOrdProdRefObject );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdRefServiceContract
     * SrvcOrdRefServiceContract} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdRefServiceContract
     *         SrvcOrdRefServiceContract} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdRefServiceContractFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SrvcOrdRefServiceContractFluentHelper getAllSrvcOrdRefServiceContract();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdRefServiceContract
     * SrvcOrdRefServiceContract} entity using key fields.
     *
     * @param referenceServiceContract
     *            Transaction ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param serviceOrder
     *            Transaction ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdRefServiceContract
     *         SrvcOrdRefServiceContract} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdRefServiceContractByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SrvcOrdRefServiceContractByKeyFluentHelper
        getSrvcOrdRefServiceContractByKey( final String serviceOrder, final String referenceServiceContract );

}
