/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanItemPriceElement;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanItemPriceElementByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanItemPriceElementCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanItemPriceElementDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanItemPriceElementFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanItemPriceElementUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanItemRefObject;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanItemRefObjectByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanItemRefObjectCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanItemRefObjectDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanItemRefObjectFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanPersonResp;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanPersonRespByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanPersonRespCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanPersonRespDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanPersonRespFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanPersonRespUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanPriceElement;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanPriceElementByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanPriceElementCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanPriceElementDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanPriceElementFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanPriceElementUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanRefObject;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanRefObjectByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanRefObjectCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanRefObjectDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanRefObjectFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQuotation;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQuotationByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQuotationCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQuotationFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQuotationItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQuotationItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQuotationItemCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQuotationItemDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQuotationItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQuotationItemText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQuotationItemTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQuotationItemTextCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQuotationItemTextDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQuotationItemTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQuotationItemTextUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQuotationItemUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQuotationText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQuotationTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQuotationTextCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQuotationTextDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQuotationTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQuotationTextUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQuotationUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.batch.ServiceQuotationServiceBatch;

/**
 * <p>
 *
 * You can use this service to integrate external applications with service quotation processing in Service in SAP
 * S/4HANA Cloud. In each API call, you can use the following operations: - Retrieve service quotations. - Create
 * service quotations. Note: You must use “deep insert” requests (a header plus the following entities: header person
 * responsible, header pricing element, header reference object, header text, and item). - Create new items for existing
 * service quotations. - Create an item reference object, item pricing element, and an item text for existing service
 * quotations items. - Update the header, header person responsible, header pricing element, header text, item, item
 * pricing element, and item text of existing service quotations. - Delete the header person responsible, header
 * reference object, header pricing element, header text, item, item reference object, item pricing element, and item
 * text of existing service quotations. .
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2208.latest/EN/44/0e29eeccde42d9ab7296cfa17fbd62/frameset.htm?profile=20020833'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_SERVICE_QUOTATION_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_SERVICE_QUOTATION_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2208</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Service Quotation Integration(SAP_COM_0355), Service - Repair Quotation Integration(SAP_COM_0744)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/3D2'>Service Order Management and Monitoring(3D2)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/3XK'>In-House Repair(3XK)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Service Quotation</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated as of release 2202 (Feb 2022). Please use the
 *             odata generator to generate the VDM.
 */
@Deprecated
public interface ServiceQuotationService extends BatchService<ServiceQuotationServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_SERVICE_QUOTATION_SRV";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    ServiceQuotationService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanItemPriceElement
     * ServiceQtanItemPriceElement} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanItemPriceElement
     *         ServiceQtanItemPriceElement} entities. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanItemPriceElementFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceQtanItemPriceElementFluentHelper getAllServiceQtanItemPriceElement();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanItemPriceElement
     * ServiceQtanItemPriceElement} entity using key fields.
     *
     * @param pricingProcedureCounter
     *            Condition Counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @param serviceQuotationItem
     *            Shortened Item Number in Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param serviceQuotation
     *            Transaction ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param pricingProcedureStep
     *            Step Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanItemPriceElement
     *         ServiceQtanItemPriceElement} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanItemPriceElementByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceQtanItemPriceElementByKeyFluentHelper getServiceQtanItemPriceElementByKey(
        final String serviceQuotation,
        final String serviceQuotationItem,
        final String pricingProcedureStep,
        final String pricingProcedureCounter );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanItemPriceElement
     * ServiceQtanItemPriceElement} entity and save it to the S/4HANA system.
     *
     * @param serviceQtanItemPriceElement
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanItemPriceElement
     *            ServiceQtanItemPriceElement} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanItemPriceElement
     *         ServiceQtanItemPriceElement} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanItemPriceElementCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceQtanItemPriceElementCreateFluentHelper
        createServiceQtanItemPriceElement( @Nonnull final ServiceQtanItemPriceElement serviceQtanItemPriceElement );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanItemPriceElement
     * ServiceQtanItemPriceElement} entity and save it to the S/4HANA system.
     *
     * @param serviceQtanItemPriceElement
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanItemPriceElement
     *            ServiceQtanItemPriceElement} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanItemPriceElement
     *         ServiceQtanItemPriceElement} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanItemPriceElementUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceQtanItemPriceElementUpdateFluentHelper
        updateServiceQtanItemPriceElement( @Nonnull final ServiceQtanItemPriceElement serviceQtanItemPriceElement );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanItemPriceElement
     * ServiceQtanItemPriceElement} entity in the S/4HANA system.
     *
     * @param serviceQtanItemPriceElement
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanItemPriceElement
     *            ServiceQtanItemPriceElement} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanItemPriceElement
     *         ServiceQtanItemPriceElement} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanItemPriceElementDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceQtanItemPriceElementDeleteFluentHelper
        deleteServiceQtanItemPriceElement( @Nonnull final ServiceQtanItemPriceElement serviceQtanItemPriceElement );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanItemRefObject
     * ServiceQtanItemRefObject} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanItemRefObject
     *         ServiceQtanItemRefObject} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanItemRefObjectFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceQtanItemRefObjectFluentHelper getAllServiceQtanItemRefObject();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanItemRefObject
     * ServiceQtanItemRefObject} entity using key fields.
     *
     * @param serviceQuotationItem
     *            Shortened Item Number in Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param serviceRefFunctionalLocation
     *            Functional Location
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @param serviceReferenceEquipment
     *            Equipment Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 18
     *            </p>
     * @param serviceQuotation
     *            Transaction ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanItemRefObject
     *         ServiceQtanItemRefObject} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanItemRefObjectByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceQtanItemRefObjectByKeyFluentHelper getServiceQtanItemRefObjectByKey(
        final String serviceQuotation,
        final String serviceQuotationItem,
        final String serviceReferenceEquipment,
        final String serviceRefFunctionalLocation );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanItemRefObject
     * ServiceQtanItemRefObject} entity and save it to the S/4HANA system.
     *
     * @param serviceQtanItemRefObject
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanItemRefObject
     *            ServiceQtanItemRefObject} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanItemRefObject
     *         ServiceQtanItemRefObject} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanItemRefObjectCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceQtanItemRefObjectCreateFluentHelper
        createServiceQtanItemRefObject( @Nonnull final ServiceQtanItemRefObject serviceQtanItemRefObject );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanItemRefObject
     * ServiceQtanItemRefObject} entity in the S/4HANA system.
     *
     * @param serviceQtanItemRefObject
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanItemRefObject
     *            ServiceQtanItemRefObject} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanItemRefObject
     *         ServiceQtanItemRefObject} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanItemRefObjectDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceQtanItemRefObjectDeleteFluentHelper
        deleteServiceQtanItemRefObject( @Nonnull final ServiceQtanItemRefObject serviceQtanItemRefObject );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanPersonResp
     * ServiceQtanPersonResp} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanPersonResp
     *         ServiceQtanPersonResp} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanPersonRespFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceQtanPersonRespFluentHelper getAllServiceQtanPersonResp();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanPersonResp
     * ServiceQtanPersonResp} entity using key fields.
     *
     * @param personResponsible
     *            Business Partner Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param serviceQuotation
     *            Transaction ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanPersonResp
     *         ServiceQtanPersonResp} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanPersonRespByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceQtanPersonRespByKeyFluentHelper
        getServiceQtanPersonRespByKey( final String serviceQuotation, final String personResponsible );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanPersonResp
     * ServiceQtanPersonResp} entity and save it to the S/4HANA system.
     *
     * @param serviceQtanPersonResp
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanPersonResp
     *            ServiceQtanPersonResp} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanPersonResp
     *         ServiceQtanPersonResp} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanPersonRespCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceQtanPersonRespCreateFluentHelper
        createServiceQtanPersonResp( @Nonnull final ServiceQtanPersonResp serviceQtanPersonResp );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanPersonResp
     * ServiceQtanPersonResp} entity and save it to the S/4HANA system.
     *
     * @param serviceQtanPersonResp
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanPersonResp
     *            ServiceQtanPersonResp} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanPersonResp
     *         ServiceQtanPersonResp} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanPersonRespUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceQtanPersonRespUpdateFluentHelper
        updateServiceQtanPersonResp( @Nonnull final ServiceQtanPersonResp serviceQtanPersonResp );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanPersonResp
     * ServiceQtanPersonResp} entity in the S/4HANA system.
     *
     * @param serviceQtanPersonResp
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanPersonResp
     *            ServiceQtanPersonResp} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanPersonResp
     *         ServiceQtanPersonResp} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanPersonRespDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceQtanPersonRespDeleteFluentHelper
        deleteServiceQtanPersonResp( @Nonnull final ServiceQtanPersonResp serviceQtanPersonResp );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanPriceElement
     * ServiceQtanPriceElement} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanPriceElement
     *         ServiceQtanPriceElement} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanPriceElementFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceQtanPriceElementFluentHelper getAllServiceQtanPriceElement();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanPriceElement
     * ServiceQtanPriceElement} entity using key fields.
     *
     * @param pricingProcedureCounter
     *            Condition Counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @param serviceQuotation
     *            Transaction ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param pricingProcedureStep
     *            Step Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanPriceElement
     *         ServiceQtanPriceElement} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanPriceElementByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceQtanPriceElementByKeyFluentHelper getServiceQtanPriceElementByKey(
        final String serviceQuotation,
        final String pricingProcedureStep,
        final String pricingProcedureCounter );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanPriceElement
     * ServiceQtanPriceElement} entity and save it to the S/4HANA system.
     *
     * @param serviceQtanPriceElement
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanPriceElement
     *            ServiceQtanPriceElement} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanPriceElement
     *         ServiceQtanPriceElement} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanPriceElementCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceQtanPriceElementCreateFluentHelper
        createServiceQtanPriceElement( @Nonnull final ServiceQtanPriceElement serviceQtanPriceElement );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanPriceElement
     * ServiceQtanPriceElement} entity and save it to the S/4HANA system.
     *
     * @param serviceQtanPriceElement
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanPriceElement
     *            ServiceQtanPriceElement} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanPriceElement
     *         ServiceQtanPriceElement} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanPriceElementUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceQtanPriceElementUpdateFluentHelper
        updateServiceQtanPriceElement( @Nonnull final ServiceQtanPriceElement serviceQtanPriceElement );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanPriceElement
     * ServiceQtanPriceElement} entity in the S/4HANA system.
     *
     * @param serviceQtanPriceElement
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanPriceElement
     *            ServiceQtanPriceElement} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanPriceElement
     *         ServiceQtanPriceElement} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanPriceElementDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceQtanPriceElementDeleteFluentHelper
        deleteServiceQtanPriceElement( @Nonnull final ServiceQtanPriceElement serviceQtanPriceElement );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanRefObject
     * ServiceQtanRefObject} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanRefObject
     *         ServiceQtanRefObject} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanRefObjectFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceQtanRefObjectFluentHelper getAllServiceQtanRefObject();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanRefObject
     * ServiceQtanRefObject} entity using key fields.
     *
     * @param serviceRefFunctionalLocation
     *            Functional Location
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @param serviceReferenceEquipment
     *            Equipment Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 18
     *            </p>
     * @param serviceQuotation
     *            Transaction ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanRefObject
     *         ServiceQtanRefObject} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanRefObjectByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceQtanRefObjectByKeyFluentHelper getServiceQtanRefObjectByKey(
        final String serviceQuotation,
        final String serviceReferenceEquipment,
        final String serviceRefFunctionalLocation );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanRefObject
     * ServiceQtanRefObject} entity and save it to the S/4HANA system.
     *
     * @param serviceQtanRefObject
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanRefObject
     *            ServiceQtanRefObject} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanRefObject
     *         ServiceQtanRefObject} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanRefObjectCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceQtanRefObjectCreateFluentHelper
        createServiceQtanRefObject( @Nonnull final ServiceQtanRefObject serviceQtanRefObject );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanRefObject
     * ServiceQtanRefObject} entity in the S/4HANA system.
     *
     * @param serviceQtanRefObject
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanRefObject
     *            ServiceQtanRefObject} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanRefObject
     *         ServiceQtanRefObject} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQtanRefObjectDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceQtanRefObjectDeleteFluentHelper
        deleteServiceQtanRefObject( @Nonnull final ServiceQtanRefObject serviceQtanRefObject );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQuotation
     * ServiceQuotation} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQuotation
     *         ServiceQuotation} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQuotationFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceQuotationFluentHelper getAllServiceQuotation();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQuotation
     * ServiceQuotation} entity using key fields.
     *
     * @param serviceQuotation
     *            Transaction ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQuotation
     *         ServiceQuotation} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQuotationByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceQuotationByKeyFluentHelper getServiceQuotationByKey( final String serviceQuotation );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQuotation
     * ServiceQuotation} entity and save it to the S/4HANA system.
     *
     * @param serviceQuotation
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQuotation
     *            ServiceQuotation} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQuotation
     *         ServiceQuotation} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQuotationCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceQuotationCreateFluentHelper createServiceQuotation( @Nonnull final ServiceQuotation serviceQuotation );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQuotation
     * ServiceQuotation} entity and save it to the S/4HANA system.
     *
     * @param serviceQuotation
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQuotation
     *            ServiceQuotation} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQuotation
     *         ServiceQuotation} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQuotationUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceQuotationUpdateFluentHelper updateServiceQuotation( @Nonnull final ServiceQuotation serviceQuotation );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQuotationItem
     * ServiceQuotationItem} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQuotationItem
     *         ServiceQuotationItem} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQuotationItemFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceQuotationItemFluentHelper getAllServiceQuotationItem();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQuotationItem
     * ServiceQuotationItem} entity using key fields.
     *
     * @param serviceQuotationItem
     *            Shortened Item Number in Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param serviceQuotation
     *            Transaction ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQuotationItem
     *         ServiceQuotationItem} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQuotationItemByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceQuotationItemByKeyFluentHelper
        getServiceQuotationItemByKey( final String serviceQuotation, final String serviceQuotationItem );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQuotationItem
     * ServiceQuotationItem} entity and save it to the S/4HANA system.
     *
     * @param serviceQuotationItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQuotationItem
     *            ServiceQuotationItem} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQuotationItem
     *         ServiceQuotationItem} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQuotationItemCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceQuotationItemCreateFluentHelper
        createServiceQuotationItem( @Nonnull final ServiceQuotationItem serviceQuotationItem );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQuotationItem
     * ServiceQuotationItem} entity and save it to the S/4HANA system.
     *
     * @param serviceQuotationItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQuotationItem
     *            ServiceQuotationItem} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQuotationItem
     *         ServiceQuotationItem} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQuotationItemUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceQuotationItemUpdateFluentHelper
        updateServiceQuotationItem( @Nonnull final ServiceQuotationItem serviceQuotationItem );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQuotationItem
     * ServiceQuotationItem} entity in the S/4HANA system.
     *
     * @param serviceQuotationItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQuotationItem
     *            ServiceQuotationItem} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQuotationItem
     *         ServiceQuotationItem} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQuotationItemDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceQuotationItemDeleteFluentHelper
        deleteServiceQuotationItem( @Nonnull final ServiceQuotationItem serviceQuotationItem );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQuotationItemText
     * ServiceQuotationItemText} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQuotationItemText
     *         ServiceQuotationItemText} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQuotationItemTextFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceQuotationItemTextFluentHelper getAllServiceQuotationItemText();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQuotationItemText
     * ServiceQuotationItemText} entity using key fields.
     *
     * @param serviceQuotationItem
     *            Shortened Item Number in Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param serviceQuotation
     *            Transaction ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param longTextID
     *            Text ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQuotationItemText
     *         ServiceQuotationItemText} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQuotationItemTextByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceQuotationItemTextByKeyFluentHelper getServiceQuotationItemTextByKey(
        final String serviceQuotation,
        final String serviceQuotationItem,
        final String language,
        final String longTextID );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQuotationItemText
     * ServiceQuotationItemText} entity and save it to the S/4HANA system.
     *
     * @param serviceQuotationItemText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQuotationItemText
     *            ServiceQuotationItemText} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQuotationItemText
     *         ServiceQuotationItemText} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQuotationItemTextCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceQuotationItemTextCreateFluentHelper
        createServiceQuotationItemText( @Nonnull final ServiceQuotationItemText serviceQuotationItemText );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQuotationItemText
     * ServiceQuotationItemText} entity and save it to the S/4HANA system.
     *
     * @param serviceQuotationItemText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQuotationItemText
     *            ServiceQuotationItemText} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQuotationItemText
     *         ServiceQuotationItemText} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQuotationItemTextUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceQuotationItemTextUpdateFluentHelper
        updateServiceQuotationItemText( @Nonnull final ServiceQuotationItemText serviceQuotationItemText );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQuotationItemText
     * ServiceQuotationItemText} entity in the S/4HANA system.
     *
     * @param serviceQuotationItemText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQuotationItemText
     *            ServiceQuotationItemText} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQuotationItemText
     *         ServiceQuotationItemText} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQuotationItemTextDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceQuotationItemTextDeleteFluentHelper
        deleteServiceQuotationItemText( @Nonnull final ServiceQuotationItemText serviceQuotationItemText );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQuotationText
     * ServiceQuotationText} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQuotationText
     *         ServiceQuotationText} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQuotationTextFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceQuotationTextFluentHelper getAllServiceQuotationText();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQuotationText
     * ServiceQuotationText} entity using key fields.
     *
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param serviceQuotation
     *            Transaction ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param longTextID
     *            Text ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQuotationText
     *         ServiceQuotationText} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQuotationTextByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceQuotationTextByKeyFluentHelper
        getServiceQuotationTextByKey( final String serviceQuotation, final String language, final String longTextID );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQuotationText
     * ServiceQuotationText} entity and save it to the S/4HANA system.
     *
     * @param serviceQuotationText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQuotationText
     *            ServiceQuotationText} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQuotationText
     *         ServiceQuotationText} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQuotationTextCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceQuotationTextCreateFluentHelper
        createServiceQuotationText( @Nonnull final ServiceQuotationText serviceQuotationText );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQuotationText
     * ServiceQuotationText} entity and save it to the S/4HANA system.
     *
     * @param serviceQuotationText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQuotationText
     *            ServiceQuotationText} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQuotationText
     *         ServiceQuotationText} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQuotationTextUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceQuotationTextUpdateFluentHelper
        updateServiceQuotationText( @Nonnull final ServiceQuotationText serviceQuotationText );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQuotationText
     * ServiceQuotationText} entity in the S/4HANA system.
     *
     * @param serviceQuotationText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQuotationText
     *            ServiceQuotationText} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQuotationText
     *         ServiceQuotationText} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicequotation.ServiceQuotationTextDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceQuotationTextDeleteFluentHelper
        deleteServiceQuotationText( @Nonnull final ServiceQuotationText serviceQuotationText );

}
