/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.standardworkformulaparametergroup.StandardWorkFmlaParamGroupByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.standardworkformulaparametergroup.StandardWorkFmlaParamGroupFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.standardworkformulaparametergroup.StandardWorkFmlaParamGrpTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.standardworkformulaparametergroup.StandardWorkFmlaParamGrpTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.standardworkformulaparametergroup.StandardWorkFormulaParamTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.standardworkformulaparametergroup.StandardWorkFormulaParamTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.standardworkformulaparametergroup.batch.StandardWorkFormulaParameterGroupServiceBatch;

/**
 * <p>
 *
 * This service is based on OData V2 protocol and can be consumed in Fiori apps and on other user interfaces. It enables
 * you to read standard work formula parameter group, standard work formula parameter group text and standard work
 * formula parameter text in an API call..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/4b/ee70f8a5844765a4a30b4113935306/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/CE_API_STDWRKFMLAPARAM_GROUP_0001?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>CE_API_STDWRKFMLAPARAM_GROUP_0001</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Production Planning Integration(SAP_COM_0104)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/BJ5'> Make-to-Stock Production - Discrete Manufacturing(BJ5)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BJ8'>Make-to-Stock - Process Manufacturing Based on Process
 * Order(BJ8)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/J44'>Material Requirements Planning(J44)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/O44'>Material Requirements Planning(O44)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Work Center</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Deprecated
public interface StandardWorkFormulaParameterGroupService
    extends
    BatchService<StandardWorkFormulaParameterGroupServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_STDWRKFMLAPARAM_GROUP";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    StandardWorkFormulaParameterGroupService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.standardworkformulaparametergroup.StandardWorkFmlaParamGroup
     * StandardWorkFmlaParamGroup} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.standardworkformulaparametergroup.StandardWorkFmlaParamGroup
     *         StandardWorkFmlaParamGroup} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.standardworkformulaparametergroup.StandardWorkFmlaParamGroupFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    StandardWorkFmlaParamGroupFluentHelper getAllStandardWorkFmlaParamGroup();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.standardworkformulaparametergroup.StandardWorkFmlaParamGroup
     * StandardWorkFmlaParamGroup} entity using key fields.
     *
     * @param standardWorkFormulaParamGroup
     *            Standard Value Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.standardworkformulaparametergroup.StandardWorkFmlaParamGroup
     *         StandardWorkFmlaParamGroup} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.standardworkformulaparametergroup.StandardWorkFmlaParamGroupByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    StandardWorkFmlaParamGroupByKeyFluentHelper
        getStandardWorkFmlaParamGroupByKey( final String standardWorkFormulaParamGroup );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.standardworkformulaparametergroup.StandardWorkFmlaParamGrpText
     * StandardWorkFmlaParamGrpText} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.standardworkformulaparametergroup.StandardWorkFmlaParamGrpText
     *         StandardWorkFmlaParamGrpText} entities. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.standardworkformulaparametergroup.StandardWorkFmlaParamGrpTextFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    StandardWorkFmlaParamGrpTextFluentHelper getAllStandardWorkFmlaParamGrpText();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.standardworkformulaparametergroup.StandardWorkFmlaParamGrpText
     * StandardWorkFmlaParamGrpText} entity using key fields.
     *
     * @param standardWorkFormulaParamGroup
     *            Standard Value Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.standardworkformulaparametergroup.StandardWorkFmlaParamGrpText
     *         StandardWorkFmlaParamGrpText} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.standardworkformulaparametergroup.StandardWorkFmlaParamGrpTextByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    StandardWorkFmlaParamGrpTextByKeyFluentHelper
        getStandardWorkFmlaParamGrpTextByKey( final String standardWorkFormulaParamGroup, final String language );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.standardworkformulaparametergroup.StandardWorkFormulaParamText
     * StandardWorkFormulaParamText} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.standardworkformulaparametergroup.StandardWorkFormulaParamText
     *         StandardWorkFormulaParamText} entities. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.standardworkformulaparametergroup.StandardWorkFormulaParamTextFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    StandardWorkFormulaParamTextFluentHelper getAllStandardWorkFormulaParamText();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.standardworkformulaparametergroup.StandardWorkFormulaParamText
     * StandardWorkFormulaParamText} entity using key fields.
     *
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param standardWorkFormulaParameter
     *            Standard Work Formula Parameter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.standardworkformulaparametergroup.StandardWorkFormulaParamText
     *         StandardWorkFormulaParamText} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.standardworkformulaparametergroup.StandardWorkFormulaParamTextByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    StandardWorkFormulaParamTextByKeyFluentHelper
        getStandardWorkFormulaParamTextByKey( final String standardWorkFormulaParameter, final String language );

}
