/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.statisticalkeyfigure.StatisticalKeyFigure;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.statisticalkeyfigure.StatisticalKeyFigureByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.statisticalkeyfigure.StatisticalKeyFigureCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.statisticalkeyfigure.StatisticalKeyFigureDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.statisticalkeyfigure.StatisticalKeyFigureFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.statisticalkeyfigure.StatisticalKeyFigureText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.statisticalkeyfigure.StatisticalKeyFigureTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.statisticalkeyfigure.StatisticalKeyFigureTextCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.statisticalkeyfigure.StatisticalKeyFigureTextDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.statisticalkeyfigure.StatisticalKeyFigureTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.statisticalkeyfigure.StatisticalKeyFigureTextUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.statisticalkeyfigure.StatisticalKeyFigureUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.statisticalkeyfigure.batch.StatisticalKeyFigureServiceBatch;

/**
 * <p>
 *
 * This service is based on the OData protocol and can be consumed in Fiori apps and on other user interfaces..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/78/c9f90d79654fdc85e2f34f404a278c/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_STATISTICALKEYFIGURE_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_STATISTICALKEYFIGURE_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Finance - Statistical Key Figure Integration(SAP_COM_0130)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/J54'>Overhead Cost Accounting(J54)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Statistical Key Figure</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Deprecated
public interface StatisticalKeyFigureService extends BatchService<StatisticalKeyFigureServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_STATISTICALKEYFIGURE_SRV";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    StatisticalKeyFigureService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.statisticalkeyfigure.StatisticalKeyFigure
     * StatisticalKeyFigure} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.statisticalkeyfigure.StatisticalKeyFigure
     *         StatisticalKeyFigure} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.statisticalkeyfigure.StatisticalKeyFigureFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    StatisticalKeyFigureFluentHelper getAllStatisticalKeyFigure();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.statisticalkeyfigure.StatisticalKeyFigure
     * StatisticalKeyFigure} entity using key fields.
     *
     * @param statisticalKeyFigure
     *            Statistical Key Figure
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param controllingArea
     *            Controlling Area
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.statisticalkeyfigure.StatisticalKeyFigure
     *         StatisticalKeyFigure} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.statisticalkeyfigure.StatisticalKeyFigureByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    StatisticalKeyFigureByKeyFluentHelper
        getStatisticalKeyFigureByKey( final String statisticalKeyFigure, final String controllingArea );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.statisticalkeyfigure.StatisticalKeyFigure
     * StatisticalKeyFigure} entity and save it to the S/4HANA system.
     *
     * @param statisticalKeyFigure
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.statisticalkeyfigure.StatisticalKeyFigure
     *            StatisticalKeyFigure} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.statisticalkeyfigure.StatisticalKeyFigure
     *         StatisticalKeyFigure} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.statisticalkeyfigure.StatisticalKeyFigureCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    StatisticalKeyFigureCreateFluentHelper
        createStatisticalKeyFigure( @Nonnull final StatisticalKeyFigure statisticalKeyFigure );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.statisticalkeyfigure.StatisticalKeyFigure
     * StatisticalKeyFigure} entity and save it to the S/4HANA system.
     *
     * @param statisticalKeyFigure
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.statisticalkeyfigure.StatisticalKeyFigure
     *            StatisticalKeyFigure} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.statisticalkeyfigure.StatisticalKeyFigure
     *         StatisticalKeyFigure} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.statisticalkeyfigure.StatisticalKeyFigureUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    StatisticalKeyFigureUpdateFluentHelper
        updateStatisticalKeyFigure( @Nonnull final StatisticalKeyFigure statisticalKeyFigure );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.statisticalkeyfigure.StatisticalKeyFigure
     * StatisticalKeyFigure} entity in the S/4HANA system.
     *
     * @param statisticalKeyFigure
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.statisticalkeyfigure.StatisticalKeyFigure
     *            StatisticalKeyFigure} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.statisticalkeyfigure.StatisticalKeyFigure
     *         StatisticalKeyFigure} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.statisticalkeyfigure.StatisticalKeyFigureDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    StatisticalKeyFigureDeleteFluentHelper
        deleteStatisticalKeyFigure( @Nonnull final StatisticalKeyFigure statisticalKeyFigure );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.statisticalkeyfigure.StatisticalKeyFigureText
     * StatisticalKeyFigureText} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.statisticalkeyfigure.StatisticalKeyFigureText
     *         StatisticalKeyFigureText} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.statisticalkeyfigure.StatisticalKeyFigureTextFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    StatisticalKeyFigureTextFluentHelper getAllStatisticalKeyFigureText();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.statisticalkeyfigure.StatisticalKeyFigureText
     * StatisticalKeyFigureText} entity using key fields.
     *
     * @param statisticalKeyFigure
     *            Statistical Key Figure
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param controllingArea
     *            Controlling Area
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.statisticalkeyfigure.StatisticalKeyFigureText
     *         StatisticalKeyFigureText} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.statisticalkeyfigure.StatisticalKeyFigureTextByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    StatisticalKeyFigureTextByKeyFluentHelper getStatisticalKeyFigureTextByKey(
        final String language,
        final String controllingArea,
        final String statisticalKeyFigure );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.statisticalkeyfigure.StatisticalKeyFigureText
     * StatisticalKeyFigureText} entity and save it to the S/4HANA system.
     *
     * @param statisticalKeyFigureText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.statisticalkeyfigure.StatisticalKeyFigureText
     *            StatisticalKeyFigureText} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.statisticalkeyfigure.StatisticalKeyFigureText
     *         StatisticalKeyFigureText} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.statisticalkeyfigure.StatisticalKeyFigureTextCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    StatisticalKeyFigureTextCreateFluentHelper
        createStatisticalKeyFigureText( @Nonnull final StatisticalKeyFigureText statisticalKeyFigureText );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.statisticalkeyfigure.StatisticalKeyFigureText
     * StatisticalKeyFigureText} entity and save it to the S/4HANA system.
     *
     * @param statisticalKeyFigureText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.statisticalkeyfigure.StatisticalKeyFigureText
     *            StatisticalKeyFigureText} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.statisticalkeyfigure.StatisticalKeyFigureText
     *         StatisticalKeyFigureText} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.statisticalkeyfigure.StatisticalKeyFigureTextUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    StatisticalKeyFigureTextUpdateFluentHelper
        updateStatisticalKeyFigureText( @Nonnull final StatisticalKeyFigureText statisticalKeyFigureText );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.statisticalkeyfigure.StatisticalKeyFigureText
     * StatisticalKeyFigureText} entity in the S/4HANA system.
     *
     * @param statisticalKeyFigureText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.statisticalkeyfigure.StatisticalKeyFigureText
     *            StatisticalKeyFigureText} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.statisticalkeyfigure.StatisticalKeyFigureText
     *         StatisticalKeyFigureText} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.statisticalkeyfigure.StatisticalKeyFigureTextDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    StatisticalKeyFigureTextDeleteFluentHelper
        deleteStatisticalKeyFigureText( @Nonnull final StatisticalKeyFigureText statisticalKeyFigureText );

}
