/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.subsequentbillingdocument.SubsqntBillgDocForSelfBillgByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.subsequentbillingdocument.SubsqntBillgDocForSelfBillgFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.subsequentbillingdocument.batch.SubsequentBillingDocumentServiceBatch;

/**
 * <p>
 *
 * SAP Self-Billing Cockpit uses this service to retrieve details about billing documents in your system that were
 * created with reference to existing billing documents in your system. For example, if a credit memo was created with
 * reference to an invoice, the invoice is the preceding billing document and the credit memo is the subsequent billing
 * document. The service makes the subsequent billing document&#39;s data available through a single service entity.
 *
 * This service is intended solely for the integration between SAP S/4HANA Cloud and SAP Self-Billing Cockpit and should
 * not be used for any other purposes. .
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/b9/f5d563bc2745df9c21f1c1c6a43cdd/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_SUBSQNT_BILLG_DOC_SBI_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_SUBSQNT_BILLG_DOC_SBI_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>SAP Self-Billing Cockpit Integration(SAP_COM_0564)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/4H2'>Self-Billing(4H2)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Billing Document</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Deprecated
public interface SubsequentBillingDocumentService extends BatchService<SubsequentBillingDocumentServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_SUBSQNT_BILLG_DOC_SBI_SRV";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    SubsequentBillingDocumentService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.subsequentbillingdocument.SubsqntBillgDocForSelfBillg
     * SubsqntBillgDocForSelfBillg} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.subsequentbillingdocument.SubsqntBillgDocForSelfBillg
     *         SubsqntBillgDocForSelfBillg} entities. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.subsequentbillingdocument.SubsqntBillgDocForSelfBillgFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SubsqntBillgDocForSelfBillgFluentHelper getAllSubsqntBillgDocForSelfBillg();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.subsequentbillingdocument.SubsqntBillgDocForSelfBillg
     * SubsqntBillgDocForSelfBillg} entity using key fields.
     *
     * @param subsequentDocumentItem
     *            Subsequent Item of an SD Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param billingDocumentItem
     *            Preceding Item of an SD Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param billingDocument
     *            Billing Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param subsequentDocument
     *            Subsequent Sales and Distribution Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.subsequentbillingdocument.SubsqntBillgDocForSelfBillg
     *         SubsqntBillgDocForSelfBillg} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.subsequentbillingdocument.SubsqntBillgDocForSelfBillgByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SubsqntBillgDocForSelfBillgByKeyFluentHelper getSubsqntBillgDocForSelfBillgByKey(
        final String billingDocument,
        final String billingDocumentItem,
        final String subsequentDocument,
        final String subsequentDocumentItem );

}
