/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.util.UUID;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActyDescription;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActyDescriptionByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActyDescriptionCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActyDescriptionDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActyDescriptionFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActyDescriptionUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActyParticipant;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActyParticipantByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActyParticipantCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActyParticipantDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActyParticipantFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActyParticipantUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActyPurchaserResp;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActyPurchaserRespByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActyPurchaserRespFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActyPurchaserRespUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActySupplier;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActySupplierByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActySupplierCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActySupplierDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActySupplierFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActySupplierUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SupplierActivity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SupplierActivityByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SupplierActivityCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SupplierActivityDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SupplierActivityFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SupplierActivityUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.batch.SupplierActivityServiceBatch;

/**
 * <p>
 * This service enables you to create, read, update and delete procurement-related activities through an API call.
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/f0/decab112af49d3825253d442dbc253/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_SUPPLIER_ACTIVITY_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_SUPPLIER_ACTIVITY_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Supplier Activity Integration(SAP_COM_0137)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/19C'>Activity Management in Procurement(19C)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Supplier Activity</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Deprecated
public interface SupplierActivityService extends BatchService<SupplierActivityServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_SUPPLIER_ACTIVITY_SRV";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    SupplierActivityService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActyDescription
     * SuplrActyDescription} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActyDescription
     *         SuplrActyDescription} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActyDescriptionFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SuplrActyDescriptionFluentHelper getAllSuplrActyDescription();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActyDescription
     * SuplrActyDescription} entity using key fields.
     *
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param suplrActyUUID
     *            Activity UUID
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActyDescription
     *         SuplrActyDescription} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActyDescriptionByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SuplrActyDescriptionByKeyFluentHelper
        getSuplrActyDescriptionByKey( final UUID suplrActyUUID, final String language );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActyDescription
     * SuplrActyDescription} entity and save it to the S/4HANA system.
     *
     * @param suplrActyDescription
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActyDescription
     *            SuplrActyDescription} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActyDescription
     *         SuplrActyDescription} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActyDescriptionCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SuplrActyDescriptionCreateFluentHelper
        createSuplrActyDescription( @Nonnull final SuplrActyDescription suplrActyDescription );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActyDescription
     * SuplrActyDescription} entity and save it to the S/4HANA system.
     *
     * @param suplrActyDescription
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActyDescription
     *            SuplrActyDescription} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActyDescription
     *         SuplrActyDescription} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActyDescriptionUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SuplrActyDescriptionUpdateFluentHelper
        updateSuplrActyDescription( @Nonnull final SuplrActyDescription suplrActyDescription );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActyDescription
     * SuplrActyDescription} entity in the S/4HANA system.
     *
     * @param suplrActyDescription
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActyDescription
     *            SuplrActyDescription} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActyDescription
     *         SuplrActyDescription} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActyDescriptionDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SuplrActyDescriptionDeleteFluentHelper
        deleteSuplrActyDescription( @Nonnull final SuplrActyDescription suplrActyDescription );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActyParticipant
     * SuplrActyParticipant} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActyParticipant
     *         SuplrActyParticipant} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActyParticipantFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SuplrActyParticipantFluentHelper getAllSuplrActyParticipant();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActyParticipant
     * SuplrActyParticipant} entity using key fields.
     *
     * @param suplrActyPartyUUID
     *            Activity Party UUID
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActyParticipant
     *         SuplrActyParticipant} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActyParticipantByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SuplrActyParticipantByKeyFluentHelper getSuplrActyParticipantByKey( final UUID suplrActyPartyUUID );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActyParticipant
     * SuplrActyParticipant} entity and save it to the S/4HANA system.
     *
     * @param suplrActyParticipant
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActyParticipant
     *            SuplrActyParticipant} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActyParticipant
     *         SuplrActyParticipant} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActyParticipantCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SuplrActyParticipantCreateFluentHelper
        createSuplrActyParticipant( @Nonnull final SuplrActyParticipant suplrActyParticipant );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActyParticipant
     * SuplrActyParticipant} entity and save it to the S/4HANA system.
     *
     * @param suplrActyParticipant
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActyParticipant
     *            SuplrActyParticipant} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActyParticipant
     *         SuplrActyParticipant} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActyParticipantUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SuplrActyParticipantUpdateFluentHelper
        updateSuplrActyParticipant( @Nonnull final SuplrActyParticipant suplrActyParticipant );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActyParticipant
     * SuplrActyParticipant} entity in the S/4HANA system.
     *
     * @param suplrActyParticipant
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActyParticipant
     *            SuplrActyParticipant} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActyParticipant
     *         SuplrActyParticipant} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActyParticipantDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SuplrActyParticipantDeleteFluentHelper
        deleteSuplrActyParticipant( @Nonnull final SuplrActyParticipant suplrActyParticipant );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActyPurchaserResp
     * SuplrActyPurchaserResp} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActyPurchaserResp
     *         SuplrActyPurchaserResp} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActyPurchaserRespFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SuplrActyPurchaserRespFluentHelper getAllSuplrActyPurchaserResp();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActyPurchaserResp
     * SuplrActyPurchaserResp} entity using key fields.
     *
     * @param suplrActyPartyUUID
     *            Activity Party UUID
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActyPurchaserResp
     *         SuplrActyPurchaserResp} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActyPurchaserRespByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SuplrActyPurchaserRespByKeyFluentHelper getSuplrActyPurchaserRespByKey( final UUID suplrActyPartyUUID );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActyPurchaserResp
     * SuplrActyPurchaserResp} entity and save it to the S/4HANA system.
     *
     * @param suplrActyPurchaserResp
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActyPurchaserResp
     *            SuplrActyPurchaserResp} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActyPurchaserResp
     *         SuplrActyPurchaserResp} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActyPurchaserRespUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SuplrActyPurchaserRespUpdateFluentHelper
        updateSuplrActyPurchaserResp( @Nonnull final SuplrActyPurchaserResp suplrActyPurchaserResp );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActySupplier
     * SuplrActySupplier} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActySupplier
     *         SuplrActySupplier} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActySupplierFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SuplrActySupplierFluentHelper getAllSuplrActySupplier();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActySupplier
     * SuplrActySupplier} entity using key fields.
     *
     * @param suplrActyPartyUUID
     *            Activity Party UUID
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActySupplier
     *         SuplrActySupplier} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActySupplierByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SuplrActySupplierByKeyFluentHelper getSuplrActySupplierByKey( final UUID suplrActyPartyUUID );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActySupplier
     * SuplrActySupplier} entity and save it to the S/4HANA system.
     *
     * @param suplrActySupplier
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActySupplier
     *            SuplrActySupplier} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActySupplier
     *         SuplrActySupplier} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActySupplierCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SuplrActySupplierCreateFluentHelper createSuplrActySupplier( @Nonnull final SuplrActySupplier suplrActySupplier );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActySupplier
     * SuplrActySupplier} entity and save it to the S/4HANA system.
     *
     * @param suplrActySupplier
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActySupplier
     *            SuplrActySupplier} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActySupplier
     *         SuplrActySupplier} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActySupplierUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SuplrActySupplierUpdateFluentHelper updateSuplrActySupplier( @Nonnull final SuplrActySupplier suplrActySupplier );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActySupplier
     * SuplrActySupplier} entity in the S/4HANA system.
     *
     * @param suplrActySupplier
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActySupplier
     *            SuplrActySupplier} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActySupplier
     *         SuplrActySupplier} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SuplrActySupplierDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SuplrActySupplierDeleteFluentHelper deleteSuplrActySupplier( @Nonnull final SuplrActySupplier suplrActySupplier );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SupplierActivity
     * SupplierActivity} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SupplierActivity
     *         SupplierActivity} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SupplierActivityFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SupplierActivityFluentHelper getAllSupplierActivity();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SupplierActivity
     * SupplierActivity} entity using key fields.
     *
     * @param suplrActyUUID
     *            Activity UUID
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SupplierActivity
     *         SupplierActivity} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SupplierActivityByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SupplierActivityByKeyFluentHelper getSupplierActivityByKey( final UUID suplrActyUUID );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SupplierActivity
     * SupplierActivity} entity and save it to the S/4HANA system.
     *
     * @param supplierActivity
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SupplierActivity
     *            SupplierActivity} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SupplierActivity
     *         SupplierActivity} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SupplierActivityCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SupplierActivityCreateFluentHelper createSupplierActivity( @Nonnull final SupplierActivity supplierActivity );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SupplierActivity
     * SupplierActivity} entity and save it to the S/4HANA system.
     *
     * @param supplierActivity
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SupplierActivity
     *            SupplierActivity} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SupplierActivity
     *         SupplierActivity} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SupplierActivityUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SupplierActivityUpdateFluentHelper updateSupplierActivity( @Nonnull final SupplierActivity supplierActivity );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SupplierActivity
     * SupplierActivity} entity in the S/4HANA system.
     *
     * @param supplierActivity
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SupplierActivity
     *            SupplierActivity} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SupplierActivity
     *         SupplierActivity} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivity.SupplierActivityDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SupplierActivityDeleteFluentHelper deleteSupplierActivity( @Nonnull final SupplierActivity supplierActivity );

}
