/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.util.UUID;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.CompleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.RequestClarificationFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.SendFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.SubmitFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.SuplrActyTskActyReferenceByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.SuplrActyTskActyReferenceFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.SuplrActyTskCommTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.SuplrActyTskCommTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.SuplrActyTskDescriptionByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.SuplrActyTskDescriptionFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.SuplrActyTskMessageTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.SuplrActyTskMessageTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.SuplrActyTskProcessorByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.SuplrActyTskProcessorFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.SuplrActyTskPurchaserRespByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.SuplrActyTskPurchaserRespFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.SuplrActyTskSupplierByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.SuplrActyTskSupplierFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.SupplierActivityTaskByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.SupplierActivityTaskFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.batch.SupplierActivityTaskServiceBatch;

/**
 * <p>
 * This service enables you to create, update and delete procurement-related tasks through an API call.
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/95/e05385472d444e8ae8a830459d6986/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_SUPPLIER_ACTIVITY_TASK_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_SUPPLIER_ACTIVITY_TASK_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Supplier Activity Task Integration(SAP_COM_0138)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/19C'>Activity Management in Procurement(19C)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Supplier Activity</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Deprecated
public interface SupplierActivityTaskService extends BatchService<SupplierActivityTaskServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_SUPPLIER_ACTIVITY_TASK_SRV";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    SupplierActivityTaskService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.SuplrActyTskActyReference
     * SuplrActyTskActyReference} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.SuplrActyTskActyReference
     *         SuplrActyTskActyReference} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.SuplrActyTskActyReferenceFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SuplrActyTskActyReferenceFluentHelper getAllSuplrActyTskActyReference();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.SuplrActyTskActyReference
     * SuplrActyTskActyReference} entity using key fields.
     *
     * @param suplrActyTaskReferenceUUID
     *            Task ReferenceUUID
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.SuplrActyTskActyReference
     *         SuplrActyTskActyReference} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.SuplrActyTskActyReferenceByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SuplrActyTskActyReferenceByKeyFluentHelper
        getSuplrActyTskActyReferenceByKey( final UUID suplrActyTaskReferenceUUID );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.SuplrActyTskCommText
     * SuplrActyTskCommText} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.SuplrActyTskCommText
     *         SuplrActyTskCommText} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.SuplrActyTskCommTextFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SuplrActyTskCommTextFluentHelper getAllSuplrActyTskCommText();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.SuplrActyTskCommText
     * SuplrActyTskCommText} entity using key fields.
     *
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param suplrActyTaskUUID
     *            Task UUID
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.SuplrActyTskCommText
     *         SuplrActyTskCommText} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.SuplrActyTskCommTextByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SuplrActyTskCommTextByKeyFluentHelper
        getSuplrActyTskCommTextByKey( final UUID suplrActyTaskUUID, final String language );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.SuplrActyTskDescription
     * SuplrActyTskDescription} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.SuplrActyTskDescription
     *         SuplrActyTskDescription} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.SuplrActyTskDescriptionFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SuplrActyTskDescriptionFluentHelper getAllSuplrActyTskDescription();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.SuplrActyTskDescription
     * SuplrActyTskDescription} entity using key fields.
     *
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param suplrActyTaskUUID
     *            Task UUID
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.SuplrActyTskDescription
     *         SuplrActyTskDescription} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.SuplrActyTskDescriptionByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SuplrActyTskDescriptionByKeyFluentHelper
        getSuplrActyTskDescriptionByKey( final UUID suplrActyTaskUUID, final String language );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.SuplrActyTskMessageText
     * SuplrActyTskMessageText} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.SuplrActyTskMessageText
     *         SuplrActyTskMessageText} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.SuplrActyTskMessageTextFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SuplrActyTskMessageTextFluentHelper getAllSuplrActyTskMessageText();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.SuplrActyTskMessageText
     * SuplrActyTskMessageText} entity using key fields.
     *
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param suplrActyTaskUUID
     *            Task UUID
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.SuplrActyTskMessageText
     *         SuplrActyTskMessageText} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.SuplrActyTskMessageTextByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SuplrActyTskMessageTextByKeyFluentHelper
        getSuplrActyTskMessageTextByKey( final UUID suplrActyTaskUUID, final String language );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.SuplrActyTskProcessor
     * SuplrActyTskProcessor} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.SuplrActyTskProcessor
     *         SuplrActyTskProcessor} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.SuplrActyTskProcessorFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SuplrActyTskProcessorFluentHelper getAllSuplrActyTskProcessor();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.SuplrActyTskProcessor
     * SuplrActyTskProcessor} entity using key fields.
     *
     * @param suplrActyTaskPartyUUID
     *            Task Party UUID
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.SuplrActyTskProcessor
     *         SuplrActyTskProcessor} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.SuplrActyTskProcessorByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SuplrActyTskProcessorByKeyFluentHelper getSuplrActyTskProcessorByKey( final UUID suplrActyTaskPartyUUID );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.SuplrActyTskPurchaserResp
     * SuplrActyTskPurchaserResp} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.SuplrActyTskPurchaserResp
     *         SuplrActyTskPurchaserResp} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.SuplrActyTskPurchaserRespFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SuplrActyTskPurchaserRespFluentHelper getAllSuplrActyTskPurchaserResp();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.SuplrActyTskPurchaserResp
     * SuplrActyTskPurchaserResp} entity using key fields.
     *
     * @param suplrActyTaskPartyUUID
     *            Task Party UUID
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.SuplrActyTskPurchaserResp
     *         SuplrActyTskPurchaserResp} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.SuplrActyTskPurchaserRespByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SuplrActyTskPurchaserRespByKeyFluentHelper getSuplrActyTskPurchaserRespByKey( final UUID suplrActyTaskPartyUUID );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.SuplrActyTskSupplier
     * SuplrActyTskSupplier} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.SuplrActyTskSupplier
     *         SuplrActyTskSupplier} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.SuplrActyTskSupplierFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SuplrActyTskSupplierFluentHelper getAllSuplrActyTskSupplier();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.SuplrActyTskSupplier
     * SuplrActyTskSupplier} entity using key fields.
     *
     * @param suplrActyTaskPartyUUID
     *            Task Party UUID
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.SuplrActyTskSupplier
     *         SuplrActyTskSupplier} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.SuplrActyTskSupplierByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SuplrActyTskSupplierByKeyFluentHelper getSuplrActyTskSupplierByKey( final UUID suplrActyTaskPartyUUID );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.SupplierActivityTask
     * SupplierActivityTask} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.SupplierActivityTask
     *         SupplierActivityTask} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.SupplierActivityTaskFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SupplierActivityTaskFluentHelper getAllSupplierActivityTask();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.SupplierActivityTask
     * SupplierActivityTask} entity using key fields.
     *
     * @param suplrActyTaskUUID
     *            Task UUID
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.SupplierActivityTask
     *         SupplierActivityTask} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.SupplierActivityTaskByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SupplierActivityTaskByKeyFluentHelper getSupplierActivityTaskByKey( final UUID suplrActyTaskUUID );

    /**
     * <p>
     * Creates a fluent helper for the <b>Send</b> OData function import.
     * </p>
     *
     * @param suplrActyTaskUUID
     *            UUID
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: none
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>SuplrActyTaskUUID</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>Send</b> OData function import with the provided
     *         parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.SendFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SendFluentHelper send( @Nonnull final UUID suplrActyTaskUUID );

    /**
     * <p>
     * Creates a fluent helper for the <b>Submit</b> OData function import.
     * </p>
     *
     * @param suplrActyTaskUUID
     *            UUID
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: none
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>SuplrActyTaskUUID</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>Submit</b> OData function import with the provided
     *         parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.SubmitFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SubmitFluentHelper submit( @Nonnull final UUID suplrActyTaskUUID );

    /**
     * <p>
     * Creates a fluent helper for the <b>Complete</b> OData function import.
     * </p>
     *
     * @param suplrActyTaskUUID
     *            UUID
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: none
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>SuplrActyTaskUUID</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>Complete</b> OData function import with the provided
     *         parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.CompleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CompleteFluentHelper complete( @Nonnull final UUID suplrActyTaskUUID );

    /**
     * <p>
     * Creates a fluent helper for the <b>RequestClarification</b> OData function import.
     * </p>
     *
     * @param suplrActyTaskUUID
     *            UUID
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: none
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>SuplrActyTaskUUID</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>RequestClarification</b> OData function import with the
     *         provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplieractivitytask.RequestClarificationFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    RequestClarificationFluentHelper requestClarification( @Nonnull final UUID suplrActyTaskUUID );

}
