/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.util.UUID;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspAppraiserByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspAppraiserFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspExplTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspExplTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspExternalNameByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspExternalNameFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspIntroductionByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspIntroductionFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspLanguageByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspLanguageFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspPurchaserRespByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspPurchaserRespFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspQuestionByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspQuestionFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspQuestionTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspQuestionTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspRootQnaireByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspRootQnaireFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspSectionByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspSectionFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspSectionTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspSectionTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspStrucQnaireByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspStrucQnaireFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspSupplierByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspSupplierFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SupplierEvaluationResponseByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SupplierEvaluationResponseFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.batch.SupplierEvaluationResponseServiceBatch;

/**
 * <p>
 * This service enables you to read supplier evaluation responses through an API call.
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/c3/ae159f9d0d4ce89c03e433212be4bf/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_SUPLR_EVAL_RESPONSE_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_SUPLR_EVAL_RESPONSE_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Supplier Evaluation Response Integration(SAP_COM_0139)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/SL4'>Supplier Evaluation and Performance Monitoring(SL4)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Supplier Evaluation Response</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Deprecated
public interface SupplierEvaluationResponseService extends BatchService<SupplierEvaluationResponseServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_SUPLR_EVAL_RESPONSE_SRV";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    SupplierEvaluationResponseService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspAppraiser
     * SuplrEvalRspAppraiser} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspAppraiser
     *         SuplrEvalRspAppraiser} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspAppraiserFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SuplrEvalRspAppraiserFluentHelper getAllSuplrEvalRspAppraiser();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspAppraiser
     * SuplrEvalRspAppraiser} entity using key fields.
     *
     * @param suplrEvalRspPartyUUID
     *            Evaluation Response Party UUID
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspAppraiser
     *         SuplrEvalRspAppraiser} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspAppraiserByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SuplrEvalRspAppraiserByKeyFluentHelper getSuplrEvalRspAppraiserByKey( final UUID suplrEvalRspPartyUUID );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspExplText
     * SuplrEvalRspExplText} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspExplText
     *         SuplrEvalRspExplText} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspExplTextFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SuplrEvalRspExplTextFluentHelper getAllSuplrEvalRspExplText();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspExplText
     * SuplrEvalRspExplText} entity using key fields.
     *
     * @param suplrEvalReqUUID
     *            Evaluation Request UUID
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspExplText
     *         SuplrEvalRspExplText} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspExplTextByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SuplrEvalRspExplTextByKeyFluentHelper
        getSuplrEvalRspExplTextByKey( final UUID suplrEvalReqUUID, final String language );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspExternalName
     * SuplrEvalRspExternalName} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspExternalName
     *         SuplrEvalRspExternalName} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspExternalNameFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SuplrEvalRspExternalNameFluentHelper getAllSuplrEvalRspExternalName();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspExternalName
     * SuplrEvalRspExternalName} entity using key fields.
     *
     * @param suplrEvalRspUUID
     *            Evaluation Response UUID
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @param language
     *            Language
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspExternalName
     *         SuplrEvalRspExternalName} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspExternalNameByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SuplrEvalRspExternalNameByKeyFluentHelper
        getSuplrEvalRspExternalNameByKey( final UUID suplrEvalRspUUID, final String language );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspIntroduction
     * SuplrEvalRspIntroduction} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspIntroduction
     *         SuplrEvalRspIntroduction} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspIntroductionFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SuplrEvalRspIntroductionFluentHelper getAllSuplrEvalRspIntroduction();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspIntroduction
     * SuplrEvalRspIntroduction} entity using key fields.
     *
     * @param suplrEvalReqUUID
     *            Evaluation Request UUID
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspIntroduction
     *         SuplrEvalRspIntroduction} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspIntroductionByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SuplrEvalRspIntroductionByKeyFluentHelper
        getSuplrEvalRspIntroductionByKey( final UUID suplrEvalReqUUID, final String language );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspLanguage
     * SuplrEvalRspLanguage} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspLanguage
     *         SuplrEvalRspLanguage} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspLanguageFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SuplrEvalRspLanguageFluentHelper getAllSuplrEvalRspLanguage();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspLanguage
     * SuplrEvalRspLanguage} entity using key fields.
     *
     * @param suplrEvalRspLanguageUUID
     *            Evaluation Response Language UUID
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspLanguage
     *         SuplrEvalRspLanguage} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspLanguageByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SuplrEvalRspLanguageByKeyFluentHelper getSuplrEvalRspLanguageByKey( final UUID suplrEvalRspLanguageUUID );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspPurchaserResp
     * SuplrEvalRspPurchaserResp} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspPurchaserResp
     *         SuplrEvalRspPurchaserResp} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspPurchaserRespFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SuplrEvalRspPurchaserRespFluentHelper getAllSuplrEvalRspPurchaserResp();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspPurchaserResp
     * SuplrEvalRspPurchaserResp} entity using key fields.
     *
     * @param suplrEvalRspPartyUUID
     *            Evaluation Response Party UUID
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspPurchaserResp
     *         SuplrEvalRspPurchaserResp} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspPurchaserRespByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SuplrEvalRspPurchaserRespByKeyFluentHelper getSuplrEvalRspPurchaserRespByKey( final UUID suplrEvalRspPartyUUID );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspQuestion
     * SuplrEvalRspQuestion} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspQuestion
     *         SuplrEvalRspQuestion} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspQuestionFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SuplrEvalRspQuestionFluentHelper getAllSuplrEvalRspQuestion();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspQuestion
     * SuplrEvalRspQuestion} entity using key fields.
     *
     * @param suplrEvalRspQuestionUUID
     *            Evaluation Response Question UUID
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspQuestion
     *         SuplrEvalRspQuestion} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspQuestionByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SuplrEvalRspQuestionByKeyFluentHelper getSuplrEvalRspQuestionByKey( final UUID suplrEvalRspQuestionUUID );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspQuestionText
     * SuplrEvalRspQuestionText} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspQuestionText
     *         SuplrEvalRspQuestionText} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspQuestionTextFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SuplrEvalRspQuestionTextFluentHelper getAllSuplrEvalRspQuestionText();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspQuestionText
     * SuplrEvalRspQuestionText} entity using key fields.
     *
     * @param suplrEvalReqUUID
     *            Evaluation Request UUID
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspQuestionText
     *         SuplrEvalRspQuestionText} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspQuestionTextByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SuplrEvalRspQuestionTextByKeyFluentHelper
        getSuplrEvalRspQuestionTextByKey( final UUID suplrEvalReqUUID, final String language );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspRootQnaire
     * SuplrEvalRspRootQnaire} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspRootQnaire
     *         SuplrEvalRspRootQnaire} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspRootQnaireFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SuplrEvalRspRootQnaireFluentHelper getAllSuplrEvalRspRootQnaire();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspRootQnaire
     * SuplrEvalRspRootQnaire} entity using key fields.
     *
     * @param suplrEvalRspQuestionnaireUUID
     *            Evaluation Response Questionnaire UUID
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspRootQnaire
     *         SuplrEvalRspRootQnaire} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspRootQnaireByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SuplrEvalRspRootQnaireByKeyFluentHelper getSuplrEvalRspRootQnaireByKey( final UUID suplrEvalRspQuestionnaireUUID );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspSection
     * SuplrEvalRspSection} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspSection
     *         SuplrEvalRspSection} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspSectionFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SuplrEvalRspSectionFluentHelper getAllSuplrEvalRspSection();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspSection
     * SuplrEvalRspSection} entity using key fields.
     *
     * @param suplrEvalRspSectionUUID
     *            Evaluation Response Section UUID
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspSection
     *         SuplrEvalRspSection} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspSectionByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SuplrEvalRspSectionByKeyFluentHelper getSuplrEvalRspSectionByKey( final UUID suplrEvalRspSectionUUID );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspSectionText
     * SuplrEvalRspSectionText} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspSectionText
     *         SuplrEvalRspSectionText} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspSectionTextFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SuplrEvalRspSectionTextFluentHelper getAllSuplrEvalRspSectionText();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspSectionText
     * SuplrEvalRspSectionText} entity using key fields.
     *
     * @param suplrEvalReqUUID
     *            Evaluation Request UUID
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspSectionText
     *         SuplrEvalRspSectionText} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspSectionTextByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SuplrEvalRspSectionTextByKeyFluentHelper
        getSuplrEvalRspSectionTextByKey( final UUID suplrEvalReqUUID, final String language );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspStrucQnaire
     * SuplrEvalRspStrucQnaire} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspStrucQnaire
     *         SuplrEvalRspStrucQnaire} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspStrucQnaireFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SuplrEvalRspStrucQnaireFluentHelper getAllSuplrEvalRspStrucQnaire();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspStrucQnaire
     * SuplrEvalRspStrucQnaire} entity using key fields.
     *
     * @param suplrEvalRspQuestionnaireUUID
     *            Evaluation Response Questionnaire UUID
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspStrucQnaire
     *         SuplrEvalRspStrucQnaire} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspStrucQnaireByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SuplrEvalRspStrucQnaireByKeyFluentHelper
        getSuplrEvalRspStrucQnaireByKey( final UUID suplrEvalRspQuestionnaireUUID );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspSupplier
     * SuplrEvalRspSupplier} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspSupplier
     *         SuplrEvalRspSupplier} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspSupplierFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SuplrEvalRspSupplierFluentHelper getAllSuplrEvalRspSupplier();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspSupplier
     * SuplrEvalRspSupplier} entity using key fields.
     *
     * @param suplrEvalRspPartyUUID
     *            Evaluation Response Party UUID
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspSupplier
     *         SuplrEvalRspSupplier} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SuplrEvalRspSupplierByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SuplrEvalRspSupplierByKeyFluentHelper getSuplrEvalRspSupplierByKey( final UUID suplrEvalRspPartyUUID );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SupplierEvaluationResponse
     * SupplierEvaluationResponse} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SupplierEvaluationResponse
     *         SupplierEvaluationResponse} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SupplierEvaluationResponseFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SupplierEvaluationResponseFluentHelper getAllSupplierEvaluationResponse();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SupplierEvaluationResponse
     * SupplierEvaluationResponse} entity using key fields.
     *
     * @param suplrEvalRspUUID
     *            Evaluation Response UUID
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SupplierEvaluationResponse
     *         SupplierEvaluationResponse} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationresponse.SupplierEvaluationResponseByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SupplierEvaluationResponseByKeyFluentHelper getSupplierEvaluationResponseByKey( final UUID suplrEvalRspUUID );

}
