/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.util.UUID;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SAP__Currency;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SAP__CurrencyByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SAP__CurrencyCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SAP__CurrencyDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SAP__CurrencyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SAP__CurrencyUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SAP__DocumentDescription;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SAP__DocumentDescriptionByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SAP__DocumentDescriptionCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SAP__DocumentDescriptionDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SAP__DocumentDescriptionFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SAP__DocumentDescriptionUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SAP__UnitOfMeasure;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SAP__UnitOfMeasureByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SAP__UnitOfMeasureCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SAP__UnitOfMeasureDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SAP__UnitOfMeasureFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SAP__UnitOfMeasureUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SAP__ValueHelp;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SAP__ValueHelpByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SAP__ValueHelpCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SAP__ValueHelpDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SAP__ValueHelpFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SAP__ValueHelpUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SupplierOplScoresAVParametersByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.batch.SupplierEvaluationScoreServiceBatch;

/**
 * <p>
 *
 * This service enables consumers to read operational supplier evaluation scores from the SAP S/4HANA Cloud system.
 * These scores are calculated in the SAP S/4HANA Cloud system by time, by quantity, by price, and by quality. This
 * service is based on the OData protocol, and can be consumed by apps and other interfaces. .
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/a8/7d292f30b04d47bc5e29cabbff1a57/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/A_SUPPLIEROPLSCORESAV_CDS?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>A_SUPPLIEROPLSCORESAV_CDS</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Procurement - Operational Supplier Evaluation Score Integration(SAP_COM_0324)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/SL4'>Supplier Evaluation and Performance Monitoring(SL4)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Supplier Evaluation Score</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Deprecated
public interface SupplierEvaluationScoreService extends BatchService<SupplierEvaluationScoreServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/A_SUPPLIEROPLSCORESAV_CDS";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    SupplierEvaluationScoreService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SAP__Currency
     * SAP__Currency} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SAP__Currency
     *         SAP__Currency} entities. This fluent helper allows methods which modify the underlying query to be called
     *         before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SAP__CurrencyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SAP__CurrencyFluentHelper getAllSAP__Currency();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SAP__Currency
     * SAP__Currency} entity using key fields.
     *
     * @param currencyCode
     *            Currency
     *            <p>
     *            Constraints: Not nullable, Maximum length: 5
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SAP__Currency
     *         SAP__Currency} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SAP__CurrencyByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SAP__CurrencyByKeyFluentHelper getSAP__CurrencyByKey( final String currencyCode );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SAP__Currency
     * SAP__Currency} entity and save it to the S/4HANA system.
     *
     * @param sAP__Currency
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SAP__Currency
     *            SAP__Currency} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SAP__Currency
     *         SAP__Currency} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SAP__CurrencyCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SAP__CurrencyCreateFluentHelper createSAP__Currency( @Nonnull final SAP__Currency sAP__Currency );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SAP__Currency SAP__Currency}
     * entity and save it to the S/4HANA system.
     *
     * @param sAP__Currency
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SAP__Currency
     *            SAP__Currency} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SAP__Currency
     *         SAP__Currency} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SAP__CurrencyUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SAP__CurrencyUpdateFluentHelper updateSAP__Currency( @Nonnull final SAP__Currency sAP__Currency );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SAP__Currency SAP__Currency}
     * entity in the S/4HANA system.
     *
     * @param sAP__Currency
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SAP__Currency
     *            SAP__Currency} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SAP__Currency
     *         SAP__Currency} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SAP__CurrencyDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SAP__CurrencyDeleteFluentHelper deleteSAP__Currency( @Nonnull final SAP__Currency sAP__Currency );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SAP__UnitOfMeasure
     * SAP__UnitOfMeasure} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SAP__UnitOfMeasure
     *         SAP__UnitOfMeasure} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SAP__UnitOfMeasureFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SAP__UnitOfMeasureFluentHelper getAllSAP__UnitOfMeasure();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SAP__UnitOfMeasure
     * SAP__UnitOfMeasure} entity using key fields.
     *
     * @param unitCode
     *            Internal UoM
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SAP__UnitOfMeasure
     *         SAP__UnitOfMeasure} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SAP__UnitOfMeasureByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SAP__UnitOfMeasureByKeyFluentHelper getSAP__UnitOfMeasureByKey( final String unitCode );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SAP__UnitOfMeasure
     * SAP__UnitOfMeasure} entity and save it to the S/4HANA system.
     *
     * @param sAP__UnitOfMeasure
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SAP__UnitOfMeasure
     *            SAP__UnitOfMeasure} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SAP__UnitOfMeasure
     *         SAP__UnitOfMeasure} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SAP__UnitOfMeasureCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SAP__UnitOfMeasureCreateFluentHelper
        createSAP__UnitOfMeasure( @Nonnull final SAP__UnitOfMeasure sAP__UnitOfMeasure );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SAP__UnitOfMeasure
     * SAP__UnitOfMeasure} entity and save it to the S/4HANA system.
     *
     * @param sAP__UnitOfMeasure
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SAP__UnitOfMeasure
     *            SAP__UnitOfMeasure} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SAP__UnitOfMeasure
     *         SAP__UnitOfMeasure} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SAP__UnitOfMeasureUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SAP__UnitOfMeasureUpdateFluentHelper
        updateSAP__UnitOfMeasure( @Nonnull final SAP__UnitOfMeasure sAP__UnitOfMeasure );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SAP__UnitOfMeasure
     * SAP__UnitOfMeasure} entity in the S/4HANA system.
     *
     * @param sAP__UnitOfMeasure
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SAP__UnitOfMeasure
     *            SAP__UnitOfMeasure} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SAP__UnitOfMeasure
     *         SAP__UnitOfMeasure} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SAP__UnitOfMeasureDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SAP__UnitOfMeasureDeleteFluentHelper
        deleteSAP__UnitOfMeasure( @Nonnull final SAP__UnitOfMeasure sAP__UnitOfMeasure );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SAP__DocumentDescription
     * SAP__DocumentDescription} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SAP__DocumentDescription
     *         SAP__DocumentDescription} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SAP__DocumentDescriptionFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SAP__DocumentDescriptionFluentHelper getAllSAP__DocumentDescription();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SAP__DocumentDescription
     * SAP__DocumentDescription} entity using key fields.
     *
     * @param id
     *            UUID
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SAP__DocumentDescription
     *         SAP__DocumentDescription} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SAP__DocumentDescriptionByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SAP__DocumentDescriptionByKeyFluentHelper getSAP__DocumentDescriptionByKey( final UUID id );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SAP__DocumentDescription
     * SAP__DocumentDescription} entity and save it to the S/4HANA system.
     *
     * @param sAP__DocumentDescription
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SAP__DocumentDescription
     *            SAP__DocumentDescription} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SAP__DocumentDescription
     *         SAP__DocumentDescription} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SAP__DocumentDescriptionCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SAP__DocumentDescriptionCreateFluentHelper
        createSAP__DocumentDescription( @Nonnull final SAP__DocumentDescription sAP__DocumentDescription );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SAP__DocumentDescription
     * SAP__DocumentDescription} entity and save it to the S/4HANA system.
     *
     * @param sAP__DocumentDescription
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SAP__DocumentDescription
     *            SAP__DocumentDescription} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SAP__DocumentDescription
     *         SAP__DocumentDescription} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SAP__DocumentDescriptionUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SAP__DocumentDescriptionUpdateFluentHelper
        updateSAP__DocumentDescription( @Nonnull final SAP__DocumentDescription sAP__DocumentDescription );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SAP__DocumentDescription
     * SAP__DocumentDescription} entity in the S/4HANA system.
     *
     * @param sAP__DocumentDescription
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SAP__DocumentDescription
     *            SAP__DocumentDescription} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SAP__DocumentDescription
     *         SAP__DocumentDescription} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SAP__DocumentDescriptionDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SAP__DocumentDescriptionDeleteFluentHelper
        deleteSAP__DocumentDescription( @Nonnull final SAP__DocumentDescription sAP__DocumentDescription );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SAP__ValueHelp
     * SAP__ValueHelp} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SAP__ValueHelp
     *         SAP__ValueHelp} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SAP__ValueHelpFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SAP__ValueHelpFluentHelper getAllSAP__ValueHelp();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SAP__ValueHelp
     * SAP__ValueHelp} entity using key fields.
     *
     * @param vALUEHELP
     *
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SAP__ValueHelp
     *         SAP__ValueHelp} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SAP__ValueHelpByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SAP__ValueHelpByKeyFluentHelper getSAP__ValueHelpByKey( final String vALUEHELP );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SAP__ValueHelp
     * SAP__ValueHelp} entity and save it to the S/4HANA system.
     *
     * @param sAP__ValueHelp
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SAP__ValueHelp
     *            SAP__ValueHelp} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SAP__ValueHelp
     *         SAP__ValueHelp} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SAP__ValueHelpCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SAP__ValueHelpCreateFluentHelper createSAP__ValueHelp( @Nonnull final SAP__ValueHelp sAP__ValueHelp );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SAP__ValueHelp SAP__ValueHelp}
     * entity and save it to the S/4HANA system.
     *
     * @param sAP__ValueHelp
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SAP__ValueHelp
     *            SAP__ValueHelp} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SAP__ValueHelp
     *         SAP__ValueHelp} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SAP__ValueHelpUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SAP__ValueHelpUpdateFluentHelper updateSAP__ValueHelp( @Nonnull final SAP__ValueHelp sAP__ValueHelp );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SAP__ValueHelp SAP__ValueHelp}
     * entity in the S/4HANA system.
     *
     * @param sAP__ValueHelp
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SAP__ValueHelp
     *            SAP__ValueHelp} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SAP__ValueHelp
     *         SAP__ValueHelp} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SAP__ValueHelpDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SAP__ValueHelpDeleteFluentHelper deleteSAP__ValueHelp( @Nonnull final SAP__ValueHelp sAP__ValueHelp );

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SupplierOplScoresAVParameters
     * SupplierOplScoresAVParameters} entity using key fields.
     *
     * @param p_DisplayCurrency
     *            Display Currency
     *            <p>
     *            Constraints: Not nullable, Default value: EUR, Maximum length: 5
     *            </p>
     * @param p_DateFunction
     *            Relative Date Function
     *            <p>
     *            Constraints: Not nullable, Default value: YEARTODATE, Maximum length: 32
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SupplierOplScoresAVParameters
     *         SupplierOplScoresAVParameters} entity using key fields. This fluent helper allows methods which modify
     *         the underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscore.SupplierOplScoresAVParametersByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SupplierOplScoresAVParametersByKeyFluentHelper
        getSupplierOplScoresAVParametersByKey( final String p_DisplayCurrency, final String p_DateFunction );

}
