/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.util.UUID;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.SuplrEvalSccrdPurchaserRespByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.SuplrEvalSccrdPurchaserRespFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.SuplrEvalSccrdQuestionByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.SuplrEvalSccrdQuestionFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.SuplrEvalSccrdSectionByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.SuplrEvalSccrdSectionFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.SuplrEvalSccrdStrucQnaireByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.SuplrEvalSccrdStrucQnaireFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.SuplrEvalSccrdSupplierByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.SuplrEvalSccrdSupplierFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.SuplrEvalScorecardByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.SuplrEvalScorecardFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.SuplrEvalScorecardRootQnaireByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.SuplrEvalScorecardRootQnaireFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.batch.SupplierEvaluationScorecardServiceBatch;

/**
 * <p>
 * This service enables you to read supplier evaluation scorecards that contain the results of the supplier evaluations
 * per supplier.
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/91/16dbdb342f4d5d8ff36e9ca410e018/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_SUPLR_EVAL_SCORECARD_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_SUPLR_EVAL_SCORECARD_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Supplier Evaluation Scorecard Integration(SAP_COM_0122)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/SL4'>Supplier Evaluation and Performance Monitoring(SL4)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Supplier Evaluation Scorecard</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Deprecated
public interface SupplierEvaluationScorecardService extends BatchService<SupplierEvaluationScorecardServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_SUPLR_EVAL_SCORECARD_SRV";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    SupplierEvaluationScorecardService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.SuplrEvalSccrdPurchaserResp
     * SuplrEvalSccrdPurchaserResp} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.SuplrEvalSccrdPurchaserResp
     *         SuplrEvalSccrdPurchaserResp} entities. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.SuplrEvalSccrdPurchaserRespFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SuplrEvalSccrdPurchaserRespFluentHelper getAllSuplrEvalSccrdPurchaserResp();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.SuplrEvalSccrdPurchaserResp
     * SuplrEvalSccrdPurchaserResp} entity using key fields.
     *
     * @param suplrEvalScorecardPtyUUID
     *            Evaluation Response Party UUID
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.SuplrEvalSccrdPurchaserResp
     *         SuplrEvalSccrdPurchaserResp} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.SuplrEvalSccrdPurchaserRespByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SuplrEvalSccrdPurchaserRespByKeyFluentHelper
        getSuplrEvalSccrdPurchaserRespByKey( final UUID suplrEvalScorecardPtyUUID );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.SuplrEvalSccrdQuestion
     * SuplrEvalSccrdQuestion} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.SuplrEvalSccrdQuestion
     *         SuplrEvalSccrdQuestion} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.SuplrEvalSccrdQuestionFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SuplrEvalSccrdQuestionFluentHelper getAllSuplrEvalSccrdQuestion();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.SuplrEvalSccrdQuestion
     * SuplrEvalSccrdQuestion} entity using key fields.
     *
     * @param suplrEvalSccrdQuestionUUID
     *            Evaluation Scorecard Question UUID
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.SuplrEvalSccrdQuestion
     *         SuplrEvalSccrdQuestion} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.SuplrEvalSccrdQuestionByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SuplrEvalSccrdQuestionByKeyFluentHelper getSuplrEvalSccrdQuestionByKey( final UUID suplrEvalSccrdQuestionUUID );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.SuplrEvalSccrdSection
     * SuplrEvalSccrdSection} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.SuplrEvalSccrdSection
     *         SuplrEvalSccrdSection} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.SuplrEvalSccrdSectionFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SuplrEvalSccrdSectionFluentHelper getAllSuplrEvalSccrdSection();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.SuplrEvalSccrdSection
     * SuplrEvalSccrdSection} entity using key fields.
     *
     * @param suplrEvalSccrdSectionUUID
     *            Evaluation Scorecard Section UUID
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.SuplrEvalSccrdSection
     *         SuplrEvalSccrdSection} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.SuplrEvalSccrdSectionByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SuplrEvalSccrdSectionByKeyFluentHelper getSuplrEvalSccrdSectionByKey( final UUID suplrEvalSccrdSectionUUID );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.SuplrEvalSccrdStrucQnaire
     * SuplrEvalSccrdStrucQnaire} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.SuplrEvalSccrdStrucQnaire
     *         SuplrEvalSccrdStrucQnaire} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.SuplrEvalSccrdStrucQnaireFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SuplrEvalSccrdStrucQnaireFluentHelper getAllSuplrEvalSccrdStrucQnaire();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.SuplrEvalSccrdStrucQnaire
     * SuplrEvalSccrdStrucQnaire} entity using key fields.
     *
     * @param suplrEvalScorecardQnaireUUID
     *            Evaluation Scorecard Questionnaire UUID
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.SuplrEvalSccrdStrucQnaire
     *         SuplrEvalSccrdStrucQnaire} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.SuplrEvalSccrdStrucQnaireByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SuplrEvalSccrdStrucQnaireByKeyFluentHelper
        getSuplrEvalSccrdStrucQnaireByKey( final UUID suplrEvalScorecardQnaireUUID );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.SuplrEvalSccrdSupplier
     * SuplrEvalSccrdSupplier} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.SuplrEvalSccrdSupplier
     *         SuplrEvalSccrdSupplier} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.SuplrEvalSccrdSupplierFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SuplrEvalSccrdSupplierFluentHelper getAllSuplrEvalSccrdSupplier();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.SuplrEvalSccrdSupplier
     * SuplrEvalSccrdSupplier} entity using key fields.
     *
     * @param suplrEvalScorecardPtyUUID
     *            Evaluation Response Party UUID
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.SuplrEvalSccrdSupplier
     *         SuplrEvalSccrdSupplier} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.SuplrEvalSccrdSupplierByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SuplrEvalSccrdSupplierByKeyFluentHelper getSuplrEvalSccrdSupplierByKey( final UUID suplrEvalScorecardPtyUUID );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.SuplrEvalScorecard
     * SuplrEvalScorecard} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.SuplrEvalScorecard
     *         SuplrEvalScorecard} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.SuplrEvalScorecardFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SuplrEvalScorecardFluentHelper getAllSuplrEvalScorecard();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.SuplrEvalScorecard
     * SuplrEvalScorecard} entity using key fields.
     *
     * @param suplrEvalScorecardUUID
     *            Evaluation Scorecard UUID
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.SuplrEvalScorecard
     *         SuplrEvalScorecard} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.SuplrEvalScorecardByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SuplrEvalScorecardByKeyFluentHelper getSuplrEvalScorecardByKey( final UUID suplrEvalScorecardUUID );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.SuplrEvalScorecardRootQnaire
     * SuplrEvalScorecardRootQnaire} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.SuplrEvalScorecardRootQnaire
     *         SuplrEvalScorecardRootQnaire} entities. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.SuplrEvalScorecardRootQnaireFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SuplrEvalScorecardRootQnaireFluentHelper getAllSuplrEvalScorecardRootQnaire();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.SuplrEvalScorecardRootQnaire
     * SuplrEvalScorecardRootQnaire} entity using key fields.
     *
     * @param suplrEvalScorecardQnaireUUID
     *            Evaluation Scorecard Questionnaire UUID
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.SuplrEvalScorecardRootQnaire
     *         SuplrEvalScorecardRootQnaire} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierevaluationscorecard.SuplrEvalScorecardRootQnaireByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SuplrEvalScorecardRootQnaireByKeyFluentHelper
        getSuplrEvalScorecardRootQnaireByKey( final UUID suplrEvalScorecardQnaireUUID );

}
