/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.time.LocalDateTime;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.CancelFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.PostFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.ReleaseFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcHeaderWhldgTaxByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcHeaderWhldgTaxFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcItemAcctAssgmtByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcItemAcctAssgmtFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcItemPurOrdRefByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcItemPurOrdRefFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcSeldInbDeliveryNoteByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcSeldInbDeliveryNoteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcSeldPurgDocumentByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcSeldPurgDocumentFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcSeldSrvcEntrShtLeanByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcSeldSrvcEntrShtLeanFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvoiceAdditionalDataByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvoiceAdditionalDataFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoice;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoiceByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoiceCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoiceDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoiceFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoiceItemGLAcctByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoiceItemGLAcctFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoiceTaxByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoiceTaxFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.batch.SupplierInvoiceIntegrationServiceBatch;

/**
 * <p>
 * This service enables you to create supplier invoices through an API call from a source system outside SAP S/4HANA
 * Cloud. Furthermore the service enables you to read, release, reverse and post existing supplier invoices from the SAP
 * S/4HANA Cloud system. The service is based on the OData protocol.
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/7b/c52558ef790a02e10000000a44147b/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_SUPPLIERINVOICE_PROCESS_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_SUPPLIERINVOICE_PROCESS_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.3.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Supplier Invoice Integration(SAP_COM_0057)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/BNX'>Consumable Purchasing(BNX)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/J13'>Service and Material Procurement - Project-Based
 * Services(J13)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/J45'>Procurement of Direct Materials(J45)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/O45'>Procurement of Direct Materials(O45)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/ONX'>Consumable Purchasing(ONX)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Supplier Invoice</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Deprecated
public interface SupplierInvoiceIntegrationService extends BatchService<SupplierInvoiceIntegrationServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_SUPPLIERINVOICE_PROCESS_SRV";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    SupplierInvoiceIntegrationService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcHeaderWhldgTax
     * SuplrInvcHeaderWhldgTax} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcHeaderWhldgTax
     *         SuplrInvcHeaderWhldgTax} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcHeaderWhldgTaxFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SuplrInvcHeaderWhldgTaxFluentHelper getAllSuplrInvcHeaderWhldgTax();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcHeaderWhldgTax
     * SuplrInvcHeaderWhldgTax} entity using key fields.
     *
     * @param withholdingTaxType
     *            Indicator for Withholding Tax Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param supplierInvoice
     *            Document Number of an Invoice Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param fiscalYear
     *            Fiscal Year
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcHeaderWhldgTax
     *         SuplrInvcHeaderWhldgTax} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcHeaderWhldgTaxByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SuplrInvcHeaderWhldgTaxByKeyFluentHelper getSuplrInvcHeaderWhldgTaxByKey(
        final String supplierInvoice,
        final String fiscalYear,
        final String withholdingTaxType );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcItemAcctAssgmt
     * SuplrInvcItemAcctAssgmt} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcItemAcctAssgmt
     *         SuplrInvcItemAcctAssgmt} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcItemAcctAssgmtFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SuplrInvcItemAcctAssgmtFluentHelper getAllSuplrInvcItemAcctAssgmt();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcItemAcctAssgmt
     * SuplrInvcItemAcctAssgmt} entity using key fields.
     *
     * @param ordinalNumber
     *            Four Character Sequential Number for Coding Block
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param supplierInvoiceItem
     *            Document Item in Invoice Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param supplierInvoice
     *            Document Number of an Accounting Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param fiscalYear
     *            Fiscal Year
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcItemAcctAssgmt
     *         SuplrInvcItemAcctAssgmt} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcItemAcctAssgmtByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SuplrInvcItemAcctAssgmtByKeyFluentHelper getSuplrInvcItemAcctAssgmtByKey(
        final String supplierInvoice,
        final String fiscalYear,
        final String supplierInvoiceItem,
        final String ordinalNumber );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcItemPurOrdRef
     * SuplrInvcItemPurOrdRef} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcItemPurOrdRef
     *         SuplrInvcItemPurOrdRef} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcItemPurOrdRefFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SuplrInvcItemPurOrdRefFluentHelper getAllSuplrInvcItemPurOrdRef();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcItemPurOrdRef
     * SuplrInvcItemPurOrdRef} entity using key fields.
     *
     * @param supplierInvoiceItem
     *            Document Item in Invoice Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param supplierInvoice
     *            Document Number of an Accounting Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param fiscalYear
     *            Fiscal Year
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcItemPurOrdRef
     *         SuplrInvcItemPurOrdRef} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcItemPurOrdRefByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SuplrInvcItemPurOrdRefByKeyFluentHelper getSuplrInvcItemPurOrdRefByKey(
        final String supplierInvoice,
        final String fiscalYear,
        final String supplierInvoiceItem );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcSeldInbDeliveryNote
     * SuplrInvcSeldInbDeliveryNote} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcSeldInbDeliveryNote
     *         SuplrInvcSeldInbDeliveryNote} entities. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcSeldInbDeliveryNoteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SuplrInvcSeldInbDeliveryNoteFluentHelper getAllSuplrInvcSeldInbDeliveryNote();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcSeldInbDeliveryNote
     * SuplrInvcSeldInbDeliveryNote} entity using key fields.
     *
     * @param inboundDeliveryNote
     *            Number of External Delivery Note
     *            <p>
     *            Constraints: Not nullable, Maximum length: 16
     *            </p>
     * @param supplierInvoice
     *            Document Number of an Accounting Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param fiscalYear
     *            Fiscal Year
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcSeldInbDeliveryNote
     *         SuplrInvcSeldInbDeliveryNote} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcSeldInbDeliveryNoteByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SuplrInvcSeldInbDeliveryNoteByKeyFluentHelper getSuplrInvcSeldInbDeliveryNoteByKey(
        final String supplierInvoice,
        final String fiscalYear,
        final String inboundDeliveryNote );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcSeldPurgDocument
     * SuplrInvcSeldPurgDocument} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcSeldPurgDocument
     *         SuplrInvcSeldPurgDocument} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcSeldPurgDocumentFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SuplrInvcSeldPurgDocumentFluentHelper getAllSuplrInvcSeldPurgDocument();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcSeldPurgDocument
     * SuplrInvcSeldPurgDocument} entity using key fields.
     *
     * @param purchaseOrder
     *            Purchasing Document Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param supplierInvoice
     *            Document Number of an Accounting Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param purchaseOrderItem
     *            Item Number of Purchasing Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 5
     *            </p>
     * @param fiscalYear
     *            Fiscal Year
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcSeldPurgDocument
     *         SuplrInvcSeldPurgDocument} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcSeldPurgDocumentByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SuplrInvcSeldPurgDocumentByKeyFluentHelper getSuplrInvcSeldPurgDocumentByKey(
        final String supplierInvoice,
        final String fiscalYear,
        final String purchaseOrder,
        final String purchaseOrderItem );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcSeldSrvcEntrShtLean
     * SuplrInvcSeldSrvcEntrShtLean} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcSeldSrvcEntrShtLean
     *         SuplrInvcSeldSrvcEntrShtLean} entities. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcSeldSrvcEntrShtLeanFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SuplrInvcSeldSrvcEntrShtLeanFluentHelper getAllSuplrInvcSeldSrvcEntrShtLean();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcSeldSrvcEntrShtLean
     * SuplrInvcSeldSrvcEntrShtLean} entity using key fields.
     *
     * @param serviceEntrySheetItem
     *            Item Number of Service Entry Sheet
     *            <p>
     *            Constraints: Not nullable, Maximum length: 5
     *            </p>
     * @param serviceEntrySheet
     *            Service Entry Sheet
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param supplierInvoice
     *            Document Number of an Accounting Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param fiscalYear
     *            Fiscal Year
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcSeldSrvcEntrShtLean
     *         SuplrInvcSeldSrvcEntrShtLean} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvcSeldSrvcEntrShtLeanByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SuplrInvcSeldSrvcEntrShtLeanByKeyFluentHelper getSuplrInvcSeldSrvcEntrShtLeanByKey(
        final String supplierInvoice,
        final String fiscalYear,
        final String serviceEntrySheet,
        final String serviceEntrySheetItem );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvoiceAdditionalData
     * SuplrInvoiceAdditionalData} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvoiceAdditionalData
     *         SuplrInvoiceAdditionalData} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvoiceAdditionalDataFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SuplrInvoiceAdditionalDataFluentHelper getAllSuplrInvoiceAdditionalData();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvoiceAdditionalData
     * SuplrInvoiceAdditionalData} entity using key fields.
     *
     * @param supplierInvoice
     *            Document Number of an Invoice Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param fiscalYear
     *            Fiscal Year
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvoiceAdditionalData
     *         SuplrInvoiceAdditionalData} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SuplrInvoiceAdditionalDataByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SuplrInvoiceAdditionalDataByKeyFluentHelper
        getSuplrInvoiceAdditionalDataByKey( final String supplierInvoice, final String fiscalYear );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoice
     * SupplierInvoice} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoice
     *         SupplierInvoice} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoiceFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SupplierInvoiceFluentHelper getAllSupplierInvoice();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoice
     * SupplierInvoice} entity using key fields.
     *
     * @param supplierInvoice
     *            Document Number of an Invoice Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param fiscalYear
     *            Fiscal Year
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoice
     *         SupplierInvoice} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoiceByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SupplierInvoiceByKeyFluentHelper getSupplierInvoiceByKey( final String supplierInvoice, final String fiscalYear );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoice
     * SupplierInvoice} entity and save it to the S/4HANA system.
     *
     * @param supplierInvoice
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoice
     *            SupplierInvoice} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoice
     *         SupplierInvoice} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoiceCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SupplierInvoiceCreateFluentHelper createSupplierInvoice( @Nonnull final SupplierInvoice supplierInvoice );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoice
     * SupplierInvoice} entity in the S/4HANA system.
     *
     * @param supplierInvoice
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoice
     *            SupplierInvoice} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoice
     *         SupplierInvoice} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoiceDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SupplierInvoiceDeleteFluentHelper deleteSupplierInvoice( @Nonnull final SupplierInvoice supplierInvoice );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoiceItemGLAcct
     * SupplierInvoiceItemGLAcct} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoiceItemGLAcct
     *         SupplierInvoiceItemGLAcct} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoiceItemGLAcctFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SupplierInvoiceItemGLAcctFluentHelper getAllSupplierInvoiceItemGLAcct();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoiceItemGLAcct
     * SupplierInvoiceItemGLAcct} entity using key fields.
     *
     * @param supplierInvoiceItem
     *            Four Character Sequential Number for Coding Block
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param supplierInvoice
     *            Document Number of an Accounting Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param fiscalYear
     *            Fiscal Year
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoiceItemGLAcct
     *         SupplierInvoiceItemGLAcct} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoiceItemGLAcctByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SupplierInvoiceItemGLAcctByKeyFluentHelper getSupplierInvoiceItemGLAcctByKey(
        final String supplierInvoice,
        final String fiscalYear,
        final String supplierInvoiceItem );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoiceTax
     * SupplierInvoiceTax} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoiceTax
     *         SupplierInvoiceTax} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoiceTaxFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SupplierInvoiceTaxFluentHelper getAllSupplierInvoiceTax();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoiceTax
     * SupplierInvoiceTax} entity using key fields.
     *
     * @param supplierInvoice
     *            Document Number of an Invoice Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param taxCode
     *            Tax code
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param fiscalYear
     *            Fiscal Year
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param supplierInvoiceTaxCounter
     *            Document Item in Invoice Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoiceTax
     *         SupplierInvoiceTax} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.SupplierInvoiceTaxByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SupplierInvoiceTaxByKeyFluentHelper getSupplierInvoiceTaxByKey(
        final String supplierInvoice,
        final String fiscalYear,
        final String taxCode,
        final String supplierInvoiceTaxCounter );

    /**
     * <p>
     * Creates a fluent helper for the <b>Post</b> OData function import.
     * </p>
     *
     * @param supplierInvoice
     *            Constraints: Not nullable, Maximum length: 10
     *            <p>
     *            Original parameter name from the Odata EDM: <b>SupplierInvoice</b>
     *            </p>
     * @param fiscalYear
     *            Constraints: Not nullable, Maximum length: 4
     *            <p>
     *            Original parameter name from the Odata EDM: <b>FiscalYear</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>Post</b> OData function import with the provided
     *         parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.PostFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PostFluentHelper post( @Nonnull final String supplierInvoice, @Nonnull final String fiscalYear );

    /**
     * <p>
     * Creates a fluent helper for the <b>Release</b> OData function import.
     * </p>
     *
     * @param supplierInvoice
     *            Constraints: Not nullable, Maximum length: 10
     *            <p>
     *            Original parameter name from the Odata EDM: <b>SupplierInvoice</b>
     *            </p>
     * @param discountDaysHaveToBeShifted
     *            Indicator
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: none
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>DiscountDaysHaveToBeShifted</b>
     *            </p>
     * @param fiscalYear
     *            Constraints: Not nullable, Maximum length: 4
     *            <p>
     *            Original parameter name from the Odata EDM: <b>FiscalYear</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>Release</b> OData function import with the provided
     *         parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.ReleaseFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ReleaseFluentHelper release(
        @Nonnull final Boolean discountDaysHaveToBeShifted,
        @Nonnull final String fiscalYear,
        @Nonnull final String supplierInvoice );

    /**
     * <p>
     * Creates a fluent helper for the <b>Cancel</b> OData function import.
     * </p>
     *
     * @param reversalReason
     *            Constraints: Not nullable, Maximum length: 2
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ReversalReason</b>
     *            </p>
     * @param supplierInvoice
     *            Constraints: Not nullable, Maximum length: 10
     *            <p>
     *            Original parameter name from the Odata EDM: <b>SupplierInvoice</b>
     *            </p>
     * @param postingDate
     *            Time Stamp
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Precision: 0
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>PostingDate</b>
     *            </p>
     * @param fiscalYear
     *            Constraints: Not nullable, Maximum length: 4
     *            <p>
     *            Original parameter name from the Odata EDM: <b>FiscalYear</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>Cancel</b> OData function import with the provided
     *         parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierinvoiceintegration.CancelFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CancelFluentHelper cancel(
        @Nonnull final String supplierInvoice,
        @Nonnull final String fiscalYear,
        @Nonnull final String reversalReason,
        @Nonnull final LocalDateTime postingDate );

}
