/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.time.LocalDateTime;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierquotation.CancelFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierquotation.CompleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierquotation.CreateFromRFQFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierquotation.SubmitFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierquotation.SubmitForApprovalFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierquotation.SupplierQuotation;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierquotation.SupplierQuotationByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierquotation.SupplierQuotationCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierquotation.SupplierQuotationDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierquotation.SupplierQuotationFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierquotation.SupplierQuotationItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierquotation.SupplierQuotationItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierquotation.SupplierQuotationItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierquotation.SupplierQuotationItemUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierquotation.SupplierQuotationUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierquotation.batch.SupplierQuotationServiceBatch;

/**
 * <p>
 *
 * This service enables you to read, update and create supplier quotations with reference to an RFQ from or in the SAP
 * S/4HANA Cloud system. The service contains header, item, and bidder nodes. The information is sent in the request as
 * a payload. Once the supplier quotation has been successfully created, the supplier quotation number is sent in the
 * response with the data included in the supplier quotation. If any issues arise when the supplier quotation is
 * created, the system displays error messages in the response. .
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/87/a40bc9b4db43d89fcbb6e10dd152fe/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_QTN_PROCESS_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_QTN_PROCESS_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Distributed Manufacturing Integration(SAP_COM_0077), Purchase Request for Quotation
 * Integration(SAP_COM_0113)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/1NX'>Collaborative Manufacturing with SAP Digital Manufacturing
 * Cloud(1NX)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/BNX'>Consumable Purchasing(BNX)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/ONX'>Consumable Purchasing(ONX)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/1A0'>Sourcing with SAP Ariba Sourcing(1A0)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/1L2'>Supplier Quote Automation with SAP Ariba Commerce
 * Automation(1L2)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/1XF'>Request for Price(1XF)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OA0'>Sourcing with SAP Ariba Sourcing(OA0)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OXF'>Request for Price(OXF)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Supplier Quotation</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Deprecated
public interface SupplierQuotationService extends BatchService<SupplierQuotationServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_QTN_PROCESS_SRV";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    SupplierQuotationService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierquotation.SupplierQuotation
     * SupplierQuotation} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierquotation.SupplierQuotation
     *         SupplierQuotation} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierquotation.SupplierQuotationFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SupplierQuotationFluentHelper getAllSupplierQuotation();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierquotation.SupplierQuotation
     * SupplierQuotation} entity using key fields.
     *
     * @param supplierQuotation
     *            Supplier Quotation Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierquotation.SupplierQuotation
     *         SupplierQuotation} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierquotation.SupplierQuotationByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SupplierQuotationByKeyFluentHelper getSupplierQuotationByKey( final String supplierQuotation );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierquotation.SupplierQuotation
     * SupplierQuotation} entity and save it to the S/4HANA system.
     *
     * @param supplierQuotation
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierquotation.SupplierQuotation
     *            SupplierQuotation} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierquotation.SupplierQuotation
     *         SupplierQuotation} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierquotation.SupplierQuotationCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SupplierQuotationCreateFluentHelper createSupplierQuotation( @Nonnull final SupplierQuotation supplierQuotation );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierquotation.SupplierQuotation
     * SupplierQuotation} entity and save it to the S/4HANA system.
     *
     * @param supplierQuotation
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierquotation.SupplierQuotation
     *            SupplierQuotation} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierquotation.SupplierQuotation
     *         SupplierQuotation} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierquotation.SupplierQuotationUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SupplierQuotationUpdateFluentHelper updateSupplierQuotation( @Nonnull final SupplierQuotation supplierQuotation );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierquotation.SupplierQuotation SupplierQuotation}
     * entity in the S/4HANA system.
     *
     * @param supplierQuotation
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierquotation.SupplierQuotation
     *            SupplierQuotation} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierquotation.SupplierQuotation
     *         SupplierQuotation} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierquotation.SupplierQuotationDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SupplierQuotationDeleteFluentHelper deleteSupplierQuotation( @Nonnull final SupplierQuotation supplierQuotation );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierquotation.SupplierQuotationItem
     * SupplierQuotationItem} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierquotation.SupplierQuotationItem
     *         SupplierQuotationItem} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierquotation.SupplierQuotationItemFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SupplierQuotationItemFluentHelper getAllSupplierQuotationItem();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierquotation.SupplierQuotationItem
     * SupplierQuotationItem} entity using key fields.
     *
     * @param supplierQuotationItem
     *            Item Number of Supplier Quotation
     *            <p>
     *            Constraints: Not nullable, Maximum length: 5
     *            </p>
     * @param supplierQuotation
     *            Purchasing Document Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierquotation.SupplierQuotationItem
     *         SupplierQuotationItem} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierquotation.SupplierQuotationItemByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SupplierQuotationItemByKeyFluentHelper
        getSupplierQuotationItemByKey( final String supplierQuotation, final String supplierQuotationItem );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierquotation.SupplierQuotationItem
     * SupplierQuotationItem} entity and save it to the S/4HANA system.
     *
     * @param supplierQuotationItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierquotation.SupplierQuotationItem
     *            SupplierQuotationItem} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierquotation.SupplierQuotationItem
     *         SupplierQuotationItem} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierquotation.SupplierQuotationItemUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SupplierQuotationItemUpdateFluentHelper
        updateSupplierQuotationItem( @Nonnull final SupplierQuotationItem supplierQuotationItem );

    /**
     * <p>
     * Creates a fluent helper for the <b>Submit</b> OData function import.
     * </p>
     *
     * @param supplierQuotation
     *            Supplier Quotation
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>SupplierQuotation</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>Submit</b> OData function import with the provided
     *         parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierquotation.SubmitFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SubmitFluentHelper submit( @Nonnull final String supplierQuotation );

    /**
     * <p>
     * Creates a fluent helper for the <b>Complete</b> OData function import.
     * </p>
     *
     * @param supplierQuotation
     *            Supplier Quotation
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>SupplierQuotation</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>Complete</b> OData function import with the provided
     *         parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierquotation.CompleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CompleteFluentHelper complete( @Nonnull final String supplierQuotation );

    /**
     * <p>
     * Creates a fluent helper for the <b>Cancel</b> OData function import.
     * </p>
     *
     * @param supplierQuotation
     *            Supplier Quotation
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>SupplierQuotation</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>Cancel</b> OData function import with the provided
     *         parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierquotation.CancelFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CancelFluentHelper cancel( @Nonnull final String supplierQuotation );

    /**
     * <p>
     * Creates a fluent helper for the <b>SubmitForApproval</b> OData function import.
     * </p>
     *
     * @param supplierQuotation
     *            Supplier Quotation
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>SupplierQuotation</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>SubmitForApproval</b> OData function import with the
     *         provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierquotation.SubmitForApprovalFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SubmitForApprovalFluentHelper submitForApproval( @Nonnull final String supplierQuotation );

    /**
     * <p>
     * Creates a fluent helper for the <b>CreateFromRFQ</b> OData function import.
     * </p>
     *
     * @param supplier
     *            Supplier
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>Supplier</b>
     *            </p>
     * @param quotationSubmissionDate
     *            Quotation Submission Date
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Precision: 0
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>QuotationSubmissionDate</b>
     *            </p>
     * @param requestForQuotation
     *            Request for Quotation
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>RequestForQuotation</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>CreateFromRFQ</b> OData function import with the provided
     *         parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.supplierquotation.CreateFromRFQFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CreateFromRFQFluentHelper createFromRFQ(
        @Nonnull final LocalDateTime quotationSubmissionDate,
        @Nonnull final String supplier,
        @Nonnull final String requestForQuotation );

}
