/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.util.UUID;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow.TrsyPosFlowByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow.TrsyPosFlowFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow.batch.TreasuryPositionFlowServiceBatch;

/**
 * <p>
 * You can use this inbound service to read treasury position flows. The treasury position is the most detailed level in
 * which you can break down the balance sheet accounts in the Treasury and Risk Management ledger. The treasury position
 * flows are generated by the operative or derived business transactions to update the position components of the
 * treasury positions. The service provides you with detailed information about each selected treasury position flow,
 * such as amount, currency, dates, differentiation criteria of the affected treasury position, business transaction,
 * and update type.
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/fd/bdf48471784561a68d2a23d474650d/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_TRSYPOSFLOW_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_TRSYPOSFLOW_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Finance - Treasury Position Flow Integration(SAP_COM_0332)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/1XN'>Market Rates Management - Manually via Upload(1XN)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OXN'>Market Data for Treasury and Risk Management(OXN)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>TreasuryLedgerPositionFlowList</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Deprecated
public interface TreasuryPositionFlowService extends BatchService<TreasuryPositionFlowServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/A_TRSYPOSFLOW_CDS";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    TreasuryPositionFlowService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow.TrsyPosFlow
     * TrsyPosFlow} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow.TrsyPosFlow TrsyPosFlow}
     *         entities. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow.TrsyPosFlowFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    TrsyPosFlowFluentHelper getAllTrsyPosFlow();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow.TrsyPosFlow
     * TrsyPosFlow} entity using key fields.
     *
     * @param businessTransactionDocUUID
     *            Business Transaction (GUID)
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @param treasuryTransactionFlow
     *            Number of TRL Flow
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow.TrsyPosFlow TrsyPosFlow}
     *         entity using key fields. This fluent helper allows methods which modify the underlying query to be called
     *         before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.treasurypositionflow.TrsyPosFlowByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    TrsyPosFlowByKeyFluentHelper
        getTrsyPosFlowByKey( final Integer treasuryTransactionFlow, final UUID businessTransactionDocUUID );

}
