/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.time.LocalDateTime;
import java.util.UUID;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.AccountingDocumentByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.AccountingDocumentCategoryByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.AccountingDocumentCategoryFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.AccountingDocumentFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.AlternativeGLAccountByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.AlternativeGLAccountFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.AssetTransactionByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.AssetTransactionFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.BalanceTransactionCurrencyByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.BalanceTransactionCurrencyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.BillingDocumentByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.BillingDocumentFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.BudgetPeriodByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.BudgetPeriodFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.BusinessAreaByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.BusinessAreaFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.BusinessProcessByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.BusinessProcessFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.BusinessTransactionByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.BusinessTransactionFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CalendarMonthByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CalendarMonthFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CalendarQuarterByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CalendarQuarterFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CalendarYearMonthByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CalendarYearMonthFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ChartOfAccountsByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ChartOfAccountsFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ClearingAccountingDocumentByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ClearingAccountingDocumentFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ClearingJournalEntryByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ClearingJournalEntryFiscalYearByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ClearingJournalEntryFiscalYearFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ClearingJournalEntryFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CompanyCodeByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CompanyCodeCurrencyByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CompanyCodeCurrencyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CompanyCodeFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ControllingAreaByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ControllingAreaFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ControllingObjectClassByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ControllingObjectClassFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ControllingObjectDebitByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ControllingObjectDebitFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CorporateGroupAccountByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CorporateGroupAccountFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CorporateGroupChartOfAccountsByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CorporateGroupChartOfAccountsFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CostCenterByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CostCenterFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CountryChartOfAccountsByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CountryChartOfAccountsFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CustomerByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CustomerFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CustomerGroupByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CustomerGroupFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.DebitCreditCodeByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.DebitCreditCodeFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.DistributionChannelByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.DistributionChannelFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.EliminationProfitCenterByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.EliminationProfitCenterFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FinancialAccountByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FinancialAccountFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FinancialManagementAreaByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FinancialManagementAreaFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FinancialTransactionByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FinancialTransactionFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FiscalYearByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FiscalYearFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FiscalYearVariantByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FiscalYearVariantFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FixedAssetByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FixedAssetFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FreeDefinedCurrency1ByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FreeDefinedCurrency1FluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FreeDefinedCurrency2ByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FreeDefinedCurrency2FluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FreeDefinedCurrency3ByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FreeDefinedCurrency3FluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FreeDefinedCurrency4ByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FreeDefinedCurrency4FluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FreeDefinedCurrency5ByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FreeDefinedCurrency5FluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FreeDefinedCurrency6ByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FreeDefinedCurrency6FluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FreeDefinedCurrency7ByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FreeDefinedCurrency7FluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FreeDefinedCurrency8ByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FreeDefinedCurrency8FluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FunctionalAreaByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FunctionalAreaFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FundByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FundFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.GLAccountByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.GLAccountFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.GLAccountHierarchyByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.GLAccountHierarchyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.GLAccount_2ByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.GLAccount_2FluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.GlobalCurrencyByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.GlobalCurrencyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.GrantIDByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.GrantIDFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.GroupFixedAssetByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.GroupFixedAssetFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.GroupMasterFixedAssetByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.GroupMasterFixedAssetFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.HouseBankAccountByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.HouseBankAccountFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.HouseBankByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.HouseBankFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.InventorySpclStkSalesDocItmByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.InventorySpclStkSalesDocItmFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.InventorySpclStkSalesDocumentByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.InventorySpclStkSalesDocumentFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.InventorySpclStockWBSElementByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.InventorySpclStockWBSElementFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.InventorySpecialStockByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.InventorySpecialStockFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.InventorySpecialStockSupplierByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.InventorySpecialStockSupplierFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.InventorySpecialStockValnByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.InventorySpecialStockValnFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.InventoryValuationByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.InventoryValuationFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.InvtrySpclStockWBSElmntExtIDByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.InvtrySpclStockWBSElmntExtIDFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.InvtrySpclStockWBSElmntIntIDByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.InvtrySpclStockWBSElmntIntIDFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.InvtrySpecialStockValnType_2ByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.InvtrySpecialStockValnType_2FluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.IsBalanceSheetAccountByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.IsBalanceSheetAccountFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.IsOpenItemManagedByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.IsOpenItemManagedFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.IsReversalByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.IsReversalFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.IsReversedByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.IsReversedFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.IsSettledByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.IsSettledFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.IsSettlementByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.IsSettlementFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.LedgerByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.LedgerFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.LineItemIsCompletedByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.LineItemIsCompletedFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.LogicalSystemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.LogicalSystemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MasterFixedAssetByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MasterFixedAssetFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ODataQueryAdditionalMetadataByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ODataQueryAdditionalMetadataFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.OffsettingAccountByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.OffsettingAccountFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.OffsettingAccount_2ByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.OffsettingAccount_2FluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.OperatingConcernByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.OperatingConcernFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.OrderCategoryByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.OrderCategoryFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.OrderIDByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.OrderIDFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.OriginCostCenterByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.OriginCostCenterFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.OriginCostCtrActivityByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.OriginCostCtrActivityFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.OriginObjectByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.OriginObjectFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerBudgetPeriodByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerBudgetPeriodFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerBusinessAreaByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerBusinessAreaFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerBusinessProcessByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerBusinessProcessFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerCompanyByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerCompanyCodeByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerCompanyCodeFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerCompanyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerControllingObjectClassByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerControllingObjectClassFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerCostCenterByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerCostCenterFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerFunctionalAreaByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerFunctionalAreaFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerFundByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerFundFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerGrantByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerGrantFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerOrderByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerOrderCategoryByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerOrderCategoryFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerOrderFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerProfitCenterByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerProfitCenterFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerProjectByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerProjectFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerProjectInternalIDByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerProjectInternalIDFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerSalesDocumentByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerSalesDocumentFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerSalesDocumentItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerSalesDocumentItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerSegmentByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerSegmentFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerWBSElementByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerWBSElementFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerWBSElementInternalIDByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerWBSElementInternalIDFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PlantByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PlantFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PostingKeyByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PostingKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PredecessorReferenceDocByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PredecessorReferenceDocFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ProductByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ProductFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ProductGroupByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ProductGroupFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ProfitCenterByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ProfitCenterFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ProjectByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ProjectExternalIDByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ProjectExternalIDFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ProjectFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ProjectNetworkByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ProjectNetworkFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PurchasingDocumentByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PurchasingDocumentFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.QuantityIsIncompleteByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.QuantityIsIncompleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ReferenceDocumentByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ReferenceDocumentFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SAP__Currency;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SAP__CurrencyByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SAP__CurrencyCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SAP__CurrencyDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SAP__CurrencyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SAP__CurrencyUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SAP__DocumentDescription;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SAP__DocumentDescriptionByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SAP__DocumentDescriptionCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SAP__DocumentDescriptionDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SAP__DocumentDescriptionFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SAP__DocumentDescriptionUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SAP__UnitOfMeasure;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SAP__UnitOfMeasureByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SAP__UnitOfMeasureCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SAP__UnitOfMeasureDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SAP__UnitOfMeasureFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SAP__UnitOfMeasureUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SAP__ValueHelp;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SAP__ValueHelpByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SAP__ValueHelpCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SAP__ValueHelpDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SAP__ValueHelpFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SAP__ValueHelpUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SalesDocumentByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SalesDocumentFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SalesDocumentItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SalesDocumentItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SalesOrderByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SalesOrderFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SalesOrderItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SalesOrderItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SalesOrganizationByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SalesOrganizationFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SegmentByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SegmentFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SoldProductByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SoldProductFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SoldProductGroupByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SoldProductGroupFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SpecialGLCodeByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SpecialGLCodeFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SupplierByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SupplierFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEParametersByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResultByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TransactionCurrencyByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TransactionCurrencyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ValuationAreaByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ValuationAreaFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.WBSElementByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.WBSElementExternalIDByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.WBSElementExternalIDFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.WBSElementFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.batch.TrialBalanceServiceBatch;

/**
 * <p>
 *
 * The service enables you to retrieve starting, credit and debit balances for G/L accounts per fiscal year period.
 *
 * You can read data for period-based balances. You cannot read data for day-based balances.
 *
 * You need to provide the time frame for the selection in a date format and you need to provide the level of
 * aggregation in a $select clause..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/61/ab22d2f6da49a394004e459947e994/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/C_TRIALBALANCE_CDS?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>C_TRIALBALANCE_CDS</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Finance - Accounting Analytics Integration(SAP_COM_0303)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/J58'>Accounting and Financial Close(J58)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/O58'>Accounting and Financial Close(O58)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>General Ledger Account</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Deprecated
public interface TrialBalanceService extends BatchService<TrialBalanceServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/C_TRIALBALANCE_CDS";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    TrialBalanceService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.Ledger Ledger} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.Ledger Ledger} entities. This
     *         fluent helper allows methods which modify the underlying query to be called before executing the query
     *         itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.LedgerFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    LedgerFluentHelper getAllLedger();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.Ledger Ledger} entity
     * using key fields.
     *
     * @param ledger
     *            Ledger
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.Ledger Ledger} entity using key
     *         fields. This fluent helper allows methods which modify the underlying query to be called before executing
     *         the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.LedgerByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    LedgerByKeyFluentHelper getLedgerByKey( final String ledger );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CompanyCode CompanyCode}
     * entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CompanyCode CompanyCode}
     *         entities. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CompanyCodeFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CompanyCodeFluentHelper getAllCompanyCode();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CompanyCode CompanyCode}
     * entity using key fields.
     *
     * @param companyCode
     *            Company Code
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CompanyCode CompanyCode} entity
     *         using key fields. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CompanyCodeByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CompanyCodeByKeyFluentHelper getCompanyCodeByKey( final String companyCode );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.GLAccount GLAccount}
     * entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.GLAccount GLAccount} entities.
     *         This fluent helper allows methods which modify the underlying query to be called before executing the
     *         query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.GLAccountFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    GLAccountFluentHelper getAllGLAccount();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.GLAccount GLAccount}
     * entity using key fields.
     *
     * @param gLAccount
     *            G/L Account
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.GLAccount GLAccount} entity using
     *         key fields. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.GLAccountByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    GLAccountByKeyFluentHelper getGLAccountByKey( final String gLAccount );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.OrderID OrderID} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.OrderID OrderID} entities. This
     *         fluent helper allows methods which modify the underlying query to be called before executing the query
     *         itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.OrderIDFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    OrderIDFluentHelper getAllOrderID();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.OrderID OrderID} entity
     * using key fields.
     *
     * @param orderID
     *            Order ID
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.OrderID OrderID} entity using key
     *         fields. This fluent helper allows methods which modify the underlying query to be called before executing
     *         the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.OrderIDByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    OrderIDByKeyFluentHelper getOrderIDByKey( final String orderID );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ProjectNetwork
     * ProjectNetwork} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ProjectNetwork ProjectNetwork}
     *         entities. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ProjectNetworkFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProjectNetworkFluentHelper getAllProjectNetwork();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ProjectNetwork
     * ProjectNetwork} entity using key fields.
     *
     * @param projectNetwork
     *            Network
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ProjectNetwork ProjectNetwork}
     *         entity using key fields. This fluent helper allows methods which modify the underlying query to be called
     *         before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ProjectNetworkByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProjectNetworkByKeyFluentHelper getProjectNetworkByKey( final String projectNetwork );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.Project Project} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.Project Project} entities. This
     *         fluent helper allows methods which modify the underlying query to be called before executing the query
     *         itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ProjectFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProjectFluentHelper getAllProject();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.Project Project} entity
     * using key fields.
     *
     * @param project
     *            Project Definition
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.Project Project} entity using key
     *         fields. This fluent helper allows methods which modify the underlying query to be called before executing
     *         the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ProjectByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProjectByKeyFluentHelper getProjectByKey( final String project );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.BusinessProcess
     * BusinessProcess} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.BusinessProcess BusinessProcess}
     *         entities. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.BusinessProcessFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusinessProcessFluentHelper getAllBusinessProcess();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.BusinessProcess
     * BusinessProcess} entity using key fields.
     *
     * @param businessProcess
     *            Business Process
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.BusinessProcess BusinessProcess}
     *         entity using key fields. This fluent helper allows methods which modify the underlying query to be called
     *         before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.BusinessProcessByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusinessProcessByKeyFluentHelper getBusinessProcessByKey( final String businessProcess );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.BillingDocument
     * BillingDocument} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.BillingDocument BillingDocument}
     *         entities. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.BillingDocumentFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BillingDocumentFluentHelper getAllBillingDocument();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.BillingDocument
     * BillingDocument} entity using key fields.
     *
     * @param billingDocumentType
     *            Billing Type
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.BillingDocument BillingDocument}
     *         entity using key fields. This fluent helper allows methods which modify the underlying query to be called
     *         before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.BillingDocumentByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BillingDocumentByKeyFluentHelper getBillingDocumentByKey( final String billingDocumentType );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SalesOrganization
     * SalesOrganization} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SalesOrganization
     *         SalesOrganization} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SalesOrganizationFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesOrganizationFluentHelper getAllSalesOrganization();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SalesOrganization
     * SalesOrganization} entity using key fields.
     *
     * @param salesOrganization
     *            Sales Organization
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SalesOrganization
     *         SalesOrganization} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SalesOrganizationByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesOrganizationByKeyFluentHelper getSalesOrganizationByKey( final String salesOrganization );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.DistributionChannel
     * DistributionChannel} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.DistributionChannel
     *         DistributionChannel} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.DistributionChannelFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    DistributionChannelFluentHelper getAllDistributionChannel();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.DistributionChannel
     * DistributionChannel} entity using key fields.
     *
     * @param distributionChannel
     *            Distribution Channel
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.DistributionChannel
     *         DistributionChannel} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.DistributionChannelByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    DistributionChannelByKeyFluentHelper getDistributionChannelByKey( final String distributionChannel );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SoldProduct SoldProduct}
     * entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SoldProduct SoldProduct}
     *         entities. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SoldProductFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SoldProductFluentHelper getAllSoldProduct();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SoldProduct SoldProduct}
     * entity using key fields.
     *
     * @param soldProduct
     *            Product Sold
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SoldProduct SoldProduct} entity
     *         using key fields. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SoldProductByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SoldProductByKeyFluentHelper getSoldProductByKey( final String soldProduct );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerCompany
     * PartnerCompany} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerCompany PartnerCompany}
     *         entities. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerCompanyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PartnerCompanyFluentHelper getAllPartnerCompany();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerCompany
     * PartnerCompany} entity using key fields.
     *
     * @param partnerCompany
     *            Trading Partner
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerCompany PartnerCompany}
     *         entity using key fields. This fluent helper allows methods which modify the underlying query to be called
     *         before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerCompanyByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PartnerCompanyByKeyFluentHelper getPartnerCompanyByKey( final String partnerCompany );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerOrder PartnerOrder}
     * entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerOrder PartnerOrder}
     *         entities. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerOrderFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PartnerOrderFluentHelper getAllPartnerOrder();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerOrder PartnerOrder}
     * entity using key fields.
     *
     * @param partnerOrder
     *            Partner Order
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerOrder PartnerOrder} entity
     *         using key fields. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerOrderByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PartnerOrderByKeyFluentHelper getPartnerOrderByKey( final String partnerOrder );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerWBSElement
     * PartnerWBSElement} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerWBSElement
     *         PartnerWBSElement} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerWBSElementFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PartnerWBSElementFluentHelper getAllPartnerWBSElement();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerWBSElement
     * PartnerWBSElement} entity using key fields.
     *
     * @param partnerWBSElement
     *            Partner WBS Element
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerWBSElement
     *         PartnerWBSElement} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerWBSElementByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PartnerWBSElementByKeyFluentHelper getPartnerWBSElementByKey( final String partnerWBSElement );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerProject
     * PartnerProject} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerProject PartnerProject}
     *         entities. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerProjectFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PartnerProjectFluentHelper getAllPartnerProject();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerProject
     * PartnerProject} entity using key fields.
     *
     * @param partnerProject
     *            Partner Project
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerProject PartnerProject}
     *         entity using key fields. This fluent helper allows methods which modify the underlying query to be called
     *         before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerProjectByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PartnerProjectByKeyFluentHelper getPartnerProjectByKey( final String partnerProject );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerSalesDocument
     * PartnerSalesDocument} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerSalesDocument
     *         PartnerSalesDocument} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerSalesDocumentFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PartnerSalesDocumentFluentHelper getAllPartnerSalesDocument();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerSalesDocument
     * PartnerSalesDocument} entity using key fields.
     *
     * @param partnerSalesDocument
     *            Partner Sales Doc.
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerSalesDocument
     *         PartnerSalesDocument} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerSalesDocumentByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PartnerSalesDocumentByKeyFluentHelper getPartnerSalesDocumentByKey( final String partnerSalesDocument );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerBusinessProcess
     * PartnerBusinessProcess} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerBusinessProcess
     *         PartnerBusinessProcess} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerBusinessProcessFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PartnerBusinessProcessFluentHelper getAllPartnerBusinessProcess();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerBusinessProcess
     * PartnerBusinessProcess} entity using key fields.
     *
     * @param partnerBusinessProcess
     *            Partner Business Process
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerBusinessProcess
     *         PartnerBusinessProcess} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerBusinessProcessByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PartnerBusinessProcessByKeyFluentHelper getPartnerBusinessProcessByKey( final String partnerBusinessProcess );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FinancialManagementArea
     * FinancialManagementArea} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FinancialManagementArea
     *         FinancialManagementArea} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FinancialManagementAreaFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    FinancialManagementAreaFluentHelper getAllFinancialManagementArea();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FinancialManagementArea
     * FinancialManagementArea} entity using key fields.
     *
     * @param financialManagementArea
     *            FM Area
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FinancialManagementArea
     *         FinancialManagementArea} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FinancialManagementAreaByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    FinancialManagementAreaByKeyFluentHelper getFinancialManagementAreaByKey( final String financialManagementArea );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.Fund Fund} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.Fund Fund} entities. This fluent
     *         helper allows methods which modify the underlying query to be called before executing the query itself.
     *         To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FundFluentHelper#execute execute}
     *         method on the fluent helper object.
     */
    @Nonnull
    FundFluentHelper getAllFund();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.Fund Fund} entity using
     * key fields.
     *
     * @param fund
     *            Fund
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.Fund Fund} entity using key
     *         fields. This fluent helper allows methods which modify the underlying query to be called before executing
     *         the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FundByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    FundByKeyFluentHelper getFundByKey( final String fund );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.GrantID GrantID} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.GrantID GrantID} entities. This
     *         fluent helper allows methods which modify the underlying query to be called before executing the query
     *         itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.GrantIDFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    GrantIDFluentHelper getAllGrantID();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.GrantID GrantID} entity
     * using key fields.
     *
     * @param grantID
     *            Grant
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.GrantID GrantID} entity using key
     *         fields. This fluent helper allows methods which modify the underlying query to be called before executing
     *         the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.GrantIDByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    GrantIDByKeyFluentHelper getGrantIDByKey( final String grantID );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.BudgetPeriod BudgetPeriod}
     * entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.BudgetPeriod BudgetPeriod}
     *         entities. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.BudgetPeriodFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BudgetPeriodFluentHelper getAllBudgetPeriod();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.BudgetPeriod BudgetPeriod}
     * entity using key fields.
     *
     * @param budgetPeriod
     *            Budget Period
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.BudgetPeriod BudgetPeriod} entity
     *         using key fields. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.BudgetPeriodByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BudgetPeriodByKeyFluentHelper getBudgetPeriodByKey( final String budgetPeriod );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerFund PartnerFund}
     * entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerFund PartnerFund}
     *         entities. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerFundFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PartnerFundFluentHelper getAllPartnerFund();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerFund PartnerFund}
     * entity using key fields.
     *
     * @param partnerFund
     *            Partner Fund
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerFund PartnerFund} entity
     *         using key fields. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerFundByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PartnerFundByKeyFluentHelper getPartnerFundByKey( final String partnerFund );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerGrant PartnerGrant}
     * entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerGrant PartnerGrant}
     *         entities. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerGrantFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PartnerGrantFluentHelper getAllPartnerGrant();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerGrant PartnerGrant}
     * entity using key fields.
     *
     * @param partnerGrant
     *            Partner Grant
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerGrant PartnerGrant} entity
     *         using key fields. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerGrantByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PartnerGrantByKeyFluentHelper getPartnerGrantByKey( final String partnerGrant );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerBudgetPeriod
     * PartnerBudgetPeriod} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerBudgetPeriod
     *         PartnerBudgetPeriod} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerBudgetPeriodFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PartnerBudgetPeriodFluentHelper getAllPartnerBudgetPeriod();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerBudgetPeriod
     * PartnerBudgetPeriod} entity using key fields.
     *
     * @param partnerBudgetPeriod
     *            Partner Budget Period
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerBudgetPeriod
     *         PartnerBudgetPeriod} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerBudgetPeriodByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PartnerBudgetPeriodByKeyFluentHelper getPartnerBudgetPeriodByKey( final String partnerBudgetPeriod );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FreeDefinedCurrency8
     * FreeDefinedCurrency8} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FreeDefinedCurrency8
     *         FreeDefinedCurrency8} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FreeDefinedCurrency8FluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    FreeDefinedCurrency8FluentHelper getAllFreeDefinedCurrency8();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FreeDefinedCurrency8
     * FreeDefinedCurrency8} entity using key fields.
     *
     * @param freeDefinedCurrency8_ID
     *            Freely Defined Currency 8
     *            <p>
     *            Constraints: Not nullable, Maximum length: 5
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FreeDefinedCurrency8
     *         FreeDefinedCurrency8} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FreeDefinedCurrency8ByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    FreeDefinedCurrency8ByKeyFluentHelper getFreeDefinedCurrency8ByKey( final String freeDefinedCurrency8_ID );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.QuantityIsIncomplete
     * QuantityIsIncomplete} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.QuantityIsIncomplete
     *         QuantityIsIncomplete} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.QuantityIsIncompleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    QuantityIsIncompleteFluentHelper getAllQuantityIsIncomplete();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.QuantityIsIncomplete
     * QuantityIsIncomplete} entity using key fields.
     *
     * @param quantityIsIncomplete_ID
     *            Qty Is Incomplete
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.QuantityIsIncomplete
     *         QuantityIsIncomplete} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.QuantityIsIncompleteByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    QuantityIsIncompleteByKeyFluentHelper getQuantityIsIncompleteByKey( final String quantityIsIncomplete_ID );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.IsOpenItemManaged
     * IsOpenItemManaged} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.IsOpenItemManaged
     *         IsOpenItemManaged} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.IsOpenItemManagedFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    IsOpenItemManagedFluentHelper getAllIsOpenItemManaged();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.IsOpenItemManaged
     * IsOpenItemManaged} entity using key fields.
     *
     * @param isOpenItemManaged_ID
     *            Open Item Management
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.IsOpenItemManaged
     *         IsOpenItemManaged} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.IsOpenItemManagedByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    IsOpenItemManagedByKeyFluentHelper getIsOpenItemManagedByKey( final String isOpenItemManaged_ID );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CorporateGroupAccount
     * CorporateGroupAccount} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CorporateGroupAccount
     *         CorporateGroupAccount} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CorporateGroupAccountFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CorporateGroupAccountFluentHelper getAllCorporateGroupAccount();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CorporateGroupAccount
     * CorporateGroupAccount} entity using key fields.
     *
     * @param corporateGroupChartOfAccounts
     *            Group Account Number (Group Chart of Accts)
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param corporateGroupAccount_ID
     *            Group Account Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CorporateGroupAccount
     *         CorporateGroupAccount} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CorporateGroupAccountByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CorporateGroupAccountByKeyFluentHelper getCorporateGroupAccountByKey(
        final String corporateGroupAccount_ID,
        final String corporateGroupChartOfAccounts );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CorporateGroupChartOfAccounts
     * CorporateGroupChartOfAccounts} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CorporateGroupChartOfAccounts
     *         CorporateGroupChartOfAccounts} entities. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CorporateGroupChartOfAccountsFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CorporateGroupChartOfAccountsFluentHelper getAllCorporateGroupChartOfAccounts();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CorporateGroupChartOfAccounts
     * CorporateGroupChartOfAccounts} entity using key fields.
     *
     * @param corporateGroupChartOfAccounts_ID
     *            Group Chart of Accts
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CorporateGroupChartOfAccounts
     *         CorporateGroupChartOfAccounts} entity using key fields. This fluent helper allows methods which modify
     *         the underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CorporateGroupChartOfAccountsByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CorporateGroupChartOfAccountsByKeyFluentHelper
        getCorporateGroupChartOfAccountsByKey( final String corporateGroupChartOfAccounts_ID );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FreeDefinedCurrency2
     * FreeDefinedCurrency2} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FreeDefinedCurrency2
     *         FreeDefinedCurrency2} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FreeDefinedCurrency2FluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    FreeDefinedCurrency2FluentHelper getAllFreeDefinedCurrency2();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FreeDefinedCurrency2
     * FreeDefinedCurrency2} entity using key fields.
     *
     * @param freeDefinedCurrency2_ID
     *            Freely Defined Currency 2
     *            <p>
     *            Constraints: Not nullable, Maximum length: 5
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FreeDefinedCurrency2
     *         FreeDefinedCurrency2} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FreeDefinedCurrency2ByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    FreeDefinedCurrency2ByKeyFluentHelper getFreeDefinedCurrency2ByKey( final String freeDefinedCurrency2_ID );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerProfitCenter
     * PartnerProfitCenter} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerProfitCenter
     *         PartnerProfitCenter} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerProfitCenterFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PartnerProfitCenterFluentHelper getAllPartnerProfitCenter();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerProfitCenter
     * PartnerProfitCenter} entity using key fields.
     *
     * @param partnerProfitCenter_ID
     *            Partner Profit Center
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param controllingArea
     *            Partner Profit Center (Controlling Area)
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerProfitCenter
     *         PartnerProfitCenter} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerProfitCenterByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PartnerProfitCenterByKeyFluentHelper
        getPartnerProfitCenterByKey( final String partnerProfitCenter_ID, final String controllingArea );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerControllingObjectClass
     * PartnerControllingObjectClass} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerControllingObjectClass
     *         PartnerControllingObjectClass} entities. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerControllingObjectClassFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PartnerControllingObjectClassFluentHelper getAllPartnerControllingObjectClass();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerControllingObjectClass
     * PartnerControllingObjectClass} entity using key fields.
     *
     * @param partnerControllingObjectClass_ID
     *            Partner Controlling Object Class
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerControllingObjectClass
     *         PartnerControllingObjectClass} entity using key fields. This fluent helper allows methods which modify
     *         the underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerControllingObjectClassByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PartnerControllingObjectClassByKeyFluentHelper
        getPartnerControllingObjectClassByKey( final String partnerControllingObjectClass_ID );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.GLAccount_2 GLAccount_2}
     * entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.GLAccount_2 GLAccount_2}
     *         entities. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.GLAccount_2FluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    GLAccount_2FluentHelper getAllGLAccount_2();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.GLAccount_2 GLAccount_2}
     * entity using key fields.
     *
     * @param gLAccountType_ID
     *            G/L Account Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.GLAccount_2 GLAccount_2} entity
     *         using key fields. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.GLAccount_2ByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    GLAccount_2ByKeyFluentHelper getGLAccount_2ByKey( final String gLAccountType_ID );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.AccountingDocumentCategory
     * AccountingDocumentCategory} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.AccountingDocumentCategory
     *         AccountingDocumentCategory} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.AccountingDocumentCategoryFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    AccountingDocumentCategoryFluentHelper getAllAccountingDocumentCategory();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.AccountingDocumentCategory
     * AccountingDocumentCategory} entity using key fields.
     *
     * @param accountingDocumentCategory_ID
     *            Journal Entry Category
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.AccountingDocumentCategory
     *         AccountingDocumentCategory} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.AccountingDocumentCategoryByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    AccountingDocumentCategoryByKeyFluentHelper
        getAccountingDocumentCategoryByKey( final String accountingDocumentCategory_ID );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.BusinessTransaction
     * BusinessTransaction} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.BusinessTransaction
     *         BusinessTransaction} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.BusinessTransactionFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusinessTransactionFluentHelper getAllBusinessTransaction();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.BusinessTransaction
     * BusinessTransaction} entity using key fields.
     *
     * @param businessTransactionType_ID
     *            Business Transaction Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.BusinessTransaction
     *         BusinessTransaction} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.BusinessTransactionByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusinessTransactionByKeyFluentHelper getBusinessTransactionByKey( final String businessTransactionType_ID );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CalendarMonth
     * CalendarMonth} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CalendarMonth CalendarMonth}
     *         entities. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CalendarMonthFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CalendarMonthFluentHelper getAllCalendarMonth();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CalendarMonth
     * CalendarMonth} entity using key fields.
     *
     * @param calendarMonth_ID
     *            Calendar Month
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CalendarMonth CalendarMonth}
     *         entity using key fields. This fluent helper allows methods which modify the underlying query to be called
     *         before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CalendarMonthByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CalendarMonthByKeyFluentHelper getCalendarMonthByKey( final String calendarMonth_ID );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CalendarQuarter
     * CalendarQuarter} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CalendarQuarter CalendarQuarter}
     *         entities. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CalendarQuarterFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CalendarQuarterFluentHelper getAllCalendarQuarter();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CalendarQuarter
     * CalendarQuarter} entity using key fields.
     *
     * @param calendarQuarter_ID
     *            Calendar Quarter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CalendarQuarter CalendarQuarter}
     *         entity using key fields. This fluent helper allows methods which modify the underlying query to be called
     *         before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CalendarQuarterByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CalendarQuarterByKeyFluentHelper getCalendarQuarterByKey( final String calendarQuarter_ID );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ClearingAccountingDocument
     * ClearingAccountingDocument} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ClearingAccountingDocument
     *         ClearingAccountingDocument} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ClearingAccountingDocumentFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ClearingAccountingDocumentFluentHelper getAllClearingAccountingDocument();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ClearingAccountingDocument
     * ClearingAccountingDocument} entity using key fields.
     *
     * @param companyCode
     *            Clearing Journal Entry (Deprecated) (Company Code)
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param clearingAccountingDocument_ID
     *            Clearing Journal Entry (Deprecated)
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param fiscalYear
     *            Clearing Journal Entry (Deprecated) (Fiscal Year)
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ClearingAccountingDocument
     *         ClearingAccountingDocument} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ClearingAccountingDocumentByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ClearingAccountingDocumentByKeyFluentHelper getClearingAccountingDocumentByKey(
        final String clearingAccountingDocument_ID,
        final String companyCode,
        final String fiscalYear );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.AccountingDocument
     * AccountingDocument} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.AccountingDocument
     *         AccountingDocument} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.AccountingDocumentFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    AccountingDocumentFluentHelper getAllAccountingDocument();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.AccountingDocument
     * AccountingDocument} entity using key fields.
     *
     * @param accountingDocumentType_ID
     *            Journal Entry Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.AccountingDocument
     *         AccountingDocument} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.AccountingDocumentByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    AccountingDocumentByKeyFluentHelper getAccountingDocumentByKey( final String accountingDocumentType_ID );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FinancialAccount
     * FinancialAccount} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FinancialAccount
     *         FinancialAccount} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FinancialAccountFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    FinancialAccountFluentHelper getAllFinancialAccount();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FinancialAccount
     * FinancialAccount} entity using key fields.
     *
     * @param financialAccountType_ID
     *            Account Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FinancialAccount
     *         FinancialAccount} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FinancialAccountByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    FinancialAccountByKeyFluentHelper getFinancialAccountByKey( final String financialAccountType_ID );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.BusinessArea BusinessArea}
     * entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.BusinessArea BusinessArea}
     *         entities. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.BusinessAreaFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusinessAreaFluentHelper getAllBusinessArea();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.BusinessArea BusinessArea}
     * entity using key fields.
     *
     * @param businessArea_ID
     *            Business Area
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.BusinessArea BusinessArea} entity
     *         using key fields. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.BusinessAreaByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusinessAreaByKeyFluentHelper getBusinessAreaByKey( final String businessArea_ID );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.OriginCostCtrActivity
     * OriginCostCtrActivity} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.OriginCostCtrActivity
     *         OriginCostCtrActivity} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.OriginCostCtrActivityFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    OriginCostCtrActivityFluentHelper getAllOriginCostCtrActivity();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.OriginCostCtrActivity
     * OriginCostCtrActivity} entity using key fields.
     *
     * @param originCostCtrActivityType_ID
     *            Origin Cost Center Activity Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param controllingArea
     *            Origin Cost Center Activity Type (Controlling Area)
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.OriginCostCtrActivity
     *         OriginCostCtrActivity} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.OriginCostCtrActivityByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    OriginCostCtrActivityByKeyFluentHelper
        getOriginCostCtrActivityByKey( final String originCostCtrActivityType_ID, final String controllingArea );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ChartOfAccounts
     * ChartOfAccounts} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ChartOfAccounts ChartOfAccounts}
     *         entities. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ChartOfAccountsFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChartOfAccountsFluentHelper getAllChartOfAccounts();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ChartOfAccounts
     * ChartOfAccounts} entity using key fields.
     *
     * @param chartOfAccounts_ID
     *            Chart of Accounts
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ChartOfAccounts ChartOfAccounts}
     *         entity using key fields. This fluent helper allows methods which modify the underlying query to be called
     *         before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ChartOfAccountsByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChartOfAccountsByKeyFluentHelper getChartOfAccountsByKey( final String chartOfAccounts_ID );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ControllingArea
     * ControllingArea} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ControllingArea ControllingArea}
     *         entities. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ControllingAreaFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ControllingAreaFluentHelper getAllControllingArea();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ControllingArea
     * ControllingArea} entity using key fields.
     *
     * @param controllingArea_ID
     *            Controlling Area
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ControllingArea ControllingArea}
     *         entity using key fields. This fluent helper allows methods which modify the underlying query to be called
     *         before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ControllingAreaByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ControllingAreaByKeyFluentHelper getControllingAreaByKey( final String controllingArea_ID );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ControllingObjectClass
     * ControllingObjectClass} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ControllingObjectClass
     *         ControllingObjectClass} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ControllingObjectClassFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ControllingObjectClassFluentHelper getAllControllingObjectClass();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ControllingObjectClass
     * ControllingObjectClass} entity using key fields.
     *
     * @param controllingObjectClass_ID
     *            Controlling Object Class
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ControllingObjectClass
     *         ControllingObjectClass} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ControllingObjectClassByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ControllingObjectClassByKeyFluentHelper getControllingObjectClassByKey( final String controllingObjectClass_ID );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerCostCenter
     * PartnerCostCenter} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerCostCenter
     *         PartnerCostCenter} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerCostCenterFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PartnerCostCenterFluentHelper getAllPartnerCostCenter();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerCostCenter
     * PartnerCostCenter} entity using key fields.
     *
     * @param partnerCostCenter_ID
     *            Partner Cost Center
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param controllingArea
     *            Partner Cost Center (Controlling Area)
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerCostCenter
     *         PartnerCostCenter} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerCostCenterByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PartnerCostCenterByKeyFluentHelper
        getPartnerCostCenterByKey( final String partnerCostCenter_ID, final String controllingArea );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.DebitCreditCode
     * DebitCreditCode} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.DebitCreditCode DebitCreditCode}
     *         entities. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.DebitCreditCodeFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    DebitCreditCodeFluentHelper getAllDebitCreditCode();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.DebitCreditCode
     * DebitCreditCode} entity using key fields.
     *
     * @param debitCreditCode_ID
     *            Debit/Credit Code
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.DebitCreditCode DebitCreditCode}
     *         entity using key fields. This fluent helper allows methods which modify the underlying query to be called
     *         before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.DebitCreditCodeByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    DebitCreditCodeByKeyFluentHelper getDebitCreditCodeByKey( final String debitCreditCode_ID );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FiscalYearVariant
     * FiscalYearVariant} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FiscalYearVariant
     *         FiscalYearVariant} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FiscalYearVariantFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    FiscalYearVariantFluentHelper getAllFiscalYearVariant();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FiscalYearVariant
     * FiscalYearVariant} entity using key fields.
     *
     * @param fiscalYearVariant_ID
     *            Fiscal Year Variant
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FiscalYearVariant
     *         FiscalYearVariant} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FiscalYearVariantByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    FiscalYearVariantByKeyFluentHelper getFiscalYearVariantByKey( final String fiscalYearVariant_ID );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FunctionalArea
     * FunctionalArea} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FunctionalArea FunctionalArea}
     *         entities. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FunctionalAreaFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    FunctionalAreaFluentHelper getAllFunctionalArea();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FunctionalArea
     * FunctionalArea} entity using key fields.
     *
     * @param functionalArea_ID
     *            Functional Area
     *            <p>
     *            Constraints: Not nullable, Maximum length: 16
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FunctionalArea FunctionalArea}
     *         entity using key fields. This fluent helper allows methods which modify the underlying query to be called
     *         before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FunctionalAreaByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    FunctionalAreaByKeyFluentHelper getFunctionalAreaByKey( final String functionalArea_ID );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FiscalYear FiscalYear}
     * entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FiscalYear FiscalYear} entities.
     *         This fluent helper allows methods which modify the underlying query to be called before executing the
     *         query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FiscalYearFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    FiscalYearFluentHelper getAllFiscalYear();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FiscalYear FiscalYear}
     * entity using key fields.
     *
     * @param companyCode
     *            Fiscal Year (Company Code)
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param fiscalYear_ID
     *            Fiscal Year
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FiscalYear FiscalYear} entity
     *         using key fields. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FiscalYearByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    FiscalYearByKeyFluentHelper getFiscalYearByKey( final String fiscalYear_ID, final String companyCode );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CostCenter CostCenter}
     * entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CostCenter CostCenter} entities.
     *         This fluent helper allows methods which modify the underlying query to be called before executing the
     *         query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CostCenterFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CostCenterFluentHelper getAllCostCenter();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CostCenter CostCenter}
     * entity using key fields.
     *
     * @param costCenter_ID
     *            Cost Center
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param controllingArea
     *            Cost Center (Controlling Area)
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CostCenter CostCenter} entity
     *         using key fields. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CostCenterByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CostCenterByKeyFluentHelper getCostCenterByKey( final String costCenter_ID, final String controllingArea );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.IsReversal IsReversal}
     * entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.IsReversal IsReversal} entities.
     *         This fluent helper allows methods which modify the underlying query to be called before executing the
     *         query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.IsReversalFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    IsReversalFluentHelper getAllIsReversal();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.IsReversal IsReversal}
     * entity using key fields.
     *
     * @param isReversal_ID
     *            Is Reversing
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.IsReversal IsReversal} entity
     *         using key fields. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.IsReversalByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    IsReversalByKeyFluentHelper getIsReversalByKey( final String isReversal_ID );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.IsReversed IsReversed}
     * entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.IsReversed IsReversed} entities.
     *         This fluent helper allows methods which modify the underlying query to be called before executing the
     *         query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.IsReversedFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    IsReversedFluentHelper getAllIsReversed();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.IsReversed IsReversed}
     * entity using key fields.
     *
     * @param isReversed_ID
     *            Is Reversed
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.IsReversed IsReversed} entity
     *         using key fields. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.IsReversedByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    IsReversedByKeyFluentHelper getIsReversedByKey( final String isReversed_ID );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.IsSettled IsSettled}
     * entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.IsSettled IsSettled} entities.
     *         This fluent helper allows methods which modify the underlying query to be called before executing the
     *         query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.IsSettledFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    IsSettledFluentHelper getAllIsSettled();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.IsSettled IsSettled}
     * entity using key fields.
     *
     * @param isSettled_ID
     *            Is Settled
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.IsSettled IsSettled} entity using
     *         key fields. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.IsSettledByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    IsSettledByKeyFluentHelper getIsSettledByKey( final String isSettled_ID );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.IsSettlement IsSettlement}
     * entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.IsSettlement IsSettlement}
     *         entities. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.IsSettlementFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    IsSettlementFluentHelper getAllIsSettlement();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.IsSettlement IsSettlement}
     * entity using key fields.
     *
     * @param isSettlement_ID
     *            Is Settling
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.IsSettlement IsSettlement} entity
     *         using key fields. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.IsSettlementByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    IsSettlementByKeyFluentHelper getIsSettlementByKey( final String isSettlement_ID );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SalesOrder SalesOrder}
     * entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SalesOrder SalesOrder} entities.
     *         This fluent helper allows methods which modify the underlying query to be called before executing the
     *         query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SalesOrderFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesOrderFluentHelper getAllSalesOrder();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SalesOrder SalesOrder}
     * entity using key fields.
     *
     * @param salesOrder_ID
     *            Sales Order
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SalesOrder SalesOrder} entity
     *         using key fields. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SalesOrderByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesOrderByKeyFluentHelper getSalesOrderByKey( final String salesOrder_ID );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.WBSElement WBSElement}
     * entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.WBSElement WBSElement} entities.
     *         This fluent helper allows methods which modify the underlying query to be called before executing the
     *         query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.WBSElementFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    WBSElementFluentHelper getAllWBSElement();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.WBSElement WBSElement}
     * entity using key fields.
     *
     * @param wBSElement_ID
     *            WBS Element
     *            <p>
     *            Constraints: Not nullable, Maximum length: 24
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.WBSElement WBSElement} entity
     *         using key fields. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.WBSElementByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    WBSElementByKeyFluentHelper getWBSElementByKey( final String wBSElement_ID );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.HouseBank HouseBank}
     * entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.HouseBank HouseBank} entities.
     *         This fluent helper allows methods which modify the underlying query to be called before executing the
     *         query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.HouseBankFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    HouseBankFluentHelper getAllHouseBank();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.HouseBank HouseBank}
     * entity using key fields.
     *
     * @param companyCode
     *            House Bank (Company Code)
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param houseBank_ID
     *            House Bank
     *            <p>
     *            Constraints: Not nullable, Maximum length: 5
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.HouseBank HouseBank} entity using
     *         key fields. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.HouseBankByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    HouseBankByKeyFluentHelper getHouseBankByKey( final String houseBank_ID, final String companyCode );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.InventorySpecialStockValn
     * InventorySpecialStockValn} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.InventorySpecialStockValn
     *         InventorySpecialStockValn} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.InventorySpecialStockValnFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    InventorySpecialStockValnFluentHelper getAllInventorySpecialStockValn();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.InventorySpecialStockValn
     * InventorySpecialStockValn} entity using key fields.
     *
     * @param inventorySpecialStockValnType_ID
     *            Inv. Special Stock Val. Type -Deprecated
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.InventorySpecialStockValn
     *         InventorySpecialStockValn} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.InventorySpecialStockValnByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    InventorySpecialStockValnByKeyFluentHelper
        getInventorySpecialStockValnByKey( final String inventorySpecialStockValnType_ID );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MasterFixedAsset
     * MasterFixedAsset} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MasterFixedAsset
     *         MasterFixedAsset} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MasterFixedAssetFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MasterFixedAssetFluentHelper getAllMasterFixedAsset();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MasterFixedAsset
     * MasterFixedAsset} entity using key fields.
     *
     * @param companyCode
     *            Fixed Asset (Company Code)
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param masterFixedAsset_ID
     *            Fixed Asset
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MasterFixedAsset
     *         MasterFixedAsset} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MasterFixedAssetByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MasterFixedAssetByKeyFluentHelper
        getMasterFixedAssetByKey( final String masterFixedAsset_ID, final String companyCode );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PostingKey PostingKey}
     * entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PostingKey PostingKey} entities.
     *         This fluent helper allows methods which modify the underlying query to be called before executing the
     *         query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PostingKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PostingKeyFluentHelper getAllPostingKey();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PostingKey PostingKey}
     * entity using key fields.
     *
     * @param postingKey_ID
     *            Posting Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PostingKey PostingKey} entity
     *         using key fields. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PostingKeyByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PostingKeyByKeyFluentHelper getPostingKeyByKey( final String postingKey_ID );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ProfitCenter ProfitCenter}
     * entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ProfitCenter ProfitCenter}
     *         entities. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ProfitCenterFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProfitCenterFluentHelper getAllProfitCenter();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ProfitCenter ProfitCenter}
     * entity using key fields.
     *
     * @param profitCenter_ID
     *            Profit Center
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param controllingArea
     *            Profit Center (Controlling Area)
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ProfitCenter ProfitCenter} entity
     *         using key fields. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ProfitCenterByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProfitCenterByKeyFluentHelper getProfitCenterByKey( final String profitCenter_ID, final String controllingArea );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.Segment Segment} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.Segment Segment} entities. This
     *         fluent helper allows methods which modify the underlying query to be called before executing the query
     *         itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SegmentFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SegmentFluentHelper getAllSegment();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.Segment Segment} entity
     * using key fields.
     *
     * @param segment_ID
     *            Segment
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.Segment Segment} entity using key
     *         fields. This fluent helper allows methods which modify the underlying query to be called before executing
     *         the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SegmentByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SegmentByKeyFluentHelper getSegmentByKey( final String segment_ID );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SpecialGLCode
     * SpecialGLCode} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SpecialGLCode SpecialGLCode}
     *         entities. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SpecialGLCodeFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SpecialGLCodeFluentHelper getAllSpecialGLCode();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SpecialGLCode
     * SpecialGLCode} entity using key fields.
     *
     * @param financialAccountType
     *            Special G/L (Account Type)
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     * @param specialGLCode_ID
     *            Special G/L
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SpecialGLCode SpecialGLCode}
     *         entity using key fields. This fluent helper allows methods which modify the underlying query to be called
     *         before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SpecialGLCodeByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SpecialGLCodeByKeyFluentHelper
        getSpecialGLCodeByKey( final String specialGLCode_ID, final String financialAccountType );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FinancialTransaction
     * FinancialTransaction} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FinancialTransaction
     *         FinancialTransaction} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FinancialTransactionFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    FinancialTransactionFluentHelper getAllFinancialTransaction();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FinancialTransaction
     * FinancialTransaction} entity using key fields.
     *
     * @param financialTransactionType_ID
     *            Financial Transaction Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FinancialTransaction
     *         FinancialTransaction} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FinancialTransactionByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    FinancialTransactionByKeyFluentHelper getFinancialTransactionByKey( final String financialTransactionType_ID );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FixedAsset FixedAsset}
     * entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FixedAsset FixedAsset} entities.
     *         This fluent helper allows methods which modify the underlying query to be called before executing the
     *         query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FixedAssetFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    FixedAssetFluentHelper getAllFixedAsset();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FixedAsset FixedAsset}
     * entity using key fields.
     *
     * @param companyCode
     *            Asset Subnumber (Company Code)
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param masterFixedAsset
     *            Asset Subnumber (Fixed Asset)
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     * @param fixedAsset_ID
     *            Asset Subnumber
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FixedAsset FixedAsset} entity
     *         using key fields. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FixedAssetByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    FixedAssetByKeyFluentHelper
        getFixedAssetByKey( final String fixedAsset_ID, final String companyCode, final String masterFixedAsset );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.HouseBankAccount
     * HouseBankAccount} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.HouseBankAccount
     *         HouseBankAccount} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.HouseBankAccountFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    HouseBankAccountFluentHelper getAllHouseBankAccount();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.HouseBankAccount
     * HouseBankAccount} entity using key fields.
     *
     * @param companyCode
     *            House Bank Account (Company Code)
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param houseBankAccount_ID
     *            House Bank Account
     *            <p>
     *            Constraints: Not nullable, Maximum length: 5
     *            </p>
     * @param houseBank
     *            House Bank Account (House Bank)
     *            <p>
     *            Constraints: Not nullable, Maximum length: 5
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.HouseBankAccount
     *         HouseBankAccount} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.HouseBankAccountByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    HouseBankAccountByKeyFluentHelper
        getHouseBankAccountByKey( final String houseBankAccount_ID, final String companyCode, final String houseBank );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.InventorySpecialStock
     * InventorySpecialStock} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.InventorySpecialStock
     *         InventorySpecialStock} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.InventorySpecialStockFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    InventorySpecialStockFluentHelper getAllInventorySpecialStock();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.InventorySpecialStock
     * InventorySpecialStock} entity using key fields.
     *
     * @param inventorySpecialStockType_ID
     *            Inventory Special Stock Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.InventorySpecialStock
     *         InventorySpecialStock} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.InventorySpecialStockByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    InventorySpecialStockByKeyFluentHelper getInventorySpecialStockByKey( final String inventorySpecialStockType_ID );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.AlternativeGLAccount
     * AlternativeGLAccount} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.AlternativeGLAccount
     *         AlternativeGLAccount} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.AlternativeGLAccountFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    AlternativeGLAccountFluentHelper getAllAlternativeGLAccount();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.AlternativeGLAccount
     * AlternativeGLAccount} entity using key fields.
     *
     * @param countryChartOfAccounts
     *            Alternative G/L Account (Alternative Chart of Accounts)
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param alternativeGLAccount_ID
     *            Alternative G/L Account
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.AlternativeGLAccount
     *         AlternativeGLAccount} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.AlternativeGLAccountByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    AlternativeGLAccountByKeyFluentHelper
        getAlternativeGLAccountByKey( final String alternativeGLAccount_ID, final String countryChartOfAccounts );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.Material Material}
     * entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.Material Material} entities. This
     *         fluent helper allows methods which modify the underlying query to be called before executing the query
     *         itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaterialFluentHelper getAllMaterial();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.Material Material} entity
     * using key fields.
     *
     * @param material_ID
     *            Product (Deprecated)
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.Material Material} entity using
     *         key fields. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaterialByKeyFluentHelper getMaterialByKey( final String material_ID );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroup
     * MaterialGroup} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroup MaterialGroup}
     *         entities. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaterialGroupFluentHelper getAllMaterialGroup();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroup
     * MaterialGroup} entity using key fields.
     *
     * @param materialGroup_ID
     *            Product Sold Group (Deprecated)
     *            <p>
     *            Constraints: Not nullable, Maximum length: 9
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroup MaterialGroup}
     *         entity using key fields. This fluent helper allows methods which modify the underlying query to be called
     *         before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.MaterialGroupByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaterialGroupByKeyFluentHelper getMaterialGroupByKey( final String materialGroup_ID );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.Plant Plant} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.Plant Plant} entities. This
     *         fluent helper allows methods which modify the underlying query to be called before executing the query
     *         itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PlantFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PlantFluentHelper getAllPlant();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.Plant Plant} entity using
     * key fields.
     *
     * @param plant_ID
     *            Plant
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.Plant Plant} entity using key
     *         fields. This fluent helper allows methods which modify the underlying query to be called before executing
     *         the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PlantByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PlantByKeyFluentHelper getPlantByKey( final String plant_ID );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.OrderCategory
     * OrderCategory} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.OrderCategory OrderCategory}
     *         entities. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.OrderCategoryFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    OrderCategoryFluentHelper getAllOrderCategory();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.OrderCategory
     * OrderCategory} entity using key fields.
     *
     * @param orderCategory_ID
     *            Order Category
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.OrderCategory OrderCategory}
     *         entity using key fields. This fluent helper allows methods which modify the underlying query to be called
     *         before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.OrderCategoryByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    OrderCategoryByKeyFluentHelper getOrderCategoryByKey( final String orderCategory_ID );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.Product Product} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.Product Product} entities. This
     *         fluent helper allows methods which modify the underlying query to be called before executing the query
     *         itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ProductFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductFluentHelper getAllProduct();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.Product Product} entity
     * using key fields.
     *
     * @param product_ID
     *            Product
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.Product Product} entity using key
     *         fields. This fluent helper allows methods which modify the underlying query to be called before executing
     *         the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ProductByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductByKeyFluentHelper getProductByKey( final String product_ID );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ProductGroup ProductGroup}
     * entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ProductGroup ProductGroup}
     *         entities. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ProductGroupFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductGroupFluentHelper getAllProductGroup();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ProductGroup ProductGroup}
     * entity using key fields.
     *
     * @param productGroup_ID
     *            Product Group
     *            <p>
     *            Constraints: Not nullable, Maximum length: 9
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ProductGroup ProductGroup} entity
     *         using key fields. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ProductGroupByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductGroupByKeyFluentHelper getProductGroupByKey( final String productGroup_ID );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ValuationArea
     * ValuationArea} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ValuationArea ValuationArea}
     *         entities. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ValuationAreaFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ValuationAreaFluentHelper getAllValuationArea();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ValuationArea
     * ValuationArea} entity using key fields.
     *
     * @param valuationArea_ID
     *            Valuation Area
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ValuationArea ValuationArea}
     *         entity using key fields. This fluent helper allows methods which modify the underlying query to be called
     *         before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ValuationAreaByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ValuationAreaByKeyFluentHelper getValuationAreaByKey( final String valuationArea_ID );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CustomerGroup
     * CustomerGroup} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CustomerGroup CustomerGroup}
     *         entities. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CustomerGroupFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustomerGroupFluentHelper getAllCustomerGroup();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CustomerGroup
     * CustomerGroup} entity using key fields.
     *
     * @param customerGroup_ID
     *            Customer Group
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CustomerGroup CustomerGroup}
     *         entity using key fields. This fluent helper allows methods which modify the underlying query to be called
     *         before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CustomerGroupByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustomerGroupByKeyFluentHelper getCustomerGroupByKey( final String customerGroup_ID );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.InventorySpclStkSalesDocument
     * InventorySpclStkSalesDocument} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.InventorySpclStkSalesDocument
     *         InventorySpclStkSalesDocument} entities. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.InventorySpclStkSalesDocumentFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    InventorySpclStkSalesDocumentFluentHelper getAllInventorySpclStkSalesDocument();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.InventorySpclStkSalesDocument
     * InventorySpclStkSalesDocument} entity using key fields.
     *
     * @param inventorySpclStkSalesDocument_ID
     *            Inventory Special Stock Sales Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.InventorySpclStkSalesDocument
     *         InventorySpclStkSalesDocument} entity using key fields. This fluent helper allows methods which modify
     *         the underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.InventorySpclStkSalesDocumentByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    InventorySpclStkSalesDocumentByKeyFluentHelper
        getInventorySpclStkSalesDocumentByKey( final String inventorySpclStkSalesDocument_ID );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.InventorySpclStkSalesDocItm
     * InventorySpclStkSalesDocItm} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.InventorySpclStkSalesDocItm
     *         InventorySpclStkSalesDocItm} entities. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.InventorySpclStkSalesDocItmFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    InventorySpclStkSalesDocItmFluentHelper getAllInventorySpclStkSalesDocItm();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.InventorySpclStkSalesDocItm
     * InventorySpclStkSalesDocItm} entity using key fields.
     *
     * @param inventorySpclStkSalesDocument
     *            Inventory Spcl Stock Sales Document Item (Inventory Special Stock Sales Document)
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param inventorySpclStkSalesDocItm_ID
     *            Inventory Spcl Stock Sales Document Item
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.InventorySpclStkSalesDocItm
     *         InventorySpclStkSalesDocItm} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.InventorySpclStkSalesDocItmByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    InventorySpclStkSalesDocItmByKeyFluentHelper getInventorySpclStkSalesDocItmByKey(
        final String inventorySpclStkSalesDocItm_ID,
        final String inventorySpclStkSalesDocument );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.InvtrySpclStockWBSElmntIntID
     * InvtrySpclStockWBSElmntIntID} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.InvtrySpclStockWBSElmntIntID
     *         InvtrySpclStockWBSElmntIntID} entities. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.InvtrySpclStockWBSElmntIntIDFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    InvtrySpclStockWBSElmntIntIDFluentHelper getAllInvtrySpclStockWBSElmntIntID();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.InvtrySpclStockWBSElmntIntID
     * InvtrySpclStockWBSElmntIntID} entity using key fields.
     *
     * @param invtrySpclStockWBSElmntIntID_ID
     *            Inv. Special Stock WBS Element Int. ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.InvtrySpclStockWBSElmntIntID
     *         InvtrySpclStockWBSElmntIntID} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.InvtrySpclStockWBSElmntIntIDByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    InvtrySpclStockWBSElmntIntIDByKeyFluentHelper
        getInvtrySpclStockWBSElmntIntIDByKey( final String invtrySpclStockWBSElmntIntID_ID );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.InventorySpclStockWBSElement
     * InventorySpclStockWBSElement} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.InventorySpclStockWBSElement
     *         InventorySpclStockWBSElement} entities. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.InventorySpclStockWBSElementFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    InventorySpclStockWBSElementFluentHelper getAllInventorySpclStockWBSElement();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.InventorySpclStockWBSElement
     * InventorySpclStockWBSElement} entity using key fields.
     *
     * @param inventorySpclStockWBSElement_ID
     *            WBSElem of Inventory
     *            <p>
     *            Constraints: Not nullable, Maximum length: 24
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.InventorySpclStockWBSElement
     *         InventorySpclStockWBSElement} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.InventorySpclStockWBSElementByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    InventorySpclStockWBSElementByKeyFluentHelper
        getInventorySpclStockWBSElementByKey( final String inventorySpclStockWBSElement_ID );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CalendarYearMonth
     * CalendarYearMonth} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CalendarYearMonth
     *         CalendarYearMonth} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CalendarYearMonthFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CalendarYearMonthFluentHelper getAllCalendarYearMonth();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CalendarYearMonth
     * CalendarYearMonth} entity using key fields.
     *
     * @param calendarYearMonth_ID
     *            Year Month
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CalendarYearMonth
     *         CalendarYearMonth} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CalendarYearMonthByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CalendarYearMonthByKeyFluentHelper getCalendarYearMonthByKey( final String calendarYearMonth_ID );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.Customer Customer}
     * entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.Customer Customer} entities. This
     *         fluent helper allows methods which modify the underlying query to be called before executing the query
     *         itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CustomerFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustomerFluentHelper getAllCustomer();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.Customer Customer} entity
     * using key fields.
     *
     * @param customer_ID
     *            Customer
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.Customer Customer} entity using
     *         key fields. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CustomerByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustomerByKeyFluentHelper getCustomerByKey( final String customer_ID );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.Supplier Supplier}
     * entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.Supplier Supplier} entities. This
     *         fluent helper allows methods which modify the underlying query to be called before executing the query
     *         itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SupplierFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SupplierFluentHelper getAllSupplier();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.Supplier Supplier} entity
     * using key fields.
     *
     * @param supplier_ID
     *            Supplier
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.Supplier Supplier} entity using
     *         key fields. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SupplierByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SupplierByKeyFluentHelper getSupplierByKey( final String supplier_ID );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.BalanceTransactionCurrency
     * BalanceTransactionCurrency} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.BalanceTransactionCurrency
     *         BalanceTransactionCurrency} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.BalanceTransactionCurrencyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BalanceTransactionCurrencyFluentHelper getAllBalanceTransactionCurrency();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.BalanceTransactionCurrency
     * BalanceTransactionCurrency} entity using key fields.
     *
     * @param balanceTransactionCurrency_ID
     *            Balance Transaction Currency
     *            <p>
     *            Constraints: Not nullable, Maximum length: 5
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.BalanceTransactionCurrency
     *         BalanceTransactionCurrency} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.BalanceTransactionCurrencyByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BalanceTransactionCurrencyByKeyFluentHelper
        getBalanceTransactionCurrencyByKey( final String balanceTransactionCurrency_ID );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.WBSElementExternalID
     * WBSElementExternalID} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.WBSElementExternalID
     *         WBSElementExternalID} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.WBSElementExternalIDFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    WBSElementExternalIDFluentHelper getAllWBSElementExternalID();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.WBSElementExternalID
     * WBSElementExternalID} entity using key fields.
     *
     * @param wBSElementExternalID_ID
     *            WBS Element External ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 24
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.WBSElementExternalID
     *         WBSElementExternalID} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.WBSElementExternalIDByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    WBSElementExternalIDByKeyFluentHelper getWBSElementExternalIDByKey( final String wBSElementExternalID_ID );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.IsBalanceSheetAccount
     * IsBalanceSheetAccount} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.IsBalanceSheetAccount
     *         IsBalanceSheetAccount} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.IsBalanceSheetAccountFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    IsBalanceSheetAccountFluentHelper getAllIsBalanceSheetAccount();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.IsBalanceSheetAccount
     * IsBalanceSheetAccount} entity using key fields.
     *
     * @param isBalanceSheetAccount_ID
     *            Balance sheet acct
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.IsBalanceSheetAccount
     *         IsBalanceSheetAccount} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.IsBalanceSheetAccountByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    IsBalanceSheetAccountByKeyFluentHelper getIsBalanceSheetAccountByKey( final String isBalanceSheetAccount_ID );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ReferenceDocument
     * ReferenceDocument} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ReferenceDocument
     *         ReferenceDocument} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ReferenceDocumentFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ReferenceDocumentFluentHelper getAllReferenceDocument();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ReferenceDocument
     * ReferenceDocument} entity using key fields.
     *
     * @param referenceDocumentType_ID
     *            Reference Document Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 5
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ReferenceDocument
     *         ReferenceDocument} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ReferenceDocumentByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ReferenceDocumentByKeyFluentHelper getReferenceDocumentByKey( final String referenceDocumentType_ID );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.GroupFixedAsset
     * GroupFixedAsset} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.GroupFixedAsset GroupFixedAsset}
     *         entities. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.GroupFixedAssetFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    GroupFixedAssetFluentHelper getAllGroupFixedAsset();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.GroupFixedAsset
     * GroupFixedAsset} entity using key fields.
     *
     * @param companyCode
     *            Group Asset Subnmbr (Company Code)
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param groupFixedAsset_ID
     *            Group Asset Subnmbr
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param groupMasterFixedAsset
     *            Group Asset Subnmbr (Group Asset)
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.GroupFixedAsset GroupFixedAsset}
     *         entity using key fields. This fluent helper allows methods which modify the underlying query to be called
     *         before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.GroupFixedAssetByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    GroupFixedAssetByKeyFluentHelper getGroupFixedAssetByKey(
        final String groupFixedAsset_ID,
        final String companyCode,
        final String groupMasterFixedAsset );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerSegment
     * PartnerSegment} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerSegment PartnerSegment}
     *         entities. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerSegmentFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PartnerSegmentFluentHelper getAllPartnerSegment();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerSegment
     * PartnerSegment} entity using key fields.
     *
     * @param partnerSegment_ID
     *            Partner Segment
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerSegment PartnerSegment}
     *         entity using key fields. This fluent helper allows methods which modify the underlying query to be called
     *         before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerSegmentByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PartnerSegmentByKeyFluentHelper getPartnerSegmentByKey( final String partnerSegment_ID );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ClearingJournalEntry
     * ClearingJournalEntry} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ClearingJournalEntry
     *         ClearingJournalEntry} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ClearingJournalEntryFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ClearingJournalEntryFluentHelper getAllClearingJournalEntry();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ClearingJournalEntry
     * ClearingJournalEntry} entity using key fields.
     *
     * @param companyCode
     *            Clearing Journal Entry (Company Code)
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param clearingJournalEntry_ID
     *            Clearing Journal Entry
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param clearingJournalEntryFiscalYear
     *            Clearing Journal Entry (Fiscal Year of Clearing Journal Entry)
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ClearingJournalEntry
     *         ClearingJournalEntry} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ClearingJournalEntryByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ClearingJournalEntryByKeyFluentHelper getClearingJournalEntryByKey(
        final String clearingJournalEntry_ID,
        final String companyCode,
        final String clearingJournalEntryFiscalYear );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.OperatingConcern
     * OperatingConcern} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.OperatingConcern
     *         OperatingConcern} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.OperatingConcernFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    OperatingConcernFluentHelper getAllOperatingConcern();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.OperatingConcern
     * OperatingConcern} entity using key fields.
     *
     * @param operatingConcern_ID
     *            Operating Concern
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.OperatingConcern
     *         OperatingConcern} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.OperatingConcernByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    OperatingConcernByKeyFluentHelper getOperatingConcernByKey( final String operatingConcern_ID );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.InvtrySpclStockWBSElmntExtID
     * InvtrySpclStockWBSElmntExtID} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.InvtrySpclStockWBSElmntExtID
     *         InvtrySpclStockWBSElmntExtID} entities. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.InvtrySpclStockWBSElmntExtIDFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    InvtrySpclStockWBSElmntExtIDFluentHelper getAllInvtrySpclStockWBSElmntExtID();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.InvtrySpclStockWBSElmntExtID
     * InvtrySpclStockWBSElmntExtID} entity using key fields.
     *
     * @param invtrySpclStockWBSElmntExtID_ID
     *            Inventory WBS Element External ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 24
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.InvtrySpclStockWBSElmntExtID
     *         InvtrySpclStockWBSElmntExtID} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.InvtrySpclStockWBSElmntExtIDByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    InvtrySpclStockWBSElmntExtIDByKeyFluentHelper
        getInvtrySpclStockWBSElmntExtIDByKey( final String invtrySpclStockWBSElmntExtID_ID );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CountryChartOfAccounts
     * CountryChartOfAccounts} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CountryChartOfAccounts
     *         CountryChartOfAccounts} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CountryChartOfAccountsFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CountryChartOfAccountsFluentHelper getAllCountryChartOfAccounts();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CountryChartOfAccounts
     * CountryChartOfAccounts} entity using key fields.
     *
     * @param countryChartOfAccounts_ID
     *            Alternative Chart of Accounts
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CountryChartOfAccounts
     *         CountryChartOfAccounts} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CountryChartOfAccountsByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CountryChartOfAccountsByKeyFluentHelper getCountryChartOfAccountsByKey( final String countryChartOfAccounts_ID );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FreeDefinedCurrency6
     * FreeDefinedCurrency6} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FreeDefinedCurrency6
     *         FreeDefinedCurrency6} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FreeDefinedCurrency6FluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    FreeDefinedCurrency6FluentHelper getAllFreeDefinedCurrency6();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FreeDefinedCurrency6
     * FreeDefinedCurrency6} entity using key fields.
     *
     * @param freeDefinedCurrency6_ID
     *            Freely Defined Currency 6
     *            <p>
     *            Constraints: Not nullable, Maximum length: 5
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FreeDefinedCurrency6
     *         FreeDefinedCurrency6} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FreeDefinedCurrency6ByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    FreeDefinedCurrency6ByKeyFluentHelper getFreeDefinedCurrency6ByKey( final String freeDefinedCurrency6_ID );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TransactionCurrency
     * TransactionCurrency} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TransactionCurrency
     *         TransactionCurrency} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TransactionCurrencyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    TransactionCurrencyFluentHelper getAllTransactionCurrency();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TransactionCurrency
     * TransactionCurrency} entity using key fields.
     *
     * @param transactionCurrency_ID
     *            Transaction Currency
     *            <p>
     *            Constraints: Not nullable, Maximum length: 5
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TransactionCurrency
     *         TransactionCurrency} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TransactionCurrencyByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    TransactionCurrencyByKeyFluentHelper getTransactionCurrencyByKey( final String transactionCurrency_ID );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SalesDocument
     * SalesDocument} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SalesDocument SalesDocument}
     *         entities. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SalesDocumentFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesDocumentFluentHelper getAllSalesDocument();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SalesDocument
     * SalesDocument} entity using key fields.
     *
     * @param salesDocument_ID
     *            Sales Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SalesDocument SalesDocument}
     *         entity using key fields. This fluent helper allows methods which modify the underlying query to be called
     *         before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SalesDocumentByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesDocumentByKeyFluentHelper getSalesDocumentByKey( final String salesDocument_ID );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FreeDefinedCurrency1
     * FreeDefinedCurrency1} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FreeDefinedCurrency1
     *         FreeDefinedCurrency1} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FreeDefinedCurrency1FluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    FreeDefinedCurrency1FluentHelper getAllFreeDefinedCurrency1();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FreeDefinedCurrency1
     * FreeDefinedCurrency1} entity using key fields.
     *
     * @param freeDefinedCurrency1_ID
     *            Freely Defined Currency 1
     *            <p>
     *            Constraints: Not nullable, Maximum length: 5
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FreeDefinedCurrency1
     *         FreeDefinedCurrency1} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FreeDefinedCurrency1ByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    FreeDefinedCurrency1ByKeyFluentHelper getFreeDefinedCurrency1ByKey( final String freeDefinedCurrency1_ID );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FreeDefinedCurrency3
     * FreeDefinedCurrency3} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FreeDefinedCurrency3
     *         FreeDefinedCurrency3} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FreeDefinedCurrency3FluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    FreeDefinedCurrency3FluentHelper getAllFreeDefinedCurrency3();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FreeDefinedCurrency3
     * FreeDefinedCurrency3} entity using key fields.
     *
     * @param freeDefinedCurrency3_ID
     *            Freely Defined Currency 3
     *            <p>
     *            Constraints: Not nullable, Maximum length: 5
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FreeDefinedCurrency3
     *         FreeDefinedCurrency3} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FreeDefinedCurrency3ByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    FreeDefinedCurrency3ByKeyFluentHelper getFreeDefinedCurrency3ByKey( final String freeDefinedCurrency3_ID );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.AssetTransaction
     * AssetTransaction} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.AssetTransaction
     *         AssetTransaction} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.AssetTransactionFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    AssetTransactionFluentHelper getAllAssetTransaction();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.AssetTransaction
     * AssetTransaction} entity using key fields.
     *
     * @param assetTransactionType_ID
     *            Ast Transaction Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.AssetTransaction
     *         AssetTransaction} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.AssetTransactionByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    AssetTransactionByKeyFluentHelper getAssetTransactionByKey( final String assetTransactionType_ID );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PurchasingDocument
     * PurchasingDocument} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PurchasingDocument
     *         PurchasingDocument} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PurchasingDocumentFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PurchasingDocumentFluentHelper getAllPurchasingDocument();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PurchasingDocument
     * PurchasingDocument} entity using key fields.
     *
     * @param purchasingDocument_ID
     *            Purchasing Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PurchasingDocument
     *         PurchasingDocument} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PurchasingDocumentByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PurchasingDocumentByKeyFluentHelper getPurchasingDocumentByKey( final String purchasingDocument_ID );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.InvtrySpecialStockValnType_2
     * InvtrySpecialStockValnType_2} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.InvtrySpecialStockValnType_2
     *         InvtrySpecialStockValnType_2} entities. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.InvtrySpecialStockValnType_2FluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    InvtrySpecialStockValnType_2FluentHelper getAllInvtrySpecialStockValnType_2();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.InvtrySpecialStockValnType_2
     * InvtrySpecialStockValnType_2} entity using key fields.
     *
     * @param invtrySpecialStockValnType_2_ID
     *            Inventory Special Stock Valuation Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.InvtrySpecialStockValnType_2
     *         InvtrySpecialStockValnType_2} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.InvtrySpecialStockValnType_2ByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    InvtrySpecialStockValnType_2ByKeyFluentHelper
        getInvtrySpecialStockValnType_2ByKey( final String invtrySpecialStockValnType_2_ID );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.EliminationProfitCenter
     * EliminationProfitCenter} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.EliminationProfitCenter
     *         EliminationProfitCenter} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.EliminationProfitCenterFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EliminationProfitCenterFluentHelper getAllEliminationProfitCenter();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.EliminationProfitCenter
     * EliminationProfitCenter} entity using key fields.
     *
     * @param eliminationProfitCenter_ID
     *            Elimination Profit Center
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param controllingArea
     *            Elimination Profit Center (Controlling Area)
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.EliminationProfitCenter
     *         EliminationProfitCenter} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.EliminationProfitCenterByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EliminationProfitCenterByKeyFluentHelper
        getEliminationProfitCenterByKey( final String eliminationProfitCenter_ID, final String controllingArea );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.GlobalCurrency
     * GlobalCurrency} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.GlobalCurrency GlobalCurrency}
     *         entities. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.GlobalCurrencyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    GlobalCurrencyFluentHelper getAllGlobalCurrency();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.GlobalCurrency
     * GlobalCurrency} entity using key fields.
     *
     * @param globalCurrency_ID
     *            Global Currency
     *            <p>
     *            Constraints: Not nullable, Maximum length: 5
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.GlobalCurrency GlobalCurrency}
     *         entity using key fields. This fluent helper allows methods which modify the underlying query to be called
     *         before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.GlobalCurrencyByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    GlobalCurrencyByKeyFluentHelper getGlobalCurrencyByKey( final String globalCurrency_ID );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PredecessorReferenceDoc
     * PredecessorReferenceDoc} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PredecessorReferenceDoc
     *         PredecessorReferenceDoc} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PredecessorReferenceDocFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PredecessorReferenceDocFluentHelper getAllPredecessorReferenceDoc();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PredecessorReferenceDoc
     * PredecessorReferenceDoc} entity using key fields.
     *
     * @param predecessorReferenceDocType_ID
     *            Predecessor Reference Document Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 5
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PredecessorReferenceDoc
     *         PredecessorReferenceDoc} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PredecessorReferenceDocByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PredecessorReferenceDocByKeyFluentHelper
        getPredecessorReferenceDocByKey( final String predecessorReferenceDocType_ID );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.OffsettingAccount
     * OffsettingAccount} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.OffsettingAccount
     *         OffsettingAccount} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.OffsettingAccountFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    OffsettingAccountFluentHelper getAllOffsettingAccount();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.OffsettingAccount
     * OffsettingAccount} entity using key fields.
     *
     * @param offsettingAccount_ID
     *            Offsetting Account
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param offsettingAccountType
     *            Offsetting Account (Offsetting Account Type)
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.OffsettingAccount
     *         OffsettingAccount} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.OffsettingAccountByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    OffsettingAccountByKeyFluentHelper
        getOffsettingAccountByKey( final String offsettingAccount_ID, final String offsettingAccountType );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FreeDefinedCurrency4
     * FreeDefinedCurrency4} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FreeDefinedCurrency4
     *         FreeDefinedCurrency4} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FreeDefinedCurrency4FluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    FreeDefinedCurrency4FluentHelper getAllFreeDefinedCurrency4();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FreeDefinedCurrency4
     * FreeDefinedCurrency4} entity using key fields.
     *
     * @param freeDefinedCurrency4_ID
     *            Freely Defined Currency 4
     *            <p>
     *            Constraints: Not nullable, Maximum length: 5
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FreeDefinedCurrency4
     *         FreeDefinedCurrency4} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FreeDefinedCurrency4ByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    FreeDefinedCurrency4ByKeyFluentHelper getFreeDefinedCurrency4ByKey( final String freeDefinedCurrency4_ID );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.LineItemIsCompleted
     * LineItemIsCompleted} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.LineItemIsCompleted
     *         LineItemIsCompleted} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.LineItemIsCompletedFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    LineItemIsCompletedFluentHelper getAllLineItemIsCompleted();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.LineItemIsCompleted
     * LineItemIsCompleted} entity using key fields.
     *
     * @param lineItemIsCompleted_ID
     *            Line Item is Completed
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.LineItemIsCompleted
     *         LineItemIsCompleted} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.LineItemIsCompletedByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    LineItemIsCompletedByKeyFluentHelper getLineItemIsCompletedByKey( final String lineItemIsCompleted_ID );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerProjectInternalID
     * PartnerProjectInternalID} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerProjectInternalID
     *         PartnerProjectInternalID} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerProjectInternalIDFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PartnerProjectInternalIDFluentHelper getAllPartnerProjectInternalID();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerProjectInternalID
     * PartnerProjectInternalID} entity using key fields.
     *
     * @param partnerProjectInternalID_ID
     *            Partner Project Internal ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerProjectInternalID
     *         PartnerProjectInternalID} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerProjectInternalIDByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PartnerProjectInternalIDByKeyFluentHelper
        getPartnerProjectInternalIDByKey( final String partnerProjectInternalID_ID );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.InventorySpecialStockSupplier
     * InventorySpecialStockSupplier} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.InventorySpecialStockSupplier
     *         InventorySpecialStockSupplier} entities. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.InventorySpecialStockSupplierFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    InventorySpecialStockSupplierFluentHelper getAllInventorySpecialStockSupplier();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.InventorySpecialStockSupplier
     * InventorySpecialStockSupplier} entity using key fields.
     *
     * @param inventorySpecialStockSupplier_ID
     *            Inventory Special Stock Supplier
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.InventorySpecialStockSupplier
     *         InventorySpecialStockSupplier} entity using key fields. This fluent helper allows methods which modify
     *         the underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.InventorySpecialStockSupplierByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    InventorySpecialStockSupplierByKeyFluentHelper
        getInventorySpecialStockSupplierByKey( final String inventorySpecialStockSupplier_ID );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SoldProductGroup
     * SoldProductGroup} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SoldProductGroup
     *         SoldProductGroup} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SoldProductGroupFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SoldProductGroupFluentHelper getAllSoldProductGroup();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SoldProductGroup
     * SoldProductGroup} entity using key fields.
     *
     * @param soldProductGroup_ID
     *            Product Sold Group
     *            <p>
     *            Constraints: Not nullable, Maximum length: 9
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SoldProductGroup
     *         SoldProductGroup} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SoldProductGroupByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SoldProductGroupByKeyFluentHelper getSoldProductGroupByKey( final String soldProductGroup_ID );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ClearingJournalEntryFiscalYear
     * ClearingJournalEntryFiscalYear} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ClearingJournalEntryFiscalYear
     *         ClearingJournalEntryFiscalYear} entities. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ClearingJournalEntryFiscalYearFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ClearingJournalEntryFiscalYearFluentHelper getAllClearingJournalEntryFiscalYear();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ClearingJournalEntryFiscalYear
     * ClearingJournalEntryFiscalYear} entity using key fields.
     *
     * @param companyCode
     *            Fiscal Year of Clearing Journal Entry (Company Code)
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param clearingJournalEntryFiscalYear_ID
     *            Fiscal Year of Clearing Journal Entry
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ClearingJournalEntryFiscalYear
     *         ClearingJournalEntryFiscalYear} entity using key fields. This fluent helper allows methods which modify
     *         the underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ClearingJournalEntryFiscalYearByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ClearingJournalEntryFiscalYearByKeyFluentHelper getClearingJournalEntryFiscalYearByKey(
        final String clearingJournalEntryFiscalYear_ID,
        final String companyCode );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.LogicalSystem
     * LogicalSystem} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.LogicalSystem LogicalSystem}
     *         entities. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.LogicalSystemFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    LogicalSystemFluentHelper getAllLogicalSystem();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.LogicalSystem
     * LogicalSystem} entity using key fields.
     *
     * @param logicalSystem_ID
     *            Logical System
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.LogicalSystem LogicalSystem}
     *         entity using key fields. This fluent helper allows methods which modify the underlying query to be called
     *         before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.LogicalSystemByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    LogicalSystemByKeyFluentHelper getLogicalSystemByKey( final String logicalSystem_ID );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.GroupMasterFixedAsset
     * GroupMasterFixedAsset} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.GroupMasterFixedAsset
     *         GroupMasterFixedAsset} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.GroupMasterFixedAssetFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    GroupMasterFixedAssetFluentHelper getAllGroupMasterFixedAsset();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.GroupMasterFixedAsset
     * GroupMasterFixedAsset} entity using key fields.
     *
     * @param companyCode
     *            Group Asset (Company Code)
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param groupMasterFixedAsset_ID
     *            Group Asset
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.GroupMasterFixedAsset
     *         GroupMasterFixedAsset} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.GroupMasterFixedAssetByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    GroupMasterFixedAssetByKeyFluentHelper
        getGroupMasterFixedAssetByKey( final String groupMasterFixedAsset_ID, final String companyCode );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SalesDocumentItem
     * SalesDocumentItem} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SalesDocumentItem
     *         SalesDocumentItem} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SalesDocumentItemFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesDocumentItemFluentHelper getAllSalesDocumentItem();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SalesDocumentItem
     * SalesDocumentItem} entity using key fields.
     *
     * @param salesDocument
     *            Sales Document Item (Sales Document)
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param salesDocumentItem_ID
     *            Sales Document Item
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SalesDocumentItem
     *         SalesDocumentItem} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SalesDocumentItemByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesDocumentItemByKeyFluentHelper
        getSalesDocumentItemByKey( final String salesDocumentItem_ID, final String salesDocument );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerOrderCategory
     * PartnerOrderCategory} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerOrderCategory
     *         PartnerOrderCategory} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerOrderCategoryFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PartnerOrderCategoryFluentHelper getAllPartnerOrderCategory();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerOrderCategory
     * PartnerOrderCategory} entity using key fields.
     *
     * @param partnerOrderCategory_ID
     *            Partner Order Cat.
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerOrderCategory
     *         PartnerOrderCategory} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerOrderCategoryByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PartnerOrderCategoryByKeyFluentHelper getPartnerOrderCategoryByKey( final String partnerOrderCategory_ID );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerBusinessArea
     * PartnerBusinessArea} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerBusinessArea
     *         PartnerBusinessArea} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerBusinessAreaFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PartnerBusinessAreaFluentHelper getAllPartnerBusinessArea();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerBusinessArea
     * PartnerBusinessArea} entity using key fields.
     *
     * @param partnerBusinessArea_ID
     *            Partner Bus. Area
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerBusinessArea
     *         PartnerBusinessArea} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerBusinessAreaByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PartnerBusinessAreaByKeyFluentHelper getPartnerBusinessAreaByKey( final String partnerBusinessArea_ID );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerFunctionalArea
     * PartnerFunctionalArea} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerFunctionalArea
     *         PartnerFunctionalArea} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerFunctionalAreaFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PartnerFunctionalAreaFluentHelper getAllPartnerFunctionalArea();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerFunctionalArea
     * PartnerFunctionalArea} entity using key fields.
     *
     * @param partnerFunctionalArea_ID
     *            Partner Func. Area
     *            <p>
     *            Constraints: Not nullable, Maximum length: 16
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerFunctionalArea
     *         PartnerFunctionalArea} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerFunctionalAreaByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PartnerFunctionalAreaByKeyFluentHelper getPartnerFunctionalAreaByKey( final String partnerFunctionalArea_ID );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ProjectExternalID
     * ProjectExternalID} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ProjectExternalID
     *         ProjectExternalID} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ProjectExternalIDFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProjectExternalIDFluentHelper getAllProjectExternalID();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ProjectExternalID
     * ProjectExternalID} entity using key fields.
     *
     * @param projectExternalID_ID
     *            Project External ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 24
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ProjectExternalID
     *         ProjectExternalID} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ProjectExternalIDByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProjectExternalIDByKeyFluentHelper getProjectExternalIDByKey( final String projectExternalID_ID );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.OriginCostCenter
     * OriginCostCenter} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.OriginCostCenter
     *         OriginCostCenter} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.OriginCostCenterFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    OriginCostCenterFluentHelper getAllOriginCostCenter();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.OriginCostCenter
     * OriginCostCenter} entity using key fields.
     *
     * @param originCostCenter_ID
     *            Origin Cost Center
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param controllingArea
     *            Origin Cost Center (Controlling Area)
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.OriginCostCenter
     *         OriginCostCenter} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.OriginCostCenterByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    OriginCostCenterByKeyFluentHelper
        getOriginCostCenterByKey( final String originCostCenter_ID, final String controllingArea );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FreeDefinedCurrency5
     * FreeDefinedCurrency5} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FreeDefinedCurrency5
     *         FreeDefinedCurrency5} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FreeDefinedCurrency5FluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    FreeDefinedCurrency5FluentHelper getAllFreeDefinedCurrency5();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FreeDefinedCurrency5
     * FreeDefinedCurrency5} entity using key fields.
     *
     * @param freeDefinedCurrency5_ID
     *            Freely Defined Currency 5
     *            <p>
     *            Constraints: Not nullable, Maximum length: 5
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FreeDefinedCurrency5
     *         FreeDefinedCurrency5} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FreeDefinedCurrency5ByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    FreeDefinedCurrency5ByKeyFluentHelper getFreeDefinedCurrency5ByKey( final String freeDefinedCurrency5_ID );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CompanyCodeCurrency
     * CompanyCodeCurrency} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CompanyCodeCurrency
     *         CompanyCodeCurrency} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CompanyCodeCurrencyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CompanyCodeCurrencyFluentHelper getAllCompanyCodeCurrency();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CompanyCodeCurrency
     * CompanyCodeCurrency} entity using key fields.
     *
     * @param companyCodeCurrency_ID
     *            Company Code Currency
     *            <p>
     *            Constraints: Not nullable, Maximum length: 5
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CompanyCodeCurrency
     *         CompanyCodeCurrency} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.CompanyCodeCurrencyByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CompanyCodeCurrencyByKeyFluentHelper getCompanyCodeCurrencyByKey( final String companyCodeCurrency_ID );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.OriginObject OriginObject}
     * entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.OriginObject OriginObject}
     *         entities. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.OriginObjectFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    OriginObjectFluentHelper getAllOriginObject();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.OriginObject OriginObject}
     * entity using key fields.
     *
     * @param originObjectType_ID
     *            Origin Object Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.OriginObject OriginObject} entity
     *         using key fields. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.OriginObjectByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    OriginObjectByKeyFluentHelper getOriginObjectByKey( final String originObjectType_ID );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ControllingObjectDebit
     * ControllingObjectDebit} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ControllingObjectDebit
     *         ControllingObjectDebit} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ControllingObjectDebitFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ControllingObjectDebitFluentHelper getAllControllingObjectDebit();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ControllingObjectDebit
     * ControllingObjectDebit} entity using key fields.
     *
     * @param controllingObjectDebitType_ID
     *            Controlling Object Debit Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ControllingObjectDebit
     *         ControllingObjectDebit} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ControllingObjectDebitByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ControllingObjectDebitByKeyFluentHelper
        getControllingObjectDebitByKey( final String controllingObjectDebitType_ID );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerWBSElementInternalID
     * PartnerWBSElementInternalID} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerWBSElementInternalID
     *         PartnerWBSElementInternalID} entities. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerWBSElementInternalIDFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PartnerWBSElementInternalIDFluentHelper getAllPartnerWBSElementInternalID();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerWBSElementInternalID
     * PartnerWBSElementInternalID} entity using key fields.
     *
     * @param partnerWBSElementInternalID_ID
     *            Partner WBS Element Internal ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerWBSElementInternalID
     *         PartnerWBSElementInternalID} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerWBSElementInternalIDByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PartnerWBSElementInternalIDByKeyFluentHelper
        getPartnerWBSElementInternalIDByKey( final String partnerWBSElementInternalID_ID );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.GLAccountHierarchy
     * GLAccountHierarchy} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.GLAccountHierarchy
     *         GLAccountHierarchy} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.GLAccountHierarchyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    GLAccountHierarchyFluentHelper getAllGLAccountHierarchy();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.GLAccountHierarchy
     * GLAccountHierarchy} entity using key fields.
     *
     * @param chartOfAccounts
     *            G/L Account (Chart of Accounts)
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param gLAccountHierarchy_ID
     *            G/L Account
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.GLAccountHierarchy
     *         GLAccountHierarchy} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.GLAccountHierarchyByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    GLAccountHierarchyByKeyFluentHelper
        getGLAccountHierarchyByKey( final String gLAccountHierarchy_ID, final String chartOfAccounts );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FreeDefinedCurrency7
     * FreeDefinedCurrency7} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FreeDefinedCurrency7
     *         FreeDefinedCurrency7} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FreeDefinedCurrency7FluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    FreeDefinedCurrency7FluentHelper getAllFreeDefinedCurrency7();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FreeDefinedCurrency7
     * FreeDefinedCurrency7} entity using key fields.
     *
     * @param freeDefinedCurrency7_ID
     *            Freely Defined Currency 7
     *            <p>
     *            Constraints: Not nullable, Maximum length: 5
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FreeDefinedCurrency7
     *         FreeDefinedCurrency7} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.FreeDefinedCurrency7ByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    FreeDefinedCurrency7ByKeyFluentHelper getFreeDefinedCurrency7ByKey( final String freeDefinedCurrency7_ID );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerCompanyCode
     * PartnerCompanyCode} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerCompanyCode
     *         PartnerCompanyCode} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerCompanyCodeFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PartnerCompanyCodeFluentHelper getAllPartnerCompanyCode();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerCompanyCode
     * PartnerCompanyCode} entity using key fields.
     *
     * @param partnerCompanyCode_ID
     *            Partner Company Code
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerCompanyCode
     *         PartnerCompanyCode} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerCompanyCodeByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PartnerCompanyCodeByKeyFluentHelper getPartnerCompanyCodeByKey( final String partnerCompanyCode_ID );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SalesOrderItem
     * SalesOrderItem} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SalesOrderItem SalesOrderItem}
     *         entities. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SalesOrderItemFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesOrderItemFluentHelper getAllSalesOrderItem();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SalesOrderItem
     * SalesOrderItem} entity using key fields.
     *
     * @param salesOrderItem_ID
     *            Item
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param salesOrder
     *            Item (Sales Order)
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SalesOrderItem SalesOrderItem}
     *         entity using key fields. This fluent helper allows methods which modify the underlying query to be called
     *         before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SalesOrderItemByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesOrderItemByKeyFluentHelper getSalesOrderItemByKey( final String salesOrderItem_ID, final String salesOrder );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.OffsettingAccount_2
     * OffsettingAccount_2} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.OffsettingAccount_2
     *         OffsettingAccount_2} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.OffsettingAccount_2FluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    OffsettingAccount_2FluentHelper getAllOffsettingAccount_2();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.OffsettingAccount_2
     * OffsettingAccount_2} entity using key fields.
     *
     * @param offsettingAccountType_ID
     *            Offsetting Account Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.OffsettingAccount_2
     *         OffsettingAccount_2} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.OffsettingAccount_2ByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    OffsettingAccount_2ByKeyFluentHelper getOffsettingAccount_2ByKey( final String offsettingAccountType_ID );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerSalesDocumentItem
     * PartnerSalesDocumentItem} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerSalesDocumentItem
     *         PartnerSalesDocumentItem} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerSalesDocumentItemFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PartnerSalesDocumentItemFluentHelper getAllPartnerSalesDocumentItem();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerSalesDocumentItem
     * PartnerSalesDocumentItem} entity using key fields.
     *
     * @param partnerSalesDocumentItem_ID
     *            Partner Sales Document Item
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param partnerSalesDocument
     *            Partner Sales Document Item (Partner Sales Doc.)
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerSalesDocumentItem
     *         PartnerSalesDocumentItem} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.PartnerSalesDocumentItemByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PartnerSalesDocumentItemByKeyFluentHelper
        getPartnerSalesDocumentItemByKey( final String partnerSalesDocumentItem_ID, final String partnerSalesDocument );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.InventoryValuation
     * InventoryValuation} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.InventoryValuation
     *         InventoryValuation} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.InventoryValuationFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    InventoryValuationFluentHelper getAllInventoryValuation();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.InventoryValuation
     * InventoryValuation} entity using key fields.
     *
     * @param inventoryValuationType_ID
     *            Inventory Valuation Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.InventoryValuation
     *         InventoryValuation} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.InventoryValuationByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    InventoryValuationByKeyFluentHelper getInventoryValuationByKey( final String inventoryValuationType_ID );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ODataQueryAdditionalMetadata
     * ODataQueryAdditionalMetadata} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ODataQueryAdditionalMetadata
     *         ODataQueryAdditionalMetadata} entities. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ODataQueryAdditionalMetadataFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ODataQueryAdditionalMetadataFluentHelper getAllODataQueryAdditionalMetadata();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ODataQueryAdditionalMetadata
     * ODataQueryAdditionalMetadata} entity using key fields.
     *
     * @param oDataQueryMetadata
     *
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ODataQueryAdditionalMetadata
     *         ODataQueryAdditionalMetadata} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.ODataQueryAdditionalMetadataByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ODataQueryAdditionalMetadataByKeyFluentHelper
        getODataQueryAdditionalMetadataByKey( final String oDataQueryMetadata );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SAP__Currency
     * SAP__Currency} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SAP__Currency SAP__Currency}
     *         entities. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SAP__CurrencyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SAP__CurrencyFluentHelper getAllSAP__Currency();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SAP__Currency
     * SAP__Currency} entity using key fields.
     *
     * @param currencyCode
     *            Currency
     *            <p>
     *            Constraints: Not nullable, Maximum length: 5
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SAP__Currency SAP__Currency}
     *         entity using key fields. This fluent helper allows methods which modify the underlying query to be called
     *         before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SAP__CurrencyByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SAP__CurrencyByKeyFluentHelper getSAP__CurrencyByKey( final String currencyCode );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SAP__Currency SAP__Currency}
     * entity and save it to the S/4HANA system.
     *
     * @param sAP__Currency
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SAP__Currency SAP__Currency}
     *            entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SAP__Currency SAP__Currency}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SAP__CurrencyCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SAP__CurrencyCreateFluentHelper createSAP__Currency( @Nonnull final SAP__Currency sAP__Currency );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SAP__Currency
     * SAP__Currency} entity and save it to the S/4HANA system.
     *
     * @param sAP__Currency
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SAP__Currency SAP__Currency}
     *            entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SAP__Currency SAP__Currency}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SAP__CurrencyUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SAP__CurrencyUpdateFluentHelper updateSAP__Currency( @Nonnull final SAP__Currency sAP__Currency );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SAP__Currency
     * SAP__Currency} entity in the S/4HANA system.
     *
     * @param sAP__Currency
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SAP__Currency SAP__Currency}
     *            entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SAP__Currency SAP__Currency}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SAP__CurrencyDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SAP__CurrencyDeleteFluentHelper deleteSAP__Currency( @Nonnull final SAP__Currency sAP__Currency );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SAP__UnitOfMeasure
     * SAP__UnitOfMeasure} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SAP__UnitOfMeasure
     *         SAP__UnitOfMeasure} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SAP__UnitOfMeasureFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SAP__UnitOfMeasureFluentHelper getAllSAP__UnitOfMeasure();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SAP__UnitOfMeasure
     * SAP__UnitOfMeasure} entity using key fields.
     *
     * @param unitCode
     *            Internal UoM
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SAP__UnitOfMeasure
     *         SAP__UnitOfMeasure} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SAP__UnitOfMeasureByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SAP__UnitOfMeasureByKeyFluentHelper getSAP__UnitOfMeasureByKey( final String unitCode );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SAP__UnitOfMeasure
     * SAP__UnitOfMeasure} entity and save it to the S/4HANA system.
     *
     * @param sAP__UnitOfMeasure
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SAP__UnitOfMeasure
     *            SAP__UnitOfMeasure} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SAP__UnitOfMeasure
     *         SAP__UnitOfMeasure} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SAP__UnitOfMeasureCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SAP__UnitOfMeasureCreateFluentHelper
        createSAP__UnitOfMeasure( @Nonnull final SAP__UnitOfMeasure sAP__UnitOfMeasure );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SAP__UnitOfMeasure
     * SAP__UnitOfMeasure} entity and save it to the S/4HANA system.
     *
     * @param sAP__UnitOfMeasure
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SAP__UnitOfMeasure
     *            SAP__UnitOfMeasure} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SAP__UnitOfMeasure
     *         SAP__UnitOfMeasure} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SAP__UnitOfMeasureUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SAP__UnitOfMeasureUpdateFluentHelper
        updateSAP__UnitOfMeasure( @Nonnull final SAP__UnitOfMeasure sAP__UnitOfMeasure );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SAP__UnitOfMeasure
     * SAP__UnitOfMeasure} entity in the S/4HANA system.
     *
     * @param sAP__UnitOfMeasure
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SAP__UnitOfMeasure
     *            SAP__UnitOfMeasure} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SAP__UnitOfMeasure
     *         SAP__UnitOfMeasure} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SAP__UnitOfMeasureDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SAP__UnitOfMeasureDeleteFluentHelper
        deleteSAP__UnitOfMeasure( @Nonnull final SAP__UnitOfMeasure sAP__UnitOfMeasure );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SAP__DocumentDescription
     * SAP__DocumentDescription} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SAP__DocumentDescription
     *         SAP__DocumentDescription} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SAP__DocumentDescriptionFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SAP__DocumentDescriptionFluentHelper getAllSAP__DocumentDescription();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SAP__DocumentDescription
     * SAP__DocumentDescription} entity using key fields.
     *
     * @param id
     *            UUID
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SAP__DocumentDescription
     *         SAP__DocumentDescription} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SAP__DocumentDescriptionByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SAP__DocumentDescriptionByKeyFluentHelper getSAP__DocumentDescriptionByKey( final UUID id );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SAP__DocumentDescription
     * SAP__DocumentDescription} entity and save it to the S/4HANA system.
     *
     * @param sAP__DocumentDescription
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SAP__DocumentDescription
     *            SAP__DocumentDescription} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SAP__DocumentDescription
     *         SAP__DocumentDescription} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SAP__DocumentDescriptionCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SAP__DocumentDescriptionCreateFluentHelper
        createSAP__DocumentDescription( @Nonnull final SAP__DocumentDescription sAP__DocumentDescription );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SAP__DocumentDescription
     * SAP__DocumentDescription} entity and save it to the S/4HANA system.
     *
     * @param sAP__DocumentDescription
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SAP__DocumentDescription
     *            SAP__DocumentDescription} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SAP__DocumentDescription
     *         SAP__DocumentDescription} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SAP__DocumentDescriptionUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SAP__DocumentDescriptionUpdateFluentHelper
        updateSAP__DocumentDescription( @Nonnull final SAP__DocumentDescription sAP__DocumentDescription );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SAP__DocumentDescription
     * SAP__DocumentDescription} entity in the S/4HANA system.
     *
     * @param sAP__DocumentDescription
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SAP__DocumentDescription
     *            SAP__DocumentDescription} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SAP__DocumentDescription
     *         SAP__DocumentDescription} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SAP__DocumentDescriptionDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SAP__DocumentDescriptionDeleteFluentHelper
        deleteSAP__DocumentDescription( @Nonnull final SAP__DocumentDescription sAP__DocumentDescription );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SAP__ValueHelp
     * SAP__ValueHelp} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SAP__ValueHelp SAP__ValueHelp}
     *         entities. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SAP__ValueHelpFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SAP__ValueHelpFluentHelper getAllSAP__ValueHelp();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SAP__ValueHelp
     * SAP__ValueHelp} entity using key fields.
     *
     * @param vALUEHELP
     *
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SAP__ValueHelp SAP__ValueHelp}
     *         entity using key fields. This fluent helper allows methods which modify the underlying query to be called
     *         before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SAP__ValueHelpByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SAP__ValueHelpByKeyFluentHelper getSAP__ValueHelpByKey( final String vALUEHELP );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SAP__ValueHelp
     * SAP__ValueHelp} entity and save it to the S/4HANA system.
     *
     * @param sAP__ValueHelp
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SAP__ValueHelp SAP__ValueHelp}
     *            entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SAP__ValueHelp SAP__ValueHelp}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SAP__ValueHelpCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SAP__ValueHelpCreateFluentHelper createSAP__ValueHelp( @Nonnull final SAP__ValueHelp sAP__ValueHelp );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SAP__ValueHelp
     * SAP__ValueHelp} entity and save it to the S/4HANA system.
     *
     * @param sAP__ValueHelp
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SAP__ValueHelp SAP__ValueHelp}
     *            entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SAP__ValueHelp SAP__ValueHelp}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SAP__ValueHelpUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SAP__ValueHelpUpdateFluentHelper updateSAP__ValueHelp( @Nonnull final SAP__ValueHelp sAP__ValueHelp );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SAP__ValueHelp
     * SAP__ValueHelp} entity in the S/4HANA system.
     *
     * @param sAP__ValueHelp
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SAP__ValueHelp SAP__ValueHelp}
     *            entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SAP__ValueHelp SAP__ValueHelp}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.SAP__ValueHelpDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SAP__ValueHelpDeleteFluentHelper deleteSAP__ValueHelp( @Nonnull final SAP__ValueHelp sAP__ValueHelp );

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult
     * TRIALBALANCEResult} entity using key fields.
     *
     * @param iD
     *
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResult
     *         TRIALBALANCEResult} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEResultByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    TRIALBALANCEResultByKeyFluentHelper getTRIALBALANCEResultByKey( final String iD );

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEParameters
     * TRIALBALANCEParameters} entity using key fields.
     *
     * @param p_ToPostingDate
     *            Posting Date To
     *            <p>
     *            Constraints: Not nullable, Precision: 0
     *            </p>
     * @param p_FromPostingDate
     *            Posting Date From
     *            <p>
     *            Constraints: Not nullable, Precision: 0
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEParameters
     *         TRIALBALANCEParameters} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.trialbalance.TRIALBALANCEParametersByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    TRIALBALANCEParametersByKeyFluentHelper
        getTRIALBALANCEParametersByKey( final LocalDateTime p_FromPostingDate, final LocalDateTime p_ToPostingDate );

}
