/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.AdjustDeliveryItemQuantityFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.PostGoodsReceiptFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.ReverseGoodsReceiptFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.WhseInbDelivItemSerialNumberByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.WhseInbDelivItemSerialNumberFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.WhseInboundDeliveryHead;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.WhseInboundDeliveryHeadByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.WhseInboundDeliveryHeadFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.WhseInboundDeliveryHeadUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.WhseInboundDeliveryItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.WhseInboundDeliveryItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.WhseInboundDeliveryItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.WhseInboundDeliveryItemUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.batch.WarehouseInboundDeliveryServiceBatch;

/**
 * <p>
 * In every API call, you can make use of the following operations: - You can retrieve header information for warehouse
 * inbound deliveries. - You can retrieve item information for warehouse inbound deliveries, including serial numbers. -
 * You can change the carrier ID for a warehouse inbound delivery at header level. - You can change the product quantity
 * and the goods movement bin for a warehouse inbound delivery at item level. - You can adjust the delivery item
 * quantity down to 0 if the item was not received, or down to the packed quantity that was received. - You can post
 * goods receipt. - You can reverse goods receipt. .
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2208.latest/EN/a8/29826d35714642999d7b7dfbd58b8f/frameset.htm?profile=20020833'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_WHSE_INBOUND_DELIVERY?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_WHSE_INBOUND_DELIVERY</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2208</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Warehousing - Inbound Delivery Integration(SAP_COM_0385)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/3BR'>Warehouse Inbound Processing(3BR)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Warehouse Inbound Delivery</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated as of release 2108 (Aug 2021). Please use the
 *             odata generator to generate the VDM.
 */
@Deprecated
public interface WarehouseInboundDeliveryService extends BatchService<WarehouseInboundDeliveryServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_WHSE_INBOUND_DELIVERY";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    WarehouseInboundDeliveryService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.WhseInboundDeliveryHead
     * WhseInboundDeliveryHead} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.WhseInboundDeliveryHead
     *         WhseInboundDeliveryHead} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.WhseInboundDeliveryHeadFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    WhseInboundDeliveryHeadFluentHelper getAllWhseInboundDeliveryHead();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.WhseInboundDeliveryHead
     * WhseInboundDeliveryHead} entity using key fields.
     *
     * @param inboundDelivery
     *            Document Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 35
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.WhseInboundDeliveryHead
     *         WhseInboundDeliveryHead} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.WhseInboundDeliveryHeadByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    WhseInboundDeliveryHeadByKeyFluentHelper getWhseInboundDeliveryHeadByKey( final String inboundDelivery );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.WhseInboundDeliveryHead
     * WhseInboundDeliveryHead} entity and save it to the S/4HANA system.
     *
     * @param whseInboundDeliveryHead
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.WhseInboundDeliveryHead
     *            WhseInboundDeliveryHead} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.WhseInboundDeliveryHead
     *         WhseInboundDeliveryHead} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.WhseInboundDeliveryHeadUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    WhseInboundDeliveryHeadUpdateFluentHelper
        updateWhseInboundDeliveryHead( @Nonnull final WhseInboundDeliveryHead whseInboundDeliveryHead );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.WhseInboundDeliveryItem
     * WhseInboundDeliveryItem} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.WhseInboundDeliveryItem
     *         WhseInboundDeliveryItem} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.WhseInboundDeliveryItemFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    WhseInboundDeliveryItemFluentHelper getAllWhseInboundDeliveryItem();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.WhseInboundDeliveryItem
     * WhseInboundDeliveryItem} entity using key fields.
     *
     * @param inboundDelivery
     *            Document Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 35
     *            </p>
     * @param inboundDeliveryItem
     *            Item Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.WhseInboundDeliveryItem
     *         WhseInboundDeliveryItem} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.WhseInboundDeliveryItemByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    WhseInboundDeliveryItemByKeyFluentHelper
        getWhseInboundDeliveryItemByKey( final String inboundDelivery, final String inboundDeliveryItem );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.WhseInboundDeliveryItem
     * WhseInboundDeliveryItem} entity and save it to the S/4HANA system.
     *
     * @param whseInboundDeliveryItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.WhseInboundDeliveryItem
     *            WhseInboundDeliveryItem} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.WhseInboundDeliveryItem
     *         WhseInboundDeliveryItem} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.WhseInboundDeliveryItemUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    WhseInboundDeliveryItemUpdateFluentHelper
        updateWhseInboundDeliveryItem( @Nonnull final WhseInboundDeliveryItem whseInboundDeliveryItem );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.WhseInbDelivItemSerialNumber
     * WhseInbDelivItemSerialNumber} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.WhseInbDelivItemSerialNumber
     *         WhseInbDelivItemSerialNumber} entities. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.WhseInbDelivItemSerialNumberFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    WhseInbDelivItemSerialNumberFluentHelper getAllWhseInbDelivItemSerialNumber();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.WhseInbDelivItemSerialNumber
     * WhseInbDelivItemSerialNumber} entity using key fields.
     *
     * @param inboundDelivery
     *            Document Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 35
     *            </p>
     * @param inboundDeliveryItem
     *            Item Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param eWMSerialNumber
     *
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.WhseInbDelivItemSerialNumber
     *         WhseInbDelivItemSerialNumber} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.WhseInbDelivItemSerialNumberByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    WhseInbDelivItemSerialNumberByKeyFluentHelper getWhseInbDelivItemSerialNumberByKey(
        final String inboundDelivery,
        final String inboundDeliveryItem,
        final String eWMSerialNumber );

    /**
     * <p>
     * Creates a fluent helper for the <b>PostGoodsReceipt</b> OData function import.
     * </p>
     *
     * @param inboundDelivery
     *            Document Number
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 35
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>InboundDelivery</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>PostGoodsReceipt</b> OData function import with the
     *         provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.PostGoodsReceiptFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PostGoodsReceiptFluentHelper postGoodsReceipt( @Nonnull final String inboundDelivery );

    /**
     * <p>
     * Creates a fluent helper for the <b>ReverseGoodsReceipt</b> OData function import.
     * </p>
     *
     * @param inboundDelivery
     *            Document Number
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 35
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>InboundDelivery</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>ReverseGoodsReceipt</b> OData function import with the
     *         provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.ReverseGoodsReceiptFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ReverseGoodsReceiptFluentHelper reverseGoodsReceipt( @Nonnull final String inboundDelivery );

    /**
     * <p>
     * Creates a fluent helper for the <b>AdjustDeliveryItemQuantity</b> OData function import.
     * </p>
     *
     * @param inboundDelivery
     *            Document Number
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 35
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>InboundDelivery</b>
     *            </p>
     * @param inboundDeliveryItem
     *            Item Number
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>InboundDeliveryItem</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>AdjustDeliveryItemQuantity</b> OData function import with
     *         the provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseinbounddelivery.AdjustDeliveryItemQuantityFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    AdjustDeliveryItemQuantityFluentHelper
        adjustDeliveryItemQuantity( @Nonnull final String inboundDelivery, @Nonnull final String inboundDeliveryItem );

}
