/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.AdjustDeliveryItemQuantityFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.PostGoodsIssueFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.PrintLoadingListFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.ReverseGoodsIssueFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseDeliveryDocumentAddressByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseDeliveryDocumentAddressFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseOutbDelivOrderItemSerialNoByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseOutbDelivOrderItemSerialNoFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseOutboundDeliveryOrderHead;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseOutboundDeliveryOrderHeadByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseOutboundDeliveryOrderHeadFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseOutboundDeliveryOrderHeadUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseOutboundDeliveryOrderItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseOutboundDeliveryOrderItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseOutboundDeliveryOrderItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseOutboundDeliveryOrderItemUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.batch.WarehouseOutboundDeliveryOrderServiceBatch;

/**
 * <p>
 * In every API call, you can make use of the following operations: - You can retrieve header information for warehouse
 * outbound delivery orders. - You can retrieve item information for warehouse outbound delivery orders, including
 * serial numbers. - You can change the carrier ID for a warehouse outbound delivery order at header level. - You can
 * change the staging bay for a warehouse outbound delivery order, as well as the product quantity, at item level. - You
 * can adjust the delivery quantity down to 0 if picking hasn&#39;t started, or down to the partial quantity that has
 * already been picked. - You can print a loading list for a delivery. - You can post goods issue. - You can reverse
 * goods issue..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2208.latest/EN/33/1cfb1d12c148569cd94072a421c69f/frameset.htm?profile=20020833'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_WHSE_OUTB_DLV_ORDER?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_WHSE_OUTB_DLV_ORDER</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2208</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Warehousing - Process Outbound Delivery Order Integration(SAP_COM_0356)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/3BS'>Warehouse Outbound Processing(3BS)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Warehouse Outbound Delivery Order</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated as of release 2108 (Aug 2021). Please use the
 *             odata generator to generate the VDM.
 */
@Deprecated
public interface WarehouseOutboundDeliveryOrderService extends BatchService<WarehouseOutboundDeliveryOrderServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_WHSE_OUTB_DLV_ORDER";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    WarehouseOutboundDeliveryOrderService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseDeliveryDocumentAddress
     * WhseDeliveryDocumentAddress} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseDeliveryDocumentAddress
     *         WhseDeliveryDocumentAddress} entities. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseDeliveryDocumentAddressFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    WhseDeliveryDocumentAddressFluentHelper getAllWhseDeliveryDocumentAddress();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseDeliveryDocumentAddress
     * WhseDeliveryDocumentAddress} entity using key fields.
     *
     * @param businessPartnerRole
     *            Partner Role
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param outboundDeliveryOrder
     *            Document Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 35
     *            </p>
     * @param outboundDeliveryOrderItem
     *            Item Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseDeliveryDocumentAddress
     *         WhseDeliveryDocumentAddress} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseDeliveryDocumentAddressByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    WhseDeliveryDocumentAddressByKeyFluentHelper getWhseDeliveryDocumentAddressByKey(
        final String outboundDeliveryOrder,
        final String outboundDeliveryOrderItem,
        final String businessPartnerRole );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseOutboundDeliveryOrderHead
     * WhseOutboundDeliveryOrderHead} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseOutboundDeliveryOrderHead
     *         WhseOutboundDeliveryOrderHead} entities. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseOutboundDeliveryOrderHeadFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    WhseOutboundDeliveryOrderHeadFluentHelper getAllWhseOutboundDeliveryOrderHead();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseOutboundDeliveryOrderHead
     * WhseOutboundDeliveryOrderHead} entity using key fields.
     *
     * @param outboundDeliveryOrder
     *            Document Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 35
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseOutboundDeliveryOrderHead
     *         WhseOutboundDeliveryOrderHead} entity using key fields. This fluent helper allows methods which modify
     *         the underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseOutboundDeliveryOrderHeadByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    WhseOutboundDeliveryOrderHeadByKeyFluentHelper
        getWhseOutboundDeliveryOrderHeadByKey( final String outboundDeliveryOrder );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseOutboundDeliveryOrderHead
     * WhseOutboundDeliveryOrderHead} entity and save it to the S/4HANA system.
     *
     * @param whseOutboundDeliveryOrderHead
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseOutboundDeliveryOrderHead
     *            WhseOutboundDeliveryOrderHead} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseOutboundDeliveryOrderHead
     *         WhseOutboundDeliveryOrderHead} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseOutboundDeliveryOrderHeadUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    WhseOutboundDeliveryOrderHeadUpdateFluentHelper updateWhseOutboundDeliveryOrderHead(
        @Nonnull final WhseOutboundDeliveryOrderHead whseOutboundDeliveryOrderHead );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseOutboundDeliveryOrderItem
     * WhseOutboundDeliveryOrderItem} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseOutboundDeliveryOrderItem
     *         WhseOutboundDeliveryOrderItem} entities. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseOutboundDeliveryOrderItemFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    WhseOutboundDeliveryOrderItemFluentHelper getAllWhseOutboundDeliveryOrderItem();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseOutboundDeliveryOrderItem
     * WhseOutboundDeliveryOrderItem} entity using key fields.
     *
     * @param outboundDeliveryOrder
     *            Document Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 35
     *            </p>
     * @param outboundDeliveryOrderItem
     *            Item Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseOutboundDeliveryOrderItem
     *         WhseOutboundDeliveryOrderItem} entity using key fields. This fluent helper allows methods which modify
     *         the underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseOutboundDeliveryOrderItemByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    WhseOutboundDeliveryOrderItemByKeyFluentHelper getWhseOutboundDeliveryOrderItemByKey(
        final String outboundDeliveryOrder,
        final String outboundDeliveryOrderItem );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseOutboundDeliveryOrderItem
     * WhseOutboundDeliveryOrderItem} entity and save it to the S/4HANA system.
     *
     * @param whseOutboundDeliveryOrderItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseOutboundDeliveryOrderItem
     *            WhseOutboundDeliveryOrderItem} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseOutboundDeliveryOrderItem
     *         WhseOutboundDeliveryOrderItem} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseOutboundDeliveryOrderItemUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    WhseOutboundDeliveryOrderItemUpdateFluentHelper updateWhseOutboundDeliveryOrderItem(
        @Nonnull final WhseOutboundDeliveryOrderItem whseOutboundDeliveryOrderItem );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseOutbDelivOrderItemSerialNo
     * WhseOutbDelivOrderItemSerialNo} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseOutbDelivOrderItemSerialNo
     *         WhseOutbDelivOrderItemSerialNo} entities. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseOutbDelivOrderItemSerialNoFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    WhseOutbDelivOrderItemSerialNoFluentHelper getAllWhseOutbDelivOrderItemSerialNo();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseOutbDelivOrderItemSerialNo
     * WhseOutbDelivOrderItemSerialNo} entity using key fields.
     *
     * @param outboundDeliveryOrder
     *            Document Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 35
     *            </p>
     * @param eWMSerialNumber
     *
     * @param outboundDeliveryOrderItem
     *            Item Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseOutbDelivOrderItemSerialNo
     *         WhseOutbDelivOrderItemSerialNo} entity using key fields. This fluent helper allows methods which modify
     *         the underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.WhseOutbDelivOrderItemSerialNoByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    WhseOutbDelivOrderItemSerialNoByKeyFluentHelper getWhseOutbDelivOrderItemSerialNoByKey(
        final String outboundDeliveryOrder,
        final String outboundDeliveryOrderItem,
        final String eWMSerialNumber );

    /**
     * <p>
     * Creates a fluent helper for the <b>PostGoodsIssue</b> OData function import.
     * </p>
     *
     * @param outboundDeliveryOrder
     *            Document Number
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 35
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>OutboundDeliveryOrder</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>PostGoodsIssue</b> OData function import with the
     *         provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.PostGoodsIssueFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PostGoodsIssueFluentHelper postGoodsIssue( @Nonnull final String outboundDeliveryOrder );

    /**
     * <p>
     * Creates a fluent helper for the <b>PrintLoadingList</b> OData function import.
     * </p>
     *
     * @param outboundDeliveryOrder
     *            Document Number
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 35
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>OutboundDeliveryOrder</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>PrintLoadingList</b> OData function import with the
     *         provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.PrintLoadingListFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PrintLoadingListFluentHelper printLoadingList( @Nonnull final String outboundDeliveryOrder );

    /**
     * <p>
     * Creates a fluent helper for the <b>ReverseGoodsIssue</b> OData function import.
     * </p>
     *
     * @param outboundDeliveryOrder
     *            Document Number
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 35
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>OutboundDeliveryOrder</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>ReverseGoodsIssue</b> OData function import with the
     *         provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.ReverseGoodsIssueFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ReverseGoodsIssueFluentHelper reverseGoodsIssue( @Nonnull final String outboundDeliveryOrder );

    /**
     * <p>
     * Creates a fluent helper for the <b>AdjustDeliveryItemQuantity</b> OData function import.
     * </p>
     *
     * @param outboundDeliveryOrder
     *            Document Number
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 35
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>OutboundDeliveryOrder</b>
     *            </p>
     * @param outboundDeliveryOrderItem
     *            Item Number
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>OutboundDeliveryOrderItem</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>AdjustDeliveryItemQuantity</b> OData function import with
     *         the provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseoutbounddeliveryorder.AdjustDeliveryItemQuantityFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    AdjustDeliveryItemQuantityFluentHelper adjustDeliveryItemQuantity(
        @Nonnull final String outboundDeliveryOrder,
        @Nonnull final String outboundDeliveryOrderItem );

}
