/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.util.UUID;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousephysicalinventory.DeletePhysicalInventoryItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousephysicalinventory.WhsePhysicalInventoryCountItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousephysicalinventory.WhsePhysicalInventoryCountItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousephysicalinventory.WhsePhysicalInventoryCountItemCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousephysicalinventory.WhsePhysicalInventoryCountItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousephysicalinventory.WhsePhysicalInventoryCountItemUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousephysicalinventory.WhsePhysicalInventoryItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousephysicalinventory.WhsePhysicalInventoryItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousephysicalinventory.WhsePhysicalInventoryItemCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousephysicalinventory.WhsePhysicalInventoryItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousephysicalinventory.WhsePhysicalInventoryItemUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousephysicalinventory.batch.WarehousePhysicalInventoryServiceBatch;

/**
 * <p>
 *
 * In every API call, you can make use of the following operations: - You can retrieve physical inventory (PI) items. -
 * You can count PI items. - You can change counted PI items. - You can mark PI items as ***Deleted***.
 *
 * You can integrate this API with external applications.
 *
 * For the count and change count operations, you can only perform these operations using batch requests. Additionally,
 * you must include the entities Warehouse Physical Inventory Item (WhsePhysicalInventoryItem) and Warehouse Physical
 * Inventory Count Item (WhsePhysicalInventoryCountItem) in the batch requests. .
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2208.latest/EN/aa/453eaa3c3142d49877ee969a5dacf7/frameset.htm?profile=20020833'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_WHSE_PHYSINVENTORYITEM?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_WHSE_PHYSINVENTORYITEM</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2208</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Warehousing - Physical Inventory Integration(SAP_COM_0378)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/3BX'>Warehouse Physical Inventory(3BX)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Warehouse Physical Inventory Document</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated as of release 2108 (Aug 2021). Please use the
 *             odata generator to generate the VDM.
 */
@Deprecated
public interface WarehousePhysicalInventoryService extends BatchService<WarehousePhysicalInventoryServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_WHSE_PHYSINVENTORYITEM";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    WarehousePhysicalInventoryService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousephysicalinventory.WhsePhysicalInventoryCountItem
     * WhsePhysicalInventoryCountItem} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousephysicalinventory.WhsePhysicalInventoryCountItem
     *         WhsePhysicalInventoryCountItem} entities. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousephysicalinventory.WhsePhysicalInventoryCountItemFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    WhsePhysicalInventoryCountItemFluentHelper getAllWhsePhysicalInventoryCountItem();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousephysicalinventory.WhsePhysicalInventoryCountItem
     * WhsePhysicalInventoryCountItem} entity using key fields.
     *
     * @param pInvQuantitySequence
     *            Row Index of Internal Tables
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @param lineIndexOfPInvItem
     *            Row Index of Internal Tables
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @param physicalInventoryItemNumber
     *            Item
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param physicalInventoryDocumentUUID
     *            GUID for Physical Inventory Document
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousephysicalinventory.WhsePhysicalInventoryCountItem
     *         WhsePhysicalInventoryCountItem} entity using key fields. This fluent helper allows methods which modify
     *         the underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousephysicalinventory.WhsePhysicalInventoryCountItemByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    WhsePhysicalInventoryCountItemByKeyFluentHelper getWhsePhysicalInventoryCountItemByKey(
        final UUID physicalInventoryDocumentUUID,
        final String physicalInventoryItemNumber,
        final Integer lineIndexOfPInvItem,
        final Integer pInvQuantitySequence );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousephysicalinventory.WhsePhysicalInventoryCountItem
     * WhsePhysicalInventoryCountItem} entity and save it to the S/4HANA system.
     *
     * @param whsePhysicalInventoryCountItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousephysicalinventory.WhsePhysicalInventoryCountItem
     *            WhsePhysicalInventoryCountItem} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousephysicalinventory.WhsePhysicalInventoryCountItem
     *         WhsePhysicalInventoryCountItem} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousephysicalinventory.WhsePhysicalInventoryCountItemCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    WhsePhysicalInventoryCountItemCreateFluentHelper createWhsePhysicalInventoryCountItem(
        @Nonnull final WhsePhysicalInventoryCountItem whsePhysicalInventoryCountItem );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousephysicalinventory.WhsePhysicalInventoryCountItem
     * WhsePhysicalInventoryCountItem} entity and save it to the S/4HANA system.
     *
     * @param whsePhysicalInventoryCountItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousephysicalinventory.WhsePhysicalInventoryCountItem
     *            WhsePhysicalInventoryCountItem} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousephysicalinventory.WhsePhysicalInventoryCountItem
     *         WhsePhysicalInventoryCountItem} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousephysicalinventory.WhsePhysicalInventoryCountItemUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    WhsePhysicalInventoryCountItemUpdateFluentHelper updateWhsePhysicalInventoryCountItem(
        @Nonnull final WhsePhysicalInventoryCountItem whsePhysicalInventoryCountItem );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousephysicalinventory.WhsePhysicalInventoryItem
     * WhsePhysicalInventoryItem} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousephysicalinventory.WhsePhysicalInventoryItem
     *         WhsePhysicalInventoryItem} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousephysicalinventory.WhsePhysicalInventoryItemFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    WhsePhysicalInventoryItemFluentHelper getAllWhsePhysicalInventoryItem();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousephysicalinventory.WhsePhysicalInventoryItem
     * WhsePhysicalInventoryItem} entity using key fields.
     *
     * @param physicalInventoryItemNumber
     *            Item
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param physicalInventoryDocumentUUID
     *            GUID for Physical Inventory Document
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousephysicalinventory.WhsePhysicalInventoryItem
     *         WhsePhysicalInventoryItem} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousephysicalinventory.WhsePhysicalInventoryItemByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    WhsePhysicalInventoryItemByKeyFluentHelper getWhsePhysicalInventoryItemByKey(
        final UUID physicalInventoryDocumentUUID,
        final String physicalInventoryItemNumber );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousephysicalinventory.WhsePhysicalInventoryItem
     * WhsePhysicalInventoryItem} entity and save it to the S/4HANA system.
     *
     * @param whsePhysicalInventoryItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousephysicalinventory.WhsePhysicalInventoryItem
     *            WhsePhysicalInventoryItem} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousephysicalinventory.WhsePhysicalInventoryItem
     *         WhsePhysicalInventoryItem} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousephysicalinventory.WhsePhysicalInventoryItemCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    WhsePhysicalInventoryItemCreateFluentHelper
        createWhsePhysicalInventoryItem( @Nonnull final WhsePhysicalInventoryItem whsePhysicalInventoryItem );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousephysicalinventory.WhsePhysicalInventoryItem
     * WhsePhysicalInventoryItem} entity and save it to the S/4HANA system.
     *
     * @param whsePhysicalInventoryItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousephysicalinventory.WhsePhysicalInventoryItem
     *            WhsePhysicalInventoryItem} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousephysicalinventory.WhsePhysicalInventoryItem
     *         WhsePhysicalInventoryItem} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousephysicalinventory.WhsePhysicalInventoryItemUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    WhsePhysicalInventoryItemUpdateFluentHelper
        updateWhsePhysicalInventoryItem( @Nonnull final WhsePhysicalInventoryItem whsePhysicalInventoryItem );

    /**
     * <p>
     * Creates a fluent helper for the <b>DeletePhysicalInventoryItem</b> OData function import.
     * </p>
     *
     * @param physicalInventoryItemNumber
     *            Item
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>PhysicalInventoryItemNumber</b>
     *            </p>
     * @param physicalInventoryDocumentUUID
     *            GUID
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: none
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>PhysicalInventoryDocumentUUID</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>DeletePhysicalInventoryItem</b> OData function import
     *         with the provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousephysicalinventory.DeletePhysicalInventoryItemFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    DeletePhysicalInventoryItemFluentHelper deletePhysicalInventoryItem(
        @Nonnull final UUID physicalInventoryDocumentUUID,
        @Nonnull final String physicalInventoryItemNumber );

}
