/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseresource.LogoffFromWarehouseResourceFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseresource.LogonToWarehouseResourceFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseresource.WarehouseResource;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseresource.WarehouseResourceByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseresource.WarehouseResourceCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseresource.WarehouseResourceDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseresource.WarehouseResourceFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseresource.batch.WarehouseResourceServiceBatch;

/**
 * <p>
 * In every API call, you can make use of the following operations: - You can retrieve warehouse resources. Apply any of
 * the filters provided or retrieve all existing data. - You can create and delete warehouse resources. - You can update
 * existing warehouse resources (log on, log off)..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2208.latest/EN/bd/d0b88001154ebcb47de632c68ce0fb/frameset.htm?profile=20020833'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_WAREHOUSE_RESOURCE?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_WAREHOUSE_RESOURCE</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2208</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Warehousing - Process Warehouse Task Integration(SAP_COM_0353)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/3W0'>Resource Management in Warehousing(3W0)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Warehouse Resource</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated as of release 2108 (Aug 2021). Please use the
 *             odata generator to generate the VDM.
 */
@Deprecated
public interface WarehouseResourceService extends BatchService<WarehouseResourceServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_WAREHOUSE_RESOURCE";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    WarehouseResourceService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseresource.WarehouseResource
     * WarehouseResource} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseresource.WarehouseResource
     *         WarehouseResource} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseresource.WarehouseResourceFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    WarehouseResourceFluentHelper getAllWarehouseResource();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseresource.WarehouseResource
     * WarehouseResource} entity using key fields.
     *
     * @param warehouseResource
     *            Resource (Means of Transportation or User)
     *            <p>
     *            Constraints: Not nullable, Maximum length: 18
     *            </p>
     * @param warehouse
     *            Warehouse Number/Warehouse Complex
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseresource.WarehouseResource
     *         WarehouseResource} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseresource.WarehouseResourceByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    WarehouseResourceByKeyFluentHelper
        getWarehouseResourceByKey( final String warehouse, final String warehouseResource );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseresource.WarehouseResource
     * WarehouseResource} entity and save it to the S/4HANA system.
     *
     * @param warehouseResource
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseresource.WarehouseResource
     *            WarehouseResource} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseresource.WarehouseResource
     *         WarehouseResource} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseresource.WarehouseResourceCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    WarehouseResourceCreateFluentHelper createWarehouseResource( @Nonnull final WarehouseResource warehouseResource );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseresource.WarehouseResource WarehouseResource}
     * entity in the S/4HANA system.
     *
     * @param warehouseResource
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseresource.WarehouseResource
     *            WarehouseResource} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseresource.WarehouseResource
     *         WarehouseResource} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseresource.WarehouseResourceDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    WarehouseResourceDeleteFluentHelper deleteWarehouseResource( @Nonnull final WarehouseResource warehouseResource );

    /**
     * <p>
     * Creates a fluent helper for the <b>LogoffFromWarehouseResource</b> OData function import.
     * </p>
     *
     * @param warehouseResource
     *            Resource
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 18
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>WarehouseResource</b>
     *            </p>
     * @param warehouse
     *            Warehouse Number
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>Warehouse</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>LogoffFromWarehouseResource</b> OData function import
     *         with the provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseresource.LogoffFromWarehouseResourceFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    LogoffFromWarehouseResourceFluentHelper
        logoffFromWarehouseResource( @Nonnull final String warehouse, @Nonnull final String warehouseResource );

    /**
     * <p>
     * Creates a fluent helper for the <b>LogonToWarehouseResource</b> OData function import.
     * </p>
     *
     * @param warehouseResource
     *            Resource
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 18
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>WarehouseResource</b>
     *            </p>
     * @param warehouse
     *            Warehouse Number
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>Warehouse</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>LogonToWarehouseResource</b> OData function import with
     *         the provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseresource.LogonToWarehouseResourceFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    LogonToWarehouseResourceFluentHelper
        logonToWarehouseResource( @Nonnull final String warehouse, @Nonnull final String warehouseResource );

}
