/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouse.WarehouseByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouse.WarehouseFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouse.WarehouseStorageTypeByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouse.WarehouseStorageTypeFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouse.WarehouseStorageTypeTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouse.WarehouseStorageTypeTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouse.WarehouseTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouse.WarehouseTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouse.batch.WarehouseServiceBatch;

/**
 * <p>
 * This allows you to integrate input help (F4 help) for warehouse numbers in your mobile apps.
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2208.latest/EN/52/2c8cc5ee864e81a0d6fe41631a11d4/frameset.htm?profile=20020833'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference:
 * <a href='https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_WAREHOUSE?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_WAREHOUSE</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2208</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Warehousing - Master Data Integration(SAP_COM_0374)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/3W0'>Resource Management in Warehousing(3W0)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Warehouse</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated as of release 2108 (Aug 2021). Please use the
 *             odata generator to generate the VDM.
 */
@Deprecated
public interface WarehouseService extends BatchService<WarehouseServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_WAREHOUSE";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    WarehouseService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouse.Warehouse Warehouse}
     * entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouse.Warehouse Warehouse} entities. This
     *         fluent helper allows methods which modify the underlying query to be called before executing the query
     *         itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouse.WarehouseFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    WarehouseFluentHelper getAllWarehouse();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouse.Warehouse Warehouse} entity
     * using key fields.
     *
     * @param warehouse
     *            Warehouse Number/Warehouse Complex
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouse.Warehouse Warehouse} entity using
     *         key fields. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouse.WarehouseByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    WarehouseByKeyFluentHelper getWarehouseByKey( final String warehouse );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouse.WarehouseStorageType
     * WarehouseStorageType} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouse.WarehouseStorageType
     *         WarehouseStorageType} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouse.WarehouseStorageTypeFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    WarehouseStorageTypeFluentHelper getAllWarehouseStorageType();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouse.WarehouseStorageType
     * WarehouseStorageType} entity using key fields.
     *
     * @param storageType
     *            Storage Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param warehouse
     *            Warehouse Number/Warehouse Complex
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouse.WarehouseStorageType
     *         WarehouseStorageType} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouse.WarehouseStorageTypeByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    WarehouseStorageTypeByKeyFluentHelper
        getWarehouseStorageTypeByKey( final String warehouse, final String storageType );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouse.WarehouseStorageTypeText
     * WarehouseStorageTypeText} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouse.WarehouseStorageTypeText
     *         WarehouseStorageTypeText} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouse.WarehouseStorageTypeTextFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    WarehouseStorageTypeTextFluentHelper getAllWarehouseStorageTypeText();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouse.WarehouseStorageTypeText
     * WarehouseStorageTypeText} entity using key fields.
     *
     * @param storageType
     *            Storage Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param warehouse
     *            Warehouse Number/Warehouse Complex
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouse.WarehouseStorageTypeText
     *         WarehouseStorageTypeText} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouse.WarehouseStorageTypeTextByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    WarehouseStorageTypeTextByKeyFluentHelper
        getWarehouseStorageTypeTextByKey( final String language, final String warehouse, final String storageType );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouse.WarehouseText WarehouseText}
     * entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouse.WarehouseText WarehouseText}
     *         entities. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouse.WarehouseTextFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    WarehouseTextFluentHelper getAllWarehouseText();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouse.WarehouseText WarehouseText}
     * entity using key fields.
     *
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param warehouse
     *            Warehouse Number/Warehouse Complex
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouse.WarehouseText WarehouseText} entity
     *         using key fields. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouse.WarehouseTextByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    WarehouseTextByKeyFluentHelper getWarehouseTextByKey( final String language, final String warehouse );

}
