/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousestoragebin.WarehouseStorageBinByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousestoragebin.WarehouseStorageBinFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousestoragebin.batch.WarehouseStorageBinServiceBatch;

/**
 * <p>
 * This allows you to integrate input help (F4 help) for warehouse storage bins in your mobile apps. It also assists in
 * the process of bin verification during warehouse order processing.
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2208.latest/EN/5d/947af85ab4402c95bdfa57d00b909b/frameset.htm?profile=20020833'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_WAREHOUSE_STORAGE_BIN?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_WAREHOUSE_STORAGE_BIN</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2208</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Warehousing - Master Data Integration(SAP_COM_0374)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/3W0'>Resource Management in Warehousing(3W0)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Warehouse Storage Bin</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated as of release 2108 (Aug 2021). Please use the
 *             odata generator to generate the VDM.
 */
@Deprecated
public interface WarehouseStorageBinService extends BatchService<WarehouseStorageBinServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_WAREHOUSE_STORAGE_BIN";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    WarehouseStorageBinService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousestoragebin.WarehouseStorageBin
     * WarehouseStorageBin} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousestoragebin.WarehouseStorageBin
     *         WarehouseStorageBin} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousestoragebin.WarehouseStorageBinFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    WarehouseStorageBinFluentHelper getAllWarehouseStorageBin();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousestoragebin.WarehouseStorageBin
     * WarehouseStorageBin} entity using key fields.
     *
     * @param storageBin
     *            Storage Bin
     *            <p>
     *            Constraints: Not nullable, Maximum length: 18
     *            </p>
     * @param warehouse
     *            Warehouse Number/Warehouse Complex
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousestoragebin.WarehouseStorageBin
     *         WarehouseStorageBin} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousestoragebin.WarehouseStorageBinByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    WarehouseStorageBinByKeyFluentHelper getWarehouseStorageBinByKey( final String warehouse, final String storageBin );

}
