/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.math.BigDecimal;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.AssignWarehouseOrderFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.CancelWarehouseTaskFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.ConfirmWarehouseTaskExactFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.ConfirmWarehouseTaskHUFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.ConfirmWarehouseTaskProductFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.SetInProcessWarehouseOrderFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.UnassignWarehouseOrderFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseOrder;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseOrderByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseOrderCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseOrderFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseTask;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseTaskByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseTaskCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseTaskExceptionCodeByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseTaskExceptionCodeFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseTaskFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.batch.WarehouseTaskServiceBatch;

/**
 * <p>
 * In every API call, you can make use of the following operations: - You can retrieve warehouse orders and warehouse
 * tasks. Apply any of the filters provided or retrieve all existing data. - For existing warehouse orders, you can
 * update the corresponding warehouse tasks. - You can update existing warehouse tasks (confirm, confirm with
 * exceptions, cancel). - You can update existing warehouse orders (assign or unassign warehouse order to warehouse
 * resource). - You can create warehouse tasks (product warehouse tasks, HU warehouse tasks, warehouse tasks for
 * warehouse requests)..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2208.latest/EN/90/419cedc18a471889c4388de49ad9dc/frameset.htm?profile=20020833'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_WAREHOUSE_ORDER_TASK?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_WAREHOUSE_ORDER_TASK</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2208</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Warehousing - Process Warehouse Task Integration(SAP_COM_0353)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/3W0'>Resource Management in Warehousing(3W0)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Warehouse Order</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated as of release 2108 (Aug 2021). Please use the
 *             odata generator to generate the VDM.
 */
@Deprecated
public interface WarehouseTaskService extends BatchService<WarehouseTaskServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_WAREHOUSE_ORDER_TASK";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    WarehouseTaskService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseOrder
     * WarehouseOrder} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseOrder WarehouseOrder}
     *         entities. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseOrderFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    WarehouseOrderFluentHelper getAllWarehouseOrder();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseOrder
     * WarehouseOrder} entity using key fields.
     *
     * @param warehouse
     *            Warehouse Number/Warehouse Complex
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param warehouseOrder
     *            Warehouse Order Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseOrder WarehouseOrder}
     *         entity using key fields. This fluent helper allows methods which modify the underlying query to be called
     *         before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseOrderByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    WarehouseOrderByKeyFluentHelper getWarehouseOrderByKey( final String warehouse, final String warehouseOrder );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseOrder
     * WarehouseOrder} entity and save it to the S/4HANA system.
     *
     * @param warehouseOrder
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseOrder
     *            WarehouseOrder} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseOrder WarehouseOrder}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseOrderCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    WarehouseOrderCreateFluentHelper createWarehouseOrder( @Nonnull final WarehouseOrder warehouseOrder );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseTask
     * WarehouseTask} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseTask WarehouseTask}
     *         entities. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseTaskFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    WarehouseTaskFluentHelper getAllWarehouseTask();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseTask
     * WarehouseTask} entity using key fields.
     *
     * @param warehouseTaskItem
     *            Warehouse Task Item
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param warehouse
     *            Warehouse Number/Warehouse Complex
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param warehouseTask
     *            Warehouse Task
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseTask WarehouseTask}
     *         entity using key fields. This fluent helper allows methods which modify the underlying query to be called
     *         before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseTaskByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    WarehouseTaskByKeyFluentHelper
        getWarehouseTaskByKey( final String warehouse, final String warehouseTask, final String warehouseTaskItem );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseTask
     * WarehouseTask} entity and save it to the S/4HANA system.
     *
     * @param warehouseTask
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseTask WarehouseTask}
     *            entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseTask WarehouseTask}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseTaskCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    WarehouseTaskCreateFluentHelper createWarehouseTask( @Nonnull final WarehouseTask warehouseTask );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseTaskExceptionCode
     * WarehouseTaskExceptionCode} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseTaskExceptionCode
     *         WarehouseTaskExceptionCode} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseTaskExceptionCodeFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    WarehouseTaskExceptionCodeFluentHelper getAllWarehouseTaskExceptionCode();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseTaskExceptionCode
     * WarehouseTaskExceptionCode} entity using key fields.
     *
     * @param businessContextExecutionStep
     *            Execution Step in Business Context
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param warehouseTaskItem
     *            Warehouse Task Item
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param warehouseTaskExceptionCode
     *            Exception Code
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param businessContext
     *            Business Context
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @param warehouse
     *            Warehouse Number/Warehouse Complex
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param warehouseTask
     *            Warehouse Task
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseTaskExceptionCode
     *         WarehouseTaskExceptionCode} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseTaskExceptionCodeByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    WarehouseTaskExceptionCodeByKeyFluentHelper getWarehouseTaskExceptionCodeByKey(
        final String warehouse,
        final String warehouseTask,
        final String warehouseTaskItem,
        final String warehouseTaskExceptionCode,
        final String businessContext,
        final String businessContextExecutionStep );

    /**
     * <p>
     * Creates a fluent helper for the <b>AssignWarehouseOrder</b> OData function import.
     * </p>
     *
     * @param warehouseResource
     *            Resource
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 18
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>WarehouseResource</b>
     *            </p>
     * @param warehouse
     *            Warehouse Number
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>Warehouse</b>
     *            </p>
     * @param warehouseOrder
     *            Warehouse Order
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>WarehouseOrder</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>AssignWarehouseOrder</b> OData function import with the
     *         provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.AssignWarehouseOrderFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    AssignWarehouseOrderFluentHelper assignWarehouseOrder(
        @Nonnull final String warehouse,
        @Nonnull final String warehouseOrder,
        @Nullable final String warehouseResource );

    /**
     * <p>
     * Creates a fluent helper for the <b>SetInProcessWarehouseOrder</b> OData function import.
     * </p>
     *
     * @param warehouse
     *            Warehouse Number
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>Warehouse</b>
     *            </p>
     * @param warehouseOrder
     *            Warehouse Order
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>WarehouseOrder</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>SetInProcessWarehouseOrder</b> OData function import with
     *         the provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.SetInProcessWarehouseOrderFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SetInProcessWarehouseOrderFluentHelper
        setInProcessWarehouseOrder( @Nonnull final String warehouse, @Nonnull final String warehouseOrder );

    /**
     * <p>
     * Creates a fluent helper for the <b>UnassignWarehouseOrder</b> OData function import.
     * </p>
     *
     * @param warehouse
     *            Warehouse Number
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>Warehouse</b>
     *            </p>
     * @param warehouseOrder
     *            Warehouse Order
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>WarehouseOrder</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>UnassignWarehouseOrder</b> OData function import with the
     *         provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.UnassignWarehouseOrderFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    UnassignWarehouseOrderFluentHelper
        unassignWarehouseOrder( @Nonnull final String warehouse, @Nonnull final String warehouseOrder );

    /**
     * <p>
     * Creates a fluent helper for the <b>CancelWarehouseTask</b> OData function import.
     * </p>
     *
     * @param warehouseTaskItem
     *            WT Item
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>WarehouseTaskItem</b>
     *            </p>
     * @param warehouse
     *            Warehouse Number
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>Warehouse</b>
     *            </p>
     * @param warehouseTask
     *            Warehouse Task
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>WarehouseTask</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>CancelWarehouseTask</b> OData function import with the
     *         provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.CancelWarehouseTaskFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CancelWarehouseTaskFluentHelper cancelWarehouseTask(
        @Nonnull final String warehouse,
        @Nonnull final String warehouseTask,
        @Nonnull final String warehouseTaskItem );

    /**
     * <p>
     * Creates a fluent helper for the <b>ConfirmWarehouseTaskExact</b> OData function import.
     * </p>
     *
     * @param warehouseTaskItem
     *            WT Item
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>WarehouseTaskItem</b>
     *            </p>
     * @param warehouse
     *            Warehouse Number
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>Warehouse</b>
     *            </p>
     * @param warehouseTask
     *            Warehouse Task
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>WarehouseTask</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>ConfirmWarehouseTaskExact</b> OData function import with
     *         the provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.ConfirmWarehouseTaskExactFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ConfirmWarehouseTaskExactFluentHelper confirmWarehouseTaskExact(
        @Nonnull final String warehouse,
        @Nonnull final String warehouseTask,
        @Nonnull final String warehouseTaskItem );

    /**
     * <p>
     * Creates a fluent helper for the <b>ConfirmWarehouseTaskHU</b> OData function import.
     * </p>
     *
     * @param warehouseTaskItem
     *            WT Item
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>WarehouseTaskItem</b>
     *            </p>
     * @param destinationStorageBin
     *            Destination Bin
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 18
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>DestinationStorageBin</b>
     *            </p>
     * @param warehouse
     *            Warehouse Number
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>Warehouse</b>
     *            </p>
     * @param warehouseTask
     *            Warehouse Task
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>WarehouseTask</b>
     *            </p>
     * @param whseTaskExCodeDestStorageBin
     *            Exception Code
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 4
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>WhseTaskExCodeDestStorageBin</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>ConfirmWarehouseTaskHU</b> OData function import with the
     *         provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.ConfirmWarehouseTaskHUFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ConfirmWarehouseTaskHUFluentHelper confirmWarehouseTaskHU(
        @Nonnull final String warehouse,
        @Nonnull final String warehouseTask,
        @Nonnull final String warehouseTaskItem,
        @Nullable final String destinationStorageBin,
        @Nullable final String whseTaskExCodeDestStorageBin );

    /**
     * <p>
     * Creates a fluent helper for the <b>ConfirmWarehouseTaskProduct</b> OData function import.
     * </p>
     *
     * @param sourceHandlingUnit
     *            Source Handling Unit
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 20
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>SourceHandlingUnit</b>
     *            </p>
     * @param whseTaskExceptionCodeQtyDiff
     *            Exception Code
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 4
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>WhseTaskExceptionCodeQtyDiff</b>
     *            </p>
     * @param warehouseTaskItem
     *            WT Item
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>WarehouseTaskItem</b>
     *            </p>
     * @param destinationStorageBin
     *            Destination Bin
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 18
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>DestinationStorageBin</b>
     *            </p>
     * @param alternativeUnit
     *            Alt. Unit of Measure
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 3
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>AlternativeUnit</b>
     *            </p>
     * @param differenceQuantityInAltvUnit
     *            Difference Quantity
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 31, Scale: 14
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>DifferenceQuantityInAltvUnit</b>
     *            </p>
     * @param actualQuantityInAltvUnit
     *            Actual Quantity
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 31, Scale: 14
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ActualQuantityInAltvUnit</b>
     *            </p>
     * @param warehouse
     *            Warehouse Number
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>Warehouse</b>
     *            </p>
     * @param warehouseTask
     *            Warehouse Task
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>WarehouseTask</b>
     *            </p>
     * @param whseTaskExCodeDestStorageBin
     *            Exception Code
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 4
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>WhseTaskExCodeDestStorageBin</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>ConfirmWarehouseTaskProduct</b> OData function import
     *         with the provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.ConfirmWarehouseTaskProductFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ConfirmWarehouseTaskProductFluentHelper confirmWarehouseTaskProduct(
        @Nonnull final String warehouse,
        @Nonnull final String warehouseTask,
        @Nonnull final String warehouseTaskItem,
        @Nullable final String alternativeUnit,
        @Nullable final BigDecimal actualQuantityInAltvUnit,
        @Nullable final BigDecimal differenceQuantityInAltvUnit,
        @Nullable final String whseTaskExceptionCodeQtyDiff,
        @Nullable final String destinationStorageBin,
        @Nullable final String whseTaskExCodeDestStorageBin,
        @Nullable final String sourceHandlingUnit );

}
